/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.endpoint;

import java.io.IOException;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.endpoint.AbstractMessenger;
import net.jxta.endpoint.AsyncChannelMessenger;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.MessengerState;
import net.jxta.endpoint.OutgoingMessageEvent;
import net.jxta.logging.Logging;
import net.jxta.peergroup.PeerGroupID;

public abstract class ThreadedMessenger
extends AbstractMessenger
implements Runnable {
    private static final transient Logger LOG = Logger.getLogger(ThreadedMessenger.class.getName());
    private static final transient ThreadGroup myThreadGroup = new ThreadGroup("Threaded Messengers");
    private volatile EndpointAddress logicalDestination = null;
    private volatile boolean inputClosed = false;
    private PeerGroupID homeGroupID = null;
    private static final long THREAD_IDLE_DEAD = 15000L;
    private DeferredAction deferredAction = DeferredAction.ACTION_NONE;
    private volatile Thread bgThread = null;
    private final int channelQueueSize;
    private final BlockingQueue<ThreadedMessengerChannel> activeChannels = new LinkedBlockingQueue<ThreadedMessengerChannel>();
    private final WeakHashMap<ThreadedMessengerChannel, ThreadedMessengerChannel> resolvingChannels = new WeakHashMap(4);
    private ThreadedMessengerChannel defaultChannel = null;
    private final ThreadedMessengerState stateMachine = new ThreadedMessengerState();

    public ThreadedMessenger(PeerGroupID homeGroupID, EndpointAddress destination, EndpointAddress logicalDestination, int channelQueueSize) {
        super(destination);
        this.homeGroupID = homeGroupID;
        this.setStateLock(this.stateMachine);
        this.logicalDestination = logicalDestination;
        this.channelQueueSize = channelQueueSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {}
            catch (Throwable any) {
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "Uncaught throwable in background thread", any);
                }
                Object var3_2 = null;
                ThreadedMessengerState threadedMessengerState = this.stateMachine;
                synchronized (threadedMessengerState) {
                    this.bgThread = null;
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ThreadedMessengerState threadedMessengerState = this.stateMachine;
            synchronized (threadedMessengerState) {
                this.bgThread = null;
                throw throwable;
            }
        }
        block13: while (true) {
            switch (this.nextAction()) {
                case ACTION_NONE: {
                    Object var3_1 = null;
                    ThreadedMessengerState threadedMessengerState = this.stateMachine;
                    synchronized (threadedMessengerState) {
                        this.bgThread = null;
                        return;
                    }
                }
                case ACTION_SEND: {
                    this.send();
                    break;
                }
                case ACTION_CONNECT: {
                    this.connect();
                    continue block13;
                }
            }
        }
    }

    private void deferAction(DeferredAction action) {
        this.deferredAction = action;
        if (this.bgThread == null) {
            this.bgThread = new Thread(myThreadGroup, this, "ThreadedMessenger for " + this.getDestinationAddress());
            this.bgThread.setDaemon(true);
            this.bgThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeferredAction nextAction() {
        long quitAt = System.currentTimeMillis() + 15000L;
        ThreadedMessengerState threadedMessengerState = this.stateMachine;
        synchronized (threadedMessengerState) {
            while (this.deferredAction == DeferredAction.ACTION_NONE) {
                if (System.currentTimeMillis() > quitAt) {
                    return DeferredAction.ACTION_NONE;
                }
                try {
                    this.stateMachine.wait(15000L);
                }
                catch (InterruptedException ie) {
                    Thread.interrupted();
                }
            }
            DeferredAction action = this.deferredAction;
            this.deferredAction = DeferredAction.ACTION_NONE;
            return action;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send() throws InterruptedException {
        ThreadedMessengerChannel theChannel;
        ThreadedMessengerState threadedMessengerState = this.stateMachine;
        synchronized (threadedMessengerState) {
            theChannel = (ThreadedMessengerChannel)this.activeChannels.peek();
            if (theChannel == null) {
                this.stateMachine.idleEvent();
                this.stateMachine.notifyAll();
                return;
            }
        }
        while (true) {
            AsyncChannelMessenger.PendingMessage theMsg;
            if ((theMsg = theChannel.peek()) == null) {
                ThreadedMessengerState threadedMessengerState2 = this.stateMachine;
                synchronized (threadedMessengerState2) {
                    this.activeChannels.poll();
                    theChannel = (ThreadedMessengerChannel)this.activeChannels.peek();
                    if (theChannel != null) {
                        continue;
                    }
                    this.stateMachine.idleEvent();
                    this.stateMachine.notifyAll();
                }
                this.notifyChange();
                return;
            }
            Message currentMsg = theMsg.msg;
            String currentService = theMsg.service;
            String currentParam = theMsg.param;
            try {
                this.sendMessageBImpl(currentMsg, currentService, currentParam);
            }
            catch (Throwable any) {
                ThreadedMessengerState threadedMessengerState3 = this.stateMachine;
                synchronized (threadedMessengerState3) {
                    if (theMsg.failure != null) {
                        theChannel.poll();
                        currentMsg.setMessageProperty(Messenger.class, new OutgoingMessageEvent(currentMsg, theMsg.failure));
                    } else {
                        theMsg.failure = any;
                    }
                    this.stateMachine.downEvent();
                    this.stateMachine.notifyAll();
                }
                this.notifyChange();
                return;
            }
            ThreadedMessengerState threadedMessengerState4 = this.stateMachine;
            synchronized (threadedMessengerState4) {
                boolean empty;
                theChannel.poll();
                boolean bl = empty = theChannel.peek() == null;
                if (this.activeChannels.size() != 1 || empty) {
                    this.activeChannels.poll();
                    if (!empty) {
                        this.activeChannels.put(theChannel);
                    }
                    if ((theChannel = (ThreadedMessengerChannel)this.activeChannels.peek()) == null) {
                        this.stateMachine.idleEvent();
                        this.stateMachine.notifyAll();
                    }
                }
            }
            if (theChannel == null) break;
        }
        this.notifyChange();
        Thread.yield();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() {
        boolean worked = this.connectImpl();
        ThreadedMessengerChannel[] channels = null;
        ThreadedMessengerState threadedMessengerState = this.stateMachine;
        synchronized (threadedMessengerState) {
            if (worked) {
                EndpointAddress effectiveLogicalDest = this.getLogicalDestinationImpl();
                if (this.logicalDestination == null) {
                    this.logicalDestination = effectiveLogicalDest;
                    this.stateMachine.upEvent();
                    channels = this.resolvingChannels.keySet().toArray(new ThreadedMessengerChannel[0]);
                    this.resolvingChannels.clear();
                } else if (this.logicalDestination.equals(effectiveLogicalDest)) {
                    this.stateMachine.upEvent();
                    channels = this.resolvingChannels.keySet().toArray(new ThreadedMessengerChannel[0]);
                    this.resolvingChannels.clear();
                } else {
                    this.closeImpl();
                    this.stateMachine.downEvent();
                }
            } else {
                this.stateMachine.downEvent();
            }
            this.stateMachine.notifyAll();
        }
        if (channels != null) {
            int i = channels.length;
            while (i-- > 0) {
                channels[i].up();
            }
            channels = null;
        }
        this.notifyChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void shutdown() {
        ThreadedMessengerState threadedMessengerState = this.stateMachine;
        synchronized (threadedMessengerState) {
            this.stateMachine.shutdownEvent();
            this.stateMachine.notifyAll();
        }
        this.notifyChange();
    }

    public EndpointAddress getLogicalDestinationAddress() {
        return this.logicalDestination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ThreadedMessengerState threadedMessengerState = this.stateMachine;
        synchronized (threadedMessengerState) {
            this.stateMachine.closeEvent();
            this.stateMachine.notifyAll();
        }
        this.notifyChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean sendMessageN(Message msg, String service, String serviceParam) {
        ThreadedMessengerState threadedMessengerState = this.stateMachine;
        synchronized (threadedMessengerState) {
            if (this.defaultChannel == null) {
                this.defaultChannel = new ThreadedMessengerChannel(this.getDestinationAddress(), null, null, null, this.channelQueueSize, false);
            }
        }
        return this.defaultChannel.sendMessageN(msg, service, serviceParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendMessageB(Message msg, String service, String serviceParam) throws IOException {
        ThreadedMessengerState threadedMessengerState = this.stateMachine;
        synchronized (threadedMessengerState) {
            if (this.defaultChannel == null) {
                this.defaultChannel = new ThreadedMessengerChannel(this.getDestinationAddress(), null, null, null, this.channelQueueSize, false);
            }
        }
        this.defaultChannel.sendMessageB(msg, service, serviceParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addToActiveChannels(ThreadedMessengerChannel channel) {
        ThreadedMessengerState threadedMessengerState = this.stateMachine;
        synchronized (threadedMessengerState) {
            if (this.inputClosed) {
                return false;
            }
            try {
                this.activeChannels.put(channel);
            }
            catch (InterruptedException failed) {
                Thread.interrupted();
                return false;
            }
            this.stateMachine.msgsEvent();
            this.stateMachine.notifyAll();
        }
        this.notifyChange();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void strongRefResolvingChannel(ThreadedMessengerChannel channel) {
        ThreadedMessengerState threadedMessengerState = this.stateMachine;
        synchronized (threadedMessengerState) {
            if (this.resolvingChannels.containsKey(channel)) {
                this.resolvingChannels.put(channel, channel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addToResolvingChannels(ThreadedMessengerChannel channel) {
        ThreadedMessengerState threadedMessengerState = this.stateMachine;
        synchronized (threadedMessengerState) {
            if ((this.stateMachine.getState() & 0x7DBCC) != 0) {
                return false;
            }
            this.resolvingChannels.put(channel, null);
            this.stateMachine.resolveEvent();
            this.stateMachine.notifyAll();
        }
        this.notifyChange();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resolve() {
        ThreadedMessengerState threadedMessengerState = this.stateMachine;
        synchronized (threadedMessengerState) {
            this.stateMachine.resolveEvent();
            this.stateMachine.notifyAll();
        }
        this.notifyChange();
    }

    public final int getState() {
        return this.stateMachine.getState();
    }

    public Messenger getChannelMessenger(PeerGroupID redirection, String service, String serviceParam) {
        return new ThreadedMessengerChannel(this.getDestinationAddress(), this.homeGroupID.equals(redirection) ? null : redirection, service, serviceParam, this.channelQueueSize, (this.stateMachine.getState() & 0x3CC) != 0);
    }

    protected abstract void closeImpl();

    protected abstract boolean connectImpl();

    protected abstract void sendMessageBImpl(Message var1, String var2, String var3) throws IOException;

    protected abstract EndpointAddress getLogicalDestinationImpl();

    private class ThreadedMessengerState
    extends MessengerState {
        protected ThreadedMessengerState() {
            super(false);
        }

        protected void connectAction() {
            ThreadedMessenger.this.deferAction(DeferredAction.ACTION_CONNECT);
        }

        protected void startAction() {
            ThreadedMessenger.this.deferAction(DeferredAction.ACTION_SEND);
        }

        protected void closeInputAction() {
            ThreadedMessenger.this.inputClosed = true;
            ThreadedMessengerChannel[] channels = ThreadedMessenger.this.resolvingChannels.keySet().toArray(new ThreadedMessengerChannel[0]);
            ThreadedMessenger.this.resolvingChannels.clear();
            int i = channels.length;
            while (i-- > 0) {
                channels[i].down();
            }
            channels = null;
        }

        protected void closeOutputAction() {
            ThreadedMessenger.this.closeImpl();
        }

        protected void failAllAction() {
            ThreadedMessengerChannel theChannel;
            while ((theChannel = (ThreadedMessengerChannel)ThreadedMessenger.this.activeChannels.poll()) != null) {
                theChannel.down();
            }
        }
    }

    private class ThreadedMessengerChannel
    extends AsyncChannelMessenger {
        public ThreadedMessengerChannel(EndpointAddress baseAddress, PeerGroupID redirection, String origService, String origServiceParam, int queueSize, boolean connected) {
            super(baseAddress, redirection, origService, origServiceParam, queueSize, connected);
        }

        public EndpointAddress getLogicalDestinationAddress() {
            return ThreadedMessenger.this.logicalDestination;
        }

        protected void startImpl() {
            if (!ThreadedMessenger.this.addToActiveChannels(this)) {
                this.down();
            }
        }

        protected void connectImpl() {
            if (!ThreadedMessenger.this.addToResolvingChannels(this)) {
                if ((ThreadedMessenger.this.getState() & 0x3FF) != 0) {
                    this.up();
                } else {
                    this.down();
                }
            }
        }

        protected void resolPendingImpl() {
            ThreadedMessenger.this.strongRefResolvingChannel(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DeferredAction {
        ACTION_NONE,
        ACTION_SEND,
        ACTION_CONNECT;

    }
}

