/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.cm;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigInteger;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.XMLDocument;
import net.jxta.impl.cm.Indexer;
import net.jxta.impl.util.JxtaHash;
import net.jxta.impl.util.TimeUtils;
import net.jxta.impl.xindice.core.DBException;
import net.jxta.impl.xindice.core.data.Key;
import net.jxta.impl.xindice.core.data.Record;
import net.jxta.impl.xindice.core.data.Value;
import net.jxta.impl.xindice.core.filer.BTreeCallback;
import net.jxta.impl.xindice.core.filer.BTreeFiler;
import net.jxta.impl.xindice.core.indexer.IndexQuery;
import net.jxta.impl.xindice.core.indexer.NameIndexer;
import net.jxta.logging.Logging;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PeerGroupAdvertisement;
import net.jxta.protocol.SrdiMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Cm
implements Runnable {
    private static final Logger LOG = Logger.getLogger(Cm.class.getName());
    final File ROOTDIRBASE;
    private static final String[] DIRNAME = new String[]{"Peers", "Groups", "Adv", "Raw"};
    public static final long DEFAULT_GC_MAX_INTERVAL = 3600000L;
    private BTreeFiler cacheDB = null;
    private Indexer indexer = null;
    private static final String databaseFileName = "advertisements";
    private boolean stop = false;
    private boolean trackDeltas = false;
    private final Map<String, List<SrdiMessage.Entry>> deltaMap = new HashMap<String, List<SrdiMessage.Entry>>(3);
    protected File rootDir;
    private Thread gcThread = null;
    private long gcTime = 0L;
    private final long gcMinInterval = 60000L;
    private long gcMaxInterval = 3600000L;
    private final int maxInconvenienceLevel = 1000;
    private volatile int inconvenienceLevel = 0;

    public Cm(URI storeRoot, String areaName) {
        this(Thread.currentThread().getThreadGroup(), storeRoot, areaName, 3600000L, false);
    }

    public Cm(ThreadGroup threadGroup, URI storeRoot, String areaName, long gcinterval, boolean trackDeltas) {
        this.trackDeltas = trackDeltas;
        this.gcMaxInterval = gcinterval;
        this.gcTime = System.currentTimeMillis() + this.gcMaxInterval;
        this.ROOTDIRBASE = new File(new File(storeRoot), "cm");
        try {
            this.rootDir = new File(this.ROOTDIRBASE, areaName);
            this.rootDir = new File(this.rootDir.getAbsolutePath());
            if (!this.rootDir.exists() && !this.rootDir.mkdirs()) {
                throw new RuntimeException("Cm cannot create directory " + this.rootDir);
            }
            boolean chkPoint = true;
            ResourceBundle jxtaRsrcs = ResourceBundle.getBundle("net.jxta.user");
            String checkpointStr = jxtaRsrcs.getString("impl.cm.defferedcheckpoint");
            if (checkpointStr != null) {
                chkPoint = !checkpointStr.equalsIgnoreCase("true");
            }
            this.cacheDB = new BTreeFiler();
            this.cacheDB.setSync(chkPoint);
            this.cacheDB.setLocation(this.rootDir.getAbsolutePath(), databaseFileName);
            if (!this.cacheDB.open()) {
                this.cacheDB.create();
                this.cacheDB.open();
            }
            this.indexer = new Indexer(chkPoint);
            this.indexer.setLocation(this.rootDir.getAbsolutePath(), databaseFileName);
            if (!this.indexer.open()) {
                this.indexer.create();
                this.indexer.open();
            }
            if (System.getProperty("net.jxta.impl.cm.index.rebuild") != null) {
                this.rebuildIndex();
            }
            this.gcThread = new Thread(threadGroup, this, "CM GC Thread interval : 60000");
            this.gcThread.setDaemon(true);
            this.gcThread.start();
            if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
                LOG.config("Instantiated Cm for: " + this.rootDir.getAbsolutePath());
            }
        }
        catch (DBException de) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Unable to Initialize databases", de);
            }
            throw new UndeclaredThrowableException(de, "Unable to Initialize databases");
        }
        catch (Throwable e) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Unable to create Cm", e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new UndeclaredThrowableException(e, "Unable to create Cm");
        }
    }

    public String toString() {
        return "CM for " + this.rootDir.getAbsolutePath() + "[" + super.toString() + "]";
    }

    private static String getDirName(Advertisement adv) {
        if (adv instanceof PeerAdvertisement) {
            return DIRNAME[0];
        }
        if (adv instanceof PeerGroupAdvertisement) {
            return DIRNAME[1];
        }
        return DIRNAME[2];
    }

    public static String createTmpName(StructuredTextDocument doc) {
        try {
            StringWriter out = new StringWriter();
            doc.sendToWriter(out);
            out.close();
            JxtaHash digester = new JxtaHash(out.toString());
            BigInteger hash = digester.getDigestInteger();
            if (hash.compareTo(BigInteger.ZERO) < 0) {
                hash = hash.negate();
            }
            return "cm" + hash.toString(16);
        }
        catch (IOException ex) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Exception creating tmp name: ", ex);
            }
            throw new IllegalStateException("Could not generate name from document");
        }
    }

    public List<InputStream> getRecords(String dn, int threshold, List<Long> expirations) {
        return this.getRecords(dn, threshold, expirations, false);
    }

    public synchronized List<InputStream> getRecords(String dn, int threshold, List<Long> expirations, boolean purge) {
        ArrayList<InputStream> res;
        block6: {
            res = new ArrayList<InputStream>();
            if (dn == null) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("null directory name");
                }
                return res;
            }
            IndexQuery iq = new IndexQuery(7, new Value(dn));
            try {
                this.cacheDB.query(iq, new SearchCallback(this.cacheDB, this.indexer, res, expirations, threshold, purge));
            }
            catch (DBException dbe) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Exception during getRecords(): ", dbe);
                }
            }
            catch (IOException ie) {
                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block6;
                LOG.log(Level.FINE, "Exception during getRecords(): ", ie);
            }
        }
        return res;
    }

    public void garbageCollect() {
        Map<String, NameIndexer> map = this.indexer.getIndexers();
        Iterator<String> it = map.keySet().iterator();
        while (it != null && it.hasNext()) {
            long t0 = System.currentTimeMillis();
            String indexName = it.next();
            this.getRecords(indexName, Integer.MAX_VALUE, null, true);
            if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("Cm garbageCollect :" + indexName + " in :" + (System.currentTimeMillis() - t0));
        }
    }

    public synchronized long getLifetime(String dn, String fn) {
        try {
            Long life;
            block9: {
                Key key = new Key(dn + "/" + fn);
                Record record = this.cacheDB.readRecord(key);
                if (record == null) {
                    return -1L;
                }
                life = (Long)record.getMetaData("lifetime");
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Lifetime for :" + fn + "  " + life.toString());
                }
                if (life < System.currentTimeMillis()) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Removing expired record :" + fn);
                    }
                    try {
                        this.remove(dn, fn);
                    }
                    catch (IOException e) {
                        if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block9;
                        LOG.log(Level.FINE, "Failed to remove record", e);
                    }
                }
            }
            return TimeUtils.toRelativeTimeMillis(life);
        }
        catch (DBException de) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "failed to remove " + dn + "/" + fn, de);
            }
            return -1L;
        }
    }

    public synchronized long getExpirationtime(String dn, String fn) {
        try {
            long expiration;
            block8: {
                Key key = new Key(dn + "/" + fn);
                Record record = this.cacheDB.readRecord(key);
                expiration = Cm.calcExpiration(record);
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Expiration for :" + fn + "  " + expiration);
                }
                if (expiration < 0L) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Removing expired record :" + fn);
                    }
                    try {
                        this.remove(dn, fn);
                    }
                    catch (IOException e) {
                        if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block8;
                        LOG.log(Level.FINE, "Failed to remove record", e);
                    }
                }
            }
            return expiration;
        }
        catch (DBException de) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "failed to get " + dn + "/" + fn, de);
            }
            return -1L;
        }
    }

    private static long calcExpiration(Record record) {
        if (record == null) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Record is null returning expiration of -1");
            }
            return -1L;
        }
        Long exp = (Long)record.getMetaData("expiration");
        Long life = (Long)record.getMetaData("lifetime");
        long expiresin = life - System.currentTimeMillis();
        if (expiresin <= 0L) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine(MessageFormat.format("Record expired lifetime   : {0} expiration: {1} expires in: {2}", life, exp, expiresin));
                LOG.fine(MessageFormat.format("Record expires on :{0}", new Date(life)));
            }
            return -1L;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine(MessageFormat.format("Record lifetime: {0} expiration: {1} expires in: {2}", life, exp, expiresin));
            LOG.fine(MessageFormat.format("Record expires on :{0}", new Date(life)));
        }
        return Math.min(expiresin, exp);
    }

    public InputStream getInputStream(String dn, String fn) throws IOException {
        Key key = new Key(dn + "/" + fn);
        try {
            Value val;
            Record record = this.cacheDB.readRecord(key);
            if (record == null) {
                return null;
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Restored record for " + key);
            }
            if ((val = record.getValue()) != null) {
                return val.getInputStream();
            }
            return null;
        }
        catch (DBException de) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Failed to restore record for " + key, de);
            }
            IOException failure = new IOException("Failed to restore record for " + key);
            failure.initCause(de);
            throw failure;
        }
    }

    public synchronized void remove(String dn, String fn) throws IOException {
        block8: {
            try {
                if (fn == null) {
                    return;
                }
                Key key = new Key(dn + "/" + fn);
                Record record = this.cacheDB.readRecord(key);
                long removePos = this.cacheDB.findValue(key);
                this.cacheDB.deleteRecord(key);
                if (record == null) break block8;
                try {
                    if (Cm.calcExpiration(record) > 0L) {
                        InputStream is = record.getValue().getInputStream();
                        XMLDocument asDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, is);
                        Advertisement adv = AdvertisementFactory.newAdvertisement(asDoc);
                        Map<String, String> indexables = Cm.getIndexfields(adv.getIndexFields(), asDoc);
                        this.indexer.removeFromIndex(Cm.addKey(dn, indexables), removePos);
                        this.addDelta(dn, indexables, 0L);
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("removed " + record);
                        }
                    }
                }
                catch (Exception e) {
                    if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.log(Level.WARNING, "failed to remove " + dn + "/" + fn, e);
                    }
                }
            }
            catch (DBException de) {
                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block8;
                LOG.fine("failed to remove " + dn + "/" + fn);
            }
        }
    }

    public StructuredDocument restore(String dn, String fn) throws IOException {
        InputStream is = this.getInputStream(dn, fn);
        return StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, is);
    }

    public synchronized byte[] restoreBytes(String dn, String fn) throws IOException {
        try {
            Value val;
            Key key = new Key(dn + "/" + fn);
            Record record = this.cacheDB.readRecord(key);
            if (record == null) {
                return null;
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("restored " + record);
            }
            if ((val = record.getValue()) != null) {
                return val.getData();
            }
            return null;
        }
        catch (DBException de) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "failed to restore " + dn + "/" + fn, de);
            }
            IOException failure = new IOException("failed to restore " + dn + "/" + fn);
            failure.initCause(de);
            throw failure;
        }
    }

    public void save(String dn, String fn, Advertisement adv) throws IOException {
        this.save(dn, fn, adv, Long.MAX_VALUE, Long.MAX_VALUE);
    }

    public synchronized void save(String dn, String fn, Advertisement adv, long lifetime, long expiration) throws IOException {
        try {
            XMLDocument doc;
            if (expiration < 0L || lifetime <= 0L) {
                throw new IllegalArgumentException("Bad expiration or lifetime.");
            }
            try {
                doc = (XMLDocument)adv.getDocument(MimeMediaType.XMLUTF8);
            }
            catch (RuntimeException e) {
                IOException failure = new IOException("Advertisement couldn't be saved");
                failure.initCause(e);
                throw failure;
            }
            Key key = new Key(dn + "/" + fn);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            doc.sendToStream(baos);
            baos.close();
            Value value = new Value(baos.toByteArray());
            Long oldLife = null;
            Record record = this.cacheDB.readRecord(key);
            if (record != null) {
                oldLife = (Long)record.getMetaData("lifetime");
            }
            long absoluteLifetime = TimeUtils.toAbsoluteTimeMillis(lifetime);
            if (oldLife != null && absoluteLifetime < oldLife) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine(MessageFormat.format("Overriding attempt to decrease adv lifetime from : {0} to :{1}", new Date(oldLife), new Date(absoluteLifetime)));
                }
                absoluteLifetime = oldLife;
            }
            if (expiration > lifetime) {
                expiration = lifetime;
            }
            long pos = this.cacheDB.writeRecord(key, value, absoluteLifetime, expiration);
            Map<String, String> indexables = Cm.getIndexfields(adv.getIndexFields(), doc);
            Map<String, String> keyedIdx = Cm.addKey(dn, indexables);
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Indexing " + keyedIdx + " at " + pos);
            }
            this.indexer.addToIndex(keyedIdx, pos);
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Stored " + indexables + " at " + pos);
            }
            if (expiration > 0L) {
                this.addDelta(dn, indexables, TimeUtils.toRelativeTimeMillis(absoluteLifetime));
            }
        }
        catch (DBException de) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, MessageFormat.format("Failed to write {0}/{1} {2} {3}", dn, fn, lifetime, expiration), de);
            }
            IOException failure = new IOException("Failed to write " + dn + "/" + fn + " " + lifetime + " " + expiration);
            failure.initCause(de);
            throw failure;
        }
    }

    public synchronized void save(String dn, String fn, byte[] data, long lifetime, long expiration) throws IOException {
        try {
            if (expiration < 0L || lifetime <= 0L) {
                throw new IllegalArgumentException("Bad expiration or lifetime.");
            }
            Key key = new Key(dn + "/" + fn);
            Value value = new Value(data);
            Long oldLife = null;
            Record record = this.cacheDB.readRecord(key);
            if (record != null) {
                oldLife = (Long)record.getMetaData("lifetime");
            }
            long absoluteLifetime = TimeUtils.toAbsoluteTimeMillis(lifetime);
            if (oldLife != null && absoluteLifetime < oldLife) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine(MessageFormat.format("Overriding attempt to decrease adv lifetime from : {0} to :{1}", new Date(oldLife), new Date(absoluteLifetime)));
                }
                absoluteLifetime = oldLife;
            }
            if (expiration > lifetime) {
                expiration = lifetime;
            }
            this.cacheDB.writeRecord(key, value, absoluteLifetime, expiration);
        }
        catch (DBException de) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Failed to write " + dn + "/" + fn + " " + lifetime + " " + expiration, de);
            }
            IOException failure = new IOException("Failed to write " + dn + "/" + fn + " " + lifetime + " " + expiration);
            failure.initCause(de);
            throw failure;
        }
    }

    private static Map<String, String> getIndexfields(String[] fields, StructuredDocument doc) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (doc == null) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Null document");
            }
            return map;
        }
        if (fields == null) {
            return map;
        }
        for (String field : fields) {
            Enumeration en = doc.getChildren(field);
            while (en.hasMoreElements()) {
                String val = (String)((Element)en.nextElement()).getValue();
                if (val == null) continue;
                map.put(field, val);
            }
        }
        return map;
    }

    private static Map<String, String> addKey(String dn, Map<String, String> map) {
        if (map == null) {
            return null;
        }
        HashMap<String, String> tmp = new HashMap<String, String>();
        if (map.size() > 0) {
            Iterator<String> it = map.keySet().iterator();
            while (it != null && it.hasNext()) {
                String name = it.next();
                tmp.put(dn + name, map.get(name));
            }
        }
        return tmp;
    }

    protected static IndexQuery getIndexQuery(String value) {
        int operator;
        if (value == null) {
            return null;
        }
        if (value.length() == 0 || "*".equals(value)) {
            return null;
        }
        if (value.indexOf("*") < 0) {
            operator = 1;
        } else if (value.charAt(0) == '*' && value.charAt(value.length() - 1) != '*') {
            operator = 8;
            value = value.substring(1, value.length());
        } else if (value.charAt(value.length() - 1) == '*' && value.charAt(0) != '*') {
            operator = 7;
            value = value.substring(0, value.length() - 1);
        } else {
            operator = 5;
            value = value.substring(1, value.length() - 1);
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Index query operator :" + operator);
        }
        return new IndexQuery(operator, new Value(value));
    }

    public synchronized List<InputStream> search(String dn, String attribute, String value, int threshold, List<Long> expirations) {
        ArrayList<InputStream> res;
        block2: {
            res = new ArrayList<InputStream>();
            IndexQuery iq = Cm.getIndexQuery(value);
            try {
                this.indexer.search(iq, dn + attribute, new SearchCallback(this.cacheDB, this.indexer, res, expirations, threshold));
            }
            catch (Exception ex) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block2;
                LOG.log(Level.WARNING, "Exception while searching in index", ex);
            }
        }
        return res;
    }

    public synchronized List<SrdiMessage.Entry> getEntries(String dn, boolean clearDeltas) {
        ArrayList<SrdiMessage.Entry> res;
        block4: {
            res = new ArrayList<SrdiMessage.Entry>();
            try {
                Map<String, NameIndexer> map = this.indexer.getIndexers();
                BTreeFiler listDB = this.indexer.getListDB();
                Iterator<String> it = map.keySet().iterator();
                while (it != null && it.hasNext()) {
                    String indexName = it.next();
                    if (!indexName.startsWith(dn)) continue;
                    String attr = indexName.substring(dn.length());
                    NameIndexer idxr = map.get(indexName);
                    idxr.query(null, new Indexer.SearchCallback(listDB, new EntriesCallback(this.cacheDB, res, attr, Integer.MAX_VALUE)));
                }
            }
            catch (Exception ex) {
                if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) break block4;
                LOG.log(Level.SEVERE, "Exception while searching in index", ex);
            }
        }
        if (clearDeltas) {
            this.clearDeltas(dn);
        }
        return res;
    }

    public synchronized List<SrdiMessage.Entry> getDeltas(String dn) {
        ArrayList<SrdiMessage.Entry> result = new ArrayList<SrdiMessage.Entry>();
        List<SrdiMessage.Entry> deltas = this.deltaMap.get(dn);
        if (deltas != null) {
            result.addAll(deltas);
            deltas.clear();
        }
        return result;
    }

    private synchronized void clearDeltas(String dn) {
        List<SrdiMessage.Entry> deltas = this.deltaMap.get(dn);
        if (deltas == null) {
            return;
        }
        deltas.clear();
    }

    private synchronized void addDelta(String dn, Map<String, String> indexables, long exp) {
        Iterator<Map.Entry<String, String>> eachIndex;
        if (this.trackDeltas && (eachIndex = indexables.entrySet().iterator()).hasNext()) {
            List<SrdiMessage.Entry> deltas = this.deltaMap.get(dn);
            if (deltas == null) {
                deltas = new ArrayList<SrdiMessage.Entry>();
                this.deltaMap.put(dn, deltas);
            }
            while (eachIndex.hasNext()) {
                Map.Entry<String, String> anEntry = eachIndex.next();
                String attr = anEntry.getKey();
                String value = anEntry.getValue();
                SrdiMessage.Entry entry = new SrdiMessage.Entry(attr, value, exp);
                deltas.add(entry);
                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("Added entry  :" + entry + " to deltas");
            }
        }
    }

    public synchronized void setTrackDeltas(boolean trackDeltas) {
        this.trackDeltas = trackDeltas;
        if (!trackDeltas) {
            this.deltaMap.clear();
        }
    }

    public synchronized void stop() {
        block2: {
            try {
                this.cacheDB.close();
                this.indexer.close();
                this.stop = true;
                this.notify();
            }
            catch (DBException ex) {
                if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) break block2;
                LOG.log(Level.SEVERE, "Unable to close advertisments.tbl", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        try {
            try {
                while (!this.stop) {
                    block10: {
                        try {
                            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                LOG.fine("waiting 60000ms before garbage collection");
                            }
                            this.wait(60000L);
                        }
                        catch (InterruptedException woken) {
                            Thread.interrupted();
                            if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block10;
                            LOG.log(Level.FINE, "Thread interrupted", woken);
                        }
                    }
                    if (this.stop) break;
                    if (this.inconvenienceLevel <= 1000 && System.currentTimeMillis() <= this.gcTime) continue;
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Garbage collection started");
                    }
                    this.garbageCollect();
                    this.inconvenienceLevel = 0;
                    this.gcTime = System.currentTimeMillis() + this.gcMaxInterval;
                    if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("Garbage collection completed");
                }
                Object var3_3 = null;
                this.gcThread = null;
            }
            catch (Throwable all) {
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "Uncaught Throwable in thread :" + Thread.currentThread().getName(), all);
                }
                Object var3_4 = null;
                this.gcThread = null;
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.gcThread = null;
            throw throwable;
        }
    }

    private synchronized void rebuildIndex() throws DBException, IOException {
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Rebuilding indices");
        }
        String pattern = "*";
        IndexQuery any = new IndexQuery(0, pattern);
        this.cacheDB.query(any, new RebuildIndexCallback(this.cacheDB, this.indexer));
    }

    private static final class RebuildIndexCallback
    implements BTreeCallback {
        private BTreeFiler database = null;
        private Indexer index = null;

        RebuildIndexCallback(BTreeFiler database, Indexer index) {
            this.database = database;
            this.index = index;
        }

        public boolean indexInfo(Value val, long pos) {
            try {
                Record record = this.database.readRecord(pos);
                if (record == null) {
                    return true;
                }
                InputStream is = record.getValue().getInputStream();
                XMLDocument asDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, is);
                Advertisement adv = AdvertisementFactory.newAdvertisement(asDoc);
                Map indexables = Cm.getIndexfields(adv.getIndexFields(), asDoc);
                String dn = Cm.getDirName(adv);
                Map keyedIdx = Cm.addKey(dn, indexables);
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Restoring index " + keyedIdx + " at " + pos);
                }
                this.index.addToIndex(keyedIdx, pos);
            }
            catch (Exception ex) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Exception rebuilding index  at " + pos, ex);
                }
                return true;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SearchCallback
    implements BTreeCallback {
        private BTreeFiler cacheDB = null;
        private Indexer indexer = null;
        private int threshold;
        private List<InputStream> results;
        private List<Long> expirations;
        private boolean purge;

        SearchCallback(BTreeFiler cacheDB, Indexer indexer, List<InputStream> results, List<Long> expirations, int threshold) {
            this(cacheDB, indexer, results, expirations, threshold, false);
        }

        SearchCallback(BTreeFiler cacheDB, Indexer indexer, List<InputStream> results, List<Long> expirations, int threshold, boolean purge) {
            this.cacheDB = cacheDB;
            this.indexer = indexer;
            this.results = results;
            this.threshold = threshold;
            this.expirations = expirations;
            this.purge = purge;
        }

        @Override
        public boolean indexInfo(Value val, long pos) {
            long exp;
            Record record;
            if (this.results.size() >= this.threshold) {
                return false;
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Found " + val.toString() + " at " + pos);
            }
            try {
                record = this.cacheDB.readRecord(pos);
            }
            catch (DBException ex) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Exception while reading indexed", ex);
                }
                return false;
            }
            if (record == null) {
                return true;
            }
            if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Search callback record " + record.toString());
            }
            if ((exp = Cm.calcExpiration(record)) < 0L) {
                block15: {
                    if (this.purge) {
                        try {
                            this.indexer.purge(pos);
                            this.cacheDB.deleteRecord(record.getKey());
                        }
                        catch (DBException ex) {
                            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                                LOG.log(Level.WARNING, "Exception while reading indexed", ex);
                            }
                            break block15;
                        }
                        catch (IOException ie) {
                            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                                LOG.log(Level.WARNING, "Exception while reading indexed", ie);
                            }
                            break block15;
                        }
                    }
                    ++Cm.this.inconvenienceLevel;
                }
                return true;
            }
            if (this.expirations != null) {
                this.expirations.add(exp);
            }
            this.results.add(record.getValue().getInputStream());
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EntriesCallback
    implements BTreeCallback {
        private BTreeFiler cacheDB = null;
        private int threshold;
        private List<SrdiMessage.Entry> results;
        private String key;

        EntriesCallback(BTreeFiler cacheDB, List<SrdiMessage.Entry> results, String key, int threshold) {
            this.cacheDB = cacheDB;
            this.results = results;
            this.key = key;
            this.threshold = threshold;
        }

        @Override
        public boolean indexInfo(Value val, long pos) {
            Record record;
            if (this.results.size() >= this.threshold) {
                return false;
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Found " + val.toString() + " at " + pos);
            }
            try {
                record = this.cacheDB.readRecord(pos);
            }
            catch (DBException ex) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Exception while reading indexed", ex);
                }
                return false;
            }
            if (record == null) {
                return true;
            }
            long exp = Cm.calcExpiration(record);
            if (exp <= 0L) {
                return true;
            }
            Long life = (Long)record.getMetaData("lifetime");
            SrdiMessage.Entry entry = new SrdiMessage.Entry(this.key, val.toString(), life - System.currentTimeMillis());
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine(" key [" + entry.key + "] value [" + entry.value + "] exp [" + entry.expiration + "]");
            }
            this.results.add(entry);
            return true;
        }
    }
}

