/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.cm;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.credential.Credential;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.cm.SrdiIndex;
import net.jxta.impl.protocol.ResolverSrdiMsgImpl;
import net.jxta.impl.protocol.SrdiMessageImpl;
import net.jxta.impl.util.JxtaHash;
import net.jxta.logging.Logging;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.RdvAdvertisement;
import net.jxta.protocol.ResolverQueryMsg;
import net.jxta.protocol.SrdiMessage;
import net.jxta.rendezvous.RendezVousService;
import net.jxta.rendezvous.RendezVousStatus;
import net.jxta.rendezvous.RendezvousEvent;
import net.jxta.rendezvous.RendezvousListener;
import net.jxta.resolver.ResolverService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Srdi
implements Runnable,
RendezvousListener {
    private static final Logger LOG = Logger.getLogger(Srdi.class.getName());
    private PeerGroup group = null;
    private String handlername = null;
    private SrdiInterface srdiService = null;
    private SrdiIndex srdiIndex;
    private long connectPollInterval = 0L;
    private long pushInterval = 0L;
    private volatile boolean stop = false;
    private AtomicBoolean republishSignal = new AtomicBoolean(false);
    private ResolverService resolver;
    private MembershipService membership;
    private final JxtaHash jxtaHash = new JxtaHash();
    private CredentialListener membershipCredListener = null;
    private Credential credential = null;
    private StructuredDocument credentialDoc = null;
    private final String rdvEventLock;
    private static final Random random = new Random();
    public static final int RPV_REPLICATION_THRESHOLD = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Srdi(PeerGroup group, String handlername, SrdiInterface srdiService, SrdiIndex srdiIndex, long connectPollInterval, long pushInterval) {
        this.group = group;
        this.handlername = handlername;
        this.srdiService = srdiService;
        this.srdiIndex = srdiIndex;
        this.connectPollInterval = connectPollInterval;
        this.pushInterval = pushInterval;
        this.rdvEventLock = new String(handlername);
        this.membership = group.getMembershipService();
        this.resolver = group.getResolverService();
        group.getRendezVousService().addListener(this);
        Srdi srdi = this;
        synchronized (srdi) {
            block5: {
                this.membershipCredListener = new CredentialListener();
                this.membership.addPropertyChangeListener("defaultCredential", this.membershipCredListener);
                try {
                    this.credential = this.membership.getDefaultCredential();
                    this.credentialDoc = null != this.credential ? this.credential.getDocument(MimeMediaType.XMLUTF8) : null;
                }
                catch (Exception all) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block5;
                    LOG.log(Level.WARNING, "could not get credential", all);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (this.stop) {
            return;
        }
        this.stop = true;
        RendezVousService rendezvous = this.group.getRendezVousService();
        if (null != rendezvous) {
            rendezvous.removeListener(this);
        }
        this.membership.removePropertyChangeListener("defaultCredential", this.membershipCredListener);
        this.membershipCredListener = null;
        String string = this.rdvEventLock;
        synchronized (string) {
            this.rdvEventLock.notify();
        }
    }

    public void replicateEntries(SrdiMessage srdiMsg) {
        Vector<PeerID> rpv = this.getGlobalPeerView();
        if (srdiMsg.getScope() < 1 || !this.group.isRendezvous() || rpv.size() < 3) {
            return;
        }
        Iterator<SrdiMessage.Entry> allEntries = srdiMsg.getEntries().iterator();
        HashMap<PeerID, SrdiMessageImpl> bins = new HashMap<PeerID, SrdiMessageImpl>(rpv.size());
        while (allEntries.hasNext()) {
            SrdiMessage.Entry entry = allEntries.next();
            PeerID destPeer = this.getReplicaPeer(srdiMsg.getPrimaryKey() + entry.key + entry.value);
            if (destPeer == null || destPeer.equals(this.group.getPeerID())) continue;
            SrdiMessageImpl sm = (SrdiMessageImpl)bins.get(destPeer);
            if (sm == null) {
                sm = new SrdiMessageImpl();
                sm.setPrimaryKey(srdiMsg.getPrimaryKey());
                sm.setPeerID(srdiMsg.getPeerID());
                bins.put(destPeer, sm);
            }
            sm.addEntry(entry);
        }
        for (PeerID destPeer : bins.keySet()) {
            SrdiMessageImpl msg = (SrdiMessageImpl)bins.get(destPeer);
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.group.getPeerGroupName() + " / " + this.handlername + "] Forwarding replica Srdi to " + destPeer);
            }
            this.pushSrdi(destPeer, msg);
        }
    }

    public void pushSrdi(ID peer, SrdiMessage srdi) {
        block4: {
            try {
                ResolverSrdiMsgImpl resSrdi = new ResolverSrdiMsgImpl(this.handlername, this.credential, srdi.toString());
                if (null == peer) {
                    this.resolver.sendSrdi(null, resSrdi);
                } else {
                    this.resolver.sendSrdi(peer.toString(), resSrdi);
                }
            }
            catch (Exception e) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block4;
                LOG.log(Level.WARNING, "Failed to send srdi message", e);
            }
        }
    }

    public void forwardQuery(PeerID peer, ResolverQueryMsg query) {
        query.incrementHopCount();
        if (query.getHopCount() > 2) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("hopCount exceeded. Not forwarding query " + query.getHopCount());
            }
            return;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine(MessageFormat.format("[{0} / {1}] Forwarding Query to {2}", this.group.getPeerGroupName(), this.handlername, peer));
        }
        this.resolver.sendQuery(peer.toString(), query);
    }

    public void forwardQuery(List<PeerID> peers, ResolverQueryMsg query) {
        query.incrementHopCount();
        if (query.getHopCount() > 2) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine(MessageFormat.format("hopCount exceeded not forwarding query {0}", query.getHopCount()));
            }
            return;
        }
        for (PeerID destPeer : peers) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine(MessageFormat.format("[{0} / {1}] Forwarding Query to {2}", this.group.getPeerGroupName(), this.handlername, destPeer));
            }
            this.resolver.sendQuery(destPeer.toString(), query);
        }
    }

    public void forwardQuery(List<PeerID> peers, ResolverQueryMsg query, int threshold) {
        if (query.getHopCount() > 2) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine(MessageFormat.format("[{0} / {1}] hopCount exceeded ({2}) not forwarding query.", this.group.getPeerGroupName(), this.handlername, query.getHopCount()));
            }
            return;
        }
        if (peers.size() <= threshold) {
            this.forwardQuery(peers, query);
        } else {
            List<PeerID> newPeers = this.randomResult(peers, threshold);
            this.forwardQuery(newPeers, query);
        }
    }

    protected List<PeerID> randomResult(List<PeerID> result, int threshold) {
        if (threshold < result.size()) {
            ArrayList<PeerID> res = new ArrayList<PeerID>(threshold);
            for (int i = 0; i < threshold; ++i) {
                int rand = random.nextInt(result.size());
                res.add(result.get(rand));
                result.remove(rand);
            }
            return res;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerID getReplicaPeer(String expression) {
        Vector<PeerID> rpv = this.getGlobalPeerView();
        if (rpv.size() >= 3) {
            BigInteger digest;
            JxtaHash jxtaHash = this.jxtaHash;
            synchronized (jxtaHash) {
                this.jxtaHash.update(expression);
                digest = this.jxtaHash.getDigestInteger().abs();
            }
            BigInteger sizeOfSpace = BigInteger.valueOf(rpv.size());
            BigInteger sizeOfHashSpace = BigInteger.ONE.shiftLeft(8 * digest.toByteArray().length);
            int pos = digest.multiply(sizeOfSpace).divide(sizeOfHashSpace).intValue();
            PeerID pid = (PeerID)rpv.get(pos);
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine(MessageFormat.format("[{0} / {1}] Found a direct peer {2}", this.group.getPeerGroupName(), this.handlername, pid));
            }
            return pid;
        }
        return null;
    }

    public void forwardSrdiMessage(PeerID peerid, PeerID srcPid, String primaryKey, String secondarykey, String value, long expiration) {
        block3: {
            try {
                SrdiMessageImpl srdi = new SrdiMessageImpl(srcPid, 0, primaryKey, secondarykey, value, expiration);
                ResolverSrdiMsgImpl resSrdi = new ResolverSrdiMsgImpl(this.handlername, this.credential, srdi.toString());
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine(MessageFormat.format("[{0} / {1}] Forwarding a SRDI messsage of type {2} to {3}", this.group.getPeerGroupName(), this.handlername, primaryKey, peerid));
                }
                this.resolver.sendSrdi(peerid.toString(), resSrdi);
            }
            catch (Exception e) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block3;
                LOG.log(Level.WARNING, "Failed forwarding SRDI Message", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rendezvousEvent(RendezvousEvent event) {
        int theEventType = event.getType();
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine(MessageFormat.format("[{0} / {1}] Processing {2}", this.group.getPeerGroupName(), this.handlername, event));
        }
        switch (theEventType) {
            case 0: {
                String string = this.rdvEventLock;
                synchronized (string) {
                    this.rdvEventLock.notify();
                    break;
                }
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                break;
            }
            case 4: 
            case 5: {
                this.republishSignal.set(true);
                break;
            }
            case 6: 
            case 7: {
                String string = this.rdvEventLock;
                synchronized (string) {
                    if (this.group.isRendezvous() && this.srdiIndex != null) {
                        this.srdiIndex.remove((PeerID)event.getPeerID());
                    }
                    break;
                }
            }
            default: {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break;
                LOG.warning(MessageFormat.format("[{0} / {1}] Unexpected RDV event {2}", this.group.getPeerGroupName(), this.handlername, event));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        boolean republish = true;
        try {
            while (!this.stop) {
                boolean waitingForRdv;
                republish |= this.republishSignal.compareAndSet(true, false);
                boolean bl = waitingForRdv = this.group.isRendezvous() || !this.group.getRendezVousService().isConnectedToRendezVous() || this.group.getRendezVousService().getRendezVousStatus() == RendezVousStatus.ADHOC;
                if (!waitingForRdv) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + this.group.getPeerGroupName() + " / " + this.handlername + "] Pushing " + (republish ? "all entries" : "deltas"));
                    }
                    this.srdiService.pushEntries(republish);
                    republish = false;
                }
                String string = this.rdvEventLock;
                synchronized (string) {
                    try {
                        this.rdvEventLock.wait(waitingForRdv ? this.connectPollInterval : this.pushInterval);
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                    }
                }
            }
            return;
        }
        catch (Throwable all) {
            if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) return;
            LOG.log(Level.SEVERE, "Uncaught Throwable in " + Thread.currentThread().getName() + "[" + this.group.getPeerGroupName() + " / " + this.handlername + "]", all);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector<PeerID> getGlobalPeerView() {
        Vector<PeerID> global = new Vector<PeerID>();
        TreeSet<String> set = new TreeSet<String>();
        try {
            Vector<RdvAdvertisement> rpv = this.group.getRendezVousService().getLocalWalkView();
            for (RdvAdvertisement padv : rpv) {
                set.add(padv.getPeerID().toString());
            }
            set.add(this.group.getPeerID().toString());
            for (String aSet : set) {
                try {
                    PeerID peerID = (PeerID)IDFactory.fromURI(new URI(aSet));
                    global.add(peerID);
                }
                catch (URISyntaxException badID) {
                    throw new IllegalArgumentException("Bad PeerID ID in advertisement");
                }
                catch (ClassCastException badID) {
                    throw new IllegalArgumentException("ID was not a peerID");
                    return global;
                }
            }
        }
        catch (Exception ex) {
            if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) return global;
            LOG.log(Level.WARNING, "Failure generating the global view", ex);
        }
        return global;
    }

    public static interface SrdiInterface {
        public void pushEntries(boolean var1);
    }

    private class CredentialListener
    implements PropertyChangeListener {
        private CredentialListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            if ("defaultCredential".equals(evt.getPropertyName())) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("New default credential event");
                }
                Srdi srdi = Srdi.this;
                synchronized (srdi) {
                    block8: {
                        Srdi.this.credential = (Credential)evt.getNewValue();
                        Srdi.this.credentialDoc = null;
                        if (null != Srdi.this.credential) {
                            try {
                                Srdi.this.credentialDoc = Srdi.this.credential.getDocument(MimeMediaType.XMLUTF8);
                            }
                            catch (Exception all) {
                                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block8;
                                LOG.log(Level.WARNING, "Could not generate credential document", all);
                            }
                        }
                    }
                }
            }
        }
    }
}

