/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.io.IOException;
import java.net.BindException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;
import net.jxta.impl.endpoint.SocketFactory;
import net.jxta.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IPUtils {
    private static final Logger LOG;
    static final String IPV4ANYADDRESS = "0.0.0.0";
    static final String IPV6ANYADDRESS = "::";
    static final String IPV4LOOPBACK = "127.0.0.1";
    static final String IPV6LOOPBACK = "::1";
    public static final InetAddress ANYADDRESS;
    public static final InetAddress ANYADDRESSV4;
    public static final InetAddress ANYADDRESSV6;
    public static final InetAddress LOOPBACK;
    public static final InetAddress LOOPBACKV4;
    public static final InetAddress LOOPBACKV6;
    private static SocketFactory socketFactory;
    private static ServerSocketFactory serverSocketFactory;
    static final int rangesize = 200;

    private IPUtils() {
    }

    public static Collection<InetAddress> getAllLocalAddresses() {
        Enumeration<NetworkInterface> allInterfaces;
        ArrayList<InetAddress> allAddr;
        block12: {
            allAddr = new ArrayList<InetAddress>();
            allInterfaces = null;
            try {
                allInterfaces = NetworkInterface.getNetworkInterfaces();
            }
            catch (SocketException caught) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block12;
                LOG.log(Level.WARNING, "Could not get local interfaces list", caught);
            }
        }
        if (null == allInterfaces) {
            allInterfaces = Collections.enumeration(Collections.emptyList());
        }
        while (allInterfaces.hasMoreElements()) {
            NetworkInterface anInterface = allInterfaces.nextElement();
            try {
                Enumeration<InetAddress> allIntfAddr = anInterface.getInetAddresses();
                while (allIntfAddr.hasMoreElements()) {
                    InetAddress anAddr = allIntfAddr.nextElement();
                    if (anAddr.isLoopbackAddress() || anAddr.isAnyLocalAddress() || allAddr.contains(anAddr)) continue;
                    allAddr.add(anAddr);
                }
            }
            catch (Throwable caught) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.log(Level.WARNING, "Could not get addresses for " + anInterface, caught);
            }
        }
        if (allAddr.isEmpty() || Boolean.getBoolean("net.jxta.impl.IPUtils.localOnly")) {
            if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                LOG.finer("Adding loopback interfaces");
            }
            if (null != LOOPBACKV4) {
                allAddr.add(LOOPBACKV4);
            }
            if (null != LOOPBACKV6) {
                allAddr.add(LOOPBACKV6);
            }
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Returning " + allAddr.size() + " addresses.");
        }
        return allAddr;
    }

    public static String getHostAddress(InetAddress anAddress) {
        String hostAddress;
        int percentAt;
        hostAddress = anAddress instanceof Inet6Address ? (-1 == (percentAt = (hostAddress = anAddress.getHostAddress()).indexOf(37)) ? "[" + hostAddress + "]" : "[" + hostAddress.substring(0, percentAt) + "]") : anAddress.getHostAddress();
        return hostAddress;
    }

    public static InetSocketAddress parseSocketAddress(String anAddress) {
        String port;
        String hostAddress;
        if (anAddress.startsWith("[")) {
            int endBracketAt = anAddress.indexOf(93);
            int portSeparatorAt = anAddress.lastIndexOf(58);
            if (-1 == endBracketAt) {
                throw new IllegalArgumentException("missing final ]");
            }
            if (-1 == portSeparatorAt) {
                throw new IllegalArgumentException("missing port separator");
            }
            if (portSeparatorAt < endBracketAt) {
                throw new IllegalArgumentException("missing port");
            }
            hostAddress = anAddress.substring(1, endBracketAt);
            port = anAddress.substring(portSeparatorAt);
        } else {
            int portSeparatorAt = anAddress.lastIndexOf(58);
            if (-1 == portSeparatorAt) {
                throw new IllegalArgumentException("missing port separator");
            }
            hostAddress = anAddress.substring(0, portSeparatorAt);
            port = anAddress.substring(portSeparatorAt + 1);
        }
        int portNum = Integer.parseInt(port);
        return InetSocketAddress.createUnresolved(hostAddress, portNum);
    }

    public static Socket connectToFrom(InetAddress inetAddress, int port, InetAddress usingInterface, int localPort, int timeout) throws IOException {
        if (socketFactory != null) {
            return socketFactory.createConnection(inetAddress, port, usingInterface, localPort, timeout);
        }
        return IPUtils.connectToFromNoFactory(inetAddress, port, usingInterface, localPort, timeout);
    }

    public static Socket connectToFromNoFactory(InetAddress inetAddress, int port, InetAddress usingInterface, int localPort, int timeout) throws IOException {
        Socket socket = new Socket();
        InetSocketAddress src = new InetSocketAddress(usingInterface, localPort);
        InetSocketAddress dst = new InetSocketAddress(inetAddress, port);
        socket.bind(src);
        socket.connect(dst, timeout);
        return socket;
    }

    public static void setSocketFactory(SocketFactory sf) {
        socketFactory = sf;
    }

    public static SocketFactory getSocketFactory() {
        return socketFactory;
    }

    public static void setServerSocketFactory(ServerSocketFactory sf) {
        serverSocketFactory = sf;
    }

    public static ServerSocketFactory getServerSocketFactory() {
        return serverSocketFactory;
    }

    public static ServerSocket openServerSocketInRange(int start, int end, int backlog, InetAddress bindAddress) throws IOException {
        ServerSocketFactory factory = IPUtils.getServerSocketFactory();
        ServerSocket result = null == factory ? new ServerSocket() : factory.createServerSocket();
        return IPUtils.bindServerSocketInRange(result, start, end, backlog, bindAddress);
    }

    public static ServerSocket bindServerSocketInRange(ServerSocket socket, int start, int end, int backlog, InetAddress bindAddress) throws IOException {
        if (start < 0 || start > 65535) {
            throw new IllegalArgumentException("Invalid start port");
        }
        if (end < 0 || end > 65535 || end < start) {
            throw new IllegalArgumentException("Invalid end port");
        }
        if (0 == start) {
            InetSocketAddress bindSocketAddress = new InetSocketAddress(bindAddress, 0);
            socket.bind(bindSocketAddress, backlog);
            return socket;
        }
        ArrayList<Integer> inRange = new ArrayList<Integer>(200);
        for (int eachInRange = 0; eachInRange < 200; ++eachInRange) {
            inRange.add(eachInRange, eachInRange);
        }
        ArrayList<Integer> ranges = new ArrayList<Integer>();
        for (int starts = start; starts <= end; starts += 200) {
            ranges.add(starts);
        }
        Collections.shuffle(ranges);
        while (!ranges.isEmpty()) {
            int range = (Integer)ranges.remove(0);
            Collections.shuffle(inRange);
            for (int eachInRange = 0; eachInRange < 200; ++eachInRange) {
                int tryPort = range + (Integer)inRange.get(eachInRange);
                if (tryPort > end) continue;
                InetSocketAddress bindSocketAddress = new InetSocketAddress(bindAddress, tryPort);
                try {
                    socket.bind(bindSocketAddress, backlog);
                    return socket;
                }
                catch (SocketException failed) {
                    // empty catch block
                }
            }
        }
        throw new BindException("All ports in range are in use.");
    }

    static {
        InetAddress GET_ADDRESS;
        block13: {
            block12: {
                block11: {
                    block10: {
                        LOG = Logger.getLogger(IPUtils.class.getName());
                        GET_ADDRESS = null;
                        try {
                            GET_ADDRESS = InetAddress.getByName(IPV4ANYADDRESS);
                        }
                        catch (Exception ignored) {
                            if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block10;
                            LOG.warning("failed to intialize ANYADDRESSV4. Not fatal");
                        }
                    }
                    ANYADDRESSV4 = GET_ADDRESS;
                    GET_ADDRESS = null;
                    try {
                        GET_ADDRESS = InetAddress.getByName(IPV6ANYADDRESS);
                    }
                    catch (Exception ignored) {
                        if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block11;
                        LOG.warning("failed to intialize IPV6ANYADDRESS. Not fatal");
                    }
                }
                ANYADDRESSV6 = GET_ADDRESS;
                ANYADDRESS = ANYADDRESSV4 == null ? ANYADDRESSV6 : ANYADDRESSV4;
                GET_ADDRESS = null;
                try {
                    GET_ADDRESS = InetAddress.getByName(IPV4LOOPBACK);
                }
                catch (Exception ignored) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block12;
                    LOG.warning("failed to intialize IPV4LOOPBACK. Not fatal");
                }
            }
            LOOPBACKV4 = GET_ADDRESS;
            GET_ADDRESS = null;
            try {
                GET_ADDRESS = InetAddress.getByName(IPV6LOOPBACK);
            }
            catch (Exception ignored) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block13;
                LOG.warning("failed to intialize ANYADDRESSV4. Not fatal");
            }
        }
        LOOPBACKV6 = GET_ADDRESS;
        InetAddress inetAddress = LOOPBACK = LOOPBACKV4 == null ? LOOPBACKV6 : LOOPBACKV4;
        if (LOOPBACK == null || ANYADDRESS == null) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.severe("failure initializing statics. Neither IPV4 nor IPV6 seem to work.");
            }
            throw new IllegalStateException("failure initializing statics. Neither IPV4 nor IPV6 seem to work.");
        }
    }
}

