/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.endpointMeter;

import net.jxta.impl.endpoint.endpointMeter.PropagationMetric;

public class PropagationMeter {
    private String serviceName;
    private String serviceParameter;
    private PropagationMetric totals;
    private PropagationMetric delta;

    public PropagationMeter(String serviceName, String serviceParameter) {
        this.serviceName = serviceName;
        this.serviceParameter = serviceParameter;
        this.totals = new PropagationMetric(this);
    }

    private void createDeltaMetric() {
        this.delta = new PropagationMetric(this);
    }

    public void registerPropagateMessageStats(int numPropagatedTo, int numFilteredOut, int numErrorsPropagated, long propagationTime) {
        if (this.delta == null) {
            this.createDeltaMetric();
        }
        this.delta.registerPropagateMessageStats(numPropagatedTo, numFilteredOut, numErrorsPropagated, propagationTime);
        this.totals.registerPropagateMessageStats(numPropagatedTo, numFilteredOut, numErrorsPropagated, propagationTime);
    }

    String getServiceName() {
        return this.serviceName;
    }

    String getServiceParameter() {
        return this.serviceParameter;
    }

    public String toString() {
        return "PropagationMeter(" + this.serviceName + "//" + this.serviceParameter + ")";
    }

    public PropagationMetric getCumulativeMetrics() {
        return this.totals;
    }

    public synchronized PropagationMetric collectMetrics() {
        PropagationMetric prevDelta = this.delta;
        this.delta = null;
        return prevDelta;
    }
}

