/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.relay;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.MessageTransport;
import net.jxta.impl.endpoint.relay.RelayClient;
import net.jxta.impl.util.URISeedingManager;
import net.jxta.logging.Logging;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.RouteAdvertisement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelayReferralSeedingManager
extends URISeedingManager {
    private static final transient Logger LOG = Logger.getLogger(RelayReferralSeedingManager.class.getName());
    private final PeerGroup group;

    public RelayReferralSeedingManager(URI aclLocation, boolean allowOnlySeeds, PeerGroup group, String serviceName) {
        super(aclLocation, allowOnlySeeds, group, serviceName);
        this.group = group;
    }

    @Override
    public synchronized URI[] getActiveSeedURIs() {
        boolean addedEA;
        ArrayList<URI> result = new ArrayList<URI>();
        Collection<RouteAdvertisement> relays = this.getRelayPeers();
        int eaIndex = 0;
        do {
            addedEA = false;
            for (RouteAdvertisement aRA : relays) {
                List<EndpointAddress> raEAs = aRA.getDestEndpointAddresses();
                if (eaIndex >= raEAs.size()) continue;
                URI seedURI = raEAs.get(eaIndex).toURI();
                if (!result.contains(seedURI)) {
                    result.add(seedURI);
                }
                addedEA = true;
            }
            ++eaIndex;
        } while (addedEA);
        for (URI eachURI : Arrays.asList(super.getActiveSeedURIs())) {
            if (result.contains(eachURI)) continue;
            result.add(eachURI);
        }
        return result.toArray(new URI[result.size()]);
    }

    @Override
    public synchronized RouteAdvertisement[] getActiveSeedRoutes() {
        ArrayList<RouteAdvertisement> result = new ArrayList<RouteAdvertisement>(this.getRelayPeers());
        for (RouteAdvertisement eachRoute : Arrays.asList(super.getActiveSeedRoutes())) {
            if (result.contains(eachRoute)) continue;
            result.add(eachRoute);
        }
        return result.toArray(new RouteAdvertisement[result.size()]);
    }

    private Collection<RouteAdvertisement> getRelayPeers() {
        ArrayList<RouteAdvertisement> result;
        block4: {
            result = new ArrayList<RouteAdvertisement>();
            try {
                EndpointService ep = this.group.getEndpointService();
                Iterator<MessageTransport> it = ep.getAllMessageTransports();
                while (it.hasNext()) {
                    RouteAdvertisement rdvAdv;
                    MessageTransport mt = it.next();
                    if (!mt.getEndpointService().getGroup().getPeerGroupID().equals(this.group.getPeerGroupID()) || !(mt instanceof RelayClient)) continue;
                    RelayClient er = (RelayClient)mt;
                    RelayClient.RelayServerConnection current = er.currentServer;
                    if (null == current || null == (rdvAdv = current.relayAdv)) continue;
                    result.add(rdvAdv.clone());
                }
            }
            catch (Exception ez1) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block4;
                LOG.log(Level.WARNING, "Unexpected error getting relays", ez1);
            }
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Found " + result.size() + " relay seeds.");
        }
        return result;
    }
}

