/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.relay;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.MessageSender;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.MessengerEvent;
import net.jxta.endpoint.MessengerEventListener;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.access.AccessList;
import net.jxta.impl.endpoint.EndpointUtils;
import net.jxta.impl.endpoint.relay.RelayServerClient;
import net.jxta.impl.endpoint.relay.RelayTransport;
import net.jxta.impl.protocol.RelayConfigAdv;
import net.jxta.logging.Logging;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.protocol.RdvAdvertisement;
import net.jxta.protocol.RouteAdvertisement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelayServer
implements MessageSender,
MessengerEventListener,
Runnable {
    private static final transient Logger LOG = Logger.getLogger(RelayServer.class.getName());
    private static final int MAX_CACHED_SERVERS = 20;
    private EndpointService endpointService;
    private DiscoveryService discoveryService;
    private final EndpointAddress publicAddress;
    private final Map<String, RelayServerClient> relayedClients;
    protected final PeerGroup group;
    protected final String serviceName;
    private final int maxClients;
    private final long maxLeaseDuration;
    private final long stallTimeout;
    private final int clientQueueSize;
    private final long minBroadcastInterval;
    protected final String peerId;
    protected final AccessList acl;
    protected File aclFile;
    protected long refreshTime;
    protected long aclFileLastModified;
    private static final long ACL_REFRESH_PERIOD = 1800000L;
    protected RelayServerCache relayServerCache;
    private Thread gcThread;
    private MessengerEventListener messengerEventListener;

    public RelayServer(PeerGroup group, String serviceName, RelayConfigAdv relayConfigAdv) {
        block3: {
            this.relayedClients = new HashMap<String, RelayServerClient>();
            this.refreshTime = 0L;
            this.aclFileLastModified = 0L;
            this.gcThread = null;
            this.messengerEventListener = null;
            this.group = group;
            this.peerId = group.getPeerID().getUniqueValue().toString();
            this.publicAddress = new EndpointAddress("relay", this.peerId, null, null);
            this.serviceName = serviceName;
            this.maxClients = -1 != relayConfigAdv.getMaxClients() ? relayConfigAdv.getMaxClients() : 150;
            this.clientQueueSize = -1 != relayConfigAdv.getClientMessageQueueSize() ? relayConfigAdv.getClientMessageQueueSize() : 20;
            this.maxLeaseDuration = -1L != relayConfigAdv.getServerLeaseDuration() ? relayConfigAdv.getServerLeaseDuration() : 3600000L;
            this.minBroadcastInterval = -1L != relayConfigAdv.getAnnounceInterval() ? relayConfigAdv.getAnnounceInterval() : 600000L;
            this.stallTimeout = -1L != relayConfigAdv.getStallTimeout() ? relayConfigAdv.getStallTimeout() : 15000L;
            this.aclFile = new File(new File(group.getStoreHome()), "relayACL.xml");
            this.aclFileLastModified = this.aclFile.lastModified();
            this.acl = new AccessList();
            try {
                this.acl.init(this.aclFile);
                this.refreshTime = System.currentTimeMillis() + 1800000L;
            }
            catch (IOException io) {
                this.acl.setGrantAll(true);
                this.refreshTime = Long.MAX_VALUE;
                if (!Logging.SHOW_INFO || !LOG.isLoggable(Level.INFO)) break block3;
                LOG.info("RelayServer Access Control granting all permissions");
            }
        }
        if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
            StringBuilder configInfo = new StringBuilder("Configuring Relay Server");
            configInfo.append("\n\tGroup Params :");
            configInfo.append("\n\t\tGroup : ").append(group);
            configInfo.append("\n\t\tPeer ID : ").append(group.getPeerID());
            configInfo.append("\n\tConfiguration :");
            configInfo.append("\n\t\tService Name : ").append(serviceName);
            configInfo.append("\n\t\tMax Relay Clients : ").append(this.maxClients);
            configInfo.append("\n\t\tMax Lease Length : ").append(this.maxLeaseDuration).append("ms.");
            configInfo.append("\n\t\tBroadcast Interval : ").append(this.minBroadcastInterval).append("ms.");
            configInfo.append("\n\t\tStall Timeout : ").append(this.stallTimeout).append("ms.");
            LOG.config(configInfo.toString());
        }
    }

    public List<String> getRelayedClients() {
        ArrayList<String> res = new ArrayList<String>();
        for (Object o : Arrays.asList(this.relayedClients.values().toArray())) {
            String client = o.toString();
            res.add(client);
        }
        return res;
    }

    public boolean startServer() {
        block6: {
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.info("Starting " + this.publicAddress.toString());
            }
            this.endpointService = this.group.getEndpointService();
            this.discoveryService = this.group.getDiscoveryService();
            this.messengerEventListener = this.endpointService.addMessageTransport(this);
            if (this.messengerEventListener == null) {
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.severe("Transport registration refused");
                }
                return false;
            }
            try {
                this.discoveryService.publish(RelayServer.createRdvAdvertisement(this.group.getPeerAdvertisement(), this.serviceName));
            }
            catch (IOException e) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block6;
                LOG.log(Level.WARNING, "Could not publish Relay RdvAdvertisement", e);
            }
        }
        this.relayServerCache = new RelayServerCache(this);
        this.relayServerCache.startCache();
        this.endpointService.addMessengerEventListener(this, 2);
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Relay Server started");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServer() {
        RelayServerClient[] oldClients;
        this.relayServerCache.stopCache();
        this.relayServerCache = null;
        this.endpointService.removeMessengerEventListener(this, 2);
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Messenger Event Listener removed " + this.serviceName);
        }
        Map<String, RelayServerClient> map = this.relayedClients;
        synchronized (map) {
            oldClients = this.relayedClients.values().toArray(new RelayServerClient[0]);
        }
        int i = oldClients.length;
        while (i-- > 0) {
            oldClients[i].closeClient();
        }
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Stopped " + this.publicAddress);
        }
    }

    @Override
    public EndpointAddress getPublicAddress() {
        return this.publicAddress;
    }

    @Override
    public boolean isConnectionOriented() {
        return true;
    }

    @Override
    public boolean allowsRouting() {
        return true;
    }

    @Override
    public Object transportControl(Object operation, Object Value2) {
        return null;
    }

    @Override
    public Messenger getMessenger(EndpointAddress destAddr, Object hintIgnored) {
        Messenger messenger = null;
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("getMessenger for dest " + destAddr);
        }
        if (!"relay".equals(destAddr.getProtocolName())) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("could not make messenger for protocol :" + destAddr.getProtocolName());
            }
            return null;
        }
        RelayServerClient handler = this.getClient(destAddr.getProtocolAddress());
        if (handler != null) {
            messenger = handler.getMessenger(this.publicAddress, destAddr, false);
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("messenger for " + destAddr.getProtocolAddress() + " is " + messenger);
        }
        return messenger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean ping(EndpointAddress addr) {
        Map<String, RelayServerClient> map = this.relayedClients;
        synchronized (map) {
            return null != this.relayedClients.get(addr.getProtocolAddress());
        }
    }

    @Override
    public String getProtocolName() {
        return "relay";
    }

    @Override
    public EndpointService getEndpointService() {
        return this.endpointService;
    }

    @Override
    public boolean messengerReady(MessengerEvent event) {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("messengerReady");
        }
        Messenger newMessenger = event.getMessenger();
        Object source = event.getSource();
        EndpointAddress connectionAddress = event.getConnectionAddress();
        if (newMessenger == null || source == null || connectionAddress == null) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("there was not a messenger or not enough information");
            }
            return false;
        }
        if (!this.serviceName.equals(connectionAddress.getServiceName())) {
            return false;
        }
        if (source instanceof MessageSender && !((MessageSender)source).allowsRouting()) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("this is a higher level messenger");
            }
            return false;
        }
        if (source == this || newMessenger instanceof RelayServerClient.RelayMessenger) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("this is a relay messenger");
            }
            return false;
        }
        EndpointAddress destAddr = newMessenger.getLogicalDestinationAddress();
        if (destAddr == null || !"jxta".equals(destAddr.getProtocolName())) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("LogicalDestinationAddress is not a \"jxta\" protocol");
            }
            return false;
        }
        String clientPeerId = destAddr.getProtocolAddress();
        RelayServerClient handler = this.getClient(clientPeerId);
        if (handler != null) {
            return handler.addMessenger(newMessenger);
        }
        this.handleRequest(newMessenger, connectionAddress);
        return true;
    }

    protected void handleRequest(Messenger messenger, EndpointAddress connectionAddress) {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("handleRequest from messenger");
        }
        String request = connectionAddress.getServiceParameter();
        EndpointAddress clientAddr = messenger.getLogicalDestinationAddress();
        if (clientAddr == null || !"jxta".equals(clientAddr.getProtocolName())) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("LogicalDestinationAddress is not a \"jxta\" protocol");
            }
            return;
        }
        String clientPeerId = clientAddr.getProtocolAddress();
        this.handleRequest(request, clientPeerId, messenger);
    }

    protected void handleRequest(Message message, EndpointAddress dstAddr) {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("handleRequest from message");
        }
        String request = RelayTransport.getString(message, "request");
        String clientPeerId = dstAddr.getServiceParameter();
        this.handleRequest(request, clientPeerId, null);
    }

    void handleRequest(String request, String clientPeerId, Messenger messenger) {
        boolean closeMessenger;
        RelayServerClient closingHandler;
        block46: {
            if (request == null) {
                return;
            }
            request = request.toLowerCase();
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("request = " + request);
            }
            if (clientPeerId == null) {
                return;
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("clientPeerId = " + clientPeerId);
            }
            if (clientPeerId.equals("unknown-unknown") && !request.startsWith("pid")) {
                return;
            }
            Message responseMessage = null;
            closingHandler = null;
            boolean rawMessenger = false;
            closeMessenger = false;
            if (request.startsWith("connect")) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("connect clientPeerId = " + clientPeerId);
                }
                long requestedLease = this.maxLeaseDuration;
                boolean returnRelayAdv = false;
                boolean returnOtherRelayAdv = false;
                boolean flushQueue = false;
                String requestedLeaseString = null;
                int startIdx = request.indexOf(44);
                if (startIdx != -1) {
                    int endIdx = request.indexOf(44, startIdx + 1);
                    if (endIdx == -1) {
                        requestedLeaseString = request.substring(startIdx + 1);
                    } else {
                        requestedLeaseString = request.substring(startIdx + 1, endIdx);
                        String flags = request.substring(endIdx + 1);
                        if (flags.endsWith("true")) {
                            returnRelayAdv = true;
                        } else if (flags.endsWith("other")) {
                            returnOtherRelayAdv = true;
                        }
                        if (flags.startsWith("flush")) {
                            flushQueue = true;
                        }
                    }
                }
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("request lease string = " + requestedLeaseString + "\treturn relay adv = " + returnRelayAdv + "\n\treturn other relay adv = " + returnOtherRelayAdv + "\tflush queue = " + flushQueue);
                }
                if (requestedLeaseString != null) {
                    block45: {
                        try {
                            requestedLease = Long.parseLong(requestedLeaseString);
                        }
                        catch (NumberFormatException e) {
                            if (!Logging.SHOW_INFO || !LOG.isLoggable(Level.INFO)) break block45;
                            LOG.info("could not parse requested lease string");
                        }
                    }
                    if (requestedLease > this.maxLeaseDuration) {
                        requestedLease = this.maxLeaseDuration;
                    }
                }
                EndpointAddress clientAddr = new EndpointAddress("jxta", clientPeerId, this.serviceName, this.peerId);
                RelayServerClient handler = this.addClient(clientPeerId, requestedLease, messenger, flushQueue);
                if (handler != null) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("added client " + clientPeerId);
                    }
                    messenger = handler.getMessenger(this.publicAddress, clientAddr, true);
                    responseMessage = RelayTransport.createConnectedMessage(handler.getLeaseRemaining());
                    RdvAdvertisement relayAdv = null;
                    if (returnRelayAdv) {
                        relayAdv = RelayServer.createRdvAdvertisement(this.group.getPeerAdvertisement(), this.serviceName);
                    } else if (returnOtherRelayAdv) {
                        relayAdv = this.relayServerCache.getRandomCacheAdv();
                    }
                    if (relayAdv != null) {
                        XMLDocument asDoc = (XMLDocument)relayAdv.getDocument(MimeMediaType.XMLUTF8);
                        TextDocumentMessageElement relayAdvElement = new TextDocumentMessageElement("relayAdv", asDoc, null);
                        responseMessage.addMessageElement("relay", relayAdvElement);
                    }
                } else {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("could not add client " + clientPeerId);
                    }
                    if (messenger == null) {
                        messenger = this.endpointService.getMessenger(clientAddr);
                        if (messenger != null) {
                            closeMessenger = true;
                        }
                    } else {
                        rawMessenger = true;
                    }
                    responseMessage = RelayTransport.createDisconnectedMessage();
                    RdvAdvertisement relayAdv = this.relayServerCache.getRandomCacheAdv();
                    if (relayAdv != null) {
                        XMLDocument asDoc = (XMLDocument)relayAdv.getDocument(MimeMediaType.XMLUTF8);
                        TextDocumentMessageElement relayAdvElement = new TextDocumentMessageElement("relayAdv", asDoc, null);
                        responseMessage.addMessageElement("relay", relayAdvElement);
                    }
                }
            } else if ("disconnect".equals(request)) {
                if (clientPeerId != null && (closingHandler = this.removeClient(clientPeerId)) != null && Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("removed client " + clientPeerId);
                }
            } else if ("pid".equals(request)) {
                PeerGroupID groupOfMyPid = (PeerGroupID)this.group.getPeerID().getPeerGroupID();
                String pidStr = IDFactory.newPeerID(groupOfMyPid).toString();
                responseMessage = RelayTransport.createPIDResponseMessage(pidStr);
                rawMessenger = true;
            }
            if (messenger != null && responseMessage != null) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("sending response to client " + clientPeerId);
                }
                if (rawMessenger) {
                    new BGSend(messenger, responseMessage, this.serviceName, this.peerId);
                } else {
                    try {
                        messenger.sendMessage(responseMessage, this.serviceName, this.peerId);
                    }
                    catch (IOException e) {
                        if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block46;
                        LOG.log(Level.WARNING, "Could not send response message to " + clientPeerId, e);
                    }
                }
            }
        }
        if (closeMessenger) {
            messenger.close();
        }
        if (closingHandler != null) {
            closingHandler.closeClient();
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("relayedClients.size()=" + this.relayedClients.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RelayServerClient getClient(String clientPeerId) {
        RelayServerClient handler;
        Map<String, RelayServerClient> map = this.relayedClients;
        synchronized (map) {
            handler = this.relayedClients.get(clientPeerId);
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("getClient(" + clientPeerId + ") = " + handler);
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RelayServerClient addClient(String clientPeerId, long requestedLease, Messenger messenger, boolean flushQueue) {
        RelayServerClient handler;
        boolean isNewClient = false;
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("addClient(" + clientPeerId + ")");
        }
        Map<String, RelayServerClient> map = this.relayedClients;
        synchronized (map) {
            handler = this.relayedClients.get(clientPeerId);
            if (handler == null) {
                if (this.relayedClients.size() < this.maxClients && messenger != null && !messenger.isClosed()) {
                    handler = new RelayServerClient(this, clientPeerId, requestedLease, this.stallTimeout, this.clientQueueSize);
                    this.relayedClients.put(clientPeerId, handler);
                    isNewClient = true;
                    if (this.relayedClients.size() == 1 && this.gcThread == null) {
                        this.gcThread = new Thread(this.group.getHomeThreadGroup(), this, "GC Thread for Relay at " + this.publicAddress);
                        this.gcThread.setDaemon(true);
                        this.gcThread.start();
                    }
                } else if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("new client denied. nb clients: " + this.relayedClients.size() + "/" + this.maxClients + ", messenger: " + messenger);
                }
            }
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("added = " + (handler != null));
        }
        if (handler == null) {
            return null;
        }
        if (!handler.renewLease()) {
            return null;
        }
        if (flushQueue) {
            handler.flushQueue();
        }
        if (messenger != null) {
            handler.addMessenger(messenger);
            if (isNewClient) {
                EndpointAddress ear = new EndpointAddress("relay", clientPeerId, null, null);
                MessengerEvent me = new MessengerEvent(this, handler.getMessenger(this.publicAddress, ear, false), null);
                this.messengerEventListener.messengerReady(me);
            }
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RelayServerClient removeClient(String clientPeerId) {
        RelayServerClient handler;
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("removeClient(" + clientPeerId + ")");
        }
        Map<String, RelayServerClient> map = this.relayedClients;
        synchronized (map) {
            block7: {
                handler = this.relayedClients.remove(clientPeerId);
                if (this.relayedClients.size() == 0 && this.gcThread != null) {
                    try {
                        this.gcThread.interrupt();
                    }
                    catch (SecurityException e) {
                        if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block7;
                        LOG.fine(e.toString());
                    }
                }
            }
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeClient(String clientPeerId, RelayServerClient handler) {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("removeClient(" + clientPeerId + "," + handler + ")");
        }
        Map<String, RelayServerClient> map = this.relayedClients;
        synchronized (map) {
            block8: {
                Thread temp;
                RelayServerClient currentHandler = this.relayedClients.get(clientPeerId);
                if (currentHandler == handler) {
                    this.relayedClients.remove(clientPeerId);
                }
                if (this.relayedClients.size() == 0 && (temp = this.gcThread) != null) {
                    try {
                        temp.interrupt();
                    }
                    catch (SecurityException e) {
                        if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block8;
                        LOG.fine(e.toString());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Starting lease gc thread");
        }
        try {
            try {
                while (true) {
                    Map<String, RelayServerClient> map = this.relayedClients;
                    synchronized (map) {
                        if (this.relayedClients.size() == 0) {
                            break;
                        }
                    }
                    this.doClientGC();
                    map = this.relayedClients;
                    synchronized (map) {
                        if (this.relayedClients.size() == 0) {
                            break;
                        }
                    }
                    try {
                        Thread.sleep(this.stallTimeout);
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                    }
                }
                Object var5_6 = null;
                this.gcThread = null;
                if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                    LOG.info("stopping lease gc thread");
                }
            }
            catch (Throwable all) {
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "Uncaught Throwable in thread :" + Thread.currentThread().getName(), all);
                }
                Object var5_7 = null;
                this.gcThread = null;
                if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                    LOG.info("stopping lease gc thread");
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.gcThread = null;
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.info("stopping lease gc thread");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClientGC() {
        RelayServerClient[] handlers;
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("start: check for expired client handler. # clients = " + this.relayedClients.size());
        }
        Map<String, RelayServerClient> map = this.relayedClients;
        synchronized (map) {
            handlers = this.relayedClients.values().toArray(new RelayServerClient[0]);
        }
        int i = handlers.length;
        while (i-- > 0) {
            try {
                handlers[i].isExpired();
            }
            catch (Exception e) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.log(Level.WARNING, "Exception during client gc", e);
            }
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("stop: check for expired client handler. # clients = " + this.relayedClients.size());
        }
    }

    private static RdvAdvertisement createRdvAdvertisement(PeerAdvertisement padv, String name) {
        try {
            RdvAdvertisement rdv = (RdvAdvertisement)AdvertisementFactory.newAdvertisement(RdvAdvertisement.getAdvertisementType());
            rdv.setPeerID(padv.getPeerID());
            rdv.setGroupID(padv.getPeerGroupID());
            rdv.setServiceName(name);
            rdv.setName(padv.getName());
            RouteAdvertisement ra = EndpointUtils.extractRouteAdv(padv);
            if (null == ra) {
                return null;
            }
            rdv.setRouteAdv(ra);
            return rdv;
        }
        catch (Exception ez) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Cannot create Local RdvAdvertisement: ", ez);
            }
            return null;
        }
    }

    static class BGSend
    extends Thread {
        Messenger mr;
        Message ms;
        String sn;
        String ps;

        BGSend(Messenger mr, Message ms, String sn, String ps) {
            super("Relay Background Sender");
            this.mr = mr;
            this.ms = ms;
            this.sn = sn;
            this.ps = ps;
            this.setDaemon(true);
            this.start();
        }

        public void run() {
            block4: {
                try {
                    this.mr.sendMessage(this.ms, this.sn, this.ps);
                }
                catch (IOException e) {
                    if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.log(Level.WARNING, "Failed sending response " + this.ms + " to " + this.ps, e);
                    }
                }
                catch (Throwable all) {
                    if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) break block4;
                    LOG.log(Level.SEVERE, "Uncaught Throwable in thread :" + Thread.currentThread().getName(), all);
                }
            }
        }
    }

    private static class RelayServerCache
    implements PipeMsgListener,
    Runnable {
        static final ID pipeID = ID.create(URI.create("urn:jxta:uuid-59616261646162614E50472050325033DEADBEEFDEAFBABAFEEDBABE0000000F04"));
        final RelayServer server;
        final PipeAdvertisement pipeAdv;
        InputPipe inputPipe = null;
        volatile boolean doRun = false;
        Thread cacheThread = null;
        final Map<String, RdvAdvertisement> relayAdvCache = new HashMap<String, RdvAdvertisement>();
        final Random rand = new Random();

        protected RelayServerCache(RelayServer server) {
            this.server = server;
            this.pipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(PipeAdvertisement.getAdvertisementType());
            this.pipeAdv.setPipeID(pipeID);
            this.pipeAdv.setType("JxtaPropagate");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int relayAdvCacheSize() {
            Map<String, RdvAdvertisement> map = this.relayAdvCache;
            synchronized (map) {
                return this.relayAdvCache.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected RdvAdvertisement getRandomCacheAdv() {
            Map<String, RdvAdvertisement> map = this.relayAdvCache;
            synchronized (map) {
                RdvAdvertisement[] items = this.relayAdvCache.values().toArray(new RdvAdvertisement[0]);
                if (items.length == 0) {
                    return null;
                }
                return items[this.rand.nextInt(items.length)];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean putCacheAdv(String peerId, RdvAdvertisement adv) {
            if (!this.server.acl.isAllowed(adv.getPeerID())) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Rejected cache entry for : " + peerId);
                }
                return false;
            }
            Map<String, RdvAdvertisement> map = this.relayAdvCache;
            synchronized (map) {
                boolean replaced;
                boolean bl = replaced = null != this.relayAdvCache.put(peerId, adv);
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine((replaced ? "Updated" : "Created") + " cache entry for : " + peerId);
                }
                if (this.relayAdvCache.size() >= 20) {
                    String[] keys = this.relayAdvCache.keySet().toArray(new String[0]);
                    this.relayAdvCache.remove(keys[this.rand.nextInt(keys.length)]);
                }
                return replaced;
            }
        }

        public void pipeMsgEvent(PipeMsgEvent event) {
            Advertisement adv;
            MessageElement me;
            Message message = event.getMessage();
            if (message == null) {
                return;
            }
            boolean isResponse = RelayTransport.getString(message, "response") != null;
            String peerId = RelayTransport.getString(message, "peerid");
            if (peerId == null || peerId.equals(this.server.peerId)) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("pipeMsgEvent() discarding message no response PID defined, or loopback ");
                }
                return;
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("pipeMsgEvent() from " + peerId);
            }
            if (null == (me = message.getMessageElement("relay", "relayAdv"))) {
                return;
            }
            try {
                adv = AdvertisementFactory.newAdvertisement(MimeMediaType.XMLUTF8, me.getStream());
            }
            catch (IOException failed) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Failed building relay advertisement", failed);
                }
                return;
            }
            catch (NoSuchElementException failed) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Could not build relay advertisement", failed);
                }
                return;
            }
            if (!(adv instanceof RdvAdvertisement)) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Response does not contain relay advertisement (" + adv.getAdvType() + ")");
                }
                return;
            }
            RdvAdvertisement radv = (RdvAdvertisement)adv;
            if (this.putCacheAdv(peerId, radv)) {
                if (isResponse) {
                    return;
                }
                int i = this.relayAdvCacheSize();
                long magic = this.server.peerId.hashCode() % i;
                if ((long)this.rand.nextInt(i) == magic) {
                    OutputPipe retPipe;
                    block24: {
                        PeerID otherPid;
                        RdvAdvertisement myAdv;
                        block23: {
                            myAdv = RelayServer.createRdvAdvertisement(this.server.group.getPeerAdvertisement(), this.server.serviceName);
                            otherPid = null;
                            try {
                                otherPid = (PeerID)IDFactory.fromURI(new URI("urn", "jxta:" + peerId, null));
                            }
                            catch (Exception ex) {
                                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block23;
                                LOG.log(Level.WARNING, "Bad peerid : " + peerId, ex);
                            }
                        }
                        PipeService pipeService = this.server.group.getPipeService();
                        if (pipeService == null) {
                            return;
                        }
                        retPipe = null;
                        try {
                            retPipe = pipeService.createOutputPipe(this.pipeAdv, Collections.singleton(otherPid), 2000L);
                            if (retPipe == null) {
                                return;
                            }
                            message = new Message();
                            RelayTransport.setString(message, "peerid", this.server.peerId);
                            RelayTransport.setString(message, "relayAdv", myAdv.toString());
                            RelayTransport.setString(message, "response", "t");
                            retPipe.send(message);
                            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                LOG.fine("Responded");
                            }
                        }
                        catch (IOException e) {
                            if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block24;
                            LOG.log(Level.FINE, "Could not send reply on pipe ", e);
                        }
                    }
                    if (retPipe != null) {
                        retPipe.close();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                block40: {
                    try {
                        OutputPipe outputPipe;
                        block37: {
                            outputPipe = null;
                            PipeService pipeService = this.server.group.getPipeService();
                            while (this.doRun && this.inputPipe == null) {
                                block35: {
                                    try {
                                        this.inputPipe = pipeService.createInputPipe(this.pipeAdv, this);
                                    }
                                    catch (IOException e) {
                                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                            LOG.fine("Could not create input pipe, try again");
                                        }
                                    }
                                    catch (IllegalStateException e) {
                                        if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block35;
                                        LOG.fine("Pipe Service not ready yet, try again");
                                    }
                                }
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException e) {
                                    if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
                                    LOG.fine("wait interrupted");
                                }
                            }
                            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                LOG.fine("Created input pipe");
                            }
                            while (this.doRun && outputPipe == null) {
                                block36: {
                                    try {
                                        outputPipe = pipeService.createOutputPipe(this.pipeAdv, 5000L);
                                    }
                                    catch (IOException e) {
                                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                            LOG.fine("Could not create output pipe, try again");
                                        }
                                    }
                                    catch (IllegalStateException e) {
                                        if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block36;
                                        LOG.fine("Pipe Service not ready yet, try again");
                                    }
                                }
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException e) {
                                    if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
                                    LOG.fine("wait interrupted ");
                                }
                            }
                            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                LOG.fine("Created output pipe");
                            }
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException e) {
                                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block37;
                                LOG.fine("wait interrupted");
                            }
                        }
                        while (this.doRun) {
                            block39: {
                                RdvAdvertisement adv;
                                block38: {
                                    adv = RelayServer.createRdvAdvertisement(this.server.group.getPeerAdvertisement(), this.server.serviceName);
                                    try {
                                        this.server.discoveryService.publish(adv);
                                    }
                                    catch (IOException e) {
                                        if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block38;
                                        LOG.log(Level.FINE, "Could not publish Relay RdvAdvertisement", e);
                                    }
                                }
                                if (adv != null) {
                                    Message message = new Message();
                                    RelayTransport.setString(message, "peerid", this.server.peerId);
                                    RelayTransport.setString(message, "relayAdv", adv.toString());
                                    try {
                                        outputPipe.send(message);
                                    }
                                    catch (IOException e) {
                                        if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block39;
                                        LOG.log(Level.FINE, "Could not send message on pipe ", e);
                                    }
                                }
                            }
                            long sleepTime = this.server.minBroadcastInterval + (long)((this.server.relayedClients.size() + 1) * 100 / (this.server.maxClients + 1)) * this.server.minBroadcastInterval;
                            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                LOG.fine("sleepTime=" + sleepTime);
                            }
                            try {
                                Thread.sleep(sleepTime);
                            }
                            catch (InterruptedException e) {
                                Thread.interrupted();
                            }
                        }
                        outputPipe.close();
                        if (System.currentTimeMillis() <= this.server.refreshTime) break block40;
                        this.server.refreshTime = System.currentTimeMillis() + 1800000L;
                        if (this.server.aclFile.lastModified() <= this.server.aclFileLastModified) break block40;
                        this.server.aclFileLastModified = this.server.aclFile.lastModified();
                        this.server.acl.refresh(this.server.aclFile);
                    }
                    catch (Throwable all) {
                        if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                            LOG.log(Level.SEVERE, "Uncaught Throwable in thread :" + Thread.currentThread().getName(), all);
                        }
                        Object var8_18 = null;
                        this.cacheThread = null;
                        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                            LOG.info("Cache thread quitting.");
                        }
                    }
                }
                Object var8_17 = null;
                this.cacheThread = null;
                if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                    LOG.info("Cache thread quitting.");
                }
            }
            catch (Throwable throwable) {
                Object var8_19 = null;
                this.cacheThread = null;
                if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                    LOG.info("Cache thread quitting.");
                }
                throw throwable;
            }
        }

        protected void startCache() {
            this.doRun = true;
            this.cacheThread = new Thread(this.server.group.getHomeThreadGroup(), this, "RelayCache Worker Thread for " + this.server.publicAddress);
            this.cacheThread.setDaemon(true);
            this.cacheThread.start();
        }

        protected void stopCache() {
            this.doRun = false;
            if (this.inputPipe != null) {
                this.inputPipe.close();
                this.inputPipe = null;
            }
            this.cacheThread.interrupt();
        }
    }
}

