/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.router;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.AdvertisementFactory;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.MessengerEvent;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.router.EndpointRouter;
import net.jxta.impl.endpoint.router.RouteCM;
import net.jxta.logging.Logging;
import net.jxta.peer.PeerID;
import net.jxta.protocol.AccessPointAdvertisement;
import net.jxta.protocol.RouteAdvertisement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteControl {
    private static final transient Logger LOG = Logger.getLogger(RouteControl.class.getName());
    public static final int OK = 0;
    public static final int ALREADY_EXIST = 1;
    public static final int FAILED = -1;
    public static final int DIRECT_ROUTE = 2;
    public static final int INVALID_ROUTE = 3;
    private final EndpointRouter router;
    private final RouteCM routeCM;
    private final ID localPeerId;

    public RouteControl(EndpointRouter router, ID pid) {
        this.router = router;
        this.routeCM = router.getRouteCM();
        this.localPeerId = pid;
    }

    public RouteAdvertisement getMyLocalRoute() {
        return this.router.getMyLocalRoute();
    }

    public int addRoute(RouteAdvertisement newRoute) {
        PeerID firstHopPid;
        RouteAdvertisement route = newRoute.clone();
        if (route.getDestPeerID().equals(this.localPeerId)) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Skipping Local peer addRoute");
            }
            return 1;
        }
        AccessPointAdvertisement firstHop = route.getFirstHop();
        if (firstHop != null && this.localPeerId.equals(firstHopPid = firstHop.getPeerID())) {
            route.removeHop(firstHopPid);
            firstHop = route.getFirstHop();
        }
        if (firstHop == null) {
            EndpointAddress destAddress = EndpointRouter.pid2addr(route.getDestPeerID());
            if (this.router.ensureLocalRoute(destAddress, route) != null) {
                this.routeCM.publishRoute(newRoute);
                return 0;
            }
            if (this.router.isLocalRoute(destAddress) || this.router.isRoutedRoute(route.getDestPeerID())) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Skipping add Route " + destAddress + " already exists");
                    LOG.fine("isLocalRoute() " + this.router.isLocalRoute(destAddress) + " isRoutedRoute() : " + this.router.isRoutedRoute(route.getDestPeerID()));
                }
                return 1;
            }
            if (this.router.ensureLocalRoute(destAddress, route) == null) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Failed to connect to address :" + destAddress);
                }
                return -1;
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Publishing route :" + newRoute);
            }
            this.routeCM.publishRoute(newRoute);
            return 0;
        }
        RouteAdvertisement firstHopRoute = null;
        firstHopPid = firstHop.getPeerID();
        EndpointAddress firstHopAddr = EndpointRouter.pid2addr(firstHopPid);
        if (!this.router.isLocalRoute(firstHopAddr) && !this.router.isRoutedRoute(firstHopPid)) {
            firstHopRoute = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
            firstHopRoute.setDest(firstHop.clone());
            this.router.updateRouteAdv(firstHopRoute);
        }
        if (this.router.ensureLocalRoute(firstHopAddr, firstHopRoute) == null) {
            return -1;
        }
        this.router.setRoute(route.clone(), false);
        return 0;
    }

    public RouteAdvertisement getRouteInfo(PeerID pId) {
        EndpointAddress pcaddr;
        EndpointAddress addr = EndpointRouter.pid2addr(pId);
        Messenger oneOfThem = this.router.getCachedMessenger(addr);
        EndpointAddress endpointAddress = pcaddr = oneOfThem == null ? null : oneOfThem.getDestinationAddress();
        if (pcaddr != null) {
            AccessPointAdvertisement ap = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(AccessPointAdvertisement.getAdvertisementType());
            ap.setPeerID(pId);
            Vector<String> eas = new Vector<String>();
            eas.add(pcaddr.getProtocolName() + "://" + pcaddr.getProtocolAddress());
            ap.setEndpointAddresses(eas);
            RouteAdvertisement route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
            route.setDest(ap);
            return route;
        }
        RouteAdvertisement route = this.router.getRoute(addr, false);
        if (route != null) {
            return route;
        }
        EndpointRouter.ClearPendingQuery entry = this.router.getPendingRouteQuery(pId);
        if (entry != null) {
            AccessPointAdvertisement ap = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(AccessPointAdvertisement.getAdvertisementType());
            ap.setPeerID(pId);
            Vector<String> eas = new Vector<String>();
            eas.add("pending " + (entry.isFailed() ? "(failed)" : "(new)"));
            ap.setEndpointAddresses(eas);
            route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
            route.setDest(ap);
            return route;
        }
        AccessPointAdvertisement ap = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(AccessPointAdvertisement.getAdvertisementType());
        ap.setPeerID(pId);
        route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
        route.setDest(ap);
        return route;
    }

    public int deleteRoute(PeerID pId) {
        if (pId.equals(this.localPeerId)) {
            return 3;
        }
        EndpointAddress addr = EndpointRouter.pid2addr(pId);
        if (this.router.isLocalRoute(addr)) {
            return 2;
        }
        this.router.removeRoute(pId);
        this.routeCM.flushRoute(pId);
        return 0;
    }

    public Vector<RouteAdvertisement> getAllRoutesInfo() {
        Vector<RouteAdvertisement> routes;
        block7: {
            routes = new Vector<RouteAdvertisement>();
            try {
                RouteAdvertisement r;
                Iterator<EndpointAddress> it = this.router.getAllCachedMessengerDestinations();
                while (it.hasNext()) {
                    EndpointAddress pcaddr;
                    EndpointAddress ea = it.next();
                    AccessPointAdvertisement accessPointAdvertisement = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(AccessPointAdvertisement.getAdvertisementType());
                    accessPointAdvertisement.setPeerID(EndpointRouter.addr2pid(ea));
                    Vector<String> eas = new Vector<String>();
                    Messenger oneOfThem = this.router.getCachedMessenger(ea);
                    EndpointAddress endpointAddress = pcaddr = oneOfThem == null ? null : oneOfThem.getDestinationAddress();
                    if (pcaddr == null) {
                        eas.add("unknown");
                    } else {
                        eas.add(pcaddr.getProtocolName() + "://" + pcaddr.getProtocolAddress());
                    }
                    accessPointAdvertisement.setEndpointAddresses(eas);
                    r = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
                    r.setDest(accessPointAdvertisement);
                    routes.add(r);
                }
                Iterator<Map.Entry<ID, RouteAdvertisement>> i = this.router.getRoutedRouteAllDestinations();
                while (i.hasNext()) {
                    Map.Entry<ID, RouteAdvertisement> entry = i.next();
                    routes.add(entry.getValue());
                }
                for (Map.Entry<PeerID, EndpointRouter.ClearPendingQuery> entry : this.router.getPendingQueriesAllDestinations()) {
                    PeerID pid = entry.getKey();
                    AccessPointAdvertisement ap = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(AccessPointAdvertisement.getAdvertisementType());
                    ap.setPeerID(pid);
                    Vector<String> eas = new Vector<String>();
                    eas.add("pending " + (entry.getValue().isFailed() ? "(failed)" : "(new)"));
                    ap.setEndpointAddresses(eas);
                    r = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
                    r.setDest(ap);
                    routes.add(r);
                }
            }
            catch (Exception ex) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block7;
                LOG.log(Level.WARNING, "getAllRoutesInfo error : ", ex);
            }
        }
        return routes;
    }

    public boolean useRouteCM() {
        return this.router.getRouteCM().useRouteCM();
    }

    public boolean useRouteResolver() {
        return this.router.getRouteResolver().useRouteResolver();
    }

    public void enableRouteCM() {
        this.router.getRouteCM().enableRouteCM(true);
    }

    public void disableRouteCM() {
        this.router.getRouteCM().enableRouteCM(false);
    }

    public void enableRouteResolver() {
        this.router.getRouteResolver().enableRouteResolver(true);
    }

    public void disableRouteResolver() {
        this.router.getRouteResolver().enableRouteResolver(false);
    }

    public boolean addMessengerFor(Object source, EndpointAddress destination, Messenger messenger) {
        return this.router.newMessenger(new MessengerEvent(source, messenger, destination));
    }

    public Messenger getMessengerFor(EndpointAddress destination, Object hint) {
        if (hint != null && !(hint instanceof RouteAdvertisement)) {
            hint = null;
        }
        return this.router.ensureLocalRoute(destination, (RouteAdvertisement)hint);
    }

    public boolean isConnected(PeerID pid) {
        return this.isConnected(pid, null);
    }

    public boolean isConnected(PeerID pid, RouteAdvertisement route) {
        Messenger messenger = this.getMessengerFor(new EndpointAddress("jxta", pid.getUniqueValue().toString(), null, null), route);
        if (messenger == null) {
            return false;
        }
        if ((messenger.getState() & 0x3FF) != 0) {
            try {
                messenger.sendMessageB(new Message(), null, null);
            }
            catch (IOException io) {
                return (messenger.getState() & 0x3FF) != 0;
            }
        }
        return (messenger.getState() & 0x40000) != 262144;
    }
}

