/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.servlethttp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.MessageReceiver;
import net.jxta.endpoint.MessengerEvent;
import net.jxta.endpoint.MessengerEventListener;
import net.jxta.exception.PeerGroupException;
import net.jxta.impl.endpoint.servlethttp.HttpMessageServlet;
import net.jxta.impl.endpoint.servlethttp.HttpServletMessenger;
import net.jxta.impl.endpoint.servlethttp.ServletHttpTransport;
import net.jxta.logging.Logging;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpServer;
import org.mortbay.http.SocketListener;
import org.mortbay.http.handler.ResourceHandler;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.util.Code;
import org.mortbay.util.InetAddrPort;
import org.mortbay.util.Log;
import org.mortbay.util.LogSink;
import org.mortbay.util.LoggerLogSink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HttpMessageReceiver
implements MessageReceiver {
    private static final transient Logger LOG = Logger.getLogger(HttpMessageReceiver.class.getName());
    private static final String MSG_RECEIVER_RELATIVE_URI = "/*";
    final ServletHttpTransport servletHttpTransport;
    private final List<EndpointAddress> publicAddresses;
    private static int MIN_LISTENER_THREADS = 10;
    private static int MAX_LISTENER_THREADS = 200;
    private static long MAX_THREAD_IDLE_DURATION = 30000L;
    private final HttpServer server;
    private final ServletHandler handler;
    private final SocketListener listener;
    private MessengerEventListener messengerEventListener;

    public HttpMessageReceiver(ServletHttpTransport servletHttpTransport, List<EndpointAddress> publicAddresses, InetAddress useInterface, int port) throws PeerGroupException {
        block6: {
            this.servletHttpTransport = servletHttpTransport;
            this.publicAddresses = publicAddresses;
            Properties prop = HttpMessageReceiver.getJxtaProperties(new File(new File(servletHttpTransport.getEndpointService().getGroup().getStoreHome()), "jxta.properties"));
            this.initFromProperties(prop);
            if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
                StringBuilder configInfo = new StringBuilder("Configuring HTTP Servlet Message Transport : " + servletHttpTransport.assignedID);
                configInfo.append("\n\tMin threads=").append(MIN_LISTENER_THREADS);
                configInfo.append("\n\tMax threads=").append(MAX_LISTENER_THREADS);
                configInfo.append("\n\tMax thread idle time=").append(MAX_THREAD_IDLE_DURATION).append("ms");
                LOG.config(configInfo.toString());
            }
            if (!Logging.SHOW_FINER || !LOG.isLoggable(Level.FINER)) {
                Log.instance().disableLog();
            }
            Code.setDebug((Logging.SHOW_FINER && LOG.isLoggable(Level.FINER) ? 1 : 0) != 0);
            Code.setSuppressWarnings((!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING) ? 1 : 0) != 0);
            Code.setSuppressStack((!Logging.SHOW_FINER || !LOG.isLoggable(Level.FINER) ? 1 : 0) != 0);
            if (System.getProperty("LOG_CLASSES") == null) {
                LoggerLogSink logSink = new LoggerLogSink();
                Logger jettyLogger = Logger.getLogger(HttpServer.class.getName());
                logSink.setLogger(jettyLogger);
                try {
                    logSink.start();
                    Log.instance().add((LogSink)logSink);
                }
                catch (Exception ex) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block6;
                    LOG.warning("Could not configure LoggerLogSink");
                }
            }
        }
        this.server = new HttpServer();
        InetAddrPort addrPort = new InetAddrPort(useInterface, port);
        this.listener = new SocketListener(addrPort);
        this.listener.setMinThreads(MIN_LISTENER_THREADS);
        this.listener.setMaxThreads(MAX_LISTENER_THREADS);
        this.listener.setMaxIdleTimeMs((int)MAX_THREAD_IDLE_DURATION);
        this.server.addListener((HttpListener)this.listener);
        HttpContext handlerContext = this.server.getContext("/");
        this.handler = new ServletHandler();
        this.handler.setUsingCookies(false);
        this.handler.initialize(handlerContext);
        handlerContext.setClassLoader((ClassLoader)servletHttpTransport.getEndpointService().getGroup().getLoader());
        handlerContext.addHandler((HttpHandler)this.handler);
        if (System.getProperty("net.jxta.http.allowdownload") != null) {
            HttpContext context = this.server.addContext("/midlets/*");
            context.setResourceBase("./midlets/");
            ResourceHandler resHandler = new ResourceHandler();
            context.addHandler((HttpHandler)resHandler);
        }
        this.handler.addServlet(MSG_RECEIVER_RELATIVE_URI, HttpMessageServlet.class.getName());
    }

    synchronized void start() throws PeerGroupException {
        try {
            this.server.start();
            this.handler.getServletContext().setAttribute("HttpMessageReceiver", (Object)this);
        }
        catch (Exception e) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Could not start server", e);
            }
            PeerGroupException failure = new PeerGroupException("Could not start server");
            failure.initCause(e);
            throw failure;
        }
        this.messengerEventListener = this.servletHttpTransport.getEndpointService().addMessageTransport(this);
        if (this.messengerEventListener == null) {
            throw new PeerGroupException("Transport registration refused");
        }
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("HTTP Servlet Transport started.");
        }
    }

    synchronized void stop() {
        block3: {
            this.servletHttpTransport.getEndpointService().removeMessageTransport(this);
            this.messengerEventListener = null;
            try {
                this.server.stop();
            }
            catch (InterruptedException e) {
                if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) break block3;
                LOG.log(Level.SEVERE, "Interrupted during stop()", e);
            }
        }
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("HTTP Servlet Transport stopped.");
        }
    }

    boolean messengerReadyEvent(HttpServletMessenger newMessenger, EndpointAddress connAddr) {
        MessengerEventListener temp = this.messengerEventListener;
        return null != temp && temp.messengerReady(new MessengerEvent(this, newMessenger, connAddr));
    }

    @Override
    public Iterator<EndpointAddress> getPublicAddresses() {
        return Collections.unmodifiableList(this.publicAddresses).iterator();
    }

    @Override
    public String getProtocolName() {
        return this.servletHttpTransport.HTTP_PROTOCOL_NAME;
    }

    @Override
    public EndpointService getEndpointService() {
        return this.servletHttpTransport.getEndpointService();
    }

    @Override
    public Object transportControl(Object operation, Object Value2) {
        return null;
    }

    ServletHttpTransport getServletHttpTransport() {
        return this.servletHttpTransport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Properties getJxtaProperties(File fromFile) {
        Properties prop;
        block13: {
            prop = new Properties();
            FileInputStream in = null;
            try {
                in = new FileInputStream(fromFile);
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Read properties from " + fromFile.getPath());
                }
            }
            catch (FileNotFoundException e) {
                return null;
            }
            prop.load(in);
            Object var5_5 = null;
            try {
                ((InputStream)in).close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            in = null;
            {
                break block13;
                catch (IOException e) {
                    if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                        LOG.log(Level.SEVERE, "Error reading " + fromFile.getPath(), e);
                    }
                    Object var5_6 = null;
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                    in = null;
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    ((InputStream)in).close();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                in = null;
                throw throwable;
            }
        }
        return prop;
    }

    private void initFromProperties(Properties prop) {
        block15: {
            if (prop == null) {
                if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
                    LOG.fine("jxta.properties not found: using default values");
                }
            } else {
                String maxThreadIdleTimeStr;
                block14: {
                    String maxThreadsStr;
                    block13: {
                        if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
                            LOG.config("Using jxta.properties to configure HTTP server");
                        }
                        String minThreadsStr = prop.getProperty("HttpServer.MinThreads");
                        maxThreadsStr = prop.getProperty("HttpServer.MaxThreads");
                        maxThreadIdleTimeStr = prop.getProperty("HttpServer.MaxThreadIdleTime");
                        try {
                            if (minThreadsStr != null) {
                                MIN_LISTENER_THREADS = Integer.parseInt(minThreadsStr);
                            }
                        }
                        catch (NumberFormatException e) {
                            if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block13;
                            LOG.warning("Invalid HttpServer.MinThreads value; using default");
                        }
                    }
                    try {
                        if (maxThreadsStr != null) {
                            MAX_LISTENER_THREADS = Integer.parseInt(maxThreadsStr);
                        }
                    }
                    catch (NumberFormatException e) {
                        if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block14;
                        LOG.warning("Invalid HttpServer.MaxThreads value; using default");
                    }
                }
                try {
                    if (maxThreadIdleTimeStr != null) {
                        MAX_THREAD_IDLE_DURATION = Integer.parseInt(maxThreadIdleTimeStr);
                    }
                }
                catch (NumberFormatException e) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block15;
                    LOG.warning("Invalid HttpServer.MaxThreadIdleTime value; using default");
                }
            }
        }
    }
}

