/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tcp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.impl.endpoint.IPUtils;
import net.jxta.impl.endpoint.tcp.TcpMessenger;
import net.jxta.impl.endpoint.tcp.TcpTransport;
import net.jxta.impl.endpoint.transportMeter.TransportBindingMeter;
import net.jxta.impl.endpoint.transportMeter.TransportMeterBuildSettings;
import net.jxta.logging.Logging;

public class IncomingUnicastServer
implements Runnable {
    private static final Logger LOG = Logger.getLogger(IncomingUnicastServer.class.getName());
    private final TcpTransport transport;
    private final InetAddress serverBindLocalInterface;
    private final int serverBindStartLocalPort;
    private int serverBindPreferredLocalPort;
    private final int serverBindEndLocalPort;
    private Thread acceptThread = null;
    private final Selector acceptSelector;
    private ServerSocketChannel serverSocChannel = null;
    private ServerSocket serverSocket = null;

    public IncomingUnicastServer(TcpTransport owner, InetAddress serverInterface, int preferredPort, int startPort, int endPort) throws IOException, SecurityException {
        this.transport = owner;
        this.serverBindLocalInterface = serverInterface;
        this.serverBindPreferredLocalPort = preferredPort;
        this.serverBindStartLocalPort = startPort;
        this.serverBindEndLocalPort = endPort;
        this.acceptSelector = SelectorProvider.provider().openSelector();
        this.serverSocChannel = this.openServerSocket(this.acceptSelector);
        this.serverSocket = this.serverSocChannel.socket();
        this.serverBindPreferredLocalPort = this.serverSocket.getLocalPort();
    }

    public synchronized boolean start() {
        if (!this.acceptSelector.isOpen()) {
            return false;
        }
        if (this.acceptThread != null) {
            return false;
        }
        this.acceptThread = new Thread(this.transport.group.getHomeThreadGroup(), this, "ServerSocketChannel acceptor for " + this.getLocalSocketAddress());
        this.acceptThread.setDaemon(true);
        this.acceptThread.start();
        return true;
    }

    public synchronized void stop() {
        block3: {
            Thread temp = this.acceptThread;
            if (null != temp) {
                temp.interrupt();
            }
            try {
                this.acceptSelector.close();
            }
            catch (IOException io) {
                if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) break block3;
                LOG.log(Level.SEVERE, "IO error occured while closing Selectors", io);
            }
        }
    }

    InetSocketAddress getLocalSocketAddress() {
        ServerSocket localSocket = this.serverSocket;
        if (null != localSocket) {
            return (InetSocketAddress)localSocket.getLocalSocketAddress();
        }
        return null;
    }

    int getStartPort() {
        return this.serverBindStartLocalPort;
    }

    int getEndPort() {
        return this.serverBindEndLocalPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block39: {
            IncomingUnicastServer incomingUnicastServer;
            try {
                if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                    LOG.info("Server is ready to accept connections. " + this.transport.getPublicAddress());
                }
                while (this.acceptSelector.isOpen()) {
                    try {
                        if (null == this.serverSocChannel || !this.serverSocChannel.isOpen()) {
                            this.serverSocChannel = null;
                            this.serverSocket = null;
                            this.serverSocChannel = this.openServerSocket(this.acceptSelector);
                            if (null == this.serverSocChannel) {
                                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break;
                                LOG.warning("Failed to open Server Channel");
                                break;
                            }
                            this.serverSocket = this.serverSocChannel.socket();
                            this.serverBindPreferredLocalPort = this.serverSocket.getLocalPort();
                        }
                        this.acceptSelector.select();
                        Iterator<SelectionKey> it = this.acceptSelector.selectedKeys().iterator();
                        while (it.hasNext()) {
                            ServerSocketChannel nextReady;
                            SocketChannel inputSocket;
                            SelectionKey key = it.next();
                            it.remove();
                            if (!key.isAcceptable() || (inputSocket = (nextReady = (ServerSocketChannel)key.channel()).accept()) == null) continue;
                            MessengerBuilder builder = new MessengerBuilder(this.transport, inputSocket);
                            try {
                                this.transport.executor.execute(builder);
                                this.transport.incrementConnectionsAccepted();
                            }
                            catch (RejectedExecutionException re) {
                                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
                                LOG.log(Level.FINE, MessageFormat.format("Executor rejected task : {0}", builder.toString()), re);
                            }
                        }
                    }
                    catch (ClosedSelectorException cse) {
                        break;
                    }
                    catch (InterruptedIOException woken) {
                        Thread.interrupted();
                    }
                    catch (IOException e1) {
                        if (!this.acceptSelector.isOpen()) break;
                        if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                        LOG.log(Level.WARNING, "[1] ServerSocket.accept() failed on " + this.serverSocket.getInetAddress() + ":" + this.serverSocket.getLocalPort(), e1);
                    }
                    catch (SecurityException e2) {
                        if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break;
                        LOG.log(Level.WARNING, "[2] ServerSocket.accept() failed on " + this.serverSocket.getInetAddress() + ":" + this.serverSocket.getLocalPort(), e2);
                        break;
                    }
                }
                Object var8_12 = null;
                incomingUnicastServer = this;
            }
            catch (Throwable throwable) {
                Object var8_14 = null;
                IncomingUnicastServer incomingUnicastServer2 = this;
                synchronized (incomingUnicastServer2) {
                    block38: {
                        ServerSocketChannel temp = this.serverSocChannel;
                        this.serverSocChannel = null;
                        if (null != temp) {
                            try {
                                temp.close();
                            }
                            catch (IOException ignored) {
                                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block38;
                                LOG.log(Level.FINE, "Exception occurred while closing server socket", ignored);
                            }
                        }
                    }
                    this.acceptThread = null;
                }
                if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                    LOG.info("Server has been shut down. " + this.transport.getPublicAddress());
                }
                throw throwable;
            }
            synchronized (incomingUnicastServer) {
                block34: {
                    ServerSocketChannel temp = this.serverSocChannel;
                    this.serverSocChannel = null;
                    if (null != temp) {
                        try {
                            temp.close();
                        }
                        catch (IOException ignored) {
                            if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block34;
                            LOG.log(Level.FINE, "Exception occurred while closing server socket", ignored);
                        }
                    }
                }
                this.acceptThread = null;
            }
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.info("Server has been shut down. " + this.transport.getPublicAddress());
            }
            break block39;
            {
                catch (Throwable all) {
                    if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                        LOG.log(Level.SEVERE, "Uncaught Throwable in thread :" + Thread.currentThread().getName(), all);
                    }
                    Object var8_13 = null;
                    IncomingUnicastServer incomingUnicastServer3 = this;
                    synchronized (incomingUnicastServer3) {
                        block36: {
                            ServerSocketChannel temp = this.serverSocChannel;
                            this.serverSocChannel = null;
                            if (null != temp) {
                                try {
                                    temp.close();
                                }
                                catch (IOException ignored) {
                                    if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block36;
                                    LOG.log(Level.FINE, "Exception occurred while closing server socket", ignored);
                                }
                            }
                        }
                        this.acceptThread = null;
                    }
                    if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                        LOG.info("Server has been shut down. " + this.transport.getPublicAddress());
                    }
                }
            }
        }
    }

    private synchronized ServerSocketChannel openServerSocket(Selector registerSelector) throws IOException, SecurityException {
        ServerSocketChannel newChannel = ServerSocketChannel.open();
        while (true) {
            int useBufferSize;
            ServerSocket newSocket;
            if (-1 != this.serverBindPreferredLocalPort && 0 != this.serverBindPreferredLocalPort) {
                try {
                    InetSocketAddress bindAddress = new InetSocketAddress(this.serverBindLocalInterface, this.serverBindPreferredLocalPort);
                    newSocket = newChannel.socket();
                    useBufferSize = Math.max(65536, newSocket.getReceiveBufferSize());
                    newSocket.setReceiveBufferSize(useBufferSize);
                    newSocket.bind(bindAddress, 50);
                }
                catch (SocketException failed) {
                    if (-1 != this.serverBindStartLocalPort) {
                        this.serverBindPreferredLocalPort = 0 == this.serverBindStartLocalPort ? 0 : -1;
                        continue;
                    }
                    if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                        LOG.log(Level.SEVERE, "Cannot bind ServerSocket on " + this.serverBindLocalInterface + ":" + this.serverBindPreferredLocalPort, failed);
                    }
                    return null;
                }
            } else {
                newSocket = newChannel.socket();
                useBufferSize = Math.max(65536, newSocket.getReceiveBufferSize());
                newSocket.setReceiveBufferSize(useBufferSize);
                newSocket = IPUtils.bindServerSocketInRange(newSocket, this.serverBindStartLocalPort, this.serverBindEndLocalPort, 50, this.serverBindLocalInterface);
            }
            try {
                newChannel.configureBlocking(false);
                newChannel.register(registerSelector, 16);
            }
            catch (ClosedChannelException cce) {
                continue;
            }
            break;
        }
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Server will accept connections at " + newChannel.socket().getLocalSocketAddress());
        }
        return newChannel;
    }

    private static class MessengerBuilder
    implements Runnable {
        private final SocketChannel socketChannel;
        private final TcpTransport transport;
        TcpMessenger newMessenger;

        MessengerBuilder(TcpTransport transport, SocketChannel socketChannel) {
            this.socketChannel = socketChannel;
            this.transport = transport;
        }

        public void run() {
            block8: {
                try {
                    if (this.socketChannel.isConnected() && null != this.socketChannel.socket()) {
                        TransportBindingMeter transportBindingMeter;
                        this.newMessenger = new TcpMessenger(this.socketChannel, this.transport);
                        if (TransportMeterBuildSettings.TRANSPORT_METERING && (transportBindingMeter = this.transport.getUnicastTransportBindingMeter(null, this.newMessenger.getDestinationAddress())) != null) {
                            transportBindingMeter.connectionEstablished(false, 0L);
                        }
                    } else if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.log(Level.WARNING, this.socketChannel + " not connected.");
                    }
                }
                catch (IOException io) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "Messenger creation failure", io);
                    }
                }
                catch (Throwable all) {
                    if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.WARNING)) break block8;
                    LOG.log(Level.SEVERE, "Uncaught Throwable", all);
                }
            }
        }
    }
}

