/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tls;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.impl.endpoint.tls.JTlsDefs;
import net.jxta.impl.endpoint.tls.TlsConn;
import net.jxta.impl.endpoint.tls.TlsSocket;
import net.jxta.impl.endpoint.tls.TlsTransport;
import net.jxta.impl.util.TimeUtils;
import net.jxta.logging.Logging;

class TlsManager
implements EndpointListener {
    private static final transient Logger LOG = Logger.getLogger(TlsManager.class.getName());
    private TlsTransport transport = null;
    private final Map<String, TlsConn> connections = new HashMap<String, TlsConn>();
    private long lastNonAuthenticatedWarning = 0L;

    TlsManager(TlsTransport tp) {
        this.transport = tp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Shutting down all connections");
        }
        Map<String, TlsConn> map = this.connections;
        synchronized (map) {
            Iterator<TlsConn> eachConnection = this.connections.values().iterator();
            while (eachConnection.hasNext()) {
                block7: {
                    TlsConn aConnection = eachConnection.next();
                    try {
                        aConnection.close(TlsConn.HandshakeState.CONNECTIONDEAD);
                    }
                    catch (IOException ignored) {
                        if (!Logging.SHOW_INFO || !LOG.isLoggable(Level.INFO)) break block7;
                        LOG.info("Non-fatal problem shutting down connection to " + aConnection);
                    }
                }
                eachConnection.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TlsConn getTlsConn(EndpointAddress dstAddr) {
        if (null == this.transport.credential) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Not authenticated. Cannot open connections.");
            }
            return null;
        }
        boolean startHandshake = false;
        String paddr = dstAddr.getProtocolAddress();
        TlsConn conn = null;
        Object object = this.connections;
        synchronized (object) {
            conn = this.connections.get(paddr);
            if (null != conn && (TlsConn.HandshakeState.CONNECTIONDEAD == conn.getHandshakeState() || TlsConn.HandshakeState.HANDSHAKEFAILED == conn.getHandshakeState())) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Removing connection for: " + paddr);
                }
                this.connections.remove(paddr);
                conn = null;
            }
            if (null == conn) {
                try {
                    conn = new TlsConn(this.transport, dstAddr, true);
                }
                catch (Exception failed) {
                    if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.log(Level.WARNING, "Failed making connection to " + paddr, failed);
                    }
                    return null;
                }
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Adding connection for: " + paddr);
                }
                this.connections.put(paddr, conn);
                startHandshake = true;
            }
        }
        if (startHandshake) {
            try {
                if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                    LOG.info("Start of client handshake for " + paddr);
                }
                conn.finishHandshake();
            }
            catch (Throwable e) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Failed making connection to " + paddr, e);
                }
                Map<String, TlsConn> failed = this.connections;
                synchronized (failed) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Removing connection for: " + paddr);
                    }
                    this.connections.remove(paddr);
                }
                try {
                    conn.close(TlsConn.HandshakeState.HANDSHAKEFAILED);
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                return null;
            }
        }
        while (true) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("getting " + conn);
            }
            object = conn;
            synchronized (object) {
                TlsConn.HandshakeState currentState = conn.getHandshakeState();
                if (TlsConn.HandshakeState.SERVERSTART == currentState || TlsConn.HandshakeState.CLIENTSTART == currentState) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Sleeping until handshake starts for " + paddr);
                    }
                    try {
                        conn.wait(1000L);
                    }
                    catch (InterruptedException woken) {
                        Thread.interrupted();
                    }
                } else if (TlsConn.HandshakeState.HANDSHAKESTARTED == currentState) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Handshake in progress for " + paddr);
                    }
                    try {
                        conn.wait(200L);
                    }
                    catch (InterruptedException woken) {
                        Thread.interrupted();
                    }
                } else {
                    if (TlsConn.HandshakeState.HANDSHAKEFINISHED == currentState) {
                        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                            LOG.info("Returning active connection to " + paddr);
                        }
                        conn.lastAccessed = TimeUtils.timeNow();
                        return conn;
                    }
                    if (TlsConn.HandshakeState.HANDSHAKEFAILED == currentState) {
                        if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                            LOG.warning("Handshake failed. " + paddr + " unreachable");
                        }
                        return null;
                    }
                    if (TlsConn.HandshakeState.CONNECTIONDEAD == currentState) {
                        if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                            LOG.warning("Connection dead for " + paddr);
                        }
                        return null;
                    }
                    if (TlsConn.HandshakeState.CONNECTIONCLOSING == currentState) {
                        if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                            LOG.warning("Connection closing for " + paddr);
                        }
                        return null;
                    }
                    if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                        LOG.severe("Unhandled Handshake state: " + (Object)((Object)currentState));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processIncomingMessage(Message msg, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        TlsSocket bound;
        boolean retrans;
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Starts for " + msg);
        }
        if (null == this.transport.credential) {
            if (TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), this.lastNonAuthenticatedWarning) > 60000L) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("NOT AUTHENTICATED--Discarding all incoming messages");
                }
                this.lastNonAuthenticatedWarning = TimeUtils.timeNow();
            }
            return;
        }
        MessageElement retryElement = msg.getMessageElement("jxtatls", "MARKRetr");
        boolean bl = retrans = null != retryElement;
        if (retrans) {
            msg.removeMessageElement(retryElement);
            retryElement = null;
        }
        int seqN = TlsManager.getMsgSequenceNumber(msg);
        String paddr = srcAddr.getProtocolAddress();
        TlsConn conn = null;
        boolean serverStart = false;
        Map<String, TlsConn> map = this.connections;
        synchronized (map) {
            conn = this.connections.get(paddr);
            if (null != conn) {
                if (1 == seqN) {
                    TlsConn tlsConn = conn;
                    synchronized (tlsConn) {
                        long idle = TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), conn.lastAccessed);
                        if (idle > this.transport.MIN_IDLE_RECONNECT) {
                            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                                LOG.warning("Restarting : " + conn + " which has been idle for " + idle + " millis");
                            }
                            try {
                                conn.close(TlsConn.HandshakeState.CONNECTIONDEAD);
                            }
                            catch (IOException ignored) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (TlsConn.HandshakeState.CONNECTIONDEAD == conn.getHandshakeState() || TlsConn.HandshakeState.HANDSHAKEFAILED == conn.getHandshakeState()) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Removing connection for: " + paddr);
                    }
                    this.connections.remove(paddr);
                    conn = null;
                }
            }
            if (null == conn) {
                if (1 == seqN) {
                    try {
                        conn = new TlsConn(this.transport, srcAddr, false);
                    }
                    catch (Exception failed) {
                        if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                            LOG.log(Level.WARNING, "Failed making connection for" + paddr, failed);
                        }
                        return;
                    }
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Adding connection for: " + paddr);
                    }
                    this.connections.put(paddr, conn);
                    serverStart = true;
                } else {
                    if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.warning(msg + " is not start of handshake (seqn#" + seqN + ") for " + paddr);
                    }
                    msg.clear();
                    return;
                }
            }
        }
        if (serverStart) {
            try {
                if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                    LOG.info("Start of SERVER handshake for " + paddr);
                }
                conn.tlsSocket.input.queueIncomingMessage(msg);
                conn.finishHandshake();
                conn.lastAccessed = TimeUtils.timeNow();
                if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                    LOG.info("Handshake complete for SERVER TLS for: " + paddr);
                }
                return;
            }
            catch (Throwable e) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "TLS Handshake failure for connection: " + paddr, e);
                }
                Map<String, TlsConn> failed = this.connections;
                synchronized (failed) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Removing connection for: " + paddr);
                    }
                    this.connections.remove(paddr);
                }
                try {
                    conn.close(TlsConn.HandshakeState.HANDSHAKEFAILED);
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                return;
            }
        }
        while (true) {
            TlsConn.HandshakeState currentState;
            TlsConn ignored = conn;
            synchronized (ignored) {
                if (retrans) {
                    ++conn.retrans;
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("retrans received, " + conn.retrans + " total.");
                    }
                    retrans = false;
                }
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Process incoming message for " + conn);
                }
                if (TlsConn.HandshakeState.HANDSHAKESTARTED != (currentState = conn.getHandshakeState()) && TlsConn.HandshakeState.HANDSHAKEFINISHED != currentState && TlsConn.HandshakeState.CONNECTIONCLOSING != currentState) {
                    if (TlsConn.HandshakeState.CONNECTIONDEAD == currentState) {
                        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                            LOG.info("Connection failed, discarding msg with seqn#" + seqN + " for " + paddr);
                        }
                        return;
                    }
                    if (TlsConn.HandshakeState.SERVERSTART == currentState || TlsConn.HandshakeState.CLIENTSTART == currentState) {
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Sleeping msg with seqn#" + seqN + " until handshake starts for " + paddr);
                        }
                        try {
                            conn.wait(60000L);
                        }
                        catch (InterruptedException woken) {
                            Thread.interrupted();
                        }
                        continue;
                    }
                    if (TlsConn.HandshakeState.HANDSHAKEFAILED == currentState) {
                        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                            LOG.info("Handshake failed, discarding msg with seqn#" + seqN + " for " + paddr);
                        }
                        return;
                    }
                    if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.warning("Unexpected state : " + (Object)((Object)currentState));
                    }
                }
            }
            if (TlsConn.HandshakeState.HANDSHAKESTARTED == currentState || TlsConn.HandshakeState.HANDSHAKEFINISHED == currentState || TlsConn.HandshakeState.CONNECTIONCLOSING == currentState) break;
        }
        Message.ElementIterator eachACK = msg.getMessageElements("jxtatls", JTlsDefs.ACKS);
        while (eachACK.hasNext()) {
            MessageElement elt = (MessageElement)eachACK.next();
            eachACK.remove();
            int sackCount = (int)elt.getByteLength() / 4 - 1;
            try {
                DataInputStream dis = new DataInputStream(elt.getStream());
                int seqack = dis.readInt();
                int[] sacs = new int[sackCount];
                for (int eachSac = 0; eachSac < sackCount; ++eachSac) {
                    sacs[eachSac] = dis.readInt();
                }
                Arrays.sort(sacs);
                conn.tlsSocket.output.ackReceived(seqack, sacs);
            }
            catch (IOException failed) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.log(Level.WARNING, "Failure processing ACK", failed);
            }
        }
        if (0 == seqN) {
            return;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Queue " + msg + " seqn#" + seqN + " for " + conn);
        }
        if (null != (bound = conn.tlsSocket)) {
            bound.input.queueIncomingMessage(msg);
        }
    }

    private static int getMsgSequenceNumber(Message msg) {
        int seqN = 0;
        Message.ElementIterator eachElement = msg.getMessageElements("jxtatls", JTlsDefs.BLOCKS);
        while (eachElement.hasNext()) {
            MessageElement elt = (MessageElement)eachElement.next();
            try {
                seqN = Integer.parseInt(elt.getElementName());
                break;
            }
            catch (NumberFormatException e) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Bad tls record name=" + elt.getElementName());
                }
                eachElement.remove();
            }
        }
        return seqN;
    }
}

