/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.transportMeter;

import java.util.Enumeration;
import java.util.Hashtable;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.impl.endpoint.transportMeter.TransportBindingMeter;
import net.jxta.impl.endpoint.transportMeter.TransportBindingMetric;
import net.jxta.impl.endpoint.transportMeter.TransportMetric;
import net.jxta.impl.meter.MetricUtilities;
import net.jxta.peer.PeerID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransportMeter {
    public static final EndpointAddress UNKNOWN_ADDRESS = new EndpointAddress("<unknown>", "<unknown>", null, null);
    public static final String UNKNOWN_PEER = MetricUtilities.UNKNOWN_PEERID.toString();
    private String protocol;
    private EndpointAddress endpointAddress;
    private Hashtable<EndpointAddress, TransportBindingMeter> transportBindingMeters = new Hashtable();
    private TransportMetric cumulativeMetrics;

    public TransportMeter(String protocol, EndpointAddress endpointAddress) {
        this.endpointAddress = endpointAddress;
        this.protocol = protocol;
        this.cumulativeMetrics = new TransportMetric(this);
    }

    public TransportMetric getCumulativeMetrics() {
        return this.cumulativeMetrics;
    }

    public TransportMetric collectMetrics() {
        TransportMetric transportMetric = new TransportMetric(this);
        boolean anyData = false;
        Enumeration<TransportBindingMeter> e = this.transportBindingMeters.elements();
        while (e.hasMoreElements()) {
            TransportBindingMeter transportBindingMeter = e.nextElement();
            TransportBindingMetric transportBindingMetric = transportBindingMeter.collectMetrics();
            if (transportBindingMetric == null) continue;
            transportMetric.addTransportBindingMetric(transportBindingMetric);
            anyData = true;
        }
        if (anyData) {
            return transportMetric;
        }
        return null;
    }

    public synchronized TransportBindingMeter getTransportBindingMeter(String peerIdString, EndpointAddress destinationAddress) {
        PeerID peerID = MetricUtilities.getPeerIdFromString(peerIdString);
        return this.getTransportBindingMeter(peerID, destinationAddress);
    }

    public synchronized TransportBindingMeter getTransportBindingMeter(PeerID peerID, EndpointAddress destinationAddress) {
        TransportBindingMeter transportBindingMeter = this.transportBindingMeters.get(destinationAddress = new EndpointAddress(destinationAddress, null, null));
        if (transportBindingMeter == null) {
            transportBindingMeter = new TransportBindingMeter(peerID, destinationAddress);
            this.transportBindingMeters.put(destinationAddress, transportBindingMeter);
            this.cumulativeMetrics.addTransportBindingMetric(transportBindingMeter.getCumulativeMetrics());
        } else {
            transportBindingMeter.setPeerID(peerID);
        }
        return transportBindingMeter;
    }

    public Enumeration<TransportBindingMeter> getTransportBindingMeters() {
        return this.transportBindingMeters.elements();
    }

    public int getTransportBindingCount() {
        return this.transportBindingMeters.size();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public EndpointAddress getEndpointAddress() {
        return this.endpointAddress;
    }

    public String toString() {
        return "TransportMeter(" + this.endpointAddress + ")";
    }
}

