/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.UUID;

import net.jxta.impl.id.UUID.IDBytes;
import net.jxta.impl.id.UUID.IDFormat;
import net.jxta.impl.id.UUID.UUID;
import net.jxta.impl.id.UUID.UUIDFactory;

public class PeerGroupID
extends net.jxta.peergroup.PeerGroupID {
    protected static final int groupIdOffset = 0;
    protected static final int parentgroupIdOffset = 16;
    protected static final int padOffset = 32;
    protected static final int padSize = 31;
    protected IDBytes id;

    protected PeerGroupID(IDBytes id) {
        this.id = id;
    }

    protected PeerGroupID(UUID groupUUID) {
        this.id = new IDBytes(2);
        this.id.longIntoBytes(0, groupUUID.getMostSignificantBits());
        this.id.longIntoBytes(8, groupUUID.getLeastSignificantBits());
    }

    public PeerGroupID() {
        this(UUIDFactory.newUUID());
    }

    public PeerGroupID(PeerGroupID parent) {
        this(UUIDFactory.newUUID());
        System.arraycopy(parent.id.bytes, 0, this.id.bytes, 16, 16);
    }

    public PeerGroupID(byte[] seed) {
        this.id = new IDBytes(2);
        for (int copySeed = Math.min(16, seed.length) - 1; copySeed >= 0; --copySeed) {
            this.id.bytes[copySeed + 0] = seed[copySeed];
        }
        this.id.bytes[6] = (byte)(this.id.bytes[6] & 0xF);
        this.id.bytes[6] = (byte)(this.id.bytes[6] | 0x40);
        this.id.bytes[8] = (byte)(this.id.bytes[8] & 0x3F);
        this.id.bytes[8] = (byte)(this.id.bytes[8] | 0x80);
        this.id.bytes[10] = (byte)(this.id.bytes[10] & 0x3F);
        this.id.bytes[10] = (byte)(this.id.bytes[10] | 0x80);
    }

    public PeerGroupID(PeerGroupID parent, byte[] seed) {
        this(seed);
        System.arraycopy(parent.id.bytes, 0, this.id.bytes, 16, 16);
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target instanceof PeerGroupID) {
            PeerGroupID peergroupTarget = (PeerGroupID)target;
            return this.id.equals(peergroupTarget.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String getIDFormat() {
        return IDFormat.INSTANTIATOR.getSupportedIDFormat();
    }

    public Object getUniqueValue() {
        return this.getIDFormat() + "-" + (String)this.id.getUniqueValue();
    }

    public net.jxta.peergroup.PeerGroupID getParentPeerGroupID() {
        boolean zero = true;
        for (int eachByte = 0; eachByte < 16; ++eachByte) {
            if (this.id.bytes[eachByte + 16] == 0) continue;
            zero = false;
            break;
        }
        if (zero) {
            return null;
        }
        UUID groupUUID = new UUID(this.id.bytesIntoLong(16), this.id.bytesIntoLong(24));
        PeerGroupID groupID = new PeerGroupID(groupUUID);
        return (net.jxta.peergroup.PeerGroupID)IDFormat.translateToWellKnown(groupID);
    }

    protected UUID getUUID() {
        return new UUID(this.id.bytesIntoLong(0), this.id.bytesIntoLong(8));
    }
}

