/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.membership.pse;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.credential.AuthenticationCredential;
import net.jxta.credential.Credential;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.exception.PeerGroupException;
import net.jxta.exception.ProtocolNotSupportedException;
import net.jxta.id.ID;
import net.jxta.impl.membership.pse.DialogAuthenticator;
import net.jxta.impl.membership.pse.EngineAuthenticator;
import net.jxta.impl.membership.pse.KeyStoreManager;
import net.jxta.impl.membership.pse.PSEAuthenticatorEngine;
import net.jxta.impl.membership.pse.PSEAuthenticatorEngineFactory;
import net.jxta.impl.membership.pse.PSEConfig;
import net.jxta.impl.membership.pse.PSECredential;
import net.jxta.impl.membership.pse.PSEKeyStoreManagerFactory;
import net.jxta.impl.membership.pse.PSEPeerSecurityEngine;
import net.jxta.impl.membership.pse.PSESecurityEngineFactory;
import net.jxta.impl.membership.pse.PSEUtils;
import net.jxta.impl.membership.pse.StringAuthenticator;
import net.jxta.impl.protocol.PSEConfigAdv;
import net.jxta.logging.Logging;
import net.jxta.membership.Authenticator;
import net.jxta.membership.MembershipService;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.service.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PSEMembershipService
implements MembershipService {
    private static final transient Logger LOG = Logger.getLogger(PSEMembershipService.class.getName());
    public static final ModuleSpecID pseMembershipSpecID = (ModuleSpecID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe000000050306"));
    PeerGroup group = null;
    private ID assignedID = null;
    private ModuleImplAdvertisement implAdvertisement = null;
    private final List<PSECredential> principals = new ArrayList<PSECredential>();
    private final List<AuthenticationCredential> authCredentials = new ArrayList<AuthenticationCredential>();
    private final PropertyChangeSupport support = new PropertyChangeSupport(this.getInterface());
    PSEConfig pseStore = null;
    private PSECredential defaultCredential = null;
    private PSEConfigAdv config;
    PSEPeerSecurityEngine peerSecurityEngine = null;
    private PSEAuthenticatorEngine authenticatorEngine = null;

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public void init(PeerGroup group, ID assignedID, Advertisement impl) throws PeerGroupException {
        this.group = group;
        this.assignedID = assignedID;
        this.implAdvertisement = (ModuleImplAdvertisement)impl;
        ConfigParams configAdv = group.getConfigAdvertisement();
        StructuredDocument param = configAdv.getServiceParam(assignedID);
        Advertisement paramsAdv = null;
        if (null != param) {
            try {
                paramsAdv = AdvertisementFactory.newAdvertisement((XMLElement)((Object)param));
            }
            catch (NoSuchElementException ignored) {
                // empty catch block
            }
            if (!(paramsAdv instanceof PSEConfigAdv)) {
                throw new PeerGroupException("Provided Advertisement was not a " + PSEConfigAdv.getAdvertisementType());
            }
            this.config = (PSEConfigAdv)paramsAdv;
        } else {
            this.config = (PSEConfigAdv)AdvertisementFactory.newAdvertisement(PSEConfigAdv.getAdvertisementType());
        }
        this.peerSecurityEngine = PSESecurityEngineFactory.getDefault().getInstance(this, this.config);
        this.authenticatorEngine = PSEAuthenticatorEngineFactory.getDefault().getInstance(this, this.config);
        KeyStoreManager storeManager = PSEKeyStoreManagerFactory.getDefault().getInstance(this, this.config);
        this.pseStore = new PSEConfig(storeManager, null);
        if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
            StringBuilder configInfo = new StringBuilder("Configuring PSE Membership Service : " + assignedID);
            configInfo.append("\n\tImplementation :");
            configInfo.append("\n\t\tModule Spec ID: " + this.implAdvertisement.getModuleSpecID());
            configInfo.append("\n\t\tImpl Description : " + this.implAdvertisement.getDescription());
            configInfo.append("\n\t\tImpl URI : " + this.implAdvertisement.getUri());
            configInfo.append("\n\t\tImpl Code : " + this.implAdvertisement.getCode());
            configInfo.append("\n\tGroup Params :");
            configInfo.append("\n\t\tGroup : " + group.getPeerGroupName());
            configInfo.append("\n\t\tGroup ID : " + group.getPeerGroupID());
            configInfo.append("\n\t\tPeer ID : " + group.getPeerID());
            configInfo.append("\n\tConfiguration :");
            configInfo.append("\n\t\tPSE state : " + (this.pseStore.isInitialized() ? "inited" : "new"));
            configInfo.append("\n\t\tPSE KeyStore location : " + (null != this.config.getKeyStoreLocation() ? this.config.getKeyStoreLocation().toString() : assignedID.toString()));
            configInfo.append("\n\t\tPSE KeyStore type : " + (null != this.config.getKeyStoreType() ? this.config.getKeyStoreType() : "<default>"));
            configInfo.append("\n\t\tPSE KeyStore provider : " + (null != this.config.getKeyStoreProvider() ? this.config.getKeyStoreProvider() : "<default>"));
            LOG.config(configInfo.toString());
        }
        this.resign();
    }

    @Override
    public Service getInterface() {
        return this;
    }

    @Override
    public Advertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    @Override
    public int startApp(String[] arg) {
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("PSE Membmership Service started.");
        }
        return 0;
    }

    @Override
    public void stopApp() {
        this.resign();
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("PSE Membmership Service stopped.");
        }
    }

    public PeerGroup getGroup() {
        return this.group;
    }

    public ID getAssignedID() {
        return this.assignedID;
    }

    @Override
    public Authenticator apply(AuthenticationCredential application) throws ProtocolNotSupportedException {
        boolean newKey;
        String method = application.getMethod();
        if (!this.pseStore.isInitialized()) {
            newKey = true;
        } else {
            X509Certificate configCert = this.config.getCertificate();
            if (null != configCert) {
                try {
                    ID[] allTrustedCerts = this.pseStore.getTrustedCertsList();
                    Iterator<ID> eachTrustedCert = Arrays.asList(allTrustedCerts).iterator();
                    newKey = true;
                    while (eachTrustedCert.hasNext()) {
                        X509Certificate aTrustedCert;
                        ID aTrustedCertID = eachTrustedCert.next();
                        if (!this.pseStore.isKey(aTrustedCertID) || !(aTrustedCert = this.pseStore.getTrustedCertificate(aTrustedCertID)).equals(configCert)) continue;
                        newKey = false;
                    }
                }
                catch (KeyStoreException bad) {
                    newKey = false;
                }
                catch (IOException bad) {
                    newKey = false;
                }
            } else {
                newKey = false;
            }
        }
        if ("StringAuthentication".equals(method)) {
            if (newKey) {
                return new StringAuthenticator(this, application, this.config.getCertificate(), this.config.getEncryptedPrivateKey());
            }
            return new StringAuthenticator(this, application);
        }
        if ("EngineAuthentication".equals(method)) {
            if (this.pseStore.isInitialized()) {
                return new EngineAuthenticator(this, application, this.authenticatorEngine);
            }
            return new EngineAuthenticator(this, application, this.authenticatorEngine);
        }
        if ("DialogAuthentication".equals(method) || "InteractiveAuthentication".equals(method) || null == method) {
            if (newKey) {
                return new DialogAuthenticator(this, application, this.config.getCertificate(), this.config.getEncryptedPrivateKey());
            }
            return new DialogAuthenticator(this, application);
        }
        throw new ProtocolNotSupportedException("Authentication method not recognized");
    }

    @Override
    public Credential getDefaultCredential() {
        return this.defaultCredential;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDefaultCredential(PSECredential newDefault) {
        PSECredential oldDefault = this.defaultCredential;
        PSEMembershipService pSEMembershipService = this;
        synchronized (pSEMembershipService) {
            this.defaultCredential = newDefault;
        }
        if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
            LOG.config("New Default credential : " + newDefault);
        }
        try {
            PeerAdvertisement peeradv = this.group.getPeerAdvertisement();
            if (null != newDefault) {
                XMLDocument paramDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
                net.jxta.impl.protocol.Certificate peerCerts = new net.jxta.impl.protocol.Certificate();
                peerCerts.setCertificates(newDefault.getCertificateChain());
                XMLDocument peerCertsAsDoc = (XMLDocument)peerCerts.getDocument(MimeMediaType.XMLUTF8);
                StructuredDocumentUtils.copyElements(paramDoc, paramDoc, peerCertsAsDoc, "RootCert");
                peeradv.putServiceParam(PeerGroup.peerGroupClassID, paramDoc);
            } else {
                peeradv.removeServiceParam(PeerGroup.peerGroupClassID);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.support.firePropertyChange("defaultCredential", oldDefault, newDefault);
    }

    @Override
    public Enumeration<Credential> getCurrentCredentials() {
        ArrayList<PSECredential> credList = new ArrayList<PSECredential>(this.principals);
        return Collections.enumeration(credList);
    }

    @Override
    public Enumeration<AuthenticationCredential> getAuthCredentials() {
        ArrayList<AuthenticationCredential> credList = new ArrayList<AuthenticationCredential>(this.authCredentials);
        return Collections.enumeration(credList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Credential join(Authenticator authenticated) throws PeerGroupException {
        PSECredential newCred;
        char[] key_password;
        block39: {
            if (this != authenticated.getSourceService()) {
                throw new ClassCastException("This is not my authenticator!");
            }
            if (!authenticated.isReadyForJoin()) {
                throw new PeerGroupException("Authenticator not ready to join!");
            }
            char[] store_password = null;
            key_password = null;
            try {
                ID identity;
                Authenticator auth;
                if (authenticated instanceof StringAuthenticator) {
                    auth = (StringAuthenticator)authenticated;
                    store_password = ((StringAuthenticator)auth).getAuth1_KeyStorePassword();
                    identity = ((StringAuthenticator)auth).getAuth2Identity();
                    key_password = ((StringAuthenticator)auth).getAuth3_IdentityPassword();
                } else if (authenticated instanceof EngineAuthenticator) {
                    auth = (EngineAuthenticator)authenticated;
                    store_password = ((EngineAuthenticator)auth).getAuth1_KeyStorePassword();
                    identity = ((EngineAuthenticator)auth).getAuth2Identity();
                    key_password = ((EngineAuthenticator)auth).getAuth3_IdentityPassword();
                } else {
                    if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.warning("I dont know how to deal with this authenticator " + authenticated);
                    }
                    throw new PeerGroupException("I dont know how to deal with this authenticator");
                }
                if (null != store_password) {
                    this.pseStore.setKeyStorePassword(store_password);
                }
                if (!this.pseStore.isInitialized()) {
                    if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                        LOG.info("Initializing the PSE key store.");
                    }
                    try {
                        this.pseStore.initialize();
                    }
                    catch (KeyStoreException bad) {
                        throw new PeerGroupException("Could not initialize new PSE keystore.", bad);
                    }
                    catch (IOException bad) {
                        throw new PeerGroupException("Could not initialize new PSE keystore.", bad);
                    }
                }
                try {
                    ID[] allkeys = this.pseStore.getKeysList();
                    if (!Arrays.asList(allkeys).contains(identity)) {
                        Certificate[] seed_cert = this.config.getCertificateChain();
                        if (null == seed_cert) {
                            throw new IOException("Could not read root certificate chain");
                        }
                        PrivateKey seedPrivKey = this.config.getPrivateKey(key_password);
                        if (null == seedPrivKey) {
                            throw new IOException("Could not read private key");
                        }
                        this.pseStore.setKey(identity, seed_cert, seedPrivKey, key_password);
                    }
                }
                catch (IOException failed) {
                    if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.log(Level.WARNING, "Could not save new key pair.", failed);
                    }
                    throw new PeerGroupException("Could not save new key pair.", failed);
                }
                catch (KeyStoreException failed) {
                    if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.log(Level.WARNING, "Could not save new key pair.", failed);
                    }
                    throw new PeerGroupException("Could not save new key pair.", failed);
                }
                try {
                    X509Certificate[] certList = this.pseStore.getTrustedCertificateChain(identity);
                    if (null == certList && (certList = new X509Certificate[]{this.pseStore.getTrustedCertificate(identity)})[0] == null && this.authenticatorEngine != null) {
                        certList[0] = this.authenticatorEngine.getX509Certificate();
                    }
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    CertPath certs = cf.generateCertPath(Arrays.asList(certList));
                    PrivateKey privateKey = this.pseStore.getKey(identity, key_password);
                    newCred = new PSECredential(this, identity, certs, privateKey);
                    PSEMembershipService pSEMembershipService = this;
                    synchronized (pSEMembershipService) {
                        this.principals.add(newCred);
                        this.authCredentials.add(authenticated.getAuthenticationCredential());
                    }
                }
                catch (IOException failed) {
                    if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.log(Level.WARNING, "Could not create credential.", failed);
                    }
                    throw new PeerGroupException("Could not create credential.", failed);
                }
                catch (KeyStoreException failed) {
                    if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.log(Level.WARNING, "Could not create credential.", failed);
                    }
                    throw new PeerGroupException("Could not create credential.", failed);
                }
                catch (CertificateException failed) {
                    if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.log(Level.WARNING, "Could not create credential.", failed);
                    }
                    throw new PeerGroupException("Could not create credential.", failed);
                }
                Object var13_19 = null;
                if (null == store_password) break block39;
            }
            catch (Throwable throwable) {
                Object var13_20 = null;
                if (null != store_password) {
                    Arrays.fill(store_password, '\u0000');
                }
                if (null != key_password) {
                    Arrays.fill(key_password, '\u0000');
                }
                throw throwable;
            }
            Arrays.fill(store_password, '\u0000');
        }
        if (null != key_password) {
            Arrays.fill(key_password, '\u0000');
        }
        if (null == this.getDefaultCredential()) {
            this.setDefaultCredential(newCred);
        }
        this.support.firePropertyChange("addCredential", null, newCred);
        return newCred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resign() {
        Iterator<Object> eachCred = Arrays.asList(this.principals.toArray()).iterator();
        PSEMembershipService pSEMembershipService = this;
        synchronized (pSEMembershipService) {
            this.principals.clear();
            this.authCredentials.clear();
        }
        this.setDefaultCredential(null);
        this.pseStore.setKeyStorePassword(null);
        while (eachCred.hasNext()) {
            PSECredential aCred = (PSECredential)eachCred.next();
            aCred.setValid(false);
        }
    }

    @Override
    public Credential makeCredential(Element element2) {
        return new PSECredential(this, element2);
    }

    public PSEConfig getPSEConfig() {
        return this.pseStore;
    }

    X509Certificate[] generateServiceCertificate(ID assignedID, PSECredential credential) throws IOException, KeyStoreException, InvalidKeyException, SignatureException {
        char[] keyPass;
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Generating new service cert for " + assignedID);
        }
        PSEUtils.IssuerInfo serviceinfo = this.peerSecurityEngine.generateCertificate(credential);
        Certificate[] serviceChain = new X509Certificate[]{serviceinfo.cert, serviceinfo.issuer};
        if (null != serviceinfo.issuerPkey) {
            ByteArrayInputStream bis = new ByteArrayInputStream(serviceinfo.issuerPkey.getEncoded());
            byte[] privateKeySignature = this.peerSecurityEngine.sign(null, credential, bis);
            keyPass = PSEUtils.base64Encode(privateKeySignature, false).toCharArray();
        } else {
            keyPass = this.authenticatorEngine.getKeyPass(this.group);
        }
        this.getPSEConfig().setKey(assignedID, serviceChain, serviceinfo.subjectPkey, keyPass);
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Generated new service cert");
        }
        return serviceChain;
    }

    public PSECredential getServiceCredential(ID assignedID, PSECredential credential) throws IOException, PeerGroupException, InvalidKeyException, SignatureException {
        PSECredential pseCredential = null;
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Getting service redential for " + assignedID);
        }
        Authenticator authenticate = null;
        if (null != this.authenticatorEngine) {
            AuthenticationCredential authCred = new AuthenticationCredential(this.group, "EngineAuthentication", null);
            try {
                authenticate = this.apply(authCred);
            }
            catch (Exception failed) {
                // empty catch block
            }
            if (null == authenticate) {
                return null;
            }
            EngineAuthenticator auth = (EngineAuthenticator)authenticate;
            auth.setAuth1_KeyStorePassword(this.authenticatorEngine.getStorePass(this.group));
            auth.setAuth2Identity(assignedID);
            auth.setAuth3_IdentityPassword(this.authenticatorEngine.getKeyPass(this.group));
        } else {
            AuthenticationCredential authCred = new AuthenticationCredential(this.group, "StringAuthentication", null);
            try {
                authenticate = this.apply(authCred);
            }
            catch (Exception failed) {
                // empty catch block
            }
            if (null == authenticate) {
                return null;
            }
            PrivateKey privateKey = credential.getPrivateKey();
            ByteArrayInputStream bis = new ByteArrayInputStream(privateKey.getEncoded());
            byte[] privateKeySignature = this.peerSecurityEngine.sign(null, credential, bis);
            String passkey = PSEUtils.base64Encode(privateKeySignature, false);
            StringAuthenticator auth = (StringAuthenticator)authenticate;
            auth.setAuth1_KeyStorePassword((String)null);
            auth.setAuth2Identity(assignedID);
            auth.setAuth3_IdentityPassword(passkey);
        }
        if (authenticate.isReadyForJoin()) {
            pseCredential = (PSECredential)this.join(authenticate);
        } else if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
            LOG.warning("Could not authenticate service credential");
        }
        return pseCredential;
    }
}

