/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peer;

import java.io.StringReader;
import java.net.URI;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.credential.Credential;
import net.jxta.document.Advertisement;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.EndpointService;
import net.jxta.exception.JxtaException;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.meter.MeterBuildSettings;
import net.jxta.impl.meter.MonitorManager;
import net.jxta.impl.peer.PeerInfoHandler;
import net.jxta.impl.peer.PeerInfoMessenger;
import net.jxta.impl.peer.PeerInfoServiceInterface;
import net.jxta.impl.peer.RemoteMonitorPeerInfoHandler;
import net.jxta.impl.protocol.PeerInfoQueryMsg;
import net.jxta.impl.protocol.PeerInfoResponseMsg;
import net.jxta.impl.protocol.ResolverQuery;
import net.jxta.impl.protocol.ResolverResponse;
import net.jxta.logging.Logging;
import net.jxta.membership.MembershipService;
import net.jxta.meter.MonitorException;
import net.jxta.meter.MonitorFilter;
import net.jxta.meter.MonitorListener;
import net.jxta.meter.MonitorReport;
import net.jxta.meter.PeerMonitorInfo;
import net.jxta.meter.PeerMonitorInfoListener;
import net.jxta.peer.PeerID;
import net.jxta.peer.PeerInfoService;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.ModuleClassID;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerInfoResponseMessage;
import net.jxta.protocol.ResolverQueryMsg;
import net.jxta.protocol.ResolverResponseMsg;
import net.jxta.resolver.QueryHandler;
import net.jxta.resolver.ResolverService;
import net.jxta.service.Service;
import net.jxta.util.documentSerializable.DocumentSerializable;

public class PeerInfoServiceImpl
implements PeerInfoService {
    private static final Logger LOG = Logger.getLogger(PeerInfoServiceImpl.class.getName());
    private long startTime = 0L;
    private ResolverService resolver = null;
    private PeerGroup group = null;
    private EndpointService endpoint = null;
    private PeerID localPeerId = null;
    private ModuleImplAdvertisement implAdvertisement = null;
    private String resolverHandlerName = null;
    private MembershipService membership = null;
    private Credential credential = null;
    private StructuredDocument credentialDoc = null;
    private MonitorManager monitorManager;
    private final Map peerInfoHandlers = new Hashtable();
    private PipQueryHandler pipQueryHandler = new PipQueryHandler();
    private RemoteMonitorPeerInfoHandler remoteMonitorPeerInfoHandler;
    private PeerInfoMessenger resolverServicePeerInfoMessenger = new ResolverServicePeerInfoMessenger();
    private int nextQueryId = 1000;
    private static final Random rand = new Random();
    static Hashtable peerInfoServices = new Hashtable();

    public void init(PeerGroup group, ID assignedID, Advertisement impl) throws PeerGroupException {
        this.group = group;
        this.implAdvertisement = (ModuleImplAdvertisement)impl;
        this.localPeerId = group.getPeerID();
        this.resolverHandlerName = assignedID.toString();
        try {
            if (MeterBuildSettings.METERING) {
                this.monitorManager = MonitorManager.registerMonitorManager(group);
            }
        }
        catch (JxtaException e) {
            throw new PeerGroupException("Unable to load MonitorManager", e);
        }
        this.startTime = System.currentTimeMillis();
        if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
            StringBuilder configInfo = new StringBuilder("Configuring PeerInfo Service : " + assignedID);
            configInfo.append("\n\tImplementation:");
            configInfo.append("\n\t\tImpl Description: ");
            configInfo.append(this.implAdvertisement.getDescription());
            configInfo.append("\n\t\tImpl URI : ").append(this.implAdvertisement.getUri());
            configInfo.append("\n\t\tImpl Code : ").append(this.implAdvertisement.getCode());
            configInfo.append("\n\tGroup Params:");
            configInfo.append("\n\t\tGroup: ").append(group.getPeerGroupName());
            configInfo.append("\n\t\tGroup ID: ").append(group.getPeerGroupID());
            configInfo.append("\n\t\tPeer ID: ").append(group.getPeerID());
            LOG.config(configInfo.toString());
        }
    }

    public int startApp(String[] arg) {
        this.resolver = this.group.getResolverService();
        if (null == this.resolver) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Stalled until there is a resolver service");
            }
            return 2;
        }
        this.resolver = this.group.getResolverService();
        this.resolver.registerHandler(this.resolverHandlerName, this.pipQueryHandler);
        peerInfoServices.put(this.group, this);
        return 0;
    }

    public void stopApp() {
        peerInfoServices.remove(this.group);
        this.resolver.unregisterHandler(this.resolverHandlerName);
        this.resolver = null;
        if (MeterBuildSettings.METERING) {
            MonitorManager.unregisterMonitorManager(this.group);
        }
        this.group = null;
    }

    public Service getInterface() {
        return new PeerInfoServiceInterface(this);
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    PeerInfoHandler getPeerInfoHandler(String name) {
        return (PeerInfoHandler)this.peerInfoHandlers.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNextQueryId() {
        int id = 0;
        Random random = rand;
        synchronized (random) {
            id = rand.nextInt(Integer.MAX_VALUE);
        }
        return id;
    }

    public PeerGroup getGroup() {
        return this.group;
    }

    public boolean isLocalMonitoringAvailable() {
        return MeterBuildSettings.METERING;
    }

    public boolean isLocalMonitoringAvailable(ModuleClassID moduleClassID) {
        return MeterBuildSettings.METERING && this.monitorManager.isLocalMonitoringAvailable(moduleClassID);
    }

    public long[] getSupportedReportRates() {
        return MonitorManager.getReportRates();
    }

    public boolean isSupportedReportRate(long reportRate) {
        return this.monitorManager.isSupportedReportRate(reportRate);
    }

    public long getBestReportRate(long desiredReportRate) {
        return this.monitorManager.getBestReportRate(desiredReportRate);
    }

    public PeerMonitorInfo getPeerMonitorInfo() {
        if (this.monitorManager != null) {
            return this.monitorManager.getPeerMonitorInfo();
        }
        return PeerMonitorInfo.NO_PEER_MONITOR_INFO;
    }

    public void getPeerMonitorInfo(PeerID peerID, PeerMonitorInfoListener peerMonitorInfoListener, long timeout) throws MonitorException {
        this.remoteMonitorPeerInfoHandler.getPeerMonitorInfo(peerID, peerMonitorInfoListener, timeout, this.resolverServicePeerInfoMessenger);
    }

    public MonitorReport getCumulativeMonitorReport(MonitorFilter monitorFilter) throws MonitorException {
        if (MeterBuildSettings.METERING) {
            throw new MonitorException(7000, "Local Monitoring not Available");
        }
        return this.monitorManager.getCumulativeMonitorReport(monitorFilter);
    }

    public void getCumulativeMonitorReport(PeerID peerID, MonitorFilter monitorFilter, MonitorListener monitorListener, long timeout) throws MonitorException {
        this.remoteMonitorPeerInfoHandler.getCumulativeMonitorReport(peerID, monitorFilter, monitorListener, timeout, this.resolverServicePeerInfoMessenger);
    }

    public long addMonitorListener(MonitorFilter monitorFilter, long reportRate, boolean includeCumulative, MonitorListener monitorListener) throws MonitorException {
        if (!MeterBuildSettings.METERING) {
            throw new MonitorException(7000, "Local Monitoring not Available");
        }
        return this.monitorManager.addMonitorListener(monitorFilter, reportRate, includeCumulative, monitorListener);
    }

    public void addRemoteMonitorListener(PeerID peerID, MonitorFilter monitorFilter, long reportRate, boolean includeCumulative, MonitorListener monitorListener, long lease, long timeout) throws MonitorException {
        this.remoteMonitorPeerInfoHandler.addRemoteMonitorListener(peerID, monitorFilter, reportRate, includeCumulative, monitorListener, lease, timeout, this.resolverServicePeerInfoMessenger);
    }

    public boolean removeMonitorListener(MonitorListener monitorListener) throws MonitorException {
        int numRemoved = this.monitorManager.removeMonitorListener(monitorListener);
        return numRemoved > 0;
    }

    public void removeRemoteMonitorListener(PeerID peerID, MonitorListener monitorListener, long timeout) throws MonitorException {
        this.remoteMonitorPeerInfoHandler.removeRemoteMonitorListener(peerID, monitorListener, timeout, this.resolverServicePeerInfoMessenger);
    }

    public void removeRemoteMonitorListener(MonitorListener monitorListener, long timeout) throws MonitorException {
        this.remoteMonitorPeerInfoHandler.removeRemoteMonitorListener(monitorListener, timeout, this.resolverServicePeerInfoMessenger);
    }

    private class ResolverServicePeerInfoMessenger
    implements PeerInfoMessenger {
        private ResolverServicePeerInfoMessenger() {
        }

        public void sendPeerInfoResponse(int queryId, PeerID destinationPeerID, String peerInfoHandler, DocumentSerializable response) {
            block2: {
                try {
                    PeerInfoResponseMsg peerInfoResponseMessage = new PeerInfoResponseMsg();
                    peerInfoResponseMessage.setSourcePid(destinationPeerID);
                    peerInfoResponseMessage.setTargetPid(PeerInfoServiceImpl.this.localPeerId);
                    long now = System.currentTimeMillis();
                    peerInfoResponseMessage.setUptime(now - PeerInfoServiceImpl.this.startTime);
                    peerInfoResponseMessage.setTimestamp(now);
                    StructuredDocument responseElement = StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, peerInfoHandler);
                    response.serializeTo(responseElement);
                    peerInfoResponseMessage.setResponse(responseElement);
                    XMLDocument doc = (XMLDocument)((PeerInfoResponseMessage)peerInfoResponseMessage).getDocument(MimeMediaType.XMLUTF8);
                    String peerInfoResponse = doc.toString();
                    ResolverResponse resolverResponse = new ResolverResponse(PeerInfoServiceImpl.this.resolverHandlerName, PeerInfoServiceImpl.this.credentialDoc, queryId, peerInfoResponse);
                    PeerInfoServiceImpl.this.resolver.sendResponse(destinationPeerID.toString(), resolverResponse);
                }
                catch (JxtaException e) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block2;
                    LOG.log(Level.WARNING, "Failure building document", e);
                }
            }
        }

        public void sendPeerInfoRequest(int queryID, PeerID destinationPeerID, String peerInfoHandler, DocumentSerializable request) {
            block2: {
                try {
                    PeerInfoQueryMsg peerInfoQueryMsg = new PeerInfoQueryMsg();
                    peerInfoQueryMsg.setSourcePid(PeerInfoServiceImpl.this.localPeerId);
                    peerInfoQueryMsg.setTargetPid(destinationPeerID);
                    StructuredDocument requestElement = StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, peerInfoHandler);
                    request.serializeTo(requestElement);
                    peerInfoQueryMsg.setRequest(requestElement);
                    XMLDocument doc = (XMLDocument)peerInfoQueryMsg.getDocument(MimeMediaType.XMLUTF8);
                    String peerInfoRequest = doc.toString();
                    ResolverQuery resolverQuery = new ResolverQuery(PeerInfoServiceImpl.this.resolverHandlerName, PeerInfoServiceImpl.this.credentialDoc, PeerInfoServiceImpl.this.localPeerId.toString(), peerInfoRequest, queryID);
                    PeerInfoServiceImpl.this.resolver.sendQuery(destinationPeerID.toString(), resolverQuery);
                }
                catch (JxtaException e) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block2;
                    LOG.log(Level.WARNING, "Failure to build resolver query", e);
                }
            }
        }
    }

    class PipQueryHandler
    implements QueryHandler {
        PipQueryHandler() {
        }

        public int processQuery(ResolverQueryMsg query) {
            int queryId = query.getQueryId();
            PeerID requestSourceID = null;
            try {
                requestSourceID = (PeerID)IDFactory.fromURI(new URI(query.getSrc()));
            }
            catch (Exception e) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "PeerInfoService.processQuery got a bad query, not valid src", e);
                }
                return 0;
            }
            XMLDocument doc = null;
            try {
                doc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, new StringReader(query.getQuery()));
            }
            catch (Exception e) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "PeerInfoService.processQuery got a bad adv", e);
                }
                return 0;
            }
            PeerInfoQueryMsg pipquery = new PeerInfoQueryMsg(doc);
            Element requestElement = pipquery.getRequest();
            String queryType = (String)requestElement.getKey();
            if (queryType != null) {
                PeerInfoHandler peerInfoHandler = PeerInfoServiceImpl.this.getPeerInfoHandler(queryType);
                if (peerInfoHandler != null) {
                    peerInfoHandler.processRequest(queryId, requestSourceID, pipquery, requestElement, PeerInfoServiceImpl.this.resolverServicePeerInfoMessenger);
                } else if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("No registered PeerInfoHandler for this type of request");
                }
            } else if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("No request PeerInfoQueryMessage Request Element found");
            }
            return 0;
        }

        public void processResponse(ResolverResponseMsg response) {
            int queryId = response.getQueryId();
            PeerInfoResponseMsg resp = null;
            try {
                StructuredDocument doc = StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, new StringReader(response.getResponse()));
                resp = new PeerInfoResponseMsg(doc);
            }
            catch (Exception e) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "PeerInfoService.processResponse got a bad adv", e);
                }
                return;
            }
            Element responseElement = resp.getResponse();
            String responseType = (String)responseElement.getKey();
            if (responseType != null) {
                PeerInfoHandler peerInfoHandler = PeerInfoServiceImpl.this.getPeerInfoHandler(responseType);
                if (peerInfoHandler != null) {
                    peerInfoHandler.processResponse(queryId, resp, responseElement, PeerInfoServiceImpl.this.resolverServicePeerInfoMessenger);
                } else if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("No registered PeerInfoHandler for this type of response");
                }
            } else if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("No request PeerInfoResponseMessage Response Element found");
            }
        }
    }
}

