/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peergroup;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLDocument;
import net.jxta.exception.ConfiguratorException;
import net.jxta.impl.peergroup.PlatformConfigurator;
import net.jxta.impl.protocol.PlatformConfig;
import net.jxta.logging.Logging;
import net.jxta.protocol.ConfigParams;

public class NullConfigurator
implements PlatformConfigurator {
    private static final transient Logger LOG = Logger.getLogger(NullConfigurator.class.getName());
    protected final URI jxtaHome;
    protected final URI configFile;
    protected PlatformConfig advertisement = null;

    public NullConfigurator(URI homeRoot) throws ConfiguratorException {
        if (!homeRoot.isAbsolute()) {
            throw new IllegalArgumentException("homeRoot must be an absoluteURI");
        }
        this.jxtaHome = homeRoot;
        if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
            LOG.config("JXTA_HOME = " + this.jxtaHome.toASCIIString());
        }
        if ("file".equalsIgnoreCase(this.jxtaHome.getScheme())) {
            File jxtaHomeDir = new File(this.jxtaHome);
            if (jxtaHomeDir.exists() && !jxtaHomeDir.isDirectory()) {
                throw new IllegalArgumentException("'" + jxtaHomeDir + "' is not a directory.");
            }
            if (!jxtaHomeDir.exists() && !jxtaHomeDir.mkdirs()) {
                throw new IllegalStateException("Could not create '" + jxtaHomeDir + "'.");
            }
            this.configFile = new File(jxtaHomeDir, "PlatformConfig").toURI();
        } else {
            this.configFile = this.jxtaHome.resolve("PlatformConfig");
        }
    }

    public PlatformConfig getPlatformConfig() throws ConfiguratorException {
        this.advertisement = (PlatformConfig)this.load();
        return this.advertisement;
    }

    public final void setPlatformConfig(PlatformConfig config) {
        this.advertisement = config;
    }

    public ConfigParams getConfigParams() throws ConfiguratorException {
        return this.getPlatformConfig();
    }

    public void setConfigParams(ConfigParams cp) {
        this.setPlatformConfig((PlatformConfig)cp);
    }

    public void setReconfigure(boolean reconfigure) {
    }

    public boolean isReconfigure() {
        return false;
    }

    public ConfigParams load() throws ConfiguratorException {
        return this.load(this.configFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    protected PlatformConfig load(URI loadFile) throws ConfiguratorException {
        PlatformConfig platformConfig;
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Reading Platform Config from : " + loadFile);
        }
        InputStream advStream = null;
        try {
            try {
                advStream = loadFile.toURL().openStream();
                XMLDocument xmlDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, advStream);
                PlatformConfig result = (PlatformConfig)AdvertisementFactory.newAdvertisement(xmlDoc);
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Recovered Platform Config from : " + loadFile);
                }
                platformConfig = result;
                Object var7_9 = null;
            }
            catch (FileNotFoundException e) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Platform Config not found : " + loadFile);
                }
                PlatformConfig platformConfig2 = null;
                Object var7_10 = null;
                try {
                    if (advStream != null) {
                        advStream.close();
                    }
                    advStream = null;
                    return platformConfig2;
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                return platformConfig2;
            }
            catch (Exception e) {
                if (!Logging.SHOW_WARNING) throw new ConfiguratorException("Failed to recover PlatformConfig", e);
                if (!LOG.isLoggable(Level.WARNING)) throw new ConfiguratorException("Failed to recover PlatformConfig", e);
                LOG.log(Level.WARNING, "Failed to Recover '" + loadFile + "' due to : ", e);
                throw new ConfiguratorException("Failed to recover PlatformConfig", e);
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            try {}
            catch (Exception ignored) {
                throw throwable;
            }
            if (advStream != null) {
                advStream.close();
            }
            advStream = null;
            throw throwable;
        }
        try {}
        catch (Exception ignored) {
            // empty catch block
            return platformConfig;
        }
        if (advStream != null) {
            advStream.close();
        }
        advStream = null;
        return platformConfig;
    }

    public boolean save() throws ConfiguratorException {
        return this.save(this.configFile);
    }

    /*
     * Loose catch block
     */
    protected boolean save(URI saveFile) throws ConfiguratorException {
        OutputStream out;
        block10: {
            out = null;
            XMLDocument aDoc = (XMLDocument)this.advertisement.getDocument(MimeMediaType.XMLUTF8);
            out = "file".equalsIgnoreCase(saveFile.getScheme()) ? new FileOutputStream(new File(saveFile)) : saveFile.toURL().openConnection().getOutputStream();
            OutputStreamWriter os = new OutputStreamWriter(out, "UTF-8");
            aDoc.sendToWriter(os);
            os.flush();
            Object var6_6 = null;
            try {
                if (null != out) {
                    out.close();
                }
                break block10;
            }
            catch (Exception ignored) {
                // empty catch block
            }
            {
                break block10;
                catch (IOException e) {
                    if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.log(Level.WARNING, "Could not save to : " + saveFile, e);
                    }
                    throw new ConfiguratorException("Could not save to : " + saveFile, e);
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                try {
                    if (null != out) {
                        out.close();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                out = null;
                throw throwable;
            }
        }
        out = null;
        return true;
    }
}

