/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peergroup;

import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import net.jxta.access.AccessService;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.Element;
import net.jxta.endpoint.EndpointService;
import net.jxta.exception.PeerGroupException;
import net.jxta.exception.ProtocolNotSupportedException;
import net.jxta.exception.ServiceNotFoundException;
import net.jxta.id.ID;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peer.PeerInfoService;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.PipeService;
import net.jxta.platform.JxtaLoader;
import net.jxta.platform.Module;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PeerGroupAdvertisement;
import net.jxta.rendezvous.RendezVousService;
import net.jxta.resolver.ResolverService;
import net.jxta.service.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PeerGroupInterface
implements PeerGroup {
    private static final Logger LOG = Logger.getLogger(PeerGroupInterface.class.getName());
    protected final AtomicBoolean unrefed = new AtomicBoolean(false);
    protected PeerGroup groupImpl;

    PeerGroupInterface(PeerGroup theRealThing) {
        this.groupImpl = theRealThing;
    }

    public boolean equals(Object target) {
        PeerGroup temp = this.groupImpl;
        if (null != temp) {
            return temp.equals(target);
        }
        return super.equals(target);
    }

    public String toString() {
        PeerGroup temp = this.groupImpl;
        if (null != temp) {
            return temp.toString();
        }
        return super.toString();
    }

    @Override
    public void init(PeerGroup pg, ID assignedID, Advertisement impl) {
    }

    @Override
    public int startApp(String[] args) {
        return 0;
    }

    @Override
    public void stopApp() {
        this.unref();
    }

    @Override
    public PeerGroup getInterface() {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return this;
    }

    @Override
    public PeerGroup getWeakInterface() {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return this;
    }

    @Override
    public void unref() {
        if (this.unrefed.compareAndSet(false, true)) {
            this.groupImpl = null;
        }
    }

    @Override
    public Advertisement getImplAdvertisement() {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return temp.getImplAdvertisement();
    }

    @Override
    public ThreadGroup getHomeThreadGroup() {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return temp.getHomeThreadGroup();
    }

    @Override
    public URI getStoreHome() {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return temp.getStoreHome();
    }

    @Override
    public JxtaLoader getLoader() {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return temp.getLoader();
    }

    @Override
    public boolean isRendezvous() {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return temp.isRendezvous();
    }

    @Override
    public PeerGroupAdvertisement getPeerGroupAdvertisement() {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return temp.getPeerGroupAdvertisement();
    }

    @Override
    public PeerAdvertisement getPeerAdvertisement() {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return temp.getPeerAdvertisement();
    }

    @Override
    public Service lookupService(ID name) throws ServiceNotFoundException {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return temp.lookupService(name);
    }

    @Override
    public Service lookupService(ID name, int roleIndex) throws ServiceNotFoundException {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return temp.lookupService(name, roleIndex);
    }

    @Override
    public Iterator<ID> getRoleMap(ID name) {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return temp.getRoleMap(name);
    }

    @Override
    public boolean compatible(Element compat) {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return temp.compatible(compat);
    }

    @Override
    public Module loadModule(ID assignedID, Advertisement impl) throws ProtocolNotSupportedException, PeerGroupException {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return temp.loadModule(assignedID, impl);
    }

    @Override
    public Module loadModule(ID assignedID, ModuleSpecID specID, int where) {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return temp.loadModule(assignedID, specID, where);
    }

    @Override
    public void publishGroup(String name, String description) throws IOException {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        temp.publishGroup(name, description);
    }

    @Override
    public PeerGroup newGroup(Advertisement pgAdv) throws PeerGroupException {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return temp.newGroup(pgAdv);
    }

    @Override
    public PeerGroup newGroup(PeerGroupID gid, Advertisement impl, String name, String description) throws PeerGroupException {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return temp.newGroup(gid, impl, name, description);
    }

    @Override
    public PeerGroup newGroup(PeerGroupID gid) throws PeerGroupException {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return temp.newGroup(gid);
    }

    @Override
    public RendezVousService getRendezVousService() {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return temp.getRendezVousService();
    }

    @Override
    public EndpointService getEndpointService() {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return temp.getEndpointService();
    }

    @Override
    public ResolverService getResolverService() {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return temp.getResolverService();
    }

    @Override
    public DiscoveryService getDiscoveryService() {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return temp.getDiscoveryService();
    }

    @Override
    public PeerInfoService getPeerInfoService() {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return temp.getPeerInfoService();
    }

    @Override
    public MembershipService getMembershipService() {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return temp.getMembershipService();
    }

    @Override
    public PipeService getPipeService() {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return temp.getPipeService();
    }

    @Override
    public AccessService getAccessService() {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return temp.getAccessService();
    }

    @Override
    public PeerGroupID getPeerGroupID() {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return temp.getPeerGroupID();
    }

    @Override
    public PeerID getPeerID() {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return temp.getPeerID();
    }

    @Override
    public String getPeerGroupName() {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return temp.getPeerGroupName();
    }

    @Override
    public String getPeerName() {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return temp.getPeerName();
    }

    @Override
    public ConfigParams getConfigAdvertisement() {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        ConfigParams configAdvertisement = temp.getConfigAdvertisement();
        if (configAdvertisement == null) {
            return null;
        }
        return configAdvertisement.clone();
    }

    @Override
    public ModuleImplAdvertisement getAllPurposePeerGroupImplAdvertisement() throws Exception {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return temp.getAllPurposePeerGroupImplAdvertisement();
    }

    @Override
    public PeerGroup getParentGroup() {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return temp.getParentGroup();
    }
}

