/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peergroup;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.exception.ServiceNotFoundException;
import net.jxta.id.ID;
import net.jxta.impl.peergroup.GenericPeerGroup;
import net.jxta.impl.peergroup.PeerGroupInterface;
import net.jxta.logging.Logging;
import net.jxta.peergroup.PeerGroup;
import net.jxta.service.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RefCountPeerGroupInterface
extends PeerGroupInterface {
    private static final Logger LOG = Logger.getLogger(RefCountPeerGroupInterface.class.getName());
    private final Map<ID, ID[]> roleMap;

    RefCountPeerGroupInterface(GenericPeerGroup theRealThing) {
        super(theRealThing);
        this.roleMap = null;
    }

    RefCountPeerGroupInterface(GenericPeerGroup theRealThing, Map<ID, ID[]> roleMap) {
        super(theRealThing);
        this.roleMap = roleMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.unrefed.get() && Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.severe("[" + this.getPeerGroupID() + "] Referenced Group has been GCed. This is an application error. Please call stopApp() before releasing Peer Group references.");
            }
            this.unref();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    @Override
    public int startApp(String[] args) {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return temp.startApp(args);
    }

    @Override
    public PeerGroup getInterface() {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return temp.getInterface();
    }

    @Override
    public PeerGroup getWeakInterface() {
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        return new PeerGroupInterface(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unref() {
        if (this.unrefed.compareAndSet(false, true)) {
            try {
                ((GenericPeerGroup)this.groupImpl).decRefCount();
                Object var2_1 = null;
                this.groupImpl = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.groupImpl = null;
                throw throwable;
            }
        }
    }

    @Override
    public Service lookupService(ID name) throws ServiceNotFoundException {
        return this.lookupService(name, 0);
    }

    @Override
    public Service lookupService(ID name, int roleIndex) throws ServiceNotFoundException {
        ID[] map;
        PeerGroup temp = this.groupImpl;
        if (this.unrefed.get() || null == temp) {
            throw new IllegalStateException("This Peer Group interface object has been unreferenced and can no longer be used.");
        }
        if (this.roleMap != null && (map = this.roleMap.get(name)) != null) {
            if (roleIndex < 0 || roleIndex >= map.length) {
                throw new ServiceNotFoundException(name + "[" + roleIndex + "]");
            }
            return temp.lookupService(map[roleIndex]);
        }
        if (roleIndex != 0) {
            throw new ServiceNotFoundException(name + "[" + roleIndex + "]");
        }
        return temp.lookupService(name);
    }

    @Override
    public Iterator<ID> getRoleMap(ID name) {
        ID[] map;
        List<ID> roles = Collections.singletonList(name);
        if (this.roleMap != null && (map = this.roleMap.get(name)) != null) {
            roles = Arrays.asList(map);
        }
        return Collections.unmodifiableList(roles).iterator();
    }
}

