/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.pipe;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.MimeMediaType;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.id.ID;
import net.jxta.impl.pipe.NonBlockingWireOutputPipe;
import net.jxta.impl.pipe.WireHeader;
import net.jxta.impl.pipe.WirePipe;
import net.jxta.logging.Logging;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.OutputPipe;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.protocol.RouteAdvertisement;

public class BlockingWireOutputPipe
implements OutputPipe {
    private static final Logger LOG = Logger.getLogger(NonBlockingWireOutputPipe.class.getName());
    private volatile boolean closed = false;
    private final PipeAdvertisement pAdv;
    private final PeerGroup group;
    private final EndpointService endpoint;
    private final EndpointAddress destination;
    private final RouteAdvertisement route;
    private Messenger destMessenger = null;

    public BlockingWireOutputPipe(PeerGroup group, PipeAdvertisement pAdv, PeerID peerID) throws IOException {
        this(group, pAdv, peerID, null);
    }

    public BlockingWireOutputPipe(PeerGroup group, PipeAdvertisement pAdv, PeerID peerID, RouteAdvertisement route) throws IOException {
        this.pAdv = pAdv;
        this.group = group;
        this.endpoint = group.getEndpointService();
        this.destination = new EndpointAddress("jxta", peerID.getUniqueValue().toString(), "PipeService", pAdv.getID().toString());
        this.route = route;
        this.checkMessenger();
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Created output pipe for " + this.getPipeID());
        }
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Closing " + this.getPipeID());
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public final String getType() {
        return this.pAdv.getType();
    }

    public final ID getPipeID() {
        return this.pAdv.getPipeID();
    }

    public final String getName() {
        return this.pAdv.getName();
    }

    public final PipeAdvertisement getAdvertisement() {
        return this.pAdv;
    }

    private synchronized boolean checkMessenger() throws IOException {
        if (this.destMessenger != null && (this.destMessenger.getState() & 0x3FF) != 0) {
            return true;
        }
        if (this.route != null) {
            this.destMessenger = this.endpoint.getDirectMessenger(this.destination, this.route, true);
        }
        if (this.destMessenger == null || (this.destMessenger.getState() & 0x70000) != 0) {
            this.destMessenger = null;
            this.destMessenger = this.endpoint.getMessenger(this.destination, this.route);
        }
        if (this.destMessenger == null || (this.destMessenger.getState() & 0x70000) != 0) {
            this.destMessenger = null;
            throw new IOException("Unable to create a messenger to " + this.destination.toString());
        }
        return true;
    }

    public boolean send(Message message) throws IOException {
        if (this.closed) {
            throw new IOException("Pipe closed");
        }
        Message msg = message.clone();
        WireHeader header = new WireHeader();
        header.setPipeID(this.getPipeID());
        header.setSrcPeer(this.group.getPeerID());
        header.setTTL(1);
        header.setMsgId(WirePipe.createMsgId());
        XMLDocument asDoc = (XMLDocument)header.getDocument(MimeMediaType.XMLUTF8);
        TextDocumentMessageElement elem = new TextDocumentMessageElement("JxtaWireHeader", asDoc, null);
        msg.replaceMessageElement("jxta", elem);
        this.checkMessenger();
        try {
            return this.destMessenger.sendMessage(msg, null, null);
        }
        catch (IOException io) {
            this.checkMessenger();
            return this.destMessenger.sendMessage(msg, null, null);
        }
    }
}

