/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.pipe;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.Messenger;
import net.jxta.id.ID;
import net.jxta.impl.pipe.PipeResolver;
import net.jxta.impl.util.TimeUtils;
import net.jxta.impl.util.UnbiasedQueue;
import net.jxta.logging.Logging;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.PipeID;
import net.jxta.protocol.PipeAdvertisement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NonBlockingOutputPipe
implements PipeResolver.Listener,
OutputPipe,
Runnable {
    private static final Logger LOG = Logger.getLogger(NonBlockingOutputPipe.class.getName());
    private static final long IDLEWORKERLINGER = 10000L;
    private static final long QUERYINTERVALMIN = 15000L;
    private static final long QUERYTIMEOUTMIN = 60000L;
    private volatile boolean closed = false;
    private boolean migrated = false;
    private PeerGroup peerGroup = null;
    private EndpointService endpoint = null;
    private PipeResolver pipeResolver = null;
    private PipeAdvertisement pAdv = null;
    private ID destPeer = null;
    private Set<? extends ID> resolvablePeers = null;
    private EndpointAddress destAddress = null;
    private Messenger destMessenger = null;
    private volatile Thread serviceThread = null;
    private long nextVerifyAt = 0L;
    private final UnbiasedQueue queue = UnbiasedQueue.synchronizedQueue(new UnbiasedQueue(50, false));
    private WorkerState workerstate;
    private int queryID = -1;

    public NonBlockingOutputPipe(PeerGroup peerGroup, PipeResolver pipeResolver, PipeAdvertisement pAdv, ID destPeer, Set<? extends ID> peers) {
        this.peerGroup = peerGroup;
        this.endpoint = peerGroup.getEndpointService();
        this.pipeResolver = pipeResolver;
        this.pAdv = pAdv;
        this.destPeer = destPeer;
        this.resolvablePeers = new HashSet<ID>(peers);
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Constructing for " + this.getPipeID());
        }
        this.workerstate = WorkerState.ACQUIREMESSENGER;
        this.startServiceThread();
    }

    protected void finalize() throws Throwable {
        if (!this.closed && Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
            LOG.warning("Pipe is being finalized without being previously closed. This is likely a bug.");
        }
        this.close();
        super.finalize();
    }

    @Override
    public synchronized void close() {
        if (!this.closed) {
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.info("Closing for " + this.getPipeID());
            }
            this.queue.close();
        }
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public final String getType() {
        return this.pAdv.getType();
    }

    @Override
    public final ID getPipeID() {
        return this.pAdv.getPipeID();
    }

    @Override
    public final String getName() {
        return this.pAdv.getName();
    }

    @Override
    public final PipeAdvertisement getAdvertisement() {
        return this.pAdv;
    }

    @Override
    public boolean send(Message msg) throws IOException {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Queuing " + msg + " for pipe " + this.getPipeID());
        }
        boolean pushed = false;
        while (!this.queue.isClosed()) {
            try {
                pushed = this.queue.push(msg, 250L);
                break;
            }
            catch (InterruptedException woken) {
                Thread.interrupted();
            }
        }
        if (!pushed && this.queue.isClosed()) {
            IOException failed = new IOException("Could not enqueue " + msg + " for sending. Pipe is closed.");
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, failed.getMessage(), failed);
            }
            throw failed;
        }
        this.startServiceThread();
        return pushed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        long absoluteTimeoutAt = -1L;
        long nextQueryAt = -1L;
        try {
            try {}
            catch (Throwable all) {
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "Uncaught Throwable in thread :" + Thread.currentThread().getName(), all);
                }
                NonBlockingOutputPipe nonBlockingOutputPipe = this;
                synchronized (nonBlockingOutputPipe) {
                    if (this.serviceThread == Thread.currentThread()) {
                        this.serviceThread = null;
                    }
                }
                Object var14_13 = null;
                if (!Logging.SHOW_INFO) return;
                if (!LOG.isLoggable(Level.INFO)) return;
                LOG.info("Thread exit : " + Thread.currentThread().getName() + "\n\tworker state : " + (Object)((Object)this.workerstate) + "\tqueue closed : " + this.queue.isClosed() + "\tnumber in queue : " + this.queue.getCurrentInQueue() + "\tnumber queued : " + this.queue.getNumEnqueued() + "\tnumber dequeued : " + this.queue.getNumDequeued());
                return;
            }
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            if (!Logging.SHOW_INFO) throw throwable;
            if (!LOG.isLoggable(Level.INFO)) throw throwable;
            LOG.info("Thread exit : " + Thread.currentThread().getName() + "\n\tworker state : " + (Object)((Object)this.workerstate) + "\tqueue closed : " + this.queue.isClosed() + "\tnumber in queue : " + this.queue.getCurrentInQueue() + "\tnumber queued : " + this.queue.getNumEnqueued() + "\tnumber dequeued : " + this.queue.getNumDequeued());
            throw throwable;
        }
        while (WorkerState.CLOSED != this.workerstate) {
            block61: {
                NonBlockingOutputPipe nonBlockingOutputPipe = this;
                synchronized (nonBlockingOutputPipe) {
                    block63: {
                        block62: {
                            LOG.fine("NON-BLOCKING WORKER AT STATE : " + (Object)((Object)this.workerstate) + (WorkerState.SENDMESSAGES == this.workerstate ? "\n\t" + TimeUtils.toRelativeTimeMillis(this.nextVerifyAt, TimeUtils.timeNow()) + " until verify." : ""));
                            if (WorkerState.STARTVERIFY != this.workerstate && WorkerState.STARTMIGRATE != this.workerstate) break block62;
                            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                if (null == this.destPeer) {
                                    LOG.fine("Starting re-resolve for '" + this.getPipeID());
                                } else {
                                    LOG.fine("Starting verify for '" + this.getPipeID() + "' to : " + this.destPeer);
                                }
                            }
                            this.queryID = PipeResolver.getNextQueryID();
                            this.pipeResolver.addListener(this.getPipeID(), this, this.queryID);
                            absoluteTimeoutAt = TimeUtils.toAbsoluteTimeMillis(Math.max(60000L, 60000L));
                            nextQueryAt = TimeUtils.timeNow();
                            if (WorkerState.STARTVERIFY == this.workerstate) {
                                this.workerstate = WorkerState.PENDINGVERIFY;
                                break block63;
                            } else if (WorkerState.STARTMIGRATE == this.workerstate) {
                                this.workerstate = WorkerState.PENDINGMIGRATE;
                            }
                            break block63;
                        }
                        if (WorkerState.PENDINGVERIFY == this.workerstate || WorkerState.PENDINGMIGRATE == this.workerstate) {
                            long sleep;
                            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                LOG.fine("Pipe " + (WorkerState.PENDINGVERIFY == this.workerstate ? "verify" : "migrate") + "in progress. Continues for " + TimeUtils.toRelativeTimeMillis(absoluteTimeoutAt, TimeUtils.timeNow()) + "ms. Next query in " + TimeUtils.toRelativeTimeMillis(nextQueryAt, TimeUtils.timeNow()) + "ms.");
                            }
                            if (TimeUtils.toRelativeTimeMillis(absoluteTimeoutAt, TimeUtils.timeNow()) <= 0L) {
                                this.pipeResolver.removeListener(this.getPipeID(), this.queryID);
                                if (WorkerState.PENDINGVERIFY == this.workerstate) {
                                    if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                                        LOG.info("Pipe '" + this.getPipeID() + "' has migrated from " + this.destPeer);
                                    }
                                    this.workerstate = WorkerState.STARTMIGRATE;
                                    continue;
                                }
                                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                                    LOG.warning("Pipe '" + this.getPipeID() + "' cannot be migrated and is being closed");
                                }
                                this.workerstate = WorkerState.CLOSED;
                                this.close();
                                continue;
                            }
                            if (TimeUtils.toRelativeTimeMillis(nextQueryAt, TimeUtils.timeNow()) <= 0L) {
                                if (null != this.destPeer) {
                                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                        LOG.fine("Sending out verify query (" + this.queryID + ") for '" + this.getPipeID() + "' to : " + this.destPeer);
                                    }
                                    this.pipeResolver.sendPipeQuery(this.pAdv, Collections.singleton(this.destPeer), this.queryID);
                                } else {
                                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                        LOG.fine("Sending out resolve query (" + this.queryID + ") for " + this.getPipeID());
                                    }
                                    this.pipeResolver.sendPipeQuery(this.pAdv, this.resolvablePeers, this.queryID);
                                }
                                nextQueryAt = TimeUtils.toAbsoluteTimeMillis(Math.max(15000L, 24000L));
                            }
                            if ((sleep = TimeUtils.toRelativeTimeMillis(Math.min(nextQueryAt, absoluteTimeoutAt), TimeUtils.timeNow())) >= 0L) {
                                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                    LOG.fine("Waiting " + sleep + "ms for response for (" + this.queryID + ") for " + this.getPipeID());
                                }
                                try {
                                    this.wait(sleep);
                                }
                                catch (InterruptedException woken) {
                                    Thread.interrupted();
                                }
                            }
                        } else {
                            if (WorkerState.ACQUIREMESSENGER == this.workerstate) {
                                if (null == this.destMessenger || this.destMessenger.isClosed()) {
                                    this.destMessenger = null;
                                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                        LOG.fine("Getting messenger to '" + this.destPeer + "' for pipe " + this.getPipeID());
                                    }
                                    this.destAddress = this.mkAddress(this.destPeer, this.getPipeID());
                                    this.destMessenger = this.endpoint.getMessenger(this.destAddress);
                                    if (this.destMessenger == null) {
                                        if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                                            LOG.warning("Could not get messenger to : " + this.destPeer + ". ");
                                        }
                                        if (this.migrated) {
                                            this.workerstate = WorkerState.CLOSED;
                                            this.close();
                                        } else {
                                            this.workerstate = WorkerState.STARTMIGRATE;
                                        }
                                        this.pipeResolver.removeListener((PipeID)this.getPipeID(), this.queryID);
                                        this.queryID = -1;
                                        this.destPeer = null;
                                        this.destAddress = null;
                                        continue;
                                    }
                                    this.migrated = false;
                                } else if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                    LOG.fine("Using existing messenger to : " + this.destPeer);
                                }
                                this.workerstate = WorkerState.SENDMESSAGES;
                                this.nextVerifyAt = TimeUtils.toAbsoluteTimeMillis(1200000L);
                                continue;
                            }
                            if (WorkerState.SENDMESSAGES == this.workerstate) {
                                if (TimeUtils.toRelativeTimeMillis(this.nextVerifyAt, TimeUtils.timeNow()) <= 0L) {
                                    this.workerstate = WorkerState.STARTVERIFY;
                                    this.pipeResolver.removeListener(this.getPipeID(), this.queryID);
                                    this.queryID = -1;
                                }
                            } else {
                                if (WorkerState.CLOSED == this.workerstate) {
                                    this.queue.clear();
                                    if (null != this.destMessenger) {
                                        this.destMessenger.close();
                                        this.destMessenger = null;
                                    }
                                    this.serviceThread = null;
                                    break;
                                }
                                LOG.warning("Unrecognized state in worker thread : " + (Object)((Object)this.workerstate));
                            }
                        }
                    }
                    if (WorkerState.SENDMESSAGES != this.workerstate) continue;
                }
                Message msg = null;
                try {
                    msg = (Message)this.queue.pop(10000L);
                }
                catch (InterruptedException woken) {
                    Thread.interrupted();
                    continue;
                }
                if (null == msg) {
                    NonBlockingOutputPipe woken = this;
                    synchronized (woken) {
                        if (null == this.queue.peek()) {
                            if (this.closed) {
                                this.workerstate = WorkerState.CLOSED;
                                continue;
                            }
                            this.serviceThread = null;
                            break;
                        }
                        continue;
                    }
                }
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Sending " + msg + " on " + this.getPipeID());
                }
                if (!this.destMessenger.isClosed()) {
                    try {
                        this.destMessenger.sendMessageB(msg, null, null);
                    }
                    catch (IOException failed) {
                        if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block61;
                        LOG.log(Level.WARNING, "Failure sending " + msg + " on " + this.getPipeID(), failed);
                    }
                }
            }
            if (!this.destMessenger.isClosed()) continue;
            NonBlockingOutputPipe nonBlockingOutputPipe = this;
            synchronized (nonBlockingOutputPipe) {
                this.workerstate = WorkerState.ACQUIREMESSENGER;
                this.destMessenger = null;
            }
        }
        Object var14_12 = null;
        if (!Logging.SHOW_INFO) return;
        if (!LOG.isLoggable(Level.INFO)) return;
        LOG.info("Thread exit : " + Thread.currentThread().getName() + "\n\tworker state : " + (Object)((Object)this.workerstate) + "\tqueue closed : " + this.queue.isClosed() + "\tnumber in queue : " + this.queue.getCurrentInQueue() + "\tnumber queued : " + this.queue.getNumEnqueued() + "\tnumber dequeued : " + this.queue.getNumDequeued());
    }

    private synchronized void startServiceThread() {
        if (null == this.serviceThread && !this.closed) {
            this.serviceThread = new Thread(this.peerGroup.getHomeThreadGroup(), this, "Worker Thread for NonBlockingOutputPipe : " + this.getPipeID());
            this.serviceThread.setDaemon(true);
            this.serviceThread.start();
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.info("Thread start : " + this.serviceThread.getName() + "\n\tworker state : " + (Object)((Object)this.workerstate) + "\tqueue closed : " + this.queue.isClosed() + "\tnumber in queue : " + this.queue.getCurrentInQueue() + "\tnumber queued : " + this.queue.getNumEnqueued() + "\tnumber dequeued : " + this.queue.getNumDequeued());
            }
        }
    }

    protected EndpointAddress mkAddress(ID destPeer, ID pipeID) {
        return new EndpointAddress("jxta", destPeer.getUniqueValue().toString(), "PipeService", pipeID.toString());
    }

    @Override
    public synchronized boolean pipeNAKEvent(PipeResolver.Event event) {
        if ((this.workerstate == WorkerState.PENDINGVERIFY || this.workerstate == WorkerState.ACQUIREMESSENGER || this.workerstate == WorkerState.SENDMESSAGES) && event.getPeerID().equals(this.destPeer) && event.getQueryID() == this.queryID) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Pipe '" + this.getPipeID() + "' is closed at " + event.getPeerID());
            }
            this.workerstate = WorkerState.STARTMIGRATE;
            this.pipeResolver.removeListener(this.getPipeID(), this.queryID);
            this.queryID = -1;
            this.destPeer = null;
            this.destAddress = null;
            if (null != this.destMessenger) {
                this.destMessenger.close();
                this.destMessenger = null;
            }
            this.notify();
            return true;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Ignoring NAK from " + event.getPeerID());
        }
        return false;
    }

    @Override
    public synchronized boolean pipeResolveEvent(PipeResolver.Event event) {
        if ((this.workerstate == WorkerState.PENDINGVERIFY || this.workerstate == WorkerState.PENDINGMIGRATE) && event.getQueryID() == this.queryID) {
            if (this.workerstate == WorkerState.PENDINGVERIFY && !event.getPeerID().equals(this.destPeer)) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Ignoring response from " + event.getPeerID());
                }
                return false;
            }
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.info("Pipe '" + this.getPipeID() + "' is verified for " + this.destPeer);
            }
            this.workerstate = WorkerState.ACQUIREMESSENGER;
            this.migrated = true;
            this.destPeer = event.getPeerID();
            if (this.workerstate == WorkerState.PENDINGMIGRATE && Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.info("Pipe '" + this.getPipeID() + "' has migrated to " + this.destPeer);
            }
            this.notify();
            return true;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Ignoring resolve from " + event.getPeerID());
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum WorkerState {
        STARTMIGRATE,
        PENDINGMIGRATE,
        STARTVERIFY,
        PENDINGVERIFY,
        ACQUIREMESSENGER,
        SENDMESSAGES,
        CLOSED;

    }
}

