/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.pipe;

import java.io.IOException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.id.ID;
import net.jxta.impl.pipe.NonBlockingOutputPipe;
import net.jxta.impl.pipe.PipeResolver;
import net.jxta.logging.Logging;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.PipeAdvertisement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecureOutputPipe
extends NonBlockingOutputPipe {
    private static final Logger LOG = Logger.getLogger(SecureOutputPipe.class.getName());

    public SecureOutputPipe(PeerGroup group, PipeResolver resolver, PipeAdvertisement pipeAdv, ID destPeer, Set<? extends ID> peers) throws IOException {
        super(group, resolver, pipeAdv, destPeer, peers);
    }

    @Override
    public synchronized boolean send(Message msg) throws IOException {
        boolean sent = false;
        int attempts = 1;
        while (!sent && !this.isClosed()) {
            try {
                sent = super.send(msg);
                if (sent) continue;
                this.wait(10 + (1 << Math.min(attempts, 14)));
                ++attempts;
            }
            catch (InterruptedException woken) {
                Thread.interrupted();
            }
        }
        if (!sent && this.isClosed()) {
            IOException failed = new IOException("Could not enqueue " + msg + " for sending. Pipe is closed.");
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, failed.getMessage(), failed);
            }
            throw failed;
        }
        return sent;
    }

    @Override
    protected EndpointAddress mkAddress(ID destPeer, ID pipeID) {
        return new EndpointAddress("jxtatls", destPeer.getUniqueValue().toString(), "PipeService", pipeID.toString());
    }
}

