/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.pipe;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.logging.Logging;

public class WireHeader {
    private static final Logger LOG = Logger.getLogger(WireHeader.class.getName());
    private static final String Name = "JxtaWire";
    private static final String MsgIdTag = "MsgId";
    private static final String PipeIdTag = "PipeId";
    private static final String SrcTag = "SrcPeer";
    private static final String TTLTag = "TTL";
    private static final String PeerTag = "VisitedPeer";
    private ID srcPeer = ID.nullID;
    private ID pipeID = ID.nullID;
    private String msgId = null;
    private int TTL = Integer.MIN_VALUE;

    public WireHeader() {
    }

    public WireHeader(Element root) {
        this.initialize(root);
    }

    public void setSrcPeer(ID p) {
        this.srcPeer = p;
    }

    public ID getSrcPeer() {
        return this.srcPeer;
    }

    public void setTTL(int t) {
        this.TTL = t;
    }

    public int getTTL() {
        return this.TTL;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public void setMsgId(String id) {
        this.msgId = id;
    }

    public ID getPipeID() {
        return this.pipeID;
    }

    public void setPipeID(ID id) {
        this.pipeID = id;
    }

    protected boolean handleElement(XMLElement elem) {
        if (elem.getName().equals(SrcTag)) {
            try {
                URI pID = new URI(elem.getTextValue());
                this.setSrcPeer(IDFactory.fromURI(pID));
            }
            catch (URISyntaxException badID) {
                throw new IllegalArgumentException("Bad PeerID ID in header: " + elem.getTextValue());
            }
            return true;
        }
        if (elem.getName().equals(MsgIdTag)) {
            this.msgId = elem.getTextValue();
            return true;
        }
        if (elem.getName().equals(PipeIdTag)) {
            try {
                URI pipeID = new URI(elem.getTextValue());
                this.setPipeID(IDFactory.fromURI(pipeID));
            }
            catch (URISyntaxException badID) {
                throw new IllegalArgumentException("Bad pipe ID in header");
            }
            return true;
        }
        if (elem.getName().equals(TTLTag)) {
            this.TTL = Integer.parseInt(elem.getTextValue());
            return true;
        }
        return elem.getName().equals(PeerTag);
    }

    protected void initialize(Element root) {
        if (!XMLElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
        }
        XMLElement doc = (XMLElement)root;
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(Name) && !Name.equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("Unhandled Element: " + elem.getName());
        }
        if (null == this.getMsgId()) {
            throw new IllegalArgumentException("Header does not contain a message id");
        }
        if (ID.nullID == this.getPipeID()) {
            throw new IllegalArgumentException("Header does not contain a pipe id");
        }
        if (this.TTL < 1) {
            throw new IllegalArgumentException("TTL must be >= 1");
        }
    }

    public Document getDocument(MimeMediaType encodeAs) {
        Object e;
        StructuredTextDocument doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(encodeAs, Name);
        if (doc instanceof XMLDocument) {
            ((XMLDocument)doc).addAttribute("xmlns:jxta", "http://jxta.org");
        }
        if (null == this.getMsgId()) {
            throw new IllegalStateException("Message id is not initialized");
        }
        if (ID.nullID == this.getPipeID()) {
            throw new IllegalStateException("PipeID is not initialized");
        }
        if (this.TTL < 1) {
            throw new IllegalStateException("TTL must be >= 1");
        }
        if (this.srcPeer != null && this.srcPeer != ID.nullID) {
            e = doc.createElement(SrcTag, this.srcPeer.toString());
            doc.appendChild(e);
        }
        e = doc.createElement(PipeIdTag, this.getPipeID().toString());
        doc.appendChild(e);
        e = doc.createElement(MsgIdTag, this.getMsgId());
        doc.appendChild(e);
        e = doc.createElement(TTLTag, Integer.toString(this.TTL));
        doc.appendChild(e);
        return doc;
    }
}

