/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.ExtendableAdvertisement;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.XMLElement;
import net.jxta.id.ID;
import net.jxta.logging.Logging;

public final class DiscoveryConfigAdv
extends ExtendableAdvertisement {
    private static final Logger LOG = Logger.getLogger(DiscoveryConfigAdv.class.getName());
    private static final String advType = "jxta:DiscoConfigAdv";
    private static final String FORWARD_ALWAYS_REPLICA = "forwardAlwaysReplica";
    private static final String FORWARD_BELOW_TRESHOLD = "forwardBelowThreshold";
    private static final String LOCAL_ONLY = "localOnly";
    private static final String[] fields = new String[0];
    private boolean forwardAlwaysReplica = false;
    private boolean forwardBelowTreshold = false;
    private boolean localOnly = false;

    public static String getAdvertisementType() {
        return advType;
    }

    private DiscoveryConfigAdv() {
    }

    private DiscoveryConfigAdv(XMLElement doc) {
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(DiscoveryConfigAdv.getAdvertisementType()) && !DiscoveryConfigAdv.getAdvertisementType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration<Attribute> eachAttr = doc.getAttributes();
        while (eachAttr.hasMoreElements()) {
            Attribute aDiscoAttr = eachAttr.nextElement();
            String name = aDiscoAttr.getName();
            boolean flag = Boolean.valueOf(aDiscoAttr.getValue().trim());
            if (FORWARD_ALWAYS_REPLICA.equals(name)) {
                this.forwardAlwaysReplica = flag;
                continue;
            }
            if (FORWARD_BELOW_TRESHOLD.equals(name)) {
                this.forwardBelowTreshold = flag;
                continue;
            }
            if (LOCAL_ONLY.equals(name)) {
                this.localOnly = flag;
                continue;
            }
            if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
            LOG.warning("Unhandled Attribute: " + name);
        }
    }

    public DiscoveryConfigAdv clone() throws CloneNotSupportedException {
        DiscoveryConfigAdv result;
        try {
            result = (DiscoveryConfigAdv)super.clone();
        }
        catch (CloneNotSupportedException impossible) {
            throw new Error("Object.clone() threw CloneNotSupportedException", impossible);
        }
        result.setForwardAlwaysReplica(this.getForwardAlwaysReplica());
        result.setForwardBelowTreshold(this.getForwardBelowTreshold());
        result.setLocalOnly(this.getLocalOnly());
        return result;
    }

    public String getAdvType() {
        return DiscoveryConfigAdv.getAdvertisementType();
    }

    public final String getBaseAdvType() {
        return DiscoveryConfigAdv.getAdvertisementType();
    }

    public ID getID() {
        return ID.nullID;
    }

    public Document getDocument(MimeMediaType encodeAs) {
        StructuredDocument adv = (StructuredDocument)super.getDocument(encodeAs);
        if (adv instanceof Attributable) {
            Attributable attrDoc = (Attributable)((Object)adv);
            if (this.forwardAlwaysReplica) {
                attrDoc.addAttribute(FORWARD_ALWAYS_REPLICA, Boolean.toString(this.forwardAlwaysReplica));
            }
            if (this.forwardBelowTreshold) {
                attrDoc.addAttribute(FORWARD_BELOW_TRESHOLD, Boolean.toString(this.forwardBelowTreshold));
            }
            if (this.localOnly) {
                attrDoc.addAttribute(FORWARD_BELOW_TRESHOLD, Boolean.toString(this.localOnly));
            }
        }
        return adv;
    }

    public String[] getIndexFields() {
        return fields;
    }

    public boolean getForwardAlwaysReplica() {
        return this.forwardAlwaysReplica;
    }

    public void setForwardAlwaysReplica(boolean newvalue) {
        this.forwardAlwaysReplica = newvalue;
    }

    public boolean getForwardBelowTreshold() {
        return this.forwardBelowTreshold;
    }

    public void setForwardBelowTreshold(boolean newvalue) {
        this.forwardBelowTreshold = newvalue;
    }

    public boolean getLocalOnly() {
        return this.localOnly;
    }

    public void setLocalOnly(boolean newvalue) {
        this.localOnly = newvalue;
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return DiscoveryConfigAdv.advType;
        }

        public Advertisement newInstance() {
            return new DiscoveryConfigAdv();
        }

        public Advertisement newInstance(Element root) {
            if (!XMLElement.class.isInstance(root)) {
                throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
            }
            return new DiscoveryConfigAdv((XMLElement)root);
        }
    }
}

