/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.id.IDFactory;
import net.jxta.logging.Logging;
import net.jxta.peer.PeerID;
import net.jxta.protocol.SrdiMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SrdiMessageImpl
extends SrdiMessage {
    private static final Logger LOG = Logger.getLogger(SrdiMessageImpl.class.getName());
    public static final String pidTag = "PID";
    public static final String scopeTag = "ttl";
    public static final String entryTag = "Entry";
    public static final String pKeyTag = "PKey";
    public static final String sKeyTag = "SKey";
    public static final String valTag = "Value";
    public static final String expirationTag = "Expiration";

    public SrdiMessageImpl() {
        this.setScope(0);
    }

    @Deprecated
    public SrdiMessageImpl(InputStream stream) throws IOException {
        XMLDocument doc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, stream);
        this.readIt(doc);
    }

    public SrdiMessageImpl(Element root) {
        if (!XMLElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
        }
        XMLElement doc = (XMLElement)root;
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(SrdiMessageImpl.getMessageType()) && !SrdiMessageImpl.getMessageType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        this.readIt(doc);
    }

    public SrdiMessageImpl(PeerID peerid, int scope, String pKey, List<SrdiMessage.Entry> entries) {
        this.setPeerID(peerid);
        this.setScope(scope);
        this.setPrimaryKey(pKey);
        this.setEntries(entries);
    }

    public SrdiMessageImpl(PeerID peerid, int scope, String pKey, String key, String value, long expiration) {
        this.setPeerID(peerid);
        this.setScope(scope);
        this.setPrimaryKey(pKey);
        this.addEntry(key, value, expiration);
    }

    public SrdiMessageImpl(String peerid, int scope, String pKey, List<SrdiMessage.Entry> entries) {
        PeerID pid;
        try {
            pid = (PeerID)IDFactory.fromURI(new URI(peerid));
        }
        catch (URISyntaxException badID) {
            throw new IllegalArgumentException("Invalid PeerID ID in message");
        }
        this.setPeerID(pid);
        this.setScope(scope);
        this.setPrimaryKey(pKey);
        this.setEntries(entries);
    }

    public void readIt(XMLElement doc) {
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (elem.getName().equals(pidTag)) {
                try {
                    URI pID = new URI(elem.getTextValue());
                    this.setPeerID((PeerID)IDFactory.fromURI(pID));
                    continue;
                }
                catch (URISyntaxException badID) {
                    throw new IllegalArgumentException("Invalid PeerID ID in message");
                }
            }
            if (elem.getName().equals(pKeyTag)) {
                this.setPrimaryKey(elem.getTextValue());
            }
            if (elem.getName().equals(scopeTag)) {
                this.setScope(Integer.parseInt(elem.getTextValue()));
            }
            if (!elem.getName().equals(entryTag)) continue;
            Attribute keyEl = elem.getAttribute(sKeyTag);
            String key = keyEl == null ? "NA" : keyEl.getValue();
            String value = elem.getTextValue();
            if (null != value) {
                long expiration;
                Attribute expAttr = elem.getAttribute(expirationTag);
                if (expAttr != null) {
                    String expstr = expAttr.getValue();
                    expiration = Long.parseLong(expstr);
                } else {
                    expiration = -1L;
                }
                SrdiMessage.Entry entry = new SrdiMessage.Entry(key, value, expiration);
                this.addEntry(entry);
                continue;
            }
            if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("SrdiMessage Entry with a Null value");
        }
    }

    @Override
    public Document getDocument(MimeMediaType encodeAs) {
        Object e;
        StructuredTextDocument adv = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(encodeAs, SrdiMessageImpl.getMessageType());
        if (adv instanceof Attributable) {
            ((Attributable)((Object)adv)).addAttribute("xmlns:jxta", "http://jxta.org");
        }
        Iterator<SrdiMessage.Entry> eachEntry = this.getEntries().iterator();
        PeerID peerid = this.getPeerID();
        if (peerid != null) {
            e = adv.createElement(pidTag, peerid.toString());
            adv.appendChild(e);
        }
        if (this.getPrimaryKey() != null) {
            e = adv.createElement(pKeyTag, this.getPrimaryKey());
            adv.appendChild(e);
        }
        if (this.getScope() > 0) {
            e = adv.createElement(scopeTag, Integer.toString(this.getScope()));
            adv.appendChild(e);
        }
        while (eachEntry.hasNext()) {
            SrdiMessage.Entry entry = eachEntry.next();
            if (entry.key == null && entry.value == null) continue;
            e = adv.createElement(entryTag, entry.value);
            adv.appendChild(e);
            ((Attributable)e).addAttribute(expirationTag, Long.toString(entry.expiration));
            ((Attributable)e).addAttribute(sKeyTag, entry.key);
        }
        return adv;
    }

    public String toString() {
        StructuredTextDocument doc = (StructuredTextDocument)this.getDocument(MimeMediaType.XMLUTF8);
        return doc.toString();
    }
}

