/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.XMLElement;
import net.jxta.logging.Logging;
import net.jxta.protocol.TransportAdvertisement;

public class TCPAdv
extends TransportAdvertisement {
    private static final Logger LOG = Logger.getLogger(TCPAdv.class.getName());
    private static final String[] CONFIGMODES = new String[]{"auto", "manual"};
    private static final String[] INDEXFIELDS = new String[0];
    private static final String PORT_ELEMENT = "Port";
    private static final String MCAST_THREAD_POOL = "Mcast_Pool_Size";
    private static final String ClientOffTag = "ClientOff";
    private static final String ServerOffTag = "ServerOff";
    private static final String MULTICAST_OFF_TAG = "MulticastOff";
    private static final String MULTICAST_INTERFACE_TAG = "MulticastInterface";
    private static final String MULTICAST_ADDRESS_TAG = "MulticastAddr";
    private static final String MULTICAST_PORT_TAG = "MulticastPort";
    private static final String FlagsTag = "Flags";
    private static final String PublicAddressOnlyAttr = "PublicAddressOnly";
    private String configMode = CONFIGMODES[0];
    private String interfaceAddress = null;
    private String mcastInterface = null;
    private int startPort = -1;
    private int listenPort = -1;
    private int endPort = -1;
    private String publicAddress = null;
    private String multicastaddr = null;
    private int multicastport = -1;
    private int poolSize = 5;
    private int multicastsize = -1;
    private boolean clientEnabled = true;
    private boolean serverEnabled = true;
    private boolean multicastEnabled = true;
    private boolean publicAddressOnly = false;

    public static String getAdvertisementType() {
        return "jxta:TCPTransportAdvertisement";
    }

    private TCPAdv() {
        this.setProtocol("tcp");
    }

    private TCPAdv(XMLElement doc) {
        this();
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(TCPAdv.getAdvertisementType()) && !TCPAdv.getAdvertisementType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Attribute attr = doc.getAttribute(FlagsTag);
        if (attr != null) {
            String options = attr.getValue();
            this.publicAddressOnly = options.indexOf(PublicAddressOnlyAttr) != -1;
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
            LOG.warning("Unhandled Element: " + elem);
        }
        if (!Arrays.asList(CONFIGMODES).contains(this.configMode)) {
            throw new IllegalArgumentException("Unsupported configuration mode.");
        }
        if (this.listenPort < -1 || this.listenPort > 65535) {
            throw new IllegalArgumentException("Illegal Listen Port Value");
        }
        if (this.startPort < -1 || this.startPort > 65535) {
            throw new IllegalArgumentException("Illegal Start Port Value");
        }
        if (this.endPort < -1 || this.endPort > 65535) {
            throw new IllegalArgumentException("Illegal End Port Value");
        }
        if (0 == this.startPort && this.endPort != 0 || 0 != this.startPort && this.endPort == 0) {
            throw new IllegalArgumentException("Port ranges must both be 0 or non-0");
        }
        if (-1 == this.startPort && this.endPort != -1 || -1 != this.startPort && this.endPort == -1) {
            throw new IllegalArgumentException("Port ranges must both be -1 or not -1");
        }
        if (null != this.publicAddress && (-1 != this.startPort || this.listenPort <= 0)) {
            throw new IllegalArgumentException("Dynamic ports not supported with public address port forwarding.");
        }
        if (this.getMulticastState() && null == this.getMulticastAddr()) {
            throw new IllegalArgumentException("Multicast enabled and no address specified.");
        }
        if (this.getMulticastState() && -1 == this.getMulticastPort()) {
            throw new IllegalArgumentException("Multicast enabled and no port specified.");
        }
        if (this.getMulticastState() && (this.getMulticastPort() <= 0 || this.getMulticastPort() > 65536)) {
            throw new IllegalArgumentException("Illegal Multicast Port Value");
        }
        if (this.getMulticastState() && -1 == this.getMulticastSize()) {
            throw new IllegalArgumentException("Multicast enabled and no size specified.");
        }
        if (this.getMulticastState() && (this.getMulticastSize() <= 0 || (long)this.getMulticastSize() > 1048575L)) {
            throw new IllegalArgumentException("Illegal Multicast datagram size");
        }
        if (null == this.getProtocol()) {
            this.setProtocol("tcp");
        }
    }

    public String getAdvType() {
        return TCPAdv.getAdvertisementType();
    }

    public String getInterfaceAddress() {
        return this.interfaceAddress;
    }

    public void setInterfaceAddress(String interfaceAddress) {
        if (null != interfaceAddress && 0 == (interfaceAddress = interfaceAddress.trim()).length()) {
            interfaceAddress = null;
        }
        this.interfaceAddress = interfaceAddress;
    }

    public int getPort() {
        return this.listenPort;
    }

    public void setPort(int port) {
        this.listenPort = port;
    }

    public int getStartPort() {
        return this.startPort;
    }

    public void setStartPort(int startPort) {
        this.startPort = startPort;
    }

    public int getEndPort() {
        return this.endPort;
    }

    public void setEndPort(int endPort) {
        this.endPort = endPort;
    }

    public boolean getMulticastState() {
        return this.multicastEnabled;
    }

    public void setMulticastState(boolean multicastState) {
        this.multicastEnabled = multicastState;
    }

    public String getMulticastAddr() {
        return this.multicastaddr;
    }

    public void setMulticastAddr(String multicastaddr) {
        if (null != multicastaddr && 0 == (multicastaddr = multicastaddr.trim()).length()) {
            multicastaddr = null;
        }
        this.multicastaddr = multicastaddr;
    }

    public void setMulticastInterface(String multicastInterface) {
        if (null != multicastInterface && 0 == (multicastInterface = multicastInterface.trim()).length()) {
            this.mcastInterface = null;
        }
        this.mcastInterface = multicastInterface;
    }

    public String getMulticastInterface() {
        return this.mcastInterface;
    }

    public int getMulticastPort() {
        return this.multicastport;
    }

    public int getMulticastPoolSize() {
        return this.poolSize;
    }

    public void setMulticastPoolSize(int size) {
        this.poolSize = size;
    }

    public void setMulticastPort(int multicastport) {
        this.multicastport = multicastport;
    }

    public int getMulticastSize() {
        return this.multicastsize;
    }

    public void setMulticastSize(int multicastsize) {
        this.multicastsize = multicastsize;
    }

    public String getServer() {
        return this.publicAddress;
    }

    public void setServer(String address) {
        if (null != address && 0 == (address = address.trim()).length()) {
            address = null;
        }
        this.publicAddress = address;
    }

    public boolean isClientEnabled() {
        return this.clientEnabled;
    }

    public void setClientEnabled(boolean enabled) {
        this.clientEnabled = enabled;
    }

    public boolean isServerEnabled() {
        return this.serverEnabled;
    }

    public void setServerEnabled(boolean enabled) {
        this.serverEnabled = enabled;
    }

    public String getConfigMode() {
        return this.configMode;
    }

    public void setConfigMode(String mode) {
        if (!Arrays.asList(CONFIGMODES).contains(mode)) {
            throw new IllegalArgumentException("Unsupported configuration mode.");
        }
        this.configMode = mode;
    }

    public boolean getPublicAddressOnly() {
        return this.publicAddressOnly;
    }

    public void setPublicAddressOnly(boolean only) {
        this.publicAddressOnly = only;
    }

    protected boolean handleElement(Element raw) {
        if (super.handleElement(raw)) {
            return true;
        }
        XMLElement elem = (XMLElement)raw;
        if (elem.getName().equals(MULTICAST_OFF_TAG)) {
            this.setMulticastState(false);
            return true;
        }
        if (elem.getName().equals(ClientOffTag)) {
            this.setClientEnabled(false);
            return true;
        }
        if (elem.getName().equals(ServerOffTag)) {
            this.setServerEnabled(false);
            return true;
        }
        String value = elem.getTextValue();
        if (null == value || 0 == value.trim().length()) {
            return false;
        }
        value = value.trim();
        if (elem.getName().equals("Protocol")) {
            this.setProtocol(value);
            return true;
        }
        if (PORT_ELEMENT.equals(elem.getName())) {
            try {
                this.setPort(Integer.parseInt(value));
                Attribute startAttr = elem.getAttribute("start");
                Attribute endAttr = elem.getAttribute("end");
                if (null != startAttr && null != endAttr) {
                    this.setStartPort(Integer.parseInt(startAttr.getValue().trim()));
                    this.setEndPort(Integer.parseInt(endAttr.getValue().trim()));
                }
            }
            catch (NumberFormatException badPort) {
                throw new IllegalArgumentException("Illegal port value : " + value);
            }
            return true;
        }
        if (elem.getName().equals(MULTICAST_ADDRESS_TAG)) {
            this.setMulticastAddr(value);
            return true;
        }
        if (elem.getName().equals(MULTICAST_INTERFACE_TAG)) {
            this.setMulticastInterface(value);
            return true;
        }
        if (elem.getName().equals(MULTICAST_PORT_TAG)) {
            try {
                this.setMulticastPort(Integer.parseInt(value));
            }
            catch (NumberFormatException badPort) {
                throw new IllegalArgumentException("Illegal multicast port value : " + value);
            }
            return true;
        }
        if (elem.getName().equals(MCAST_THREAD_POOL)) {
            try {
                this.setMulticastPoolSize(Integer.parseInt(value));
            }
            catch (NumberFormatException badPort) {
                throw new IllegalArgumentException("Illegal multicast port value : " + value);
            }
            return true;
        }
        if (elem.getName().equals("MulticastSize")) {
            try {
                int theMulticastSize = Integer.parseInt(value);
                this.setMulticastSize(theMulticastSize);
            }
            catch (NumberFormatException badPort) {
                throw new IllegalArgumentException("Illegal multicast datagram size : " + value);
            }
            return true;
        }
        if (elem.getName().equals("Server")) {
            this.setServer(value);
            return true;
        }
        if (elem.getName().equals("InterfaceAddress")) {
            this.setInterfaceAddress(value);
            return true;
        }
        if (elem.getName().equals("ConfigMode")) {
            this.setConfigMode(value);
            return true;
        }
        return false;
    }

    public Document getDocument(MimeMediaType encodeAs) {
        String serverAddr;
        String interfaceAddr;
        StructuredDocument adv = (StructuredDocument)super.getDocument(encodeAs);
        if (!(adv instanceof Attributable)) {
            throw new IllegalStateException("Only Attributable document types allowed.");
        }
        if (null == this.getProtocol()) {
            this.setProtocol("tcp");
        }
        if (this.listenPort < -1 || this.listenPort > 65535) {
            throw new IllegalStateException("Illegal Listen Port Value");
        }
        if (this.startPort < -1 || this.startPort > 65535) {
            throw new IllegalStateException("Illegal Start Port Value");
        }
        if (this.endPort < -1 || this.endPort > 65535) {
            throw new IllegalStateException("Illegal End Port Value");
        }
        if (0 == this.startPort && this.endPort != 0 || 0 != this.startPort && this.endPort == 0) {
            throw new IllegalStateException("Port ranges must both be 0 or non-0");
        }
        if (-1 == this.startPort && this.endPort != -1 || -1 != this.startPort && this.endPort == -1) {
            throw new IllegalStateException("Port ranges must both be -1 or not -1");
        }
        if (null != this.publicAddress && (-1 != this.startPort || this.listenPort <= 0)) {
            throw new IllegalStateException("Dynamic ports not supported with public address port forwarding.");
        }
        if (this.getMulticastState() && null == this.getMulticastAddr()) {
            throw new IllegalStateException("Multicast enabled and no address specified.");
        }
        if (this.getMulticastState() && -1 == this.getMulticastPort()) {
            throw new IllegalStateException("Multicast enabled and no port specified.");
        }
        if (this.getMulticastState() && (this.getMulticastPort() <= 0 || this.getMulticastPort() > 65536)) {
            throw new IllegalStateException("Illegal Multicast Port Value");
        }
        if (this.getMulticastState() && -1 == this.getMulticastSize()) {
            throw new IllegalStateException("Multicast enabled and no size specified.");
        }
        if (this.getMulticastState() && (this.getMulticastSize() <= 0 || (long)this.getMulticastSize() > 1048575L)) {
            throw new IllegalStateException("Illegal Multicast datagram size");
        }
        if (adv instanceof Attributable && this.publicAddressOnly) {
            ((Attributable)((Object)adv)).addAttribute(FlagsTag, PublicAddressOnlyAttr);
        }
        Object proto = adv.createElement("Protocol", this.getProtocol());
        adv.appendChild(proto);
        if (!this.isClientEnabled()) {
            Object clientEnabled = adv.createElement(ClientOffTag);
            adv.appendChild(clientEnabled);
        }
        if (!this.isServerEnabled()) {
            Object serverOff = adv.createElement(ServerOffTag);
            adv.appendChild(serverOff);
        }
        if (this.getConfigMode() != null) {
            Object configMode = adv.createElement("ConfigMode", this.getConfigMode());
            adv.appendChild(configMode);
        }
        if (null != (interfaceAddr = this.getInterfaceAddress())) {
            Object interfaceAddrr = adv.createElement("InterfaceAddress", interfaceAddr);
            adv.appendChild(interfaceAddrr);
        }
        Object portEl = adv.createElement(PORT_ELEMENT, Integer.toString(this.listenPort));
        adv.appendChild(portEl);
        if (adv instanceof Attributable) {
            Attributable attrElem = (Attributable)portEl;
            if (-1 != this.startPort && -1 != this.endPort) {
                attrElem.addAttribute("start", Integer.toString(this.startPort));
                attrElem.addAttribute("end", Integer.toString(this.endPort));
            }
        }
        if (null != (serverAddr = this.getServer())) {
            Object server = adv.createElement("Server", serverAddr);
            adv.appendChild(server);
        }
        if (!this.getMulticastState()) {
            Object mOff = adv.createElement(MULTICAST_OFF_TAG);
            adv.appendChild(mOff);
        }
        if (null != this.getMulticastAddr()) {
            Object mAddrr = adv.createElement(MULTICAST_ADDRESS_TAG, this.getMulticastAddr());
            adv.appendChild(mAddrr);
        }
        if (null != this.getMulticastInterface()) {
            Object mInterace = adv.createElement(MULTICAST_INTERFACE_TAG, this.getMulticastInterface());
            adv.appendChild(mInterace);
        }
        if (-1 != this.getMulticastPort()) {
            Object mPort = adv.createElement(MULTICAST_PORT_TAG, Integer.toString(this.getMulticastPort()));
            adv.appendChild(mPort);
        }
        if (-1 != this.getMulticastPoolSize()) {
            Object poolEl = adv.createElement(MCAST_THREAD_POOL, Integer.toString(this.getMulticastPoolSize()));
            adv.appendChild(poolEl);
        }
        if (-1 != this.getMulticastSize()) {
            Object mSize = adv.createElement("MulticastSize", Integer.toString(this.getMulticastSize()));
            adv.appendChild(mSize);
        }
        return adv;
    }

    public String[] getIndexFields() {
        return INDEXFIELDS;
    }

    public boolean getServerEnabled() {
        return this.serverEnabled;
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return TCPAdv.getAdvertisementType();
        }

        public Advertisement newInstance() {
            return new TCPAdv();
        }

        public Advertisement newInstance(Element root) {
            if (!XMLElement.class.isInstance(root)) {
                throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
            }
            return new TCPAdv((XMLElement)root);
        }
    }
}

