/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous.limited;

import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.impl.protocol.LimitedRangeRdvMsg;
import net.jxta.impl.rendezvous.RdvWalk;
import net.jxta.impl.rendezvous.limited.LimitedRangeGreeter;
import net.jxta.impl.rendezvous.limited.LimitedRangeWalker;
import net.jxta.impl.rendezvous.rpv.PeerView;
import net.jxta.peergroup.PeerGroup;

public class LimitedRangeWalk
extends RdvWalk {
    public static final String SERVICENAME = "LR-Greeter";
    public static final String ELEMENTNAME = "LimitedRangeRdvMessage";
    private final PeerView rpv;
    private final String walkSvcName;
    private final String walkSvcParam;
    private LimitedRangeWalker walker = null;
    private LimitedRangeGreeter greeter = null;

    static LimitedRangeRdvMsg getRdvMessage(Message msg) {
        MessageElement el = msg.getMessageElement("jxta", ELEMENTNAME);
        if (el == null) {
            return null;
        }
        try {
            XMLDocument asDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(el);
            return new LimitedRangeRdvMsg(asDoc);
        }
        catch (Exception ez) {
            return null;
        }
    }

    public LimitedRangeWalk(PeerGroup group, EndpointListener listener, String srcServiceName, String srcServiceParam, PeerView rpv) {
        super(group, listener, srcServiceName, srcServiceParam);
        this.rpv = rpv;
        this.walkSvcName = SERVICENAME + group.getPeerGroupID().toString();
        this.walkSvcParam = srcServiceName + srcServiceParam;
        this.walker = new LimitedRangeWalker(this);
        this.greeter = new LimitedRangeGreeter(this);
    }

    PeerView getPeerView() {
        return this.rpv;
    }

    String getWalkServiceName() {
        return this.walkSvcName;
    }

    String getWalkServiceParam() {
        return this.walkSvcParam;
    }

    public LimitedRangeWalker getWalker() {
        return this.walker;
    }

    public LimitedRangeGreeter getGreeter() {
        return this.greeter;
    }

    public synchronized void stop() {
        if (this.walker != null) {
            this.walker.stop();
            this.walker = null;
        }
        if (this.greeter != null) {
            this.greeter.stop();
            this.greeter = null;
        }
    }
}

