/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous.rpv;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.endpoint.EndpointUtils;
import net.jxta.impl.endpoint.relay.RelayReferralSeedingManager;
import net.jxta.impl.protocol.RdvConfigAdv;
import net.jxta.impl.rendezvous.RendezVousServiceImpl;
import net.jxta.impl.rendezvous.rpv.PeerViewDestination;
import net.jxta.impl.rendezvous.rpv.PeerViewElement;
import net.jxta.impl.rendezvous.rpv.PeerViewEvent;
import net.jxta.impl.rendezvous.rpv.PeerViewListener;
import net.jxta.impl.rendezvous.rpv.PeerViewRandomStrategy;
import net.jxta.impl.rendezvous.rpv.PeerViewRandomWithReplaceStrategy;
import net.jxta.impl.rendezvous.rpv.PeerViewSequentialStrategy;
import net.jxta.impl.rendezvous.rpv.PeerViewStrategy;
import net.jxta.impl.util.SeedingManager;
import net.jxta.impl.util.TimeUtils;
import net.jxta.impl.util.URISeedingManager;
import net.jxta.logging.Logging;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.PipeID;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.protocol.RdvAdvertisement;
import net.jxta.protocol.RouteAdvertisement;
import net.jxta.rendezvous.RendezvousEvent;
import net.jxta.rendezvous.RendezvousListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PeerView
implements EndpointListener,
RendezvousListener {
    private static final transient Logger LOG = Logger.getLogger(PeerView.class.getName());
    static final String SERVICE_NAME = "PeerView";
    static final String MESSAGE_NAMESPACE = "jxta";
    static final String MESSAGE_ELEMENT_NAME = "PeerView.PeerAdv";
    static final String RESPONSE_ELEMENT_NAME = "PeerView.PeerAdv.Response";
    static final String CACHED_RADV_ELEMENT_NAME = "PeerView.Cached";
    static final MessageElement CACHED_RADV_ELEMENT = new StringMessageElement("PeerView.Cached", Boolean.TRUE.toString(), null);
    static final String SRCROUTEADV_ELEMENT_NAME = "PeerView.SrcRouteAdv";
    static final String EDGE_ELEMENT_NAME = "PeerView.EdgePeer";
    static final MessageElement EDGE_ELEMENT = new StringMessageElement("PeerView.EdgePeer", Boolean.TRUE.toString(), null);
    static final String FAILURE_ELEMENT_NAME = "PeerView.Failure";
    static final MessageElement FAILURE_ELEMENT = new StringMessageElement("PeerView.Failure", Boolean.TRUE.toString(), null);
    private static final long DEFAULT_SEEDING_PERIOD = 5000L;
    private static final long WATCHDOG_PERIOD = 30000L;
    private static final long WATCHDOG_GRACE_DELAY = 300000L;
    private static final long DEFAULT_BOOTSTRAP_KICK_INTERVAL = 3000L;
    private static final int MIN_BOOTLEVEL = 0;
    private static final int BOOTLEVEL_INCREMENT = 1;
    private static final int MAX_BOOTLEVEL = 6;
    private final PeerGroup group;
    private final PeerGroup advertisingGroup;
    private final RendezVousServiceImpl rdvService;
    private final EndpointService endpoint;
    private final String name;
    private long seedingRdvConnDelay = 0L;
    private final boolean useOnlySeeds;
    private final SeedingManager seedingManager;
    private int minHappyPeerView = 4;
    private final Timer timer;
    private static final Random random = new Random();
    private final Set<TimerTask> scheduledTasks = Collections.synchronizedSet(new HashSet());
    private int bootLevel = 0;
    private long earliestReseed = 0L;
    private final String uniqueGroupId;
    private final Set<PeerViewListener> rpvListeners = Collections.synchronizedSet(new HashSet());
    private InputPipe wirePipeInputPipe = null;
    private OutputPipe wirePipeOutputPipe = null;
    private InputPipe localGroupWirePipeInputPipe = null;
    private OutputPipe localGroupWirePipeOutputPipe = null;
    private WatchdogTask watchdogTask = null;
    private final SortedSet<PeerViewDestination> localView = Collections.synchronizedSortedSet(new TreeSet());
    private final PeerViewElement self;
    private PeerViewElement upPeer = null;
    private PeerViewElement downPeer = null;
    private final PeerViewStrategy replyStrategy;
    private final PeerViewStrategy kickRecipientStrategy;
    private final PeerViewStrategy kickAdvertisementStrategy;
    private final PeerViewStrategy refreshRecipientStrategy;
    private PeerAdvertisement lastPeerAdv = null;
    private int lastModCount = -1;
    private final PipeAdvertisement localGroupWirePipeAdv;
    private final PipeAdvertisement advGroupPropPipeAdv;
    private volatile boolean closed = false;

    public PeerView(PeerGroup group, PeerGroup advertisingGroup, RendezVousServiceImpl rdvService, String name) {
        RdvConfigAdv rdvConfigAdv;
        this.group = group;
        this.advertisingGroup = advertisingGroup;
        this.rdvService = rdvService;
        this.name = name;
        this.endpoint = group.getEndpointService();
        this.uniqueGroupId = group.getPeerGroupID().getUniqueValue().toString();
        this.timer = new Timer("PeerView Timer for " + group.getPeerGroupID(), true);
        Advertisement adv = null;
        ConfigParams confAdv = group.getConfigAdvertisement();
        if (confAdv != null) {
            try {
                XMLDocument configDoc = (XMLDocument)confAdv.getServiceParam(rdvService.getAssignedID());
                if (null != configDoc) {
                    adv = AdvertisementFactory.newAdvertisement(configDoc);
                }
            }
            catch (NoSuchElementException failed) {
                // empty catch block
            }
        }
        if (!(adv instanceof RdvConfigAdv)) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Creating new RdvConfigAdv for defaults.");
            }
            rdvConfigAdv = (RdvConfigAdv)AdvertisementFactory.newAdvertisement(RdvConfigAdv.getAdvertisementType());
        } else {
            rdvConfigAdv = (RdvConfigAdv)adv;
        }
        if (rdvConfigAdv.getSeedRendezvousConnectDelay() > 0L) {
            this.seedingRdvConnDelay = rdvConfigAdv.getSeedRendezvousConnectDelay();
        }
        this.useOnlySeeds = rdvConfigAdv.getUseOnlySeeds();
        if (rdvConfigAdv.getMinHappyPeerView() > 0) {
            this.minHappyPeerView = rdvConfigAdv.getMinHappyPeerView();
        }
        URISeedingManager seedingManager = null == advertisingGroup && rdvConfigAdv.getProbeRelays() ? new RelayReferralSeedingManager(rdvConfigAdv.getAclUri(), this.useOnlySeeds, group, name) : new URISeedingManager(rdvConfigAdv.getAclUri(), this.useOnlySeeds, group, name);
        for (URI aSeeder : Arrays.asList(rdvConfigAdv.getSeedingURIs())) {
            seedingManager.addSeedingURI(aSeeder);
        }
        for (URI aSeed : Arrays.asList(rdvConfigAdv.getSeedRendezvous())) {
            seedingManager.addSeed(aSeed);
        }
        this.seedingManager = seedingManager;
        this.lastPeerAdv = group.getPeerAdvertisement();
        this.lastModCount = this.lastPeerAdv.getModCount();
        RdvAdvertisement radv = PeerView.createRdvAdvertisement(this.lastPeerAdv, name);
        this.self = new PeerViewElement(this.endpoint, radv);
        this.endpoint.addIncomingMessageListener(this, SERVICE_NAME, this.uniqueGroupId);
        rdvService.addListener(this);
        this.replyStrategy = new PeerViewRandomWithReplaceStrategy(this.localView);
        this.kickRecipientStrategy = new PeerViewRandomStrategy(this.localView);
        this.kickAdvertisementStrategy = new PeerViewRandomWithReplaceStrategy(this.localView);
        this.refreshRecipientStrategy = new PeerViewSequentialStrategy(this.localView);
        this.localGroupWirePipeAdv = PeerView.makeWirePipeAdvertisement(group, group, name);
        this.advGroupPropPipeAdv = null != advertisingGroup ? PeerView.makeWirePipeAdvertisement(advertisingGroup, group, name) : null;
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("PeerView created for group \"" + group.getPeerGroupName() + "\" [" + group.getPeerGroupID() + "] name \"" + name + "\"");
        }
    }

    @Override
    public void processIncomingMessage(Message msg, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        boolean isTrusted;
        RdvAdvertisement radv;
        MessageElement me;
        boolean isResponse;
        block30: {
            Advertisement adv;
            isResponse = false;
            me = msg.getMessageElement(MESSAGE_NAMESPACE, MESSAGE_ELEMENT_NAME);
            if (me == null) {
                me = msg.getMessageElement(MESSAGE_NAMESPACE, RESPONSE_ELEMENT_NAME);
                if (me == null) {
                    if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.warning("Discarding damaged " + msg + ".");
                    }
                    return;
                }
                isResponse = true;
            }
            try {
                XMLDocument asDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(me);
                adv = AdvertisementFactory.newAdvertisement(asDoc);
            }
            catch (RuntimeException failed) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Failed building rdv advertisement from message element", failed);
                }
                return;
            }
            catch (IOException failed) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Failed building rdv advertisement from message element", failed);
                }
                return;
            }
            if (!(adv instanceof RdvAdvertisement)) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Response does not contain radv (" + adv.getAdvertisementType() + ")");
                }
                return;
            }
            radv = (RdvAdvertisement)adv;
            if (null == radv.getRouteAdv()) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Rdv Advertisement does not contain route.");
                }
                return;
            }
            me = msg.getMessageElement(MESSAGE_NAMESPACE, SRCROUTEADV_ELEMENT_NAME);
            if (me != null) {
                try {
                    XMLDocument asDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(me);
                    Advertisement routeAdv = AdvertisementFactory.newAdvertisement(asDoc);
                    if (!(routeAdv instanceof RouteAdvertisement)) {
                        if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                            LOG.warning("Advertisement is not a RouteAdvertisement");
                        }
                    } else {
                        RouteAdvertisement rdvRouteAdv = radv.getRouteAdv().clone();
                        RouteAdvertisement.stichRoute(rdvRouteAdv, (RouteAdvertisement)routeAdv);
                        radv.setRouteAdv(rdvRouteAdv);
                    }
                }
                catch (RuntimeException failed) {
                    if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.log(Level.WARNING, "Failed building route adv from message element", failed);
                    }
                }
                catch (IOException failed) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block30;
                    LOG.log(Level.WARNING, "Failed building route adv from message element", failed);
                }
            }
        }
        me = null;
        if (this.group.getPeerID().equals(radv.getPeerID())) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Received a PeerView message about self. Discard.");
            }
            return;
        }
        boolean isFailure = msg.getMessageElement(MESSAGE_NAMESPACE, FAILURE_ELEMENT_NAME) != null;
        boolean isCached = msg.getMessageElement(MESSAGE_NAMESPACE, CACHED_RADV_ELEMENT_NAME) != null;
        boolean isFromEdge = msg.getMessageElement(MESSAGE_NAMESPACE, EDGE_ELEMENT_NAME) != null;
        boolean bl = isTrusted = isFromEdge || this.seedingManager.isAcceptablePeer(radv.getRouteAdv());
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            String srcPeer = srcAddr.toString();
            if (MESSAGE_NAMESPACE.equals(srcAddr.getProtocolName())) {
                try {
                    String idstr = "urn:jxta:" + srcAddr.getProtocolAddress();
                    ID asID = IDFactory.fromURI(new URI(idstr));
                    PeerViewElement pve = this.getPeerViewElement(asID);
                    if (null != pve) {
                        srcPeer = "\"" + pve.getRdvAdvertisement().getName() + "\"";
                    }
                }
                catch (URISyntaxException failed) {
                    // empty catch block
                }
            }
            LOG.fine("[" + this.group.getPeerGroupID() + "] Received a" + (isCached ? " cached" : "") + (isResponse ? " response" : "") + (isFailure ? " failure" : "") + " message (" + msg.toString() + ")" + (isFromEdge ? " from edge" : "") + " regarding \"" + radv.getName() + "\" from " + srcPeer);
        }
        if (!isTrusted) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Rejecting peerview message from " + radv.getPeerID());
            }
            return;
        }
        if (isFailure) {
            this.notifyFailure(radv.getPeerID(), false);
            return;
        }
        this.handlePeerViewMessage(isResponse, isCached, isFromEdge, isTrusted, radv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePeerViewMessage(boolean isResponse, boolean isCached, boolean isFromEdge, boolean isTrusted, RdvAdvertisement radv) {
        PeerViewElement pve;
        boolean isNewbie = false;
        boolean added = false;
        SortedSet<PeerViewDestination> sortedSet = this.localView;
        synchronized (sortedSet) {
            PeerViewElement newbie = new PeerViewElement(this.endpoint, radv);
            pve = this.getPeerViewElement(newbie);
            if (null == pve) {
                pve = newbie;
                isNewbie = true;
            }
            if (!isFromEdge && !isCached && isTrusted) {
                if (isNewbie) {
                    added = this.addPeerViewElement(pve);
                } else {
                    pve.setRdvAdvertisement(radv);
                }
            }
        }
        if (!isNewbie && isFromEdge && !isCached) {
            this.notifyFailure(pve, true);
        }
        if (added) {
            this.generateEvent(10, pve);
        }
        if (!isCached) {
            if (!isResponse) {
                PeerViewElement sendpve;
                boolean status = this.send(pve, this.self, true, false);
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Type 1 (Respond with self PVE) : Sent to " + pve + " result =" + status);
                }
                if ((sendpve = this.replyStrategy.next()) != null && !pve.equals(sendpve) && !this.self.equals(sendpve)) {
                    status = this.send(pve, sendpve, true, false);
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Type 3 (Respond with random PVE) : Sent " + sendpve + " to " + pve + " result=" + status);
                    }
                }
            }
        } else if (isResponse && isNewbie && !this.useOnlySeeds && !isFromEdge) {
            boolean status = this.send(pve, this.self, false, false);
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Type 2 (Probe PVE) : Probed " + pve + " result=" + status);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rendezvousEvent(RendezvousEvent event) {
        if (this.closed) {
            return;
        }
        boolean notifyFailure = false;
        PeerView peerView = this;
        synchronized (peerView) {
            int theEventType = event.getType();
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.group.getPeerGroupName() + "] Processing  " + event);
            }
            this.refreshSelf();
            if ((8 == theEventType || 9 == theEventType) && null != this.watchdogTask) {
                this.removeTask(this.watchdogTask);
                this.watchdogTask.cancel();
                this.watchdogTask = null;
            }
            switch (theEventType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 8: {
                    this.openWirePipes();
                    this.watchdogTask = new WatchdogTask();
                    this.addTask(this.watchdogTask, 30000L, 30000L);
                    this.rescheduleKick(true);
                    break;
                }
                case 9: {
                    this.openWirePipes();
                    if (!this.localView.isEmpty()) {
                        notifyFailure = true;
                    }
                    this.rescheduleKick(true);
                    break;
                }
                default: {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break;
                    LOG.warning("[" + this.group.getPeerGroupName() + "] Unexpected RDV event : " + event);
                }
            }
        }
        if (notifyFailure) {
            this.notifyFailure(this.self, true);
        }
    }

    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        PeerView peerView = this;
        synchronized (peerView) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.notifyFailure(this.self, true);
        peerView = this;
        synchronized (peerView) {
            if (this.watchdogTask != null) {
                this.removeTask(this.watchdogTask);
                this.watchdogTask.cancel();
                this.watchdogTask = null;
            }
            this.endpoint.removeIncomingMessageListener(SERVICE_NAME, this.uniqueGroupId);
            this.rdvService.removeListener(this);
            Set<TimerTask> set = this.scheduledTasks;
            synchronized (set) {
                Iterator<TimerTask> eachTask = this.scheduledTasks.iterator();
                while (eachTask.hasNext()) {
                    try {
                        TimerTask task = eachTask.next();
                        task.cancel();
                        eachTask.remove();
                    }
                    catch (Exception ez1) {
                        if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                        LOG.log(Level.WARNING, "Cannot cancel task: ", ez1);
                    }
                }
            }
            this.closeWirePipes();
            this.downPeer = null;
            this.upPeer = null;
            this.localView.clear();
            this.timer.cancel();
            this.rpvListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTask(TimerTask task, long delay, long interval) {
        Set<TimerTask> set = this.scheduledTasks;
        synchronized (set) {
            if (this.scheduledTasks.contains(task) && Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Task list already contains specified task.");
            }
            this.scheduledTasks.add(task);
        }
        if (interval >= 1L) {
            this.timer.schedule(task, delay, interval);
        } else {
            this.timer.schedule(task, delay);
        }
    }

    protected void removeTask(TimerTask task) {
        this.scheduledTasks.remove(task);
    }

    public void addSeed(URI seed) {
        if (this.seedingManager instanceof URISeedingManager) {
            ((URISeedingManager)this.seedingManager).addSeed(seed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean probeAddress(EndpointAddress address, RouteAdvertisement hint) {
        PeerViewElement holdIt;
        SortedSet<PeerViewDestination> sortedSet = this.localView;
        synchronized (sortedSet) {
            holdIt = this.self;
        }
        return this.send(address, hint, holdIt, false, false);
    }

    public void seed() {
        long reseedRemaining = this.earliestReseed - TimeUtils.timeNow();
        if (reseedRemaining > 0L) {
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.info("Still Seeding for " + reseedRemaining + "ms.");
            }
            return;
        }
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("New Seeding...");
        }
        this.send(null, null, this.self, false, false);
        long iterations = 0L;
        if (this.localView.size() < this.minHappyPeerView) {
            ArrayList<RouteAdvertisement> seedRdvs = new ArrayList<RouteAdvertisement>(Arrays.asList(this.seedingManager.getActiveSeedRoutes()));
            while (!seedRdvs.isEmpty()) {
                RouteAdvertisement aSeed = (RouteAdvertisement)seedRdvs.remove(0);
                if (null == aSeed.getDestPeerID()) {
                    Vector<String> seed_eas = aSeed.getDest().getVectorEndpointAddresses();
                    if (seed_eas.isEmpty()) continue;
                    EndpointAddress aSeedHost = new EndpointAddress(seed_eas.get(0));
                    this.send(aSeedHost, null, this.self, false, false);
                    continue;
                }
                if (null != this.getPeerViewElement(aSeed.getDestPeerID()) || this.group.getPeerID().equals(aSeed.getDestPeerID())) continue;
                EndpointAddress aSeedHost = new EndpointAddress(MESSAGE_NAMESPACE, aSeed.getDestPeerID().getUniqueValue().toString(), null, null);
                this.send(aSeedHost, aSeed, this.self, false, false);
            }
            if (!this.useOnlySeeds && this.advertisingGroup != null) {
                this.scheduleAdvertisingGroupQuery(10000L);
            }
        }
        this.earliestReseed = TimeUtils.toAbsoluteTimeMillis(this.seedingRdvConnDelay + 5000L * iterations);
    }

    private void scheduleOpenPipes(long delay) {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Scheduling open pipes attempt in " + delay + "ms.");
        }
        this.addTask(new OpenPipesTask(), delay, -1L);
    }

    private boolean send(PeerViewElement dest, PeerViewElement pve, boolean response, boolean failure) {
        Message msg = this.makeMessage(pve, response, failure);
        boolean result = dest.sendMessage(msg, SERVICE_NAME, this.uniqueGroupId);
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Sending " + msg + " to " + dest + " success = " + result);
        }
        return result;
    }

    private boolean send(EndpointAddress dest, RouteAdvertisement hint, PeerViewElement pve, boolean response, boolean failure) {
        Message msg = this.makeMessage(pve, response, failure);
        if (null != dest) {
            EndpointAddress realAddr = new EndpointAddress(dest, SERVICE_NAME, this.uniqueGroupId);
            Messenger messenger = this.rdvService.endpoint.getMessengerImmediate(realAddr, hint);
            if (null != messenger) {
                try {
                    boolean result = messenger.sendMessage(msg);
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Sending " + msg + " to " + dest + " success = " + result);
                    }
                    return result;
                }
                catch (IOException failed) {
                    if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.log(Level.WARNING, "Could not send " + msg + " to " + dest, failed);
                    }
                    return false;
                }
            }
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Could not get messenger for " + dest);
            }
            return false;
        }
        try {
            this.endpoint.propagate(msg, SERVICE_NAME, this.uniqueGroupId);
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Sent " + msg + " via propagate");
            }
            return true;
        }
        catch (IOException ez) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Could not propagate " + msg, ez);
            }
            return false;
        }
    }

    private boolean send(OutputPipe dest, PeerViewElement pve, boolean response, boolean failure) {
        Message msg = this.makeMessage(pve, response, failure);
        try {
            return dest.send(msg);
        }
        catch (IOException ez) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Could not send " + msg, ez);
            }
            return false;
        }
    }

    private Message makeMessage(PeerViewElement content, boolean response, boolean failure) {
        Message msg;
        block5: {
            msg = new Message();
            if (failure) {
                msg.addMessageElement(MESSAGE_NAMESPACE, FAILURE_ELEMENT);
            }
            this.refreshSelf();
            RdvAdvertisement radv = content.getRdvAdvertisement();
            XMLDocument doc = (XMLDocument)radv.getDocument(MimeMediaType.XMLUTF8);
            String msgName = response ? RESPONSE_ELEMENT_NAME : MESSAGE_ELEMENT_NAME;
            TextDocumentMessageElement msge = new TextDocumentMessageElement(msgName, doc, null);
            msg.addMessageElement(MESSAGE_NAMESPACE, msge);
            if (!content.equals(this.self)) {
                msg.addMessageElement(MESSAGE_NAMESPACE, CACHED_RADV_ELEMENT);
                RouteAdvertisement localra = EndpointUtils.extractRouteAdv(this.lastPeerAdv);
                if (localra != null) {
                    try {
                        XMLDocument radoc = (XMLDocument)localra.getDocument(MimeMediaType.XMLUTF8);
                        msge = new TextDocumentMessageElement(SRCROUTEADV_ELEMENT_NAME, radoc, null);
                        msg.addMessageElement(MESSAGE_NAMESPACE, msge);
                    }
                    catch (Exception ez1) {
                        if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block5;
                        LOG.log(Level.WARNING, "Could not create optional src route adv for " + content, ez1);
                    }
                }
            }
        }
        return msg;
    }

    public void notifyFailure(PeerID pid, boolean propagateFailure) {
        PeerViewElement pve = this.getPeerViewElement(pid);
        if (null != pve) {
            this.notifyFailure(pve, propagateFailure);
        }
    }

    void notifyFailure(PeerViewElement pve, boolean propagateFailure) {
        block7: {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Notifying failure of " + pve);
            }
            try {
                OutputPipe op;
                boolean emptyPeerView;
                boolean removedFromPeerView = this.removePeerViewElement(pve);
                propagateFailure &= removedFromPeerView || this.self == pve;
                if (removedFromPeerView) {
                    this.generateEvent(12, pve);
                }
                if ((emptyPeerView = this.localView.isEmpty()) && removedFromPeerView) {
                    this.rescheduleKick(true);
                }
                if (propagateFailure && null != (op = this.localGroupWirePipeOutputPipe)) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Propagating failure of " + pve);
                    }
                    this.send(op, pve, true, true);
                }
            }
            catch (Exception ez) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block7;
                LOG.log(Level.WARNING, "Failure while generating noficiation of failure of PeerView : " + pve, ez);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void kick() {
        block14: {
            block13: {
                block12: {
                    try {
                        PeerViewElement recipient;
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Begun kick() in " + this.group.getPeerGroupID());
                        }
                        this.seed();
                        PeerViewElement refreshee = this.refreshRecipientStrategy.next();
                        if (refreshee != null && this.self != refreshee) {
                            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                LOG.fine("Refresh " + refreshee);
                            }
                            this.send(refreshee, this.self, false, false);
                        }
                        if ((recipient = this.kickRecipientStrategy.next()) == null) {
                            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                LOG.fine("No recipient to send adv ");
                            }
                            Object var5_3 = null;
                            this.rescheduleKick(false);
                            return;
                        }
                        PeerViewElement rpve = this.kickAdvertisementStrategy.next();
                        if (rpve == null) {
                            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                LOG.fine("No adv to send");
                            }
                            break block12;
                        }
                        if (rpve.equals(recipient) || this.self.equals(recipient)) {
                            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                LOG.fine("adv to send is same as recipient: Nothing to do.");
                            }
                            break block13;
                        }
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Sending adv " + rpve + " to " + recipient);
                        }
                        this.send(recipient, rpve, true, false);
                        break block14;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        this.rescheduleKick(false);
                        throw throwable;
                    }
                }
                Object var5_4 = null;
                this.rescheduleKick(false);
                return;
            }
            Object var5_5 = null;
            this.rescheduleKick(false);
            return;
        }
        Object var5_6 = null;
        this.rescheduleKick(false);
    }

    private int adjustBootLevel() {
        boolean areWeHappy = this.localView.size() >= this.minHappyPeerView;
        int increment = areWeHappy ? 1 : 2;
        int maxbootlevel = 6 - (areWeHappy ? 0 : 1);
        this.bootLevel = Math.min(maxbootlevel, this.bootLevel + increment);
        return this.bootLevel;
    }

    private synchronized void rescheduleKick(boolean now) {
        block6: {
            if (this.closed) {
                return;
            }
            try {
                if (now) {
                    this.bootLevel = 0;
                } else {
                    this.adjustBootLevel();
                }
                long tilNextKick = 3000L * ((1L << this.bootLevel) - 1L);
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Scheduling kick in " + tilNextKick / 1000L + " seconds at bootLevel " + this.bootLevel + " in group " + this.group.getPeerGroupID());
                }
                KickerTask task = new KickerTask();
                this.addTask(task, tilNextKick, -1L);
            }
            catch (Exception ez1) {
                if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) break block6;
                LOG.log(Level.SEVERE, "Cannot set timer. RPV will not work.", ez1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshSelf() {
        PeerView peerView = this;
        synchronized (peerView) {
            PeerAdvertisement newPadv = this.group.getPeerAdvertisement();
            int newModCount = newPadv.getModCount();
            if (this.lastPeerAdv != newPadv || this.lastModCount != newModCount) {
                this.lastPeerAdv = newPadv;
                this.lastModCount = newModCount;
                RdvAdvertisement radv = PeerView.createRdvAdvertisement(this.lastPeerAdv, this.name);
                if (radv != null) {
                    this.self.setRdvAdvertisement(radv);
                }
            }
        }
    }

    static RdvAdvertisement createRdvAdvertisement(PeerAdvertisement padv, String serviceName) {
        try {
            RdvAdvertisement rdv = (RdvAdvertisement)AdvertisementFactory.newAdvertisement(RdvAdvertisement.getAdvertisementType());
            rdv.setPeerID(padv.getPeerID());
            rdv.setGroupID(padv.getPeerGroupID());
            rdv.setServiceName(serviceName);
            rdv.setName(padv.getName());
            RouteAdvertisement ra = EndpointUtils.extractRouteAdv(padv);
            rdv.setRouteAdv(ra);
            return rdv;
        }
        catch (Exception ez) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Cannot create Local RdvAdvertisement: ", ez);
            }
            return null;
        }
    }

    public boolean addListener(PeerViewListener listener) {
        boolean added = this.rpvListeners.add(listener);
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Registered PeerViewEvent Listener (" + listener.getClass().getName() + ")");
        }
        return added;
    }

    public boolean removeListener(PeerViewListener listener) {
        boolean removed = this.rpvListeners.remove(listener);
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Removed PeerViewEvent Listener (" + listener.getClass().getName() + ")");
        }
        return removed;
    }

    private void generateEvent(int type, PeerViewElement element2) {
        PeerViewEvent newevent = new PeerViewEvent(this, type, element2);
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Calling listeners for " + newevent + " in group " + this.group.getPeerGroupID());
        }
        for (Object o : Arrays.asList(this.rpvListeners.toArray())) {
            PeerViewListener pvl = (PeerViewListener)o;
            try {
                pvl.peerViewEvent(newevent);
            }
            catch (Throwable ignored) {
                if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) continue;
                LOG.log(Level.SEVERE, "Uncaught Throwable in PeerViewEvent listener : (" + pvl.getClass().getName() + ")", ignored);
            }
        }
    }

    static PipeAdvertisement makeWirePipeAdvertisement(PeerGroup destGroup, PeerGroup group, String name) {
        PipeAdvertisement adv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(PipeAdvertisement.getAdvertisementType());
        PipeID pipeId = IDFactory.newPipeID(destGroup.getPeerGroupID(), (SERVICE_NAME + group.getPeerGroupID().getUniqueValue().toString() + name).getBytes());
        adv.setPipeID(pipeId);
        adv.setType("JxtaPropagate");
        adv.setName("PeerView pipe for " + group.getPeerGroupID());
        return adv;
    }

    private synchronized void openWirePipes() {
        PipeService pipes = this.group.getPipeService();
        if (null == pipes) {
            this.scheduleOpenPipes(1000L);
            return;
        }
        try {
            if (null == this.localGroupWirePipeInputPipe) {
                this.localGroupWirePipeInputPipe = pipes.createInputPipe(this.localGroupWirePipeAdv, new WirePipeListener());
            }
            if (null == this.localGroupWirePipeOutputPipe) {
                this.localGroupWirePipeOutputPipe = pipes.createOutputPipe(this.localGroupWirePipeAdv, 1000L);
            }
            if (this.localGroupWirePipeOutputPipe == null && Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Cannot get OutputPipe for current group");
            }
        }
        catch (Exception failed) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("PipeService not ready yet. Trying again in 1 second.");
            }
            this.scheduleOpenPipes(1000L);
            return;
        }
        if (this.advertisingGroup != null) {
            try {
                pipes = this.advertisingGroup.getPipeService();
                if (null == pipes) {
                    this.scheduleOpenPipes(1000L);
                    return;
                }
                if (null == this.wirePipeInputPipe) {
                    this.wirePipeInputPipe = pipes.createInputPipe(this.advGroupPropPipeAdv, new WirePipeListener());
                }
                if (null == this.wirePipeOutputPipe) {
                    this.wirePipeOutputPipe = pipes.createOutputPipe(this.advGroupPropPipeAdv, 1000L);
                }
                if (this.wirePipeOutputPipe == null && Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Cannot get OutputPipe for current group");
                }
            }
            catch (Exception failed) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Could not open pipes in local group. Trying again in 1 second.");
                }
                this.scheduleOpenPipes(1000L);
                return;
            }
        }
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Propagate Pipes opened.");
        }
    }

    private synchronized void closeWirePipes() {
        if (this.localGroupWirePipeInputPipe != null) {
            this.localGroupWirePipeInputPipe.close();
            this.localGroupWirePipeInputPipe = null;
        }
        if (this.localGroupWirePipeOutputPipe != null) {
            this.localGroupWirePipeOutputPipe.close();
            this.localGroupWirePipeOutputPipe = null;
        }
        if (this.wirePipeInputPipe != null) {
            this.wirePipeInputPipe.close();
            this.wirePipeInputPipe = null;
        }
        if (this.wirePipeOutputPipe != null) {
            this.wirePipeOutputPipe.close();
            this.wirePipeOutputPipe = null;
        }
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Propagate Pipes closed.");
        }
    }

    private synchronized void scheduleAdvertisingGroupQuery(long delay) {
        if (this.closed) {
            return;
        }
        AdvertisingGroupQueryTask task = new AdvertisingGroupQueryTask();
        this.addTask(task, delay, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<PeerViewElement> getView() {
        SortedSet<PeerViewDestination> sortedSet = this.localView;
        synchronized (sortedSet) {
            return new TreeSet<PeerViewDestination>(this.localView);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addPeerViewElement(PeerViewElement pve) {
        boolean added;
        if (null == pve.getRdvAdvertisement()) {
            throw new IllegalStateException("Cannot add a seed pve to local view");
        }
        SortedSet<PeerViewDestination> sortedSet = this.localView;
        synchronized (sortedSet) {
            added = this.localView.add(pve);
            if (added) {
                this.updateUpAndDownPeers();
            }
        }
        if (added) {
            pve.setPeerView(this);
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removePeerViewElement(PeerViewElement pve) {
        boolean removed;
        SortedSet<PeerViewDestination> sortedSet = this.localView;
        synchronized (sortedSet) {
            removed = this.localView.remove(pve);
            if (removed) {
                this.updateUpAndDownPeers();
            }
        }
        if (removed) {
            pve.setPeerView(null);
        }
        return removed;
    }

    public PeerViewElement getPeerViewElement(PeerViewDestination wanted) {
        try {
            PeerViewElement found = (PeerViewElement)this.localView.tailSet(wanted).first();
            if (wanted.equals(found)) {
                return found;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return null;
    }

    public PeerViewElement getPeerViewElement(ID pid) {
        return this.getPeerViewElement(new PeerViewDestination(pid));
    }

    public PeerViewElement getDownPeer() {
        return this.downPeer;
    }

    public PeerViewElement getSelf() {
        return this.self;
    }

    public PeerViewElement getUpPeer() {
        return this.upPeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUpAndDownPeers() {
        SortedSet<PeerViewDestination> sortedSet = this.localView;
        synchronized (sortedSet) {
            PeerViewElement oldDown = this.downPeer;
            PeerViewElement oldUp = this.upPeer;
            SortedSet<PeerViewDestination> headSet = this.localView.headSet(this.self);
            this.downPeer = !headSet.isEmpty() ? (PeerViewElement)headSet.last() : null;
            SortedSet<PeerViewDestination> tailSet = this.localView.tailSet(this.self);
            if (!tailSet.isEmpty()) {
                if (this.self.equals(tailSet.first())) {
                    Iterator eachTail = tailSet.iterator();
                    eachTail.next();
                    this.upPeer = eachTail.hasNext() ? (PeerViewElement)eachTail.next() : null;
                } else {
                    this.upPeer = (PeerViewElement)tailSet.first();
                }
            } else {
                this.upPeer = null;
            }
            if (oldDown != this.downPeer && this.downPeer != null) {
                this.downPeer.setLastUpdateTime(TimeUtils.timeNow());
            }
            if (oldUp != this.upPeer && this.upPeer != null) {
                this.upPeer.setLastUpdateTime(TimeUtils.timeNow());
            }
        }
    }

    private final class KickerTask
    extends TimerTask {
        private KickerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    if (PeerView.this.closed) {
                        Object var3_1 = null;
                        PeerView.this.removeTask(this);
                        return;
                    }
                    PeerView.this.kick();
                }
                catch (Throwable all) {
                    if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                        LOG.log(Level.SEVERE, "Uncaught Throwable in thread : " + Thread.currentThread().getName(), all);
                    }
                    Object var3_3 = null;
                    PeerView.this.removeTask(this);
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                PeerView.this.removeTask(this);
                throw throwable;
            }
            Object var3_2 = null;
            PeerView.this.removeTask(this);
        }
    }

    private final class WatchdogTask
    extends TimerTask {
        int iterations = 0;

        WatchdogTask() {
        }

        public void run() {
            block15: {
                try {
                    PeerViewElement down;
                    PeerViewElement up;
                    DiscoveryService discovery;
                    if (PeerView.this.closed) {
                        return;
                    }
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Watchdog task executing for group " + PeerView.this.group.getPeerGroupID());
                    }
                    PeerView.this.refreshSelf();
                    if (0 == this.iterations % 5 && null != (discovery = PeerView.this.group.getDiscoveryService())) {
                        discovery.publish(PeerView.this.self.getRdvAdvertisement(), 300000L, 150000L);
                    }
                    if ((up = PeerView.this.getUpPeer()) != null) {
                        if (TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), up.getLastUpdateTime()) > 300000L) {
                            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                                LOG.warning("UP peer has gone MIA : " + up);
                            }
                            PeerView.this.notifyFailure(up, true);
                        } else {
                            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                LOG.fine("Checking on UP peer : " + up);
                            }
                            PeerView.this.send(up, PeerView.this.getSelf(), false, false);
                        }
                    }
                    if ((down = PeerView.this.getDownPeer()) != null) {
                        if (TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), down.getLastUpdateTime()) > 300000L) {
                            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                                LOG.warning("DOWN peer has gone MIA : " + down);
                            }
                            PeerView.this.notifyFailure(down, true);
                        } else {
                            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                LOG.fine("Checking on DOWN peer : " + down);
                            }
                            PeerView.this.send(down, PeerView.this.getSelf(), false, false);
                        }
                    }
                }
                catch (Throwable all) {
                    if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) break block15;
                    LOG.log(Level.SEVERE, "Uncaught Throwable in thread :" + Thread.currentThread().getName(), all);
                }
            }
            ++this.iterations;
        }
    }

    private final class AdvertisingGroupQueryTask
    extends TimerTask {
        private AdvertisingGroupQueryTask() {
        }

        public boolean cancel() {
            boolean res = super.cancel();
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    if (PeerView.this.closed) {
                        Object var4_1 = null;
                        PeerView.this.removeTask(this);
                        return;
                    }
                    OutputPipe op = PeerView.this.wirePipeOutputPipe;
                    if (null != op) {
                        Message msg = PeerView.this.makeMessage(PeerView.this.self, false, false);
                        op.send(msg);
                    }
                }
                catch (Throwable all) {
                    if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                        LOG.log(Level.SEVERE, "Uncaught Throwable in thread :" + Thread.currentThread().getName(), all);
                    }
                    Object var4_3 = null;
                    PeerView.this.removeTask(this);
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                PeerView.this.removeTask(this);
                throw throwable;
            }
            Object var4_2 = null;
            PeerView.this.removeTask(this);
        }
    }

    private class WirePipeListener
    implements PipeMsgListener {
        private WirePipeListener() {
        }

        public void pipeMsgEvent(PipeMsgEvent event) {
            block5: {
                int randinview;
                int viewsize;
                boolean response;
                Message msg = event.getMessage();
                boolean failure = null != msg.getMessageElement(PeerView.MESSAGE_NAMESPACE, PeerView.FAILURE_ELEMENT_NAME);
                boolean bl = response = null != msg.getMessageElement(PeerView.MESSAGE_NAMESPACE, PeerView.RESPONSE_ELEMENT_NAME);
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Received a PeerView " + (failure ? "failure " : "") + (response ? "response " : "") + "message [" + msg + "] on propagated pipe " + event.getPipeID());
                }
                if (!failure && !response && (viewsize = PeerView.this.localView.size()) > PeerView.this.minHappyPeerView && (randinview = random.nextInt(viewsize)) >= PeerView.this.minHappyPeerView) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Ignoring " + msg + " from pipe " + event.getPipeID());
                    }
                    return;
                }
                EndpointAddress src = new EndpointAddress(event.getPipeID(), PeerView.SERVICE_NAME, null);
                EndpointAddress dest = new EndpointAddress(event.getPipeID(), PeerView.SERVICE_NAME, null);
                try {
                    PeerView.this.processIncomingMessage(msg, src, dest);
                }
                catch (Throwable ez) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block5;
                    LOG.log(Level.WARNING, "Failed processing " + msg + " from pipe " + event.getPipeID(), ez);
                }
            }
        }
    }

    private class OpenPipesTask
    extends TimerTask {
        private OpenPipesTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    if (PeerView.this.closed) {
                        Object var3_1 = null;
                        PeerView.this.removeTask(this);
                        return;
                    }
                    PeerView.this.openWirePipes();
                }
                catch (Throwable all) {
                    if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                        LOG.log(Level.SEVERE, "Uncaught Throwable in thread: " + Thread.currentThread().getName(), all);
                    }
                    Object var3_3 = null;
                    PeerView.this.removeTask(this);
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                PeerView.this.removeTask(this);
                throw throwable;
            }
            Object var3_2 = null;
            PeerView.this.removeTask(this);
        }
    }
}

