/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.resolver.resolverMeter;

import net.jxta.impl.resolver.resolverMeter.QueryDestinationMetric;
import net.jxta.peer.PeerID;

public class QueryDestinationMeter {
    private PeerID peerID;
    private QueryDestinationMetric cumulativeMetrics;
    private QueryDestinationMetric deltaMetrics;

    public QueryDestinationMeter(PeerID peerID) {
        this.cumulativeMetrics = new QueryDestinationMetric(peerID);
    }

    public synchronized QueryDestinationMetric collectMetrics() {
        QueryDestinationMetric prevDelta = this.deltaMetrics;
        this.deltaMetrics = null;
        return prevDelta;
    }

    public QueryDestinationMetric getCumulativeMetrics() {
        return this.cumulativeMetrics;
    }

    private void createDeltaMetric() {
        this.deltaMetrics = new QueryDestinationMetric(this.peerID);
    }

    protected void querySentViaUnicast() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.querySentViaUnicast();
        this.cumulativeMetrics.querySentViaUnicast();
    }

    protected void responseSentViaUnicast() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.responseSentViaUnicast();
        this.cumulativeMetrics.responseSentViaUnicast();
    }

    protected void responseProcessed() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.responseProcessed();
        this.cumulativeMetrics.responseProcessed();
    }

    protected void responseToUnregisteredHandler() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.responseToUnregisteredHandler();
        this.cumulativeMetrics.responseToUnregisteredHandler();
    }

    protected void errorWhileProcessingResponse() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.errorWhileProcessingResponse();
        this.cumulativeMetrics.errorWhileProcessingResponse();
    }

    protected void queryProcessed() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.queryProcessed();
        this.cumulativeMetrics.queryProcessed();
    }

    protected void queryToUnregisteredHandler() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.queryToUnregisteredHandler();
        this.cumulativeMetrics.queryToUnregisteredHandler();
    }

    protected void errorWhileProcessingQuery() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.errorWhileProcessingQuery();
        this.cumulativeMetrics.errorWhileProcessingQuery();
    }
}

