/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUCache<K, V> {
    private final transient int cacheSize;
    private transient int currentSize = 0;
    private transient CacheNode<K, V> first;
    private transient CacheNode<K, V> last;
    private final transient Map<K, CacheNode<K, V>> nodes;

    public LRUCache(int size) {
        this.cacheSize = size;
        this.nodes = new HashMap<K, CacheNode<K, V>>(size);
    }

    public synchronized void clear() {
        this.first = null;
        this.last = null;
        this.nodes.clear();
        this.currentSize = 0;
    }

    public synchronized int size() {
        return this.currentSize;
    }

    public synchronized V get(K key) {
        CacheNode<K, V> node = this.nodes.get(key);
        if (node != null) {
            this.moveToHead(node);
            return node.value;
        }
        return null;
    }

    public synchronized boolean contains(K key) {
        return this.nodes.keySet().contains(key);
    }

    private void moveToHead(CacheNode<K, V> node) {
        if (node == this.first) {
            return;
        }
        if (node.prev != null) {
            node.prev.next = node.next;
        }
        if (node.next != null) {
            node.next.prev = node.prev;
        }
        if (this.last == node) {
            this.last = node.prev;
        }
        if (this.first != null) {
            node.next = this.first;
            this.first.prev = node;
        }
        this.first = node;
        node.prev = null;
        if (this.last == null) {
            this.last = this.first;
        }
    }

    public synchronized void put(K key, V value) {
        CacheNode<K, V> node = this.nodes.get(key);
        if (node == null) {
            if (this.currentSize >= this.cacheSize) {
                if (this.last != null) {
                    this.nodes.remove(this.last.key);
                }
                this.removeLast();
            } else {
                ++this.currentSize;
            }
            node = new CacheNode<K, V>(key, value);
        }
        node.value = value;
        this.moveToHead(node);
        this.nodes.put(key, node);
    }

    public synchronized V remove(K key) {
        CacheNode<K, V> node = this.nodes.get(key);
        if (node != null) {
            if (node.prev != null) {
                node.prev.next = node.next;
            }
            if (node.next != null) {
                node.next.prev = node.prev;
            }
            if (this.last == node) {
                this.last = node.prev;
            }
            if (this.first == node) {
                this.first = node.next;
            }
        }
        if (node != null) {
            return node.value;
        }
        return null;
    }

    private void removeLast() {
        if (this.last != null) {
            if (this.last.prev != null) {
                this.last.prev.next = null;
            } else {
                this.first = null;
            }
            this.last = this.last.prev;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CacheNode<K, V> {
        final K key;
        CacheNode<K, V> next;
        CacheNode<K, V> prev;
        V value;

        CacheNode(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

