/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attribute;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.impl.endpoint.EndpointUtils;
import net.jxta.impl.util.RdvAdvSeedingManager;
import net.jxta.impl.util.TimeUtils;
import net.jxta.logging.Logging;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.AccessPointAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.RouteAdvertisement;

public class URISeedingManager
extends RdvAdvSeedingManager {
    private static final transient Logger LOG = Logger.getLogger(URISeedingManager.class.getName());
    private static final long MINIMUM_SEEDING_REFRESH_INTERVAL = 300000L;
    private static final long STANDARD_SEEDING_REFRESH_INTERVAL = 1800000L;
    private boolean allowOnlySeeds = false;
    private final Set<URI> seedingURIs = new HashSet<URI>();
    private long nextSeedingURIrefreshTime = 0L;
    private int failedSeedingLoads = 0;
    private final Set<RouteAdvertisement> permanentSeeds = new HashSet<RouteAdvertisement>();
    private final List<RouteAdvertisement> activeSeeds = new ArrayList<RouteAdvertisement>();

    public URISeedingManager(URI aclLocation, boolean allowOnlySeeds, PeerGroup group, String serviceName) {
        super(aclLocation, group, serviceName);
        this.allowOnlySeeds = allowOnlySeeds;
    }

    public void stop() {
        super.stop();
    }

    public synchronized void addSeed(URI seed) {
        RouteAdvertisement ra = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
        AccessPointAdvertisement apa = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(AccessPointAdvertisement.getAdvertisementType());
        ra.addDestEndpointAddress(new EndpointAddress(seed));
        this.permanentSeeds.add(ra);
        this.activeSeeds.add(ra);
    }

    public synchronized void addSeed(RouteAdvertisement seed) {
        this.permanentSeeds.add(seed.clone());
        this.activeSeeds.add(seed.clone());
    }

    public synchronized void addSeedingURI(URI seeding) {
        this.seedingURIs.add(seeding);
        this.nextSeedingURIrefreshTime = TimeUtils.timeNow();
    }

    public synchronized URI[] getActiveSeedURIs() {
        boolean addedEA;
        ArrayList<URI> result = new ArrayList<URI>();
        this.refreshActiveSeeds();
        int eaIndex = 0;
        do {
            addedEA = false;
            for (RouteAdvertisement aRA : this.activeSeeds) {
                Vector<String> eas = aRA.getDest().getVectorEndpointAddresses();
                if (eaIndex >= eas.size()) continue;
                String anEndpointAddress = (String)eas.get(eaIndex);
                try {
                    result.add(new URI(anEndpointAddress));
                    addedEA = true;
                }
                catch (URISyntaxException failed) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                    LOG.log(Level.WARNING, "bad address in route : " + anEndpointAddress, failed);
                }
            }
            ++eaIndex;
        } while (addedEA);
        if (!this.allowOnlySeeds) {
            for (URI eachURI : Arrays.asList(super.getActiveSeedURIs())) {
                if (result.contains(eachURI)) continue;
                result.add(eachURI);
            }
        }
        return result.toArray(new URI[result.size()]);
    }

    public synchronized RouteAdvertisement[] getActiveSeedRoutes() {
        this.refreshActiveSeeds();
        ArrayList<RouteAdvertisement> result = new ArrayList<RouteAdvertisement>(this.activeSeeds);
        if (!this.allowOnlySeeds) {
            for (RouteAdvertisement eachRoute : Arrays.asList(super.getActiveSeedRoutes())) {
                if (result.contains(eachRoute)) continue;
                result.add(eachRoute);
            }
        }
        return result.toArray(new RouteAdvertisement[result.size()]);
    }

    public synchronized boolean isAcceptablePeer(PeerAdvertisement peeradv) {
        RouteAdvertisement route = EndpointUtils.extractRouteAdv(peeradv);
        boolean acceptable = true;
        if (this.allowOnlySeeds) {
            acceptable = this.isSeedPeer(route);
        }
        if (!acceptable) {
            return false;
        }
        if (null != route) {
            return this.isAcceptablePeer(route);
        }
        return this.acl.getGrantAll();
    }

    public synchronized boolean isAcceptablePeer(RouteAdvertisement radv) {
        boolean acceptable = true;
        if (this.allowOnlySeeds) {
            acceptable = this.isSeedPeer(radv);
        }
        return acceptable && super.isAcceptablePeer(radv);
    }

    private void refreshActiveSeeds() {
        if (TimeUtils.timeNow() < this.nextSeedingURIrefreshTime) {
            return;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Regenerating active seeds list.");
        }
        this.activeSeeds.clear();
        if (!this.seedingURIs.isEmpty()) {
            ArrayList<URI> allSeedingURIs = new ArrayList<URI>(this.seedingURIs);
            boolean allLoadsFailed = true;
            Collections.shuffle(allSeedingURIs);
            for (URI aSeedingURI : allSeedingURIs) {
                try {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Loading seeding list from : " + aSeedingURI);
                    }
                    RouteAdvertisement[] ras = URISeedingManager.loadSeeds(aSeedingURI);
                    for (RouteAdvertisement aRA : Arrays.asList(ras)) {
                        if (this.activeSeeds.contains(aRA)) continue;
                        this.activeSeeds.add(aRA);
                        allLoadsFailed = false;
                    }
                }
                catch (IOException failed) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                    LOG.warning("Failed loading seeding list from : " + aSeedingURI);
                }
            }
            if (allLoadsFailed) {
                ++this.failedSeedingLoads;
                long nextAttemptInterval = Math.min(300000L * (long)this.failedSeedingLoads, 1800000L);
                this.nextSeedingURIrefreshTime = TimeUtils.toAbsoluteTimeMillis(nextAttemptInterval);
            } else {
                this.failedSeedingLoads = 0;
                this.nextSeedingURIrefreshTime = TimeUtils.toAbsoluteTimeMillis(1800000L);
            }
        }
        ArrayList<RouteAdvertisement> asList = new ArrayList<RouteAdvertisement>(this.permanentSeeds);
        Collections.shuffle(asList);
        this.activeSeeds.addAll(asList);
    }

    private boolean isSeedPeer(RouteAdvertisement route) {
        List<EndpointAddress> addrList = route.getDestEndpointAddresses();
        ListIterator<EndpointAddress> eachAddr = addrList.listIterator();
        while (eachAddr.hasNext()) {
            EndpointAddress anAddr = eachAddr.next();
            eachAddr.set((EndpointAddress)((Object)anAddr.toURI()));
        }
        addrList.retainAll(Arrays.asList(this.getActiveSeedURIs()));
        return !addrList.isEmpty();
    }

    static RouteAdvertisement[] loadSeeds(URI seedingURI) throws IOException {
        MimeMediaType type;
        URL seedingURL = seedingURI.toURL();
        URLConnection connection = seedingURL.openConnection();
        connection.setDoInput(true);
        InputStream is = connection.getInputStream();
        String content_type = connection.getContentType();
        if (null == content_type) {
            String name = seedingURI.getPath();
            int extIdx = name.lastIndexOf(46);
            int sepIdx = name.lastIndexOf(47);
            if (-1 != extIdx && extIdx > sepIdx) {
                String ext = name.substring(extIdx + 1);
                type = StructuredDocumentFactory.getMimeTypeForFileExtension(ext);
            } else {
                type = MimeMediaType.AOS;
            }
        } else {
            type = new MimeMediaType(content_type);
        }
        boolean isXML = MimeMediaType.XML_DEFAULTENCODING.equalsIngoringParams(type) || MimeMediaType.APPLICATION_XML_DEFAULTENCODING.equalsIngoringParams(type);
        BufferedReader seeds = new BufferedReader(new InputStreamReader(is));
        ArrayList<RouteAdvertisement> result = new ArrayList<RouteAdvertisement>();
        if (isXML) {
            XMLDocument xmldoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XML_DEFAULTENCODING, seeds);
            Enumeration eachRA = xmldoc.getChildren(RouteAdvertisement.getAdvertisementType());
            while (eachRA.hasMoreElements()) {
                XMLElement anRAElement = (XMLElement)eachRA.nextElement();
                RouteAdvertisement ra = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(anRAElement);
                result.add(ra);
            }
            boolean randomize = true;
            Attribute ordered = xmldoc.getAttribute("ordered");
            if (null != ordered) {
                boolean bl = randomize = Boolean.valueOf(ordered.getValue()) == false;
            }
            if (randomize) {
                Collections.shuffle(result);
            }
        } else {
            String aSeed;
            while (null != (aSeed = seeds.readLine())) {
                if (0 == (aSeed = aSeed.trim()).length()) continue;
                try {
                    URI validation = URI.create(aSeed);
                    EndpointAddress ea = new EndpointAddress(validation.toString());
                    RouteAdvertisement ra = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
                    ra.addDestEndpointAddress(ea);
                    result.add(ra);
                }
                catch (IllegalArgumentException badURI) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                    LOG.log(Level.WARNING, "bad URI in seeding list : " + aSeed, badURI);
                }
            }
        }
        is.close();
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine(MessageFormat.format("Loaded #{0} seeds from : {1}", result.size(), seedingURI));
        }
        return result.toArray(new RouteAdvertisement[result.size()]);
    }
}

