/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util.pipe.reliable;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.endpoint.ByteArrayMessageElement;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.WireFormatMessageFactory;
import net.jxta.impl.util.TimeUtils;
import net.jxta.impl.util.pipe.reliable.Defs;
import net.jxta.impl.util.pipe.reliable.Incoming;
import net.jxta.impl.util.pipe.reliable.Outgoing;
import net.jxta.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReliableInputStream
extends InputStream
implements Incoming {
    private static final Logger LOG = Logger.getLogger(ReliableInputStream.class.getName());
    private Outgoing outgoing;
    private volatile boolean closed = false;
    private boolean closing = false;
    private MsgListener listener = null;
    private long timeout;
    private volatile int sequenceNumber = 0;
    private final List<IQElt> inputQueue = new ArrayList<IQElt>();
    private final Record record;
    long nextRetransRequest = TimeUtils.toAbsoluteTimeMillis(1000L);

    public ReliableInputStream(Outgoing outgoing, int timeout) {
        this(outgoing, timeout, null);
    }

    public ReliableInputStream(Outgoing outgoing, int timeout, MsgListener listener) {
        this.outgoing = outgoing;
        this.setTimeout(timeout);
        this.record = new Record();
        this.listener = listener;
        this.sequenceNumber = 0;
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO) && listener != null) {
            LOG.info("Listener based ReliableInputStream created");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        super.close();
        List<IQElt> list = this.inputQueue;
        synchronized (list) {
            this.closed = true;
            this.inputQueue.clear();
            this.inputQueue.notifyAll();
        }
    }

    public boolean isInputShutdown() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void softClose() {
        List<IQElt> list = this.inputQueue;
        synchronized (list) {
            this.closing = true;
            this.inputQueue.notifyAll();
        }
    }

    public void setTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("Timeout must be >=0");
        }
        this.timeout = 0 == timeout ? Long.MAX_VALUE : (long)timeout;
    }

    @Override
    public int read() throws IOException {
        int len;
        if (this.closed) {
            return -1;
        }
        byte[] a = new byte[1];
        while ((len = this.local_read(a, 0, 1)) >= 0) {
            if (len <= 0) continue;
            if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                LOG.finer("Read() : " + (a[0] & 0xFF));
            }
            return a[0] & 0xFF;
        }
        this.close();
        return -1;
    }

    @Override
    public int read(byte[] a, int offset, int length) throws IOException {
        if (this.closed) {
            return -1;
        }
        if (0 == length) {
            return 0;
        }
        int i = this.local_read(a, offset, length);
        if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
            LOG.finer("Read(byte[], int, " + length + "), bytes read = " + i);
        }
        if (i == -1) {
            this.close();
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendACK(int seqnAck) {
        ArrayList<IQElt> queue;
        ArrayList<Integer> selectedAckList = new ArrayList<Integer>();
        List<IQElt> list = this.inputQueue;
        synchronized (list) {
            queue = new ArrayList<IQElt>(this.inputQueue);
        }
        Iterator eachInQueue = queue.iterator();
        while (eachInQueue.hasNext() && selectedAckList.size() < 100) {
            IQElt anIQElt = (IQElt)eachInQueue.next();
            if (anIQElt.seqnum <= seqnAck || anIQElt.ackd) continue;
            selectedAckList.add(anIQElt.seqnum);
            anIQElt.ackd = true;
        }
        this.sendACK(seqnAck, selectedAckList);
    }

    private void sendACK(int seqnAck, List<Integer> sackList) {
        block4: {
            ByteArrayOutputStream bos = new ByteArrayOutputStream((1 + sackList.size()) * 4);
            DataOutputStream dos = new DataOutputStream(bos);
            try {
                dos.writeInt(seqnAck);
                for (Integer aSackList : sackList) {
                    dos.writeInt(aSackList);
                }
                dos.close();
                bos.close();
                Message ACKMsg = new Message();
                ByteArrayMessageElement elt = new ByteArrayMessageElement("ack", Defs.MIME_TYPE_ACK, bos.toByteArray(), null);
                ACKMsg.addMessageElement("jxtarel", elt);
                this.outgoing.send(ACKMsg);
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("SENT ACK, seqn#" + seqnAck + " and " + sackList.size() + " SACKs ");
                }
            }
            catch (IOException e) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block4;
                LOG.log(Level.WARNING, "sendACK caught IOException:", e);
            }
        }
    }

    @Override
    public void recv(Message msg) {
        this.queueIncomingMessage(msg);
    }

    public boolean hasNextMessage() {
        return !this.inputQueue.isEmpty();
    }

    Message nextMessage(boolean blocking) throws IOException {
        Message msg;
        MessageElement elt;
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("nextMessage blocking?  [" + blocking + "]");
        }
        if (null == (elt = this.dequeueMessage(this.sequenceNumber + 1, blocking))) {
            return null;
        }
        ++this.sequenceNumber;
        try {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Converting message seqn :" + (this.sequenceNumber - 1) + "element to message");
            }
            msg = WireFormatMessageFactory.fromWire(elt.getStream(), Defs.MIME_TYPE_MSG, null);
        }
        catch (IOException ex) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Could not deserialize message " + elt.getElementName(), ex);
            }
            return null;
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueIncomingMessage(Message msg) {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Queue Incoming Message begins for " + msg);
        }
        long startEnqueue = TimeUtils.timeNow();
        Message.ElementIterator eachElement = msg.getMessageElements("jxtarel", Defs.MIME_TYPE_BLOCK);
        while (!this.closed && !this.closing && eachElement.hasNext()) {
            int msgSeqn;
            MessageElement elt = (MessageElement)eachElement.next();
            eachElement.remove();
            try {
                msgSeqn = Integer.parseInt(elt.getElementName());
            }
            catch (NumberFormatException n) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.warning("Discarding element (" + elt.getElementName() + ") Not one of ours.");
                continue;
            }
            IQElt newElt = new IQElt(msgSeqn, elt);
            if (newElt.seqnum <= this.sequenceNumber) {
                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break;
                LOG.fine("RCVD OLD MESSAGE : Discard seqn#" + newElt.seqnum + " now at seqn#" + this.sequenceNumber);
                break;
            }
            List<IQElt> list = this.inputQueue;
            synchronized (list) {
                if (this.closing || this.closed) {
                    return;
                }
                int insertIndex = this.inputQueue.size();
                boolean duplicate = false;
                for (int j = 0; j < this.inputQueue.size(); ++j) {
                    IQElt iq = this.inputQueue.get(j);
                    if (newElt.seqnum < iq.seqnum) {
                        insertIndex = j;
                        break;
                    }
                    if (newElt.seqnum != iq.seqnum) continue;
                    duplicate = true;
                    break;
                }
                if (duplicate) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("RCVD OLD MESSAGE :  Discard duplicate msg, seqn#" + newElt.seqnum);
                    }
                    break;
                }
                this.inputQueue.add(insertIndex, newElt);
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Enqueued msg with seqn#" + newElt.seqnum + " at index " + insertIndex);
                }
                this.inputQueue.notifyAll();
            }
        }
        if (this.listener != null) {
            Message newmsg = null;
            while (true) {
                try {
                    newmsg = this.nextMessage(false);
                }
                catch (IOException io) {
                    // empty catch block
                }
                if (newmsg == null) break;
                try {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("In listener mode, calling back listener");
                    }
                    this.listener.processIncomingMessage(newmsg);
                }
                catch (Throwable all) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                    LOG.log(Level.WARNING, "Uncaught Throwable calling listener", all);
                }
            }
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            long waited = TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), startEnqueue);
            LOG.fine("Queue Incoming Message for " + msg + " completed in " + waited + " msec.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageElement dequeueMessage(int desiredSeqn, boolean blocking) throws IOException {
        IQElt iQ = null;
        long startDequeue = TimeUtils.timeNow();
        long timeoutAt = TimeUtils.toAbsoluteTimeMillis(this.timeout);
        int wct = 0;
        List<IQElt> list = this.inputQueue;
        synchronized (list) {
            while (!this.closed) {
                if (this.inputQueue.isEmpty()) {
                    if (!blocking) {
                        return null;
                    }
                    if (this.closing) {
                        return null;
                    }
                    try {
                        ++wct;
                        this.inputQueue.wait(1000L);
                        if (timeoutAt < TimeUtils.timeNow()) {
                            throw new SocketTimeoutException("Read timeout reached");
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                    }
                    this.nextRetransRequest = TimeUtils.toAbsoluteTimeMillis(1000L);
                    continue;
                }
                iQ = this.inputQueue.get(0);
                if (iQ.seqnum < desiredSeqn) {
                    this.inputQueue.remove(0);
                    this.sendACK(iQ.seqnum);
                    continue;
                }
                if (iQ.seqnum != desiredSeqn) {
                    if (TimeUtils.toRelativeTimeMillis(this.nextRetransRequest) < 0L) {
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Trigger retransmission. Wanted seqn#" + desiredSeqn + " found seqn#" + iQ.seqnum);
                        }
                        this.sendACK(desiredSeqn - 1);
                        this.nextRetransRequest = TimeUtils.toAbsoluteTimeMillis(1000L);
                    }
                    if (!blocking) {
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Message out of sequece in Non-Blocking mode. returning");
                        }
                        return null;
                    }
                    try {
                        ++wct;
                        this.inputQueue.wait(1000L);
                        if (timeoutAt >= TimeUtils.timeNow()) continue;
                        throw new SocketTimeoutException("Read timeout reached");
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException("IO interrupted ");
                    }
                }
                this.inputQueue.remove(0);
                break;
            }
        }
        this.nextRetransRequest = 0L;
        if (null == iQ) {
            return null;
        }
        this.sendACK(desiredSeqn);
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            long waited = TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), startDequeue);
            LOG.fine("DEQUEUED seqn#" + iQ.seqnum + " in " + waited + " msec on input queue");
            if (wct > 0) {
                LOG.fine("DEQUEUE waited " + wct + " times on input queue");
            }
        }
        return iQ.elt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        if (this.listener != null) {
            throw new IOException("available() not supported in async mode");
        }
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        Record record = this.record;
        synchronized (record) {
            if (this.record.inputStream != null) {
                if (this.record.size == 0L || this.record.nextByte == this.record.size) {
                    MessageElement elt;
                    if (this.inputQueue.isEmpty()) {
                        return 0;
                    }
                    this.record.resetRecord();
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Getting next data block at seqn#" + (this.sequenceNumber + 1));
                    }
                    if (null == (elt = this.dequeueMessage(this.sequenceNumber + 1, false))) {
                        return 0;
                    }
                    ++this.sequenceNumber;
                    this.record.size = elt.getByteLength();
                    this.record.inputStream = elt.getStream();
                }
                return this.record.inputStream.available();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int local_read(byte[] buf, int offset, int length) throws IOException {
        if (this.listener != null) {
            throw new IOException("read() not supported in async mode");
        }
        Record record = this.record;
        synchronized (record) {
            int res;
            if (this.record.size == 0L || this.record.nextByte == this.record.size) {
                MessageElement elt;
                this.record.resetRecord();
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Getting next data block at seqn#" + (this.sequenceNumber + 1));
                }
                if (null == (elt = this.dequeueMessage(this.sequenceNumber + 1, true))) {
                    return -1;
                }
                ++this.sequenceNumber;
                this.record.size = elt.getByteLength();
                this.record.inputStream = elt.getStream();
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("new seqn#" + this.sequenceNumber + ", bytes = " + this.record.size);
                }
            }
            long left = this.record.size - this.record.nextByte;
            int copyLen = (int)Math.min((long)length, left);
            int copied = 0;
            while ((res = this.record.inputStream.read(buf, offset + copied, copyLen - copied)) >= 0 && (copied += res) < copyLen) {
            }
            this.record.nextByte += (long)copied;
            if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                LOG.finer("Requested " + length + ", Read " + copied + " bytes");
            }
            return copied;
        }
    }

    public MsgListener getListener() {
        return this.listener;
    }

    public static interface MsgListener {
        public void processIncomingMessage(Message var1);
    }

    private static class IQElt
    implements Comparable {
        final int seqnum;
        final MessageElement elt;
        boolean ackd = false;

        IQElt(int sequence, MessageElement element2) {
            this.seqnum = sequence;
            this.elt = element2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof IQElt) {
                IQElt targ = (IQElt)obj;
                return this.seqnum == targ.seqnum;
            }
            return false;
        }

        public int compareTo(IQElt el) {
            return this.seqnum < el.seqnum ? -1 : (this.seqnum == el.seqnum ? 0 : 1);
        }

        public int compareTo(Object o) {
            return this.compareTo((IQElt)o);
        }
    }

    private static class Record {
        public InputStream inputStream = null;
        public long nextByte = 0L;
        public long size = 0L;

        public void resetRecord() {
            if (null != this.inputStream) {
                try {
                    this.inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.inputStream = null;
            this.nextByte = 0L;
            this.size = 0L;
        }
    }
}

