/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.xindice.core.filer;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.impl.xindice.core.DBException;
import net.jxta.impl.xindice.core.data.Value;
import net.jxta.impl.xindice.core.filer.BTreeCallback;
import net.jxta.impl.xindice.core.filer.BTreeCorruptException;
import net.jxta.impl.xindice.core.filer.BTreeException;
import net.jxta.impl.xindice.core.filer.BTreeNotFoundException;
import net.jxta.impl.xindice.core.filer.Paged;
import net.jxta.impl.xindice.core.indexer.IndexQuery;
import net.jxta.logging.Logging;

public class BTree
extends Paged {
    private static final Logger LOG = Logger.getLogger(BTree.class.getName());
    protected static final byte LEAF = 1;
    protected static final byte BRANCH = 2;
    protected static final byte STREAM = 3;
    private final Map<Long, WeakReference<BTreeNode>> cache = new WeakHashMap<Long, WeakReference<BTreeNode>>();
    private BTreeFileHeader fileHeader = (BTreeFileHeader)this.getFileHeader();
    private BTreeRootInfo rootInfo;
    private BTreeNode rootNode;

    public BTree() {
    }

    public BTree(File file) {
        this();
        this.setFile(file);
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public boolean open() throws DBException {
        if (super.open()) {
            long p = this.fileHeader.getRootPage();
            this.rootInfo = new BTreeRootInfo(p);
            this.rootNode = this.getBTreeNode(p, null);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean create() throws DBException {
        block6: {
            if (super.create()) {
                try {
                    super.open();
                    long p = this.fileHeader.getRootPage();
                    this.rootInfo = new BTreeRootInfo(p);
                    this.rootNode = new BTreeNode(this.getPage(p), null, new Value[0], new long[0]);
                    this.rootNode.ph.setStatus((byte)1);
                    this.rootNode.write();
                    Map<Long, WeakReference<BTreeNode>> map = this.cache;
                    synchronized (map) {
                        this.cache.put(this.rootNode.page.getPageNum(), new WeakReference<BTreeNode>(this.rootNode));
                    }
                    this.close();
                    return true;
                }
                catch (Exception e) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block6;
                    LOG.log(Level.WARNING, "Failed to create BTree, return false", e);
                }
            }
        }
        return false;
    }

    public long addValue(Value value, long pointer) throws IOException, BTreeException {
        return this.getRootNode().addValue(value, pointer);
    }

    public long addValue(BTreeRootInfo root, Value value, long pointer) throws IOException, BTreeException {
        return this.getRootNode(root).addValue(value, pointer);
    }

    public long removeValue(Value value) throws IOException, BTreeException {
        return this.getRootNode().removeValue(value);
    }

    public long removeValue(BTreeRootInfo root, Value value) throws IOException, BTreeException {
        return this.getRootNode(root).removeValue(value);
    }

    public long findValue(Value value) throws IOException, BTreeException {
        return this.getRootNode().findValue(value);
    }

    public long findValue(BTreeRootInfo root, Value value) throws IOException, BTreeException {
        return this.getRootNode(root).findValue(value);
    }

    public void query(IndexQuery query, BTreeCallback callback) throws IOException, BTreeException {
        this.getRootNode().query(query, callback);
    }

    public void query(BTreeRootInfo root, IndexQuery query, BTreeCallback callback) throws IOException, BTreeException {
        this.getRootNode(root).query(query, callback);
    }

    protected final BTreeRootInfo createBTreeRoot(Value v) throws IOException, BTreeException {
        BTreeNode n = this.createBTreeNode((byte)1, null);
        n.write();
        long position = n.page.getPageNum();
        this.addValue(v, position);
        return new BTreeRootInfo(v, position);
    }

    protected final BTreeRootInfo createBTreeRoot(BTreeRootInfo root, Value v) throws IOException, BTreeException {
        BTreeNode n = this.createBTreeNode((byte)1, null);
        n.write();
        long position = n.page.getPageNum();
        this.addValue(v, position);
        return new BTreeRootInfo(root, v, position);
    }

    protected final BTreeRootInfo findBTreeRoot(Value v) throws IOException, BTreeException {
        long position = this.findValue(v);
        return new BTreeRootInfo(v, position);
    }

    protected final BTreeRootInfo findBTreeRoot(BTreeRootInfo root, Value v) throws IOException, BTreeException {
        long position = this.findValue(root, v);
        return new BTreeRootInfo(root, v, position);
    }

    protected final void setRootNode(BTreeRootInfo root, BTreeNode newRoot) throws IOException, BTreeException {
        BTreeRootInfo parent = root.getParent();
        if (parent == null) {
            this.rootNode = newRoot;
            long p = this.rootNode.page.getPageNum();
            this.rootInfo.setPage(p);
            this.fileHeader.setRootPage(p);
        } else {
            long p = newRoot.page.getPageNum();
            root.setPage(p);
            this.addValue(parent, root.name, p);
        }
    }

    protected final void setRootNode(BTreeNode rootNode) throws IOException, BTreeException {
        this.setRootNode(this.rootInfo, rootNode);
    }

    protected final BTreeNode getRootNode(BTreeRootInfo root) {
        if (root.page == this.rootInfo.page) {
            return this.rootNode;
        }
        return this.getBTreeNode(root.getPage(), null);
    }

    protected final BTreeNode getRootNode() {
        return this.rootNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BTreeNode getBTreeNode(long page, BTreeNode parent) {
        try {
            BTreeNode node = null;
            Map<Long, WeakReference<BTreeNode>> map = this.cache;
            synchronized (map) {
                WeakReference<BTreeNode> ref = this.cache.get(page);
                if (ref != null) {
                    node = (BTreeNode)ref.get();
                }
                if (node == null) {
                    node = new BTreeNode(this.getPage(page), parent);
                } else {
                    node.parent = parent;
                }
                this.cache.put(node.page.getPageNum(), new WeakReference<BTreeNode>(node));
            }
            node.read();
            return node;
        }
        catch (Exception e) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Ignored exception", e);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BTreeNode createBTreeNode(byte status, BTreeNode parent) throws IOException {
        Paged.Page p = this.getFreePage();
        BTreeNode node = new BTreeNode(p, parent, new Value[0], new long[0]);
        node.ph.setStatus(status);
        Map<Long, WeakReference<BTreeNode>> map = this.cache;
        synchronized (map) {
            this.cache.put(p.getPageNum(), new WeakReference<BTreeNode>(node));
        }
        return node;
    }

    public Paged.FileHeader createFileHeader() {
        BTreeFileHeader header = new BTreeFileHeader();
        header.setPageCount(1L);
        header.setTotalCount(1L);
        return header;
    }

    public Paged.FileHeader createFileHeader(boolean read) throws IOException {
        return new BTreeFileHeader(read);
    }

    public Paged.FileHeader createFileHeader(long pageCount) {
        return new BTreeFileHeader(pageCount);
    }

    public Paged.FileHeader createFileHeader(long pageCount, int pageSize) {
        return new BTreeFileHeader(pageCount, pageSize);
    }

    public Paged.PageHeader createPageHeader() {
        return new BTreePageHeader();
    }

    protected class BTreePageHeader
    extends Paged.PageHeader {
        private short valueCount;

        public BTreePageHeader() {
            this.valueCount = 0;
        }

        public BTreePageHeader(DataInputStream dis) throws IOException {
            super(dis);
            this.valueCount = 0;
        }

        public synchronized void read(DataInputStream dis) throws IOException {
            super.read(dis);
            if (this.getStatus() == 0) {
                return;
            }
            this.valueCount = dis.readShort();
        }

        public synchronized void write(DataOutputStream dos) throws IOException {
            super.write(dos);
            dos.writeShort(this.valueCount);
        }

        public final synchronized void setValueCount(short valueCount) {
            this.valueCount = valueCount;
            this.setDirty();
        }

        public final synchronized short getValueCount() {
            return this.valueCount;
        }

        public final synchronized short getPointerCount() {
            if (this.getStatus() == 2) {
                return (short)(this.valueCount + 1);
            }
            return this.valueCount;
        }
    }

    protected class BTreeFileHeader
    extends Paged.FileHeader {
        private long rootPage;

        public BTreeFileHeader() {
            this.rootPage = 0L;
        }

        public BTreeFileHeader(long pageCount) {
            super(pageCount);
            this.rootPage = 0L;
        }

        public BTreeFileHeader(long pageCount, int pageSize) {
            super(pageCount, pageSize);
            this.rootPage = 0L;
        }

        public BTreeFileHeader(boolean read) throws IOException {
            super(read);
            this.rootPage = 0L;
        }

        public synchronized void read(RandomAccessFile raf) throws IOException {
            super.read(raf);
            this.rootPage = raf.readLong();
        }

        public synchronized void write(RandomAccessFile raf) throws IOException {
            super.write(raf);
            raf.writeLong(this.rootPage);
        }

        public final synchronized void setRootPage(long rootPage) {
            this.rootPage = rootPage;
            this.setDirty();
        }

        public final synchronized long getRootPage() {
            return this.rootPage;
        }
    }

    private final class BTreeNode {
        private final Paged.Page page;
        private final BTreePageHeader ph;
        private Value[] values;
        private long[] ptrs;
        private BTreeNode parent;
        private boolean loaded;

        public BTreeNode(Paged.Page page) {
            this(page, null);
        }

        public BTreeNode(Paged.Page page, BTreeNode parent) {
            this.page = page;
            this.parent = parent;
            this.ph = (BTreePageHeader)page.getPageHeader();
        }

        public BTreeNode(Paged.Page page, BTreeNode parent, Value[] values, long[] ptrs) {
            this(page, parent);
            this.set(values, ptrs);
            this.loaded = true;
        }

        private void set(Value[] values, long[] ptrs) {
            this.values = values;
            this.ph.setValueCount((short)values.length);
            this.ptrs = ptrs;
        }

        public synchronized void read() throws IOException {
            if (!this.loaded) {
                int i;
                Value v = BTree.this.readValue(this.page);
                DataInputStream is = new DataInputStream(v.getInputStream());
                this.values = new Value[this.ph.getValueCount()];
                for (i = 0; i < this.values.length; ++i) {
                    short valSize = is.readShort();
                    byte[] b = new byte[valSize];
                    is.read(b);
                    this.values[i] = new Value(b);
                }
                this.ptrs = new long[this.ph.getPointerCount()];
                for (i = 0; i < this.ptrs.length; ++i) {
                    this.ptrs[i] = is.readLong();
                }
                this.loaded = true;
            }
        }

        public synchronized void write() throws IOException {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(BTree.this.fileHeader.getWorkSize());
            DataOutputStream os = new DataOutputStream(bos);
            for (Value value : this.values) {
                os.writeShort(value.getLength());
                value.streamTo(os);
            }
            for (long ptr : this.ptrs) {
                os.writeLong(ptr);
            }
            BTree.this.writeValue(this.page, new Value(bos.toByteArray()));
        }

        private BTreeNode getChildNode(int idx) {
            if (this.ph.getStatus() == 2 && idx >= 0 && idx < this.ptrs.length) {
                return BTree.this.getBTreeNode(this.ptrs[idx], this);
            }
            return null;
        }

        public synchronized long removeValue(Value value) throws IOException, BTreeException {
            int idx = Arrays.binarySearch(this.values, value);
            switch (this.ph.getStatus()) {
                case 2: {
                    idx = idx < 0 ? -(idx + 1) : idx + 1;
                    return this.getChildNode(idx).removeValue(value);
                }
                case 1: {
                    if (idx < 0) {
                        throw new BTreeNotFoundException("Value '" + value + "' doesn't exist");
                    }
                    long oldPtr = this.ptrs[idx];
                    this.set(Paged.deleteArrayValue(this.values, idx), Paged.deleteArrayLong(this.ptrs, idx));
                    this.write();
                    return oldPtr;
                }
            }
            throw new BTreeCorruptException("Invalid page type '" + this.ph.getStatus() + "' in removeValue");
        }

        public synchronized long addValue(Value value, long pointer) throws IOException, BTreeException {
            if (value == null) {
                throw new BTreeException(571, "Can't add a null Value");
            }
            int idx = Arrays.binarySearch(this.values, value);
            switch (this.ph.getStatus()) {
                case 2: {
                    idx = idx < 0 ? -(idx + 1) : idx + 1;
                    return this.getChildNode(idx).addValue(value, pointer);
                }
                case 1: {
                    if (idx >= 0) {
                        long oldPtr = this.ptrs[idx];
                        this.ptrs[idx] = pointer;
                        this.set(this.values, this.ptrs);
                        this.write();
                        return oldPtr;
                    }
                    idx = -(idx + 1);
                    boolean split = this.needSplit(value);
                    this.set(Paged.insertArrayValue(this.values, value, idx), Paged.insertArrayLong(this.ptrs, pointer, idx));
                    if (split) {
                        this.split();
                    } else {
                        this.write();
                    }
                    return -1L;
                }
            }
            throw new BTreeCorruptException("Invalid Page Type In addValue");
        }

        private synchronized void promoteValue(Value value, long rightPointer) throws IOException, BTreeException {
            boolean split = this.needSplit(value);
            int idx = Arrays.binarySearch(this.values, value);
            idx = idx < 0 ? -(idx + 1) : idx + 1;
            this.set(Paged.insertArrayValue(this.values, value, idx), Paged.insertArrayLong(this.ptrs, rightPointer, idx + 1));
            if (split) {
                this.split();
            } else {
                this.write();
            }
        }

        private Value getSeparator(Value value1, Value value2) {
            int idx = value1.compareTo(value2);
            byte[] b = new byte[Math.abs(idx)];
            value2.copyTo(b, 0, b.length);
            return new Value(b);
        }

        private boolean needSplit(Value value) {
            return this.values.length > 4 && this.ph.getDataLen() + 8 + value.getLength() + 2 > BTree.this.fileHeader.getWorkSize();
        }

        private void split() throws IOException, BTreeException {
            Value separator;
            long[] rightPtrs;
            Value[] rightVals;
            long[] leftPtrs;
            Value[] leftVals;
            short vc = this.ph.getValueCount();
            int pivot = vc / 2;
            switch (this.ph.getStatus()) {
                case 2: {
                    leftVals = new Value[pivot];
                    leftPtrs = new long[leftVals.length + 1];
                    rightVals = new Value[vc - (pivot + 1)];
                    rightPtrs = new long[rightVals.length + 1];
                    System.arraycopy(this.values, 0, leftVals, 0, leftVals.length);
                    System.arraycopy(this.ptrs, 0, leftPtrs, 0, leftPtrs.length);
                    System.arraycopy(this.values, leftVals.length + 1, rightVals, 0, rightVals.length);
                    System.arraycopy(this.ptrs, leftPtrs.length, rightPtrs, 0, rightPtrs.length);
                    separator = this.values[leftVals.length];
                    break;
                }
                case 1: {
                    leftVals = new Value[pivot];
                    leftPtrs = new long[leftVals.length];
                    rightVals = new Value[vc - pivot];
                    rightPtrs = new long[rightVals.length];
                    System.arraycopy(this.values, 0, leftVals, 0, leftVals.length);
                    System.arraycopy(this.ptrs, 0, leftPtrs, 0, leftPtrs.length);
                    System.arraycopy(this.values, leftVals.length, rightVals, 0, rightVals.length);
                    System.arraycopy(this.ptrs, leftPtrs.length, rightPtrs, 0, rightPtrs.length);
                    separator = this.getSeparator(leftVals[leftVals.length - 1], rightVals[0]);
                    break;
                }
                default: {
                    throw new BTreeCorruptException("Invalid Page Type In split");
                }
            }
            if (this.parent == null) {
                BTreeNode rNode = BTree.this.createBTreeNode(this.ph.getStatus(), this);
                rNode.set(rightVals, rightPtrs);
                BTreeNode lNode = BTree.this.createBTreeNode(this.ph.getStatus(), this);
                lNode.set(leftVals, leftPtrs);
                this.ph.setStatus((byte)2);
                this.set(new Value[]{separator}, new long[]{lNode.page.getPageNum(), rNode.page.getPageNum()});
                this.write();
                rNode.write();
                lNode.write();
            } else {
                this.set(leftVals, leftPtrs);
                BTreeNode rNode = BTree.this.createBTreeNode(this.ph.getStatus(), this.parent);
                rNode.set(rightVals, rightPtrs);
                this.write();
                rNode.write();
                this.parent.promoteValue(separator, rNode.page.getPageNum());
            }
        }

        public synchronized long findValue(Value value) throws IOException, BTreeException {
            if (value == null) {
                throw new BTreeNotFoundException("Can't search on null Value");
            }
            int idx = Arrays.binarySearch(this.values, value);
            switch (this.ph.getStatus()) {
                case 2: {
                    idx = idx < 0 ? -(idx + 1) : idx + 1;
                    return this.getChildNode(idx).findValue(value);
                }
                case 1: {
                    if (idx < 0) {
                        throw new BTreeNotFoundException("Value '" + value + "' doesn't exist");
                    }
                    return this.ptrs[idx];
                }
            }
            throw new BTreeCorruptException("Invalid page type '" + this.ph.getStatus() + "' in findValue");
        }

        public synchronized void query(IndexQuery query, BTreeCallback callback) throws IOException, BTreeException {
            block51: {
                block50: {
                    if (query == null || query.getOperator() == 0) break block50;
                    Value[] qvals = query.getValues();
                    int leftIdx = Arrays.binarySearch(this.values, qvals[0]);
                    int rightIdx = qvals.length > 1 ? Arrays.binarySearch(this.values, qvals[qvals.length - 1]) : leftIdx;
                    switch (this.ph.getStatus()) {
                        case 2: {
                            leftIdx = leftIdx < 0 ? -(leftIdx + 1) : leftIdx + 1;
                            rightIdx = rightIdx < 0 ? -(rightIdx + 1) : rightIdx + 1;
                            switch (query.getOperator()) {
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: {
                                    if (leftIdx < 0) {
                                        leftIdx = 0;
                                    }
                                    if (rightIdx > this.ptrs.length - 1) {
                                        rightIdx = this.ptrs.length - 1;
                                    }
                                    for (int i = leftIdx; i <= rightIdx; ++i) {
                                        this.getChildNode(i).query(query, callback);
                                    }
                                    break block51;
                                }
                                case -7: 
                                case -6: 
                                case -5: 
                                case -4: {
                                    int i;
                                    if (leftIdx > this.ptrs.length - 1) {
                                        leftIdx = this.ptrs.length - 1;
                                    }
                                    for (i = 0; i <= leftIdx; ++i) {
                                        this.getChildNode(i).query(query, callback);
                                    }
                                    if (rightIdx < 0) {
                                        rightIdx = 0;
                                    }
                                    for (i = rightIdx; i < this.ptrs.length; ++i) {
                                        this.getChildNode(i).query(query, callback);
                                    }
                                    break block51;
                                }
                                case 1: {
                                    this.getChildNode(leftIdx).query(query, callback);
                                    break;
                                }
                                case -2: 
                                case 3: {
                                    if (leftIdx > this.ptrs.length - 1) {
                                        leftIdx = this.ptrs.length - 1;
                                    }
                                    for (int i = 0; i <= leftIdx; ++i) {
                                        this.getChildNode(i).query(query, callback);
                                    }
                                    break block51;
                                }
                                case -3: 
                                case 2: {
                                    if (rightIdx < 0) {
                                        rightIdx = 0;
                                    }
                                    for (int i = rightIdx; i < this.ptrs.length; ++i) {
                                        this.getChildNode(i).query(query, callback);
                                    }
                                    break block51;
                                }
                                default: {
                                    for (int i = 0; i < this.ptrs.length; ++i) {
                                        this.getChildNode(i).query(query, callback);
                                    }
                                    break block51;
                                }
                            }
                            break block51;
                        }
                        case 1: {
                            switch (query.getOperator()) {
                                case 1: {
                                    if (leftIdx >= 0) {
                                        callback.indexInfo(this.values[leftIdx], this.ptrs[leftIdx]);
                                        break;
                                    }
                                    break block51;
                                }
                                case -1: {
                                    for (int i = 0; i < this.ptrs.length; ++i) {
                                        if (i == leftIdx) continue;
                                        callback.indexInfo(this.values[i], this.ptrs[i]);
                                    }
                                    break block51;
                                }
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: {
                                    if (leftIdx < 0) {
                                        leftIdx = -(leftIdx + 1);
                                    }
                                    if (rightIdx < 0) {
                                        rightIdx = -(rightIdx + 1);
                                    }
                                    for (int i = 0; i < this.ptrs.length; ++i) {
                                        if (i < leftIdx || i > rightIdx || !query.testValue(this.values[i])) continue;
                                        callback.indexInfo(this.values[i], this.ptrs[i]);
                                    }
                                    break block51;
                                }
                                case -7: 
                                case -5: 
                                case -4: {
                                    if (leftIdx < 0) {
                                        leftIdx = -(leftIdx + 1);
                                    }
                                    if (rightIdx < 0) {
                                        rightIdx = -(rightIdx + 1);
                                    }
                                    for (int i = 0; i < this.ptrs.length; ++i) {
                                        if (i > leftIdx && i < rightIdx || !query.testValue(this.values[i])) continue;
                                        callback.indexInfo(this.values[i], this.ptrs[i]);
                                    }
                                    break block51;
                                }
                                case -2: 
                                case 3: {
                                    if (leftIdx < 0) {
                                        leftIdx = -(leftIdx + 1);
                                    }
                                    for (int i = 0; i < this.ptrs.length; ++i) {
                                        if (i > leftIdx || !query.testValue(this.values[i])) continue;
                                        callback.indexInfo(this.values[i], this.ptrs[i]);
                                    }
                                    break block51;
                                }
                                case -3: 
                                case 2: {
                                    if (rightIdx < 0) {
                                        rightIdx = -(rightIdx + 1);
                                    }
                                    for (int i = 0; i < this.ptrs.length; ++i) {
                                        if (i < rightIdx || !query.testValue(this.values[i])) continue;
                                        callback.indexInfo(this.values[i], this.ptrs[i]);
                                    }
                                    break block51;
                                }
                                default: {
                                    for (int i = 0; i < this.ptrs.length; ++i) {
                                        if (!query.testValue(this.values[i])) continue;
                                        callback.indexInfo(this.values[i], this.ptrs[i]);
                                    }
                                    break block51;
                                }
                            }
                            break block51;
                        }
                        default: {
                            throw new BTreeCorruptException("Invalid Page Type In query");
                        }
                    }
                }
                switch (this.ph.getStatus()) {
                    case 2: {
                        for (int i = 0; i < this.ptrs.length; ++i) {
                            this.getChildNode(i).query(query, callback);
                        }
                        break;
                    }
                    case 1: {
                        for (int i = 0; i < this.values.length; ++i) {
                            callback.indexInfo(this.values[i], this.ptrs[i]);
                        }
                        break;
                    }
                    default: {
                        throw new BTreeCorruptException("Invalid Page Type In query");
                    }
                }
            }
        }
    }

    public final class BTreeRootInfo {
        private final BTreeRootInfo parent;
        private final Value name;
        private long page;

        public BTreeRootInfo(BTreeRootInfo parent, String name, long page) {
            this.parent = parent;
            this.name = new Value(name);
            this.page = page;
        }

        public BTreeRootInfo(BTreeRootInfo parent, Value name, long page) {
            this.parent = parent;
            this.name = name;
            this.page = page;
        }

        public BTreeRootInfo(String name, long page) {
            this.parent = BTree.this.rootInfo;
            this.name = new Value(name);
            this.page = page;
        }

        public BTreeRootInfo(Value name, long page) {
            this.parent = BTree.this.rootInfo;
            this.name = name;
            this.page = page;
        }

        private BTreeRootInfo(long page) {
            this.parent = null;
            this.name = null;
            this.page = page;
        }

        public BTreeRootInfo getParent() {
            return this.parent;
        }

        public Value getName() {
            return this.name;
        }

        public synchronized long getPage() {
            return this.page;
        }

        public synchronized void setPage(long page) {
            this.page = page;
        }
    }
}

