/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.peergroup;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLElement;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.peergroup.GenericPeerGroup;
import net.jxta.impl.protocol.PeerGroupConfigAdv;
import net.jxta.logging.Logging;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.peergroup.WorldPeerGroupFactory;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.ModuleImplAdvertisement;

public final class NetPeerGroupFactory {
    private static final transient Logger LOG = Logger.getLogger(NetPeerGroupFactory.class.getName());
    private final PeerGroup net;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetPeerGroupFactory() throws PeerGroupException {
        WorldPeerGroupFactory world = new WorldPeerGroupFactory();
        PeerGroup worldGroup = world.getInterface();
        try {
            NetGroupTunables tunables;
            ConfigParams cp = worldGroup.getConfigAdvertisement();
            PeerGroupConfigAdv netGroupConfig = (PeerGroupConfigAdv)cp.getSvcConfigAdvertisement(PeerGroup.peerGroupClassID);
            if (null == netGroupConfig) {
                tunables = new NetGroupTunables(ResourceBundle.getBundle("net.jxta.impl.config"), new NetGroupTunables());
                URI storeHome = worldGroup.getStoreHome();
                if (null != storeHome) {
                    try {
                        File configProperties = new File(new File(storeHome), "config.properties");
                        PropertyResourceBundle rsrcs = new PropertyResourceBundle(new FileInputStream(configProperties));
                        tunables = new NetGroupTunables(rsrcs, tunables);
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Loaded defaults from " + rsrcs);
                        }
                    }
                    catch (MissingResourceException ignored) {
                    }
                    catch (IOException ignored) {}
                }
            } else {
                tunables = new NetGroupTunables(netGroupConfig.getPeerGroupID(), netGroupConfig.getName(), netGroupConfig.getDesc());
            }
            this.net = this.newNetPeerGroup(worldGroup, null, tunables.id, tunables.name, tunables.desc, null);
            Object var10_11 = null;
            worldGroup.unref();
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            worldGroup.unref();
            throw throwable;
        }
    }

    public NetPeerGroupFactory(PeerGroup parentGroup) throws PeerGroupException {
        ConfigParams cp = parentGroup.getConfigAdvertisement();
        PeerGroupConfigAdv netGroupConfig = (PeerGroupConfigAdv)cp.getSvcConfigAdvertisement(PeerGroup.peerGroupClassID);
        NetGroupTunables tunables = null == netGroupConfig ? new NetGroupTunables(ResourceBundle.getBundle("net.jxta.impl.config"), new NetGroupTunables()) : new NetGroupTunables(netGroupConfig.getPeerGroupID(), netGroupConfig.getName(), netGroupConfig.getDesc());
        this.net = this.newNetPeerGroup(parentGroup, null, tunables.id, tunables.name, tunables.desc, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetPeerGroupFactory(ConfigParams config, URI storeHome) throws PeerGroupException {
        WorldPeerGroupFactory world = new WorldPeerGroupFactory(config, storeHome);
        PeerGroup worldGroup = world.getInterface();
        try {
            PeerGroupConfigAdv netGroupConfig = (PeerGroupConfigAdv)config.getSvcConfigAdvertisement(PeerGroup.peerGroupClassID);
            NetGroupTunables tunables = null == netGroupConfig ? new NetGroupTunables(ResourceBundle.getBundle("net.jxta.impl.config"), new NetGroupTunables()) : new NetGroupTunables(netGroupConfig.getPeerGroupID(), netGroupConfig.getName(), netGroupConfig.getDesc());
            this.net = this.newNetPeerGroup(worldGroup, config, tunables.id, tunables.name, tunables.desc, null);
            Object var8_7 = null;
            worldGroup.unref();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            worldGroup.unref();
            throw throwable;
        }
    }

    public NetPeerGroupFactory(PeerGroup parentGroup, ConfigParams config, URI storeHome) throws PeerGroupException {
        if (config != parentGroup.getConfigAdvertisement()) {
            throw new IllegalArgumentException("This constructor cannot currently accept group parameters different than the parent group");
        }
        if (null == storeHome ? null != parentGroup.getStoreHome() : !storeHome.equals(parentGroup.getStoreHome())) {
            throw new IllegalArgumentException("This constructor cannot currently accept a different store location than the parent group");
        }
        ConfigParams cp = parentGroup.getConfigAdvertisement();
        PeerGroupConfigAdv netGroupConfig = (PeerGroupConfigAdv)cp.getSvcConfigAdvertisement(PeerGroup.peerGroupClassID);
        NetGroupTunables tunables = null == netGroupConfig ? new NetGroupTunables(ResourceBundle.getBundle("net.jxta.impl.config"), new NetGroupTunables()) : new NetGroupTunables(netGroupConfig.getPeerGroupID(), netGroupConfig.getName(), netGroupConfig.getDesc());
        this.net = this.newNetPeerGroup(parentGroup, config, tunables.id, tunables.name, tunables.desc, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public NetPeerGroupFactory(ConfigParams config, URI storeHome, ID id, String name, XMLElement desc) throws PeerGroupException {
        WorldPeerGroupFactory world = new WorldPeerGroupFactory(config, storeHome);
        PeerGroup worldGroup = world.getInterface();
        try {
            this.net = this.newNetPeerGroup(worldGroup, config, id, name, desc, null);
            Object var9_8 = null;
            worldGroup.unref();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            worldGroup.unref();
            throw throwable;
        }
    }

    @Deprecated
    public NetPeerGroupFactory(PeerGroup parentGroup, ID id, String name, XMLElement desc) throws PeerGroupException {
        this.net = this.newNetPeerGroup(parentGroup, null, id, name, desc, null);
    }

    @Deprecated
    public NetPeerGroupFactory(PeerGroup parentGroup, ID id, String name, XMLElement desc, ModuleImplAdvertisement moduleImplAdv) throws PeerGroupException {
        this.net = this.newNetPeerGroup(parentGroup, null, id, name, desc, moduleImplAdv);
    }

    public NetPeerGroupFactory(PeerGroup parentGroup, ConfigParams config, ModuleImplAdvertisement moduleImplAdv) throws PeerGroupException {
        PeerGroupConfigAdv netGroupConfig = (PeerGroupConfigAdv)config.getSvcConfigAdvertisement(PeerGroup.peerGroupClassID);
        NetGroupTunables tunables = null == netGroupConfig ? new NetGroupTunables(ResourceBundle.getBundle("net.jxta.impl.config"), new NetGroupTunables()) : new NetGroupTunables(netGroupConfig.getPeerGroupID(), netGroupConfig.getName(), netGroupConfig.getDesc());
        this.net = this.newNetPeerGroup(parentGroup, config, tunables.id, tunables.name, tunables.desc, moduleImplAdv);
    }

    public PeerGroup getInterface() {
        return this.net.getInterface();
    }

    public PeerGroup getWeakInterface() {
        return this.net.getWeakInterface();
    }

    private PeerGroup newNetPeerGroup(PeerGroup parentGroup, ConfigParams config, ID id, String name, XMLElement desc, ModuleImplAdvertisement implAdv) throws PeerGroupException {
        PeerGroup.GlobalRegistry globalRegistry = PeerGroup.globalRegistry;
        synchronized (globalRegistry) {
            PeerGroup result = PeerGroup.globalRegistry.lookupInstance((PeerGroupID)id);
            if (null != result) {
                result.unref();
                throw new PeerGroupException("Only a single instance of a Peer Group may be instantiated at a single time.");
            }
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.info("Instantiating net peer group : " + id + "\n\tParent : " + parentGroup + "\n\tID : " + id + "\n\tName : " + name + "\n\timpl : " + implAdv);
            }
            try {
                if (null == implAdv) {
                    implAdv = parentGroup.getAllPurposePeerGroupImplAdvertisement();
                }
                GenericPeerGroup.setGroupConfigAdvertisement(id, config);
                result = (PeerGroup)parentGroup.loadModule(id, implAdv);
                if (null != desc) {
                    result.publishGroup(name, desc.getTextValue());
                } else {
                    result.publishGroup(name, null);
                }
                return result;
            }
            catch (PeerGroupException failed) {
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "newNetPeerGroup failed", failed);
                }
                throw failed;
            }
            catch (RuntimeException e) {
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "newNetPeerGroup failed", e);
                }
                throw e;
            }
            catch (Exception e) {
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "newNetPeerGroup failed", e);
                }
                throw new PeerGroupException("newNetPeerGroup failed", e);
            }
        }
    }

    static class NetGroupTunables {
        final ID id;
        final String name;
        final XMLElement desc;

        NetGroupTunables() {
            this.id = PeerGroupID.defaultNetPeerGroupID;
            this.name = "NetPeerGroup";
            this.desc = (XMLElement)((Object)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "desc", "default Net Peer Group"));
        }

        NetGroupTunables(ID pgid, String pgname, XMLElement pgdesc) {
            this.id = pgid;
            this.name = pgname;
            this.desc = pgdesc;
        }

        NetGroupTunables(ResourceBundle rsrcs, NetGroupTunables defaults) {
            XMLElement descTmp;
            String nameTmp;
            ID idTmp;
            try {
                String idTmpStr = rsrcs.getString("NetPeerGroupID").trim();
                if (idTmpStr.startsWith("jxta:")) {
                    idTmpStr = idTmpStr.substring(5);
                }
                idTmp = IDFactory.fromURI(new URI("urn:jxta:" + idTmpStr));
                nameTmp = rsrcs.getString("NetPeerGroupName").trim();
                descTmp = (XMLElement)((Object)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "desc", rsrcs.getString("NetPeerGroupDesc").trim()));
            }
            catch (Exception failed) {
                if (null != defaults) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "NetPeerGroup tunables not defined or could not be loaded. Using defaults.", failed);
                    }
                    idTmp = defaults.id;
                    nameTmp = defaults.name;
                    descTmp = defaults.desc;
                }
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "NetPeerGroup tunables not defined or could not be loaded.", failed);
                }
                throw new IllegalStateException("NetPeerGroup tunables not defined or could not be loaded.");
            }
            this.id = idTmp;
            this.name = nameTmp;
            this.desc = descTmp;
        }
    }
}

