/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.platform;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.List;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.cert.CertificateException;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.membership.pse.PSEUtils;
import net.jxta.impl.protocol.HTTPAdv;
import net.jxta.impl.protocol.PSEConfigAdv;
import net.jxta.impl.protocol.PeerGroupConfigAdv;
import net.jxta.impl.protocol.PlatformConfig;
import net.jxta.impl.protocol.RdvConfigAdv;
import net.jxta.impl.protocol.RelayConfigAdv;
import net.jxta.impl.protocol.TCPAdv;
import net.jxta.logging.Logging;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.TransportAdvertisement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkConfigurator {
    private static final transient Logger LOG = Logger.getLogger(NetworkConfigurator.class.getName());
    public static final int RELAY_OFF = 4;
    public static final int RELAY_CLIENT = 8;
    public static final int RELAY_SERVER = 16;
    public static final int PROXY_SERVER = 32;
    public static final int TCP_CLIENT = 64;
    public static final int TCP_SERVER = 128;
    public static final int HTTP_CLIENT = 256;
    public static final int HTTP_SERVER = 512;
    public static final int IP_MULTICAST = 1024;
    public static final int RDV_SERVER = 2048;
    public static final int RDV_CLIENT = 4096;
    public static final int RDV_AD_HOC = 8192;
    public static final int ADHOC_NODE = 9412;
    public static final int EDGE_NODE = 5576;
    public static final int RDV_NODE = 2752;
    public static final int RELAY_NODE = 720;
    public static final int PROXY_NODE = 752;
    public static final int RDV_RELAY_PROXY_NODE = 2800;
    protected transient int mode = 5576;
    protected transient String description = "Platform Config Advertisement created by : " + NetworkConfigurator.class.getName();
    private transient URI storeHome = null;
    protected transient String name = "unknown";
    protected transient String password = null;
    protected transient PeerID peerid = IDFactory.newPeerID(PeerGroupID.defaultNetPeerGroupID);
    protected transient String principal = null;
    protected transient X509Certificate[] cert = null;
    protected transient PrivateKey subjectPkey = null;
    protected transient URI keyStoreLocation = null;
    protected transient XMLElement proxyConfig;
    protected transient PSEConfigAdv pseConf;
    protected transient RdvConfigAdv rdvConfig;
    protected URI rdvSeedingURI = null;
    protected transient RelayConfigAdv relayConfig;
    protected transient URI relaySeedingURI = null;
    protected transient TCPAdv tcpConfig;
    protected transient boolean tcpEnabled = true;
    protected transient HTTPAdv httpConfig;
    protected transient boolean httpEnabled = true;
    protected transient PeerGroupConfigAdv infraPeerGroupConfig;

    public static NetworkConfigurator newAdHocConfiguration(URI storeHome) {
        return new NetworkConfigurator(9412, storeHome);
    }

    public static NetworkConfigurator newEdgeConfiguration(URI storeHome) {
        return new NetworkConfigurator(5576, storeHome);
    }

    public static NetworkConfigurator newRdvConfiguration(URI storeHome) {
        return new NetworkConfigurator(2752, storeHome);
    }

    public static NetworkConfigurator newRelayConfiguration(URI storeHome) {
        return new NetworkConfigurator(720, storeHome);
    }

    public static NetworkConfigurator newRdvRelayConfiguration(URI storeHome) {
        return new NetworkConfigurator(2768, storeHome);
    }

    public static NetworkConfigurator newProxyConfiguration(URI storeHome) {
        return new NetworkConfigurator(752, storeHome);
    }

    public static NetworkConfigurator newRdvRelayProxyConfiguration(URI storeHome) {
        return new NetworkConfigurator(2800, storeHome);
    }

    public NetworkConfigurator() {
        this(5576, new File(".jxta").toURI());
    }

    public NetworkConfigurator(int mode, URI storeHome) {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Creating a default configuration");
        }
        this.setStoreHome(storeHome);
        this.httpConfig = this.createHttpAdv();
        this.rdvConfig = this.createRdvConfigAdv();
        this.relayConfig = this.createRelayConfigAdv();
        this.proxyConfig = this.createProxyAdv();
        this.tcpConfig = this.createTcpAdv();
        this.infraPeerGroupConfig = this.createInfraConfigAdv();
        this.setMode(mode);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setHome(File home) {
        this.storeHome = home.toURI();
    }

    public File getHome() {
        if ("file".equalsIgnoreCase(this.storeHome.getScheme())) {
            return new File(this.storeHome);
        }
        throw new UnsupportedOperationException("Home location is not a file:// URI : " + this.storeHome);
    }

    public URI getStoreHome() {
        return this.storeHome;
    }

    public void setStoreHome(URI newHome) {
        if (!newHome.isAbsolute()) {
            throw new IllegalArgumentException("Only absolute URIs accepted for store home location.");
        }
        if (newHome.isOpaque()) {
            throw new IllegalArgumentException("Only hierarchical URIs accepted for store home location.");
        }
        if (!"file".equalsIgnoreCase(newHome.getScheme())) {
            throw new IllegalArgumentException("Only file based URI currently supported");
        }
        if (!newHome.toString().endsWith("/")) {
            newHome = URI.create(newHome.toString() + "/");
        }
        this.storeHome = newHome;
    }

    public void setHttpEnabled(boolean enabled) {
        this.httpEnabled = enabled;
        if (!this.httpEnabled) {
            this.httpConfig.setClientEnabled(false);
            this.httpConfig.setServerEnabled(false);
        }
    }

    public void setHttpIncoming(boolean incoming) {
        this.httpConfig.setServerEnabled(incoming);
    }

    public void setHttpOutgoing(boolean outgoing) {
        this.httpConfig.setClientEnabled(outgoing);
    }

    public void setHttpPort(int port) {
        this.httpConfig.setPort(port);
    }

    public void setHttpInterfaceAddress(String address) {
        this.httpConfig.setInterfaceAddress(address);
    }

    public void setHttpPublicAddress(String address, boolean exclusive) {
        this.httpConfig.setServer(address);
        this.httpConfig.setPublicAddressOnly(exclusive);
    }

    public void setInfrastructureID(ID id) {
        if (id == null || id.equals(ID.nullID)) {
            throw new IllegalArgumentException("PeerGroupID can not be null");
        }
        this.infraPeerGroupConfig.setPeerGroupID(id);
    }

    public void setInfrastructureID(String idStr) {
        if (idStr == null || idStr.length() == 0) {
            throw new IllegalArgumentException("PeerGroupID string can not be empty or null");
        }
        PeerGroupID pgid = (PeerGroupID)ID.create(URI.create(idStr));
        this.setInfrastructureID(pgid);
    }

    public String getInfrastructureIDStr() {
        return this.infraPeerGroupConfig.getPeerGroupID().toString();
    }

    public void setInfrastructureName(String name) {
        this.infraPeerGroupConfig.setName(name);
    }

    public String getInfrastructureName() {
        return this.infraPeerGroupConfig.getName();
    }

    public void setInfrastructureDescriptionStr(String description) {
        this.infraPeerGroupConfig.setDescription(description);
    }

    public String getInfrastructureDescriptionStr() {
        return this.infraPeerGroupConfig.getDescription();
    }

    public void setInfrastructureDesc(XMLElement description) {
        this.infraPeerGroupConfig.setDesc(description);
    }

    public void setMode(int mode) {
        this.mode = mode;
        if ((mode & 0x20) == 32 && (mode & 0x10) != 16) {
            mode |= 0x10;
        }
        this.relayConfig.setClientEnabled((mode & 8) == 8);
        this.relayConfig.setServerEnabled((mode & 0x10) == 16);
        if ((mode & 0x800) == 2048) {
            this.rdvConfig.setConfiguration(RdvConfigAdv.RendezVousConfiguration.RENDEZVOUS);
        } else if ((mode & 0x1000) == 4096) {
            this.rdvConfig.setConfiguration(RdvConfigAdv.RendezVousConfiguration.EDGE);
        } else if ((mode & 0x2000) == 8192) {
            this.rdvConfig.setConfiguration(RdvConfigAdv.RendezVousConfiguration.AD_HOC);
        }
        this.tcpConfig.setClientEnabled((mode & 0x40) == 64);
        this.tcpConfig.setServerEnabled((mode & 0x80) == 128);
        this.httpConfig.setClientEnabled((mode & 0x100) == 256);
        this.httpConfig.setServerEnabled((mode & 0x200) == 512);
        this.tcpConfig.setMulticastState((mode & 0x400) == 1024);
        if (mode == 5576) {
            this.rdvConfig.setConfiguration(RdvConfigAdv.RendezVousConfiguration.EDGE);
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void setMulticastSize(int size) {
        this.tcpConfig.setMulticastSize(size);
    }

    public int getMulticastSize() {
        return this.tcpConfig.getMulticastSize();
    }

    public void setMulticastAddress(String mcastAddress) {
        this.tcpConfig.setMulticastAddr(mcastAddress);
    }

    public String getMulticastInterface() {
        return this.tcpConfig.getMulticastInterface();
    }

    public void setMulticastInterface(String interfaceAddress) {
        this.tcpConfig.setMulticastInterface(interfaceAddress);
    }

    public void setMulticastPort(int port) {
        this.tcpConfig.setMulticastPort(port);
    }

    public void setMulticastPoolSize(int size) {
        this.tcpConfig.setMulticastPoolSize(size);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void setCertificate(X509Certificate cert) {
        this.cert = new X509Certificate[]{cert};
    }

    public X509Certificate getCertificate() {
        return this.cert == null || this.cert.length == 0 ? null : this.cert[0];
    }

    public void setCertificateChain(X509Certificate[] certificateChain) {
        this.cert = certificateChain;
    }

    public X509Certificate[] getCertificateChain() {
        return this.cert;
    }

    public void setPrivateKey(PrivateKey subjectPkey) {
        this.subjectPkey = subjectPkey;
    }

    public PrivateKey getPrivateKey() {
        return this.subjectPkey;
    }

    public void setKeyStoreLocation(URI keyStoreLocation) {
        this.keyStoreLocation = keyStoreLocation;
    }

    public URI getKeyStoreLocation() {
        return this.keyStoreLocation;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPeerID(PeerID peerid) {
        this.peerid = peerid;
    }

    public PeerID getPeerID() {
        return this.peerid;
    }

    public void addRdvSeedingURI(URI seedURI) {
        this.rdvConfig.addSeedingURI(seedURI);
    }

    public void setRdvACLURI(URI aclURI) {
        this.rdvConfig.setAclUri(aclURI);
    }

    public URI getRdvACLURI() {
        return this.rdvConfig.getAclUri();
    }

    public void setRelayACLURI(URI aclURI) {
        this.relayConfig.setAclUri(aclURI);
    }

    public URI getRelayACLURI() {
        return this.relayConfig.getAclUri();
    }

    public void setRelayMaxClients(int relayMaxClients) {
        if (relayMaxClients != -1 && relayMaxClients <= 0) {
            throw new IllegalArgumentException("Relay Max Clients : " + relayMaxClients + " must be > 0");
        }
        this.relayConfig.setMaxClients(relayMaxClients);
    }

    public void addRelaySeedingURI(URI seedURI) {
        this.relayConfig.addSeedingURI(seedURI);
    }

    public void setRendezvousMaxClients(int rdvMaxClients) {
        if (rdvMaxClients != -1 && rdvMaxClients <= 0) {
            throw new IllegalArgumentException("Rendezvous Max Clients : " + rdvMaxClients + " must be > 0");
        }
        this.rdvConfig.setMaxClients(rdvMaxClients);
    }

    public void setTcpEnabled(boolean enabled) {
        this.tcpEnabled = enabled;
        if (!this.tcpEnabled) {
            this.tcpConfig.setClientEnabled(false);
            this.tcpConfig.setServerEnabled(false);
        }
    }

    public void setTcpPort(int port) {
        this.tcpConfig.setPort(port);
    }

    public void setTcpStartPort(int start) {
        this.tcpConfig.setStartPort(start);
    }

    public void setTcpEndPort(int end) {
        this.tcpConfig.setEndPort(end);
    }

    public void setTcpIncoming(boolean incoming) {
        this.tcpConfig.setServerEnabled(incoming);
    }

    public void setTcpOutgoing(boolean outgoing) {
        this.tcpConfig.setClientEnabled(outgoing);
    }

    public void setTcpInterfaceAddress(String address) {
        this.tcpConfig.setInterfaceAddress(address);
    }

    public void setTcpPublicAddress(String address, boolean exclusive) {
        this.tcpConfig.setServer(address);
        this.tcpConfig.setPublicAddressOnly(exclusive);
    }

    public void setUseMulticast(boolean multicastOn) {
        this.tcpConfig.setMulticastState(multicastOn);
    }

    public void setUseOnlyRelaySeeds(boolean useOnlyRelaySeeds) {
        this.relayConfig.setUseOnlySeeds(useOnlyRelaySeeds);
    }

    public void setUseOnlyRendezvousSeeds(boolean useOnlyRendezvouSeeds) {
        this.rdvConfig.setUseOnlySeeds(useOnlyRendezvouSeeds);
    }

    public void addSeedRelay(URI seedURI) {
        this.relayConfig.addSeedRelay(seedURI.toString());
    }

    public void addSeedRendezvous(URI seedURI) {
        this.rdvConfig.addSeedRendezvous(seedURI);
    }

    public boolean exists() {
        URI platformConfig = this.storeHome.resolve("PlatformConfig");
        try {
            return null != this.read(platformConfig);
        }
        catch (IOException failed) {
            return false;
        }
    }

    public void setPeerId(String peerIdStr) {
        this.peerid = (PeerID)ID.create(URI.create(peerIdStr));
    }

    public void addRdvSeedingURI(String seedURIStr) {
        this.rdvConfig.addSeedingURI(URI.create(seedURIStr));
    }

    public void addRelaySeedingURI(String seedURIStr) {
        this.relayConfig.addSeedingURI(URI.create(seedURIStr));
    }

    public void setRelaySeedURIs(List<String> seeds) {
        this.relayConfig.clearSeedRelays();
        for (String seedStr : seeds) {
            this.relayConfig.addSeedRelay(new EndpointAddress(seedStr));
        }
    }

    public void setRelaySeedingURIs(Set<String> seedURIs) {
        this.relayConfig.clearSeedingURIs();
        for (String seedStr : seedURIs) {
            this.relayConfig.addSeedingURI(URI.create(seedStr));
        }
    }

    public void clearRelaySeeds() {
        this.relayConfig.clearSeedRelays();
    }

    public void clearRelaySeedingURIs() {
        this.relayConfig.clearSeedingURIs();
    }

    public void setRendezvousSeeds(Set<String> seeds) {
        this.rdvConfig.clearSeedRendezvous();
        for (String seedStr : seeds) {
            this.rdvConfig.addSeedRendezvous(URI.create(seedStr));
        }
    }

    @Deprecated
    public void setRendezvousSeedURIs(List<String> seedingURIs) {
        this.setRendezvousSeedingURIs(seedingURIs);
    }

    public void setRendezvousSeedingURIs(List<String> seedingURIs) {
        this.rdvConfig.clearSeedingURIs();
        for (String seedStr : seedingURIs) {
            this.rdvConfig.addSeedingURI(URI.create(seedStr));
        }
    }

    public void clearRendezvousSeeds() {
        this.rdvConfig.clearSeedRendezvous();
    }

    @Deprecated
    public void clearRendezvousSeedURIs() {
        this.rdvConfig.clearSeedingURIs();
    }

    public void clearRendezvousSeedingURIs() {
        this.rdvConfig.clearSeedingURIs();
    }

    public ConfigParams load() throws IOException, CertificateException {
        return this.load(this.storeHome.resolve("PlatformConfig"));
    }

    public ConfigParams load(URI uri) throws IOException, CertificateException {
        if (uri == null) {
            throw new IllegalArgumentException("URI can not be null");
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Loading configuration : " + uri);
        }
        PlatformConfig platformConfig = this.read(uri);
        this.name = platformConfig.getName();
        this.peerid = platformConfig.getPeerID();
        this.description = platformConfig.getDescription();
        XMLElement param = (XMLElement)((Object)platformConfig.getServiceParam(PeerGroup.tcpProtoClassID));
        this.tcpEnabled = platformConfig.isSvcEnabled(PeerGroup.tcpProtoClassID);
        Enumeration tcpChilds = param.getChildren(TransportAdvertisement.getAdvertisementType());
        if (!tcpChilds.hasMoreElements()) {
            throw new IllegalStateException("Missing TCP Advertisment");
        }
        param = (XMLElement)tcpChilds.nextElement();
        this.tcpConfig = (TCPAdv)AdvertisementFactory.newAdvertisement(param);
        try {
            param = (XMLElement)((Object)platformConfig.getServiceParam(PeerGroup.httpProtoClassID));
            this.httpEnabled = platformConfig.isSvcEnabled(PeerGroup.httpProtoClassID);
            Enumeration httpChilds = param.getChildren(TransportAdvertisement.getAdvertisementType());
            if (!httpChilds.hasMoreElements()) {
                throw new IllegalStateException("Missing HTTP Advertisment");
            }
            param = (XMLElement)httpChilds.nextElement();
            this.httpConfig = (HTTPAdv)AdvertisementFactory.newAdvertisement(param);
        }
        catch (Exception failure) {
            IOException ioe = new IOException("error processing the HTTP config advertisement");
            ioe.initCause(failure);
            throw ioe;
        }
        try {
            param = (XMLElement)((Object)platformConfig.getServiceParam(PeerGroup.proxyClassID));
            if (param != null && !platformConfig.isSvcEnabled(PeerGroup.proxyClassID)) {
                this.mode |= 0x20;
            }
        }
        catch (Exception failure) {
            IOException ioe = new IOException("error processing the pse config advertisement");
            ioe.initCause(failure);
            throw ioe;
        }
        try {
            param = (XMLElement)((Object)platformConfig.getServiceParam(PeerGroup.rendezvousClassID));
            param.addAttribute("type", RdvConfigAdv.getAdvertisementType());
            this.rdvConfig = (RdvConfigAdv)AdvertisementFactory.newAdvertisement(param);
            if (this.rdvConfig.getConfiguration() == RdvConfigAdv.RendezVousConfiguration.AD_HOC) {
                this.mode |= 0x2000;
            } else if (this.rdvConfig.getConfiguration() == RdvConfigAdv.RendezVousConfiguration.EDGE) {
                this.mode |= 0x1000;
            } else if (this.rdvConfig.getConfiguration() == RdvConfigAdv.RendezVousConfiguration.RENDEZVOUS) {
                this.mode |= 0x800;
            }
        }
        catch (Exception failure) {
            IOException ioe = new IOException("error processing the rendezvous config advertisement");
            ioe.initCause(failure);
            throw ioe;
        }
        try {
            param = (XMLElement)((Object)platformConfig.getServiceParam(PeerGroup.relayProtoClassID));
            if (param != null && !platformConfig.isSvcEnabled(PeerGroup.relayProtoClassID)) {
                this.mode |= 4;
            }
            param.addAttribute("type", RelayConfigAdv.getAdvertisementType());
            this.relayConfig = (RelayConfigAdv)AdvertisementFactory.newAdvertisement(param);
        }
        catch (Exception failure) {
            IOException ioe = new IOException("error processing the relay config advertisement");
            ioe.initCause(failure);
            throw ioe;
        }
        param = (XMLElement)((Object)platformConfig.getServiceParam(PeerGroup.membershipClassID));
        if (param != null) {
            CertificateException cnfe;
            Advertisement adv = null;
            try {
                adv = AdvertisementFactory.newAdvertisement(param);
            }
            catch (NoSuchElementException notAnAdv) {
                cnfe = new CertificateException("No membership advertisement found");
                cnfe.initCause(notAnAdv);
            }
            catch (IllegalArgumentException invalidAdv) {
                cnfe = new CertificateException("Invalid membership advertisement");
                cnfe.initCause(invalidAdv);
            }
            if (adv instanceof PSEConfigAdv) {
                this.pseConf = (PSEConfigAdv)adv;
                this.cert = this.pseConf.getCertificateChain();
            } else {
                throw new CertificateException("Error processing the Membership config advertisement. Unexpected membership advertisement " + adv.getAdvertisementType());
            }
        }
        this.infraPeerGroupConfig = (PeerGroupConfigAdv)platformConfig.getSvcConfigAdvertisement(PeerGroup.peerGroupClassID);
        if (null == this.infraPeerGroupConfig) {
            this.infraPeerGroupConfig = this.createInfraConfigAdv();
            try {
                URI configPropsURI = this.storeHome.resolve("config.properties");
                InputStream configPropsIS = configPropsURI.toURL().openStream();
                PropertyResourceBundle rsrcs = new PropertyResourceBundle(configPropsIS);
                configPropsIS.close();
                NetGroupTunables tunables = new NetGroupTunables(rsrcs, new NetGroupTunables());
                this.infraPeerGroupConfig.setPeerGroupID(tunables.id);
                this.infraPeerGroupConfig.setName(tunables.name);
                this.infraPeerGroupConfig.setDesc(tunables.desc);
            }
            catch (IOException ignored) {
            }
            catch (MissingResourceException ignored) {
                // empty catch block
            }
        }
        return platformConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void save() throws IOException {
        this.httpEnabled = this.httpConfig.isClientEnabled() || this.httpConfig.isServerEnabled();
        this.tcpEnabled = this.tcpConfig.isClientEnabled() || this.tcpConfig.isServerEnabled();
        ConfigParams advertisement = this.getPlatformConfig();
        OutputStream out = null;
        try {
            if ("file".equalsIgnoreCase(this.storeHome.getScheme())) {
                File saveDir = new File(this.storeHome);
                saveDir.mkdirs();
                out = new FileOutputStream(new File(saveDir, "PlatformConfig"));
            } else {
                out = this.storeHome.resolve("PlatformConfig").toURL().openConnection().getOutputStream();
            }
            XMLDocument aDoc = (XMLDocument)advertisement.getDocument(MimeMediaType.XMLUTF8);
            OutputStreamWriter os = new OutputStreamWriter(out, "UTF-8");
            aDoc.sendToWriter(os);
            os.flush();
            Object var6_5 = null;
            if (null == out) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (null == out) throw throwable;
            out.close();
            throw throwable;
        }
        out.close();
    }

    protected XMLDocument getParmDoc(boolean enabled, Advertisement adv) {
        XMLDocument parmDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
        XMLDocument doc = (XMLDocument)adv.getDocument(MimeMediaType.XMLUTF8);
        StructuredDocumentUtils.copyElements(parmDoc, parmDoc, doc);
        if (!enabled) {
            parmDoc.appendChild(parmDoc.createElement("isOff"));
        }
        return parmDoc;
    }

    protected HTTPAdv createHttpAdv() {
        this.httpConfig = (HTTPAdv)AdvertisementFactory.newAdvertisement(HTTPAdv.getAdvertisementType());
        this.httpConfig.setProtocol("http");
        this.httpConfig.setPort(9700);
        this.httpConfig.setClientEnabled((this.mode & 0x100) == 256);
        this.httpConfig.setServerEnabled((this.mode & 0x200) == 512);
        return this.httpConfig;
    }

    protected PSEConfigAdv createPSEAdv(String principal, String password) {
        this.pseConf = (PSEConfigAdv)AdvertisementFactory.newAdvertisement(PSEConfigAdv.getAdvertisementType());
        if (principal != null && password != null) {
            PSEUtils.IssuerInfo info = PSEUtils.genCert(principal, null);
            this.pseConf.setCertificate(info.cert);
            this.pseConf.setPrivateKey(info.subjectPkey, password.toCharArray());
        }
        return this.pseConf;
    }

    protected PSEConfigAdv createPSEAdv(X509Certificate cert) {
        this.pseConf = (PSEConfigAdv)AdvertisementFactory.newAdvertisement(PSEConfigAdv.getAdvertisementType());
        if (this.subjectPkey != null && this.password != null) {
            this.pseConf.setCertificate(cert);
            this.pseConf.setPrivateKey(this.subjectPkey, this.password.toCharArray());
        }
        return this.pseConf;
    }

    protected PSEConfigAdv createPSEAdv(X509Certificate[] certificateChain) {
        this.pseConf = (PSEConfigAdv)AdvertisementFactory.newAdvertisement(PSEConfigAdv.getAdvertisementType());
        if (this.subjectPkey != null && this.password != null) {
            this.pseConf.setCertificateChain(certificateChain);
            this.pseConf.setPrivateKey(this.subjectPkey, this.password.toCharArray());
        }
        return this.pseConf;
    }

    protected XMLDocument createProxyAdv() {
        return (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
    }

    protected RdvConfigAdv createRdvConfigAdv() {
        this.rdvConfig = (RdvConfigAdv)AdvertisementFactory.newAdvertisement(RdvConfigAdv.getAdvertisementType());
        if (this.mode == 8192) {
            this.rdvConfig.setConfiguration(RdvConfigAdv.RendezVousConfiguration.AD_HOC);
        } else if ((this.mode & 0x1000) == 4096) {
            this.rdvConfig.setConfiguration(RdvConfigAdv.RendezVousConfiguration.EDGE);
        } else if ((this.mode & 0x800) == 2048) {
            this.rdvConfig.setConfiguration(RdvConfigAdv.RendezVousConfiguration.RENDEZVOUS);
        }
        return this.rdvConfig;
    }

    protected RelayConfigAdv createRelayConfigAdv() {
        this.relayConfig = (RelayConfigAdv)AdvertisementFactory.newAdvertisement(RelayConfigAdv.getAdvertisementType());
        this.relayConfig.setUseOnlySeeds(false);
        this.relayConfig.setClientEnabled((this.mode & 8) == 8 || this.mode == 5576);
        this.relayConfig.setServerEnabled((this.mode & 0x10) == 16);
        return this.relayConfig;
    }

    protected TCPAdv createTcpAdv() {
        this.tcpConfig = (TCPAdv)AdvertisementFactory.newAdvertisement(TCPAdv.getAdvertisementType());
        this.tcpConfig.setProtocol("tcp");
        this.tcpConfig.setInterfaceAddress(null);
        this.tcpConfig.setPort(9701);
        this.tcpConfig.setStartPort(9701);
        this.tcpConfig.setEndPort(9799);
        this.tcpConfig.setMulticastAddr("224.0.1.85");
        this.tcpConfig.setMulticastPort(1234);
        this.tcpConfig.setMulticastSize(16384);
        this.tcpConfig.setMulticastState((this.mode & 0x400) == 1024);
        this.tcpConfig.setServer(null);
        this.tcpConfig.setClientEnabled((this.mode & 0x40) == 64);
        this.tcpConfig.setServerEnabled((this.mode & 0x80) == 128);
        return this.tcpConfig;
    }

    protected PeerGroupConfigAdv createInfraConfigAdv() {
        this.infraPeerGroupConfig = (PeerGroupConfigAdv)AdvertisementFactory.newAdvertisement(PeerGroupConfigAdv.getAdvertisementType());
        NetGroupTunables tunables = new NetGroupTunables(ResourceBundle.getBundle("net.jxta.impl.config"), new NetGroupTunables());
        this.infraPeerGroupConfig.setPeerGroupID(tunables.id);
        this.infraPeerGroupConfig.setName(tunables.name);
        this.infraPeerGroupConfig.setDesc(tunables.desc);
        return this.infraPeerGroupConfig;
    }

    public ConfigParams getPlatformConfig() {
        boolean enabled;
        PlatformConfig advertisement = (PlatformConfig)AdvertisementFactory.newAdvertisement(PlatformConfig.getAdvertisementType());
        advertisement.setName(this.name);
        advertisement.setDescription(this.description);
        if (this.peerid != null) {
            advertisement.setPeerID(this.peerid);
        }
        if (this.tcpConfig != null) {
            enabled = this.tcpEnabled && (this.tcpConfig.isServerEnabled() || this.tcpConfig.isClientEnabled());
            advertisement.putServiceParam(PeerGroup.tcpProtoClassID, this.getParmDoc(enabled, this.tcpConfig));
        }
        if (this.httpConfig != null) {
            enabled = this.httpEnabled && (this.httpConfig.isServerEnabled() || this.httpConfig.isClientEnabled());
            advertisement.putServiceParam(PeerGroup.httpProtoClassID, this.getParmDoc(enabled, this.httpConfig));
        }
        if (this.relayConfig != null) {
            boolean isOff = (this.mode & 4) == 4 || this.relayConfig.isServerEnabled() && this.relayConfig.isClientEnabled();
            XMLDocument relayDoc = (XMLDocument)this.relayConfig.getDocument(MimeMediaType.XMLUTF8);
            if (isOff) {
                relayDoc.appendChild(relayDoc.createElement("isOff"));
            }
            advertisement.putServiceParam(PeerGroup.relayProtoClassID, relayDoc);
        }
        if (this.rdvConfig != null) {
            XMLDocument rdvDoc = (XMLDocument)this.rdvConfig.getDocument(MimeMediaType.XMLUTF8);
            advertisement.putServiceParam(PeerGroup.rendezvousClassID, rdvDoc);
        }
        this.pseConf = this.cert != null ? this.createPSEAdv(this.cert) : this.createPSEAdv(this.principal, this.password);
        if (this.pseConf != null) {
            if (this.keyStoreLocation != null) {
                if (this.keyStoreLocation.isAbsolute()) {
                    this.pseConf.setKeyStoreLocation(this.keyStoreLocation);
                } else if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Keystore location set, but is not absolute: " + this.keyStoreLocation);
                }
            }
            XMLDocument pseDoc = (XMLDocument)this.pseConf.getDocument(MimeMediaType.XMLUTF8);
            advertisement.putServiceParam(PeerGroup.membershipClassID, pseDoc);
        }
        if (this.proxyConfig != null && (this.mode & 0x20) == 32) {
            advertisement.putServiceParam(PeerGroup.proxyClassID, this.proxyConfig);
        }
        if (null != this.infraPeerGroupConfig && null != this.infraPeerGroupConfig.getPeerGroupID() && ID.nullID != this.infraPeerGroupConfig.getPeerGroupID() && PeerGroupID.defaultNetPeerGroupID != this.infraPeerGroupConfig.getPeerGroupID()) {
            advertisement.setSvcConfigAdvertisement(PeerGroup.peerGroupClassID, this.infraPeerGroupConfig);
        }
        return advertisement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlatformConfig read(URI location) throws IOException {
        PlatformConfig platformConfig;
        URL url;
        try {
            url = location.toURL();
        }
        catch (MalformedURLException mue) {
            IllegalArgumentException failure = new IllegalArgumentException("Failed to convert URI to URL");
            failure.initCause(mue);
            throw failure;
        }
        InputStream input = url.openStream();
        try {
            PlatformConfig platformConfig2;
            XMLDocument document = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, input);
            platformConfig = platformConfig2 = (PlatformConfig)AdvertisementFactory.newAdvertisement(document);
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            input.close();
            throw throwable;
        }
        input.close();
        return platformConfig;
    }

    public boolean isHttpEnabled() {
        return this.httpEnabled;
    }

    public boolean getHttpIncomingStatus() {
        return this.httpConfig.getServerEnabled();
    }

    public boolean getHttpOutgoingStatus() {
        return this.httpConfig.getClientEnabled();
    }

    public int getHttpPort() {
        return this.httpConfig.getPort();
    }

    public ID getInfrastructureID() {
        return this.infraPeerGroupConfig.getPeerGroupID();
    }

    public String getMulticastAddress() {
        return this.tcpConfig.getMulticastAddr();
    }

    public int getMulticastPort() {
        return this.tcpConfig.getMulticastPort();
    }

    public int getMulticastPoolSize() {
        return this.tcpConfig.getMulticastPoolSize();
    }

    public boolean isTcpEnabled() {
        return this.tcpEnabled;
    }

    public int getTcpEndport() {
        return this.tcpConfig.getEndPort();
    }

    public boolean getTcpIncomingStatus() {
        return this.tcpConfig.getServerEnabled();
    }

    public String getTcpInterfaceAddress() {
        return this.tcpConfig.getInterfaceAddress();
    }

    public int getTcpPort() {
        return this.tcpConfig.getPort();
    }

    public String getTcpPublicAddress() {
        return this.tcpConfig.getServer();
    }

    public boolean isTcpPublicAddressExclusive() {
        return this.tcpConfig.getPublicAddressOnly();
    }

    public int getTcpStartPort() {
        return this.tcpConfig.getStartPort();
    }

    public boolean getMulticastStatus() {
        return this.tcpConfig.getMulticastState();
    }

    public boolean getUseOnlyRelaySeedsStatus() {
        return this.relayConfig.getUseOnlySeeds();
    }

    public boolean getUseOnlyRendezvousSeedsStatus() {
        return this.rdvConfig.getUseOnlySeeds();
    }

    public int getRendezvousMaxClients() {
        return this.rdvConfig.getMaxClients();
    }

    public int getRelayMaxClients() {
        return this.rdvConfig.getMaxClients();
    }

    public URI[] getRdvSeedingURIs() {
        return this.rdvConfig.getSeedingURIs();
    }

    public URI[] getRelaySeedingURIs() {
        return this.relayConfig.getSeedingURIs();
    }

    static class NetGroupTunables {
        final ID id;
        final String name;
        final XMLElement desc;

        NetGroupTunables() {
            this.id = PeerGroupID.defaultNetPeerGroupID;
            this.name = "NetPeerGroup";
            this.desc = (XMLElement)((Object)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "desc", "default Net Peer Group"));
        }

        NetGroupTunables(ID pgid, String pgname, XMLElement pgdesc) {
            this.id = pgid;
            this.name = pgname;
            this.desc = pgdesc;
        }

        NetGroupTunables(ResourceBundle rsrcs, NetGroupTunables defaults) {
            XMLElement descTmp;
            String nameTmp;
            ID idTmp;
            try {
                String idTmpStr = rsrcs.getString("NetPeerGroupID").trim();
                if (idTmpStr.startsWith("jxta:")) {
                    idTmpStr = idTmpStr.substring(5);
                }
                idTmp = IDFactory.fromURI(new URI("urn:jxta:" + idTmpStr));
                nameTmp = rsrcs.getString("NetPeerGroupName").trim();
                descTmp = (XMLElement)((Object)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "desc", rsrcs.getString("NetPeerGroupDesc").trim()));
            }
            catch (Exception failed) {
                if (null != defaults) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "NetPeerGroup tunables not defined or could not be loaded. Using defaults.", failed);
                    }
                    idTmp = defaults.id;
                    nameTmp = defaults.name;
                    descTmp = defaults.desc;
                }
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "NetPeerGroup tunables not defined or could not be loaded.", failed);
                }
                throw new IllegalStateException("NetPeerGroup tunables not defined or could not be loaded.");
            }
            this.id = idTmp;
            this.name = nameTmp;
            this.desc = descTmp;
        }
    }
}

