/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.platform;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.cert.CertificateException;
import net.jxta.credential.AuthenticationCredential;
import net.jxta.credential.Credential;
import net.jxta.exception.PeerGroupException;
import net.jxta.exception.ProtocolNotSupportedException;
import net.jxta.id.IDFactory;
import net.jxta.impl.membership.pse.StringAuthenticator;
import net.jxta.logging.Logging;
import net.jxta.membership.InteractiveAuthenticator;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.NetPeerGroupFactory;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.platform.NetworkConfigurator;
import net.jxta.rendezvous.RendezVousService;
import net.jxta.rendezvous.RendezvousEvent;
import net.jxta.rendezvous.RendezvousListener;

public class NetworkManager
implements RendezvousListener {
    private static final transient Logger LOG = Logger.getLogger(NetworkManager.class.getName());
    protected final transient URI publicSeedingRdvURI = URI.create("http://rdv.jxtahosts.net/cgi-bin/rendezvous.cgi?3");
    protected final transient URI publicSeedingRelayURI = URI.create("http://rdv.jxtahosts.net/cgi-bin/relays.cgi?3");
    private final Object networkConnectLock = new String("rendezvous connection lock");
    private PeerGroup netPeerGroup = null;
    private volatile boolean started = false;
    private volatile boolean connected = false;
    private volatile boolean stopped = false;
    private RendezVousService rendezvous;
    private String instanceName = "NA";
    private ShutdownHook shutdownHook;
    private ConfigMode mode;
    private URI instanceHome;
    private PeerGroupID infrastructureID = PeerGroupID.defaultNetPeerGroupID;
    private PeerID peerID = IDFactory.newPeerID(PeerGroupID.defaultNetPeerGroupID);
    private NetworkConfigurator config;
    private boolean configPersistent = true;
    private boolean useDefaultSeeds;

    public NetworkManager(ConfigMode mode, String instanceName) throws IOException {
        this(mode, instanceName, new File(".jxta/").toURI());
    }

    public NetworkManager(ConfigMode mode, String instanceName, URI instanceHome) throws IOException {
        this.instanceName = instanceName;
        this.mode = mode;
        this.instanceHome = instanceHome;
    }

    public synchronized NetworkConfigurator getConfigurator() throws IOException {
        if (this.config == null) {
            this.configure(this.mode);
        }
        return this.config;
    }

    public PeerGroupID getInfrastructureID() {
        return this.infrastructureID;
    }

    public void setInfrastructureID(PeerGroupID infrastructureID) {
        this.infrastructureID = infrastructureID;
        if (this.config != null) {
            this.config.setInfrastructureID(infrastructureID);
        }
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public URI getInstanceHome() {
        return this.instanceHome;
    }

    public void setInstanceHome(URI instanceHome) {
        this.instanceHome = instanceHome;
    }

    public ConfigMode getMode() {
        return this.mode;
    }

    public void setMode(ConfigMode mode) throws IOException {
        this.mode = mode;
        this.configure(mode);
    }

    public PeerID getPeerID() {
        return this.peerID;
    }

    public void setPeerID(PeerID peerID) {
        this.peerID = peerID;
    }

    public boolean isConfigPersistent() {
        return this.configPersistent;
    }

    public void setConfigPersistent(boolean persisted) {
        this.configPersistent = persisted;
    }

    private void configure(ConfigMode mode) throws IOException {
        switch (mode) {
            case ADHOC: {
                this.config = NetworkConfigurator.newAdHocConfiguration(this.instanceHome);
                break;
            }
            case EDGE: {
                this.config = NetworkConfigurator.newEdgeConfiguration(this.instanceHome);
                break;
            }
            case RENDEZVOUS: {
                this.config = NetworkConfigurator.newRdvConfiguration(this.instanceHome);
                break;
            }
            case RELAY: {
                this.config = NetworkConfigurator.newRelayConfiguration(this.instanceHome);
                break;
            }
            case RENDEZVOUS_RELAY: {
                this.config = NetworkConfigurator.newRdvRelayConfiguration(this.instanceHome);
                break;
            }
            case PROXY: {
                this.config = NetworkConfigurator.newProxyConfiguration(this.instanceHome);
                break;
            }
            case SUPER: {
                this.config = NetworkConfigurator.newRdvRelayProxyConfiguration(this.instanceHome);
                break;
            }
            default: {
                this.config = NetworkConfigurator.newAdHocConfiguration(this.instanceHome);
            }
        }
        if (!this.config.exists()) {
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.log(Level.INFO, "Created new configuration. mode = " + mode.toString());
            }
            this.config.setDescription("Created by NetworkManager");
            this.config.setPeerID(this.peerID);
            this.config.setInfrastructureID(this.infrastructureID);
            this.config.setName(this.instanceName);
            if (this.useDefaultSeeds) {
                this.config.addRdvSeedingURI(this.publicSeedingRdvURI);
                this.config.addRelaySeedingURI(this.publicSeedingRelayURI);
            }
        } else {
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.log(Level.INFO, "Loading existing configuration. mode = " + mode.toString());
            }
            File pc = new File(this.config.getHome(), "PlatformConfig");
            try {
                this.config.load(pc.toURI());
            }
            catch (CertificateException pseFailed) {
                IOException failure = new IOException("Failure reading membership service certificates.");
                failure.initCause(pseFailed);
                throw failure;
            }
        }
    }

    public synchronized PeerGroup startNetwork() throws PeerGroupException, IOException {
        if (this.started) {
            return this.netPeerGroup;
        }
        if (this.config == null) {
            this.configure(this.mode);
        }
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "Starting JXTA Network! MODE = " + this.mode.toString() + ",  HOME = " + this.instanceHome);
        }
        NetPeerGroupFactory factory = new NetPeerGroupFactory(this.config.getPlatformConfig(), this.instanceHome);
        this.netPeerGroup = factory.getInterface();
        if (this.configPersistent) {
            this.config.save();
        }
        this.rendezvous = this.netPeerGroup.getRendezVousService();
        this.rendezvous.addListener(this);
        this.started = true;
        this.stopped = false;
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "Started JXTA Network!");
        }
        return this.netPeerGroup;
    }

    public static void login(PeerGroup group, char[] keystore_password, char[] principal_password) throws PeerGroupException, ProtocolNotSupportedException {
        InteractiveAuthenticator iAuth;
        AuthenticationCredential authCred;
        StringAuthenticator auth;
        MembershipService membership = group.getMembershipService();
        Credential cred = membership.getDefaultCredential();
        if (cred == null && (auth = (StringAuthenticator)membership.apply(authCred = new AuthenticationCredential(group, "StringAuthentication", null))) != null) {
            auth.setAuth1_KeyStorePassword(keystore_password);
            auth.setAuth2Identity(group.getPeerID());
            auth.setAuth3_IdentityPassword(principal_password);
            if (auth.isReadyForJoin()) {
                membership.join(auth);
            }
        }
        if (null == (cred = membership.getDefaultCredential()) && (iAuth = (InteractiveAuthenticator)membership.apply(authCred = new AuthenticationCredential(group, "InteractiveAuthentication", null))).interact() && iAuth.isReadyForJoin()) {
            membership.join(iAuth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stopNetwork() {
        if (this.stopped || !this.started) {
            return;
        }
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "Stopping JXTA Network!");
        }
        this.stopped = true;
        Object object = this.networkConnectLock;
        synchronized (object) {
            this.connected = false;
            this.networkConnectLock.notifyAll();
        }
        this.rendezvous.removeListener(this);
        this.netPeerGroup.stopApp();
        this.netPeerGroup.unref();
        this.netPeerGroup = null;
        this.started = false;
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "Stopped JXTA Network!");
        }
    }

    public PeerGroup getNetPeerGroup() {
        return this.netPeerGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForRendezvousConnection(long timeout) {
        long timeoutAt;
        if (0L == timeout) {
            timeout = Long.MAX_VALUE;
        }
        if ((timeoutAt = System.currentTimeMillis() + timeout) <= 0L) {
            timeoutAt = Long.MAX_VALUE;
        }
        while (this.started && !this.stopped && !this.rendezvous.isConnectedToRendezVous() && !this.rendezvous.isRendezVous()) {
            try {
                long waitFor = timeoutAt - System.currentTimeMillis();
                if (waitFor > 0L) {
                    Object object = this.networkConnectLock;
                    synchronized (object) {
                        this.networkConnectLock.wait(timeout);
                        continue;
                    }
                }
                break;
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                break;
            }
        }
        return this.rendezvous.isConnectedToRendezVous() || this.rendezvous.isRendezVous();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rendezvousEvent(RendezvousEvent event) {
        if (event.getType() == 0 || event.getType() == 1 || event.getType() == 8) {
            Object object = this.networkConnectLock;
            synchronized (object) {
                this.connected = true;
                this.networkConnectLock.notifyAll();
            }
        }
    }

    public void setUseDefaultSeeds(boolean useDefaultSeeds) {
        this.useDefaultSeeds = useDefaultSeeds;
    }

    public boolean getUseDefaultSeeds() {
        return this.useDefaultSeeds;
    }

    public synchronized void registerShutdownHook() {
        if (this.shutdownHook != null) {
            return;
        }
        this.shutdownHook = new ShutdownHook();
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public synchronized void unregisterShutdownHook() {
        if (this.shutdownHook == null) {
            return;
        }
        Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        this.shutdownHook = null;
    }

    public boolean isStarted() {
        return this.started && !this.stopped;
    }

    private class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        public void run() {
            NetworkManager.this.stopNetwork();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConfigMode {
        ADHOC,
        EDGE,
        RENDEZVOUS,
        RELAY,
        RENDEZVOUS_RELAY,
        PROXY,
        SUPER;

    }
}

