/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.protocol;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Element;
import net.jxta.document.ExtendableAdvertisement;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.TextElement;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfigParams
extends ExtendableAdvertisement
implements Cloneable {
    private static final transient Logger LOG = Logger.getLogger(ConfigParams.class.getName());
    private static final String SVC_TAG = "Svc";
    private static final String MCID_TAG = "MCID";
    private static final String PARAM_TAG = "Parm";
    private final Map<ID, StructuredDocument> params = new HashMap<ID, StructuredDocument>();
    private final Map<ID, Advertisement> ads = new HashMap<ID, Advertisement>();
    private final Set<ID> disabled = new HashSet<ID>();
    protected final transient AtomicInteger modCount = new AtomicInteger(0);

    public static String getAdvertisementType() {
        return "jxta:CP";
    }

    protected ConfigParams() {
        super(true);
    }

    @Override
    public ConfigParams clone() {
        try {
            ConfigParams result = (ConfigParams)super.clone();
            for (Map.Entry<ID, StructuredDocument> entry : this.params.entrySet()) {
                result.params.put(entry.getKey(), StructuredDocumentUtils.copyAsDocument(entry.getValue()));
            }
            for (Map.Entry<ID, Object> entry : this.ads.entrySet()) {
                result.ads.put(entry.getKey(), ((Advertisement)entry.getValue()).clone());
            }
            result.disabled.addAll(this.disabled);
            return result;
        }
        catch (CloneNotSupportedException impossible) {
            throw new Error("Object.clone() threw CloneNotSupportedException", impossible);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ConfigParams) {
            ConfigParams likeMe = (ConfigParams)other;
            boolean ep = ((Object)this.params).equals(likeMe.params);
            boolean ea = ((Object)this.ads).equals(likeMe.ads);
            boolean ed = ((Object)this.disabled).equals(likeMe.disabled);
            return ep && ea && ed;
        }
        return false;
    }

    @Override
    public final String getBaseAdvType() {
        return ConfigParams.getAdvertisementType();
    }

    @Override
    protected boolean handleElement(Element raw) {
        if (super.handleElement(raw)) {
            return true;
        }
        XMLElement elem = (XMLElement)raw;
        if (SVC_TAG.equals(elem.getName())) {
            Attribute disabledAttr = elem.getAttribute("disabled");
            boolean isDisabled = null != disabledAttr && Boolean.parseBoolean(disabledAttr.getValue());
            Enumeration elems = elem.getChildren();
            ID key = null;
            TextElement param = null;
            while (elems.hasMoreElements()) {
                XMLElement e = (XMLElement)elems.nextElement();
                if (MCID_TAG.equals(e.getName())) {
                    try {
                        URI mcid = new URI(e.getTextValue());
                        key = IDFactory.fromURI(mcid);
                        continue;
                    }
                    catch (URISyntaxException badID) {
                        throw new IllegalArgumentException("Bad ID in advertisement: " + e.getTextValue());
                    }
                }
                if (PARAM_TAG.equals(e.getName())) {
                    param = e;
                    continue;
                }
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.warning("Unrecognized <Svc> tag : " + e.getName());
            }
            if (key != null && param != null) {
                if (!isDisabled) {
                    Enumeration isOff = param.getChildren("isOff");
                    isDisabled = isOff.hasMoreElements();
                }
                this.putServiceParam(key, param);
                if (isDisabled) {
                    this.disabled.add(key);
                }
            } else {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Incomplete Service Param : id=" + key + " param=" + param);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean addDocumentElements(StructuredDocument adv) {
        Object e;
        Object s;
        ID anID;
        for (Map.Entry<ID, StructuredDocument> entry : this.params.entrySet()) {
            anID = entry.getKey();
            StructuredDocument aDoc = entry.getValue();
            s = adv.createElement(SVC_TAG);
            adv.appendChild(s);
            if (this.disabled.contains(anID)) {
                ((Attributable)s).addAttribute("disabled", "true");
            }
            e = adv.createElement(MCID_TAG, anID.toString());
            s.appendChild(e);
            StructuredDocumentUtils.copyElements(adv, s, aDoc, PARAM_TAG);
        }
        for (Map.Entry<ID, Object> entry : this.ads.entrySet()) {
            anID = entry.getKey();
            Advertisement anAdv = (Advertisement)entry.getValue();
            s = adv.createElement(SVC_TAG);
            adv.appendChild(s);
            if (this.disabled.contains(anID)) {
                ((Attributable)s).addAttribute("disabled", "true");
            }
            e = adv.createElement(MCID_TAG, anID.toString());
            s.appendChild(e);
            StructuredDocument asDoc = (StructuredDocument)anAdv.getDocument(adv.getMimeType());
            StructuredDocumentUtils.copyElements(adv, s, asDoc, PARAM_TAG);
        }
        return true;
    }

    public int getModCount() {
        return this.modCount.get();
    }

    protected synchronized int incModCount() {
        return this.modCount.incrementAndGet();
    }

    public void putServiceParam(ID key, Element param) {
        this.incModCount();
        this.params.remove(key);
        this.ads.remove(key);
        if (param == null) {
            return;
        }
        boolean isDisabled = false;
        if (param instanceof XMLElement) {
            Enumeration isOff = param.getChildren("isOff");
            isDisabled = isOff.hasMoreElements();
            Advertisement adv = null;
            try {
                adv = AdvertisementFactory.newAdvertisement((XMLElement)param);
            }
            catch (RuntimeException ignored) {
                // empty catch block
            }
            if (null != adv) {
                this.setSvcConfigAdvertisement(key, adv, !isDisabled);
                return;
            }
        }
        StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(param);
        if (isDisabled) {
            this.disabled.add(key);
        } else {
            this.disabled.remove(key);
        }
        this.params.put(key, newDoc);
    }

    public void setSvcConfigAdvertisement(ID key, Advertisement adv) {
        this.setSvcConfigAdvertisement(key, adv, true);
    }

    public void setSvcConfigAdvertisement(ID key, Advertisement adv, boolean enabled) {
        this.incModCount();
        this.params.remove(key);
        this.ads.remove(key);
        if (enabled) {
            this.disabled.remove(key);
        } else {
            this.disabled.add(key);
        }
        if (null == adv) {
            return;
        }
        try {
            this.ads.put(key, adv.clone());
        }
        catch (CloneNotSupportedException failed) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Unclonable Advertisements may not be used : " + adv.getClass().getName(), failed);
            }
            throw new IllegalArgumentException("Unclonable Advertisements may not be used : " + adv.getClass().getName());
        }
    }

    public boolean isSvcEnabled(ID key) {
        return !this.disabled.contains(key);
    }

    public Advertisement getSvcConfigAdvertisement(ID key) {
        Advertisement adv = this.ads.get(key);
        if (null == adv) {
            if (this.params.containsKey(key)) {
                throw new IllegalStateException("Unable to return advertisement, params are not an advertisement.");
            }
            return null;
        }
        try {
            return adv.clone();
        }
        catch (CloneNotSupportedException failed) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Unclonable Advertisements may not be used : " + adv.getClass().getName(), failed);
            }
            throw new IllegalArgumentException("Unclonable Advertisements may not be used : " + adv.getClass().getName());
        }
    }

    public StructuredDocument getServiceParam(ID key) {
        Enumeration isOffAlready;
        StructuredDocument param = this.params.get(key);
        if (param == null) {
            Advertisement ad = this.ads.get(key);
            if (null == ad) {
                return null;
            }
            return (XMLDocument)ad.getDocument(MimeMediaType.XMLUTF8);
        }
        StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(param);
        if (this.disabled.contains(key) && !(isOffAlready = newDoc.getChildren("isOff")).hasMoreElements()) {
            newDoc.appendChild(newDoc.createElement("isOff", null));
        }
        return newDoc;
    }

    public StructuredDocument removeServiceParam(ID key) {
        StructuredDocument param = this.params.remove(key);
        if (param == null) {
            Advertisement ad = this.ads.remove(key);
            if (null == ad) {
                return null;
            }
            return (XMLDocument)ad.getDocument(MimeMediaType.XMLUTF8);
        }
        this.ads.remove(key);
        this.incModCount();
        StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(param);
        if (this.disabled.contains(key)) {
            newDoc.appendChild(newDoc.createElement("isOff", null));
            this.disabled.remove(key);
        }
        return newDoc;
    }

    public void removeSvcConfigAdvertisement(ID key) {
        this.incModCount();
        this.params.remove(key);
        this.ads.remove(key);
    }

    @Deprecated
    public Set<Map.Entry<ID, StructuredDocument>> getServiceParamsEntrySet() {
        HashMap<ID, StructuredDocument> result = new HashMap<ID, StructuredDocument>();
        result.putAll(this.params);
        for (Map.Entry<ID, Advertisement> anEntry : this.ads.entrySet()) {
            XMLDocument entryDoc = (XMLDocument)anEntry.getValue().getDocument(MimeMediaType.XMLUTF8);
            if (this.disabled.contains(anEntry.getKey())) {
                entryDoc.appendChild(entryDoc.createElement("isOff", null));
            }
            result.put(anEntry.getKey(), entryDoc);
        }
        return Collections.unmodifiableSet(result.entrySet());
    }
}

