/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.protocol;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.ExtendableAdvertisement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.AccessPointAdvertisement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RouteAdvertisement
extends ExtendableAdvertisement
implements Cloneable {
    public static final String DEST_PID_TAG = "DstPID";
    private transient AccessPointAdvertisement dest = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(AccessPointAdvertisement.getAdvertisementType());
    private transient Vector<AccessPointAdvertisement> hops = new Vector();
    private transient ID hashID = null;

    public static RouteAdvertisement newRoute(PeerID destPid, PeerID firsthop, Vector<AccessPointAdvertisement> hops) {
        AccessPointAdvertisement ap;
        if (destPid == null) {
            throw new IllegalArgumentException("Missing destination peer id.");
        }
        for (AccessPointAdvertisement apa : hops) {
            if (null == apa) {
                throw new IllegalArgumentException("Bad route. null APA.");
            }
            if (apa.getPeerID() != null) continue;
            throw new IllegalArgumentException("Bad route. Incomplete APA.");
        }
        RouteAdvertisement route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
        route.setDestPeerID(destPid);
        route.setHops(hops);
        if (!(firsthop == null || (ap = route.getFirstHop()) != null && ap.getPeerID().equals(firsthop))) {
            ap = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(AccessPointAdvertisement.getAdvertisementType());
            ap.setPeerID(firsthop);
            route.setFirstHop(ap);
        }
        return route;
    }

    @Override
    public RouteAdvertisement clone() {
        try {
            RouteAdvertisement a = (RouteAdvertisement)super.clone();
            a.setDest(this.getDest());
            Vector<AccessPointAdvertisement> clonehops = this.getVectorHops();
            ListIterator<AccessPointAdvertisement> eachHop = clonehops.listIterator();
            while (eachHop.hasNext()) {
                eachHop.set(eachHop.next().clone());
            }
            a.setHops(clonehops);
            return a;
        }
        catch (CloneNotSupportedException impossible) {
            throw new Error("Object.clone() threw CloneNotSupportedException", impossible);
        }
    }

    public RouteAdvertisement cloneOnlyPIDs() {
        RouteAdvertisement routeAdvertisement;
        try {
            routeAdvertisement = (RouteAdvertisement)super.clone();
            routeAdvertisement.setDestEndpointAddresses(new Vector<String>());
        }
        catch (CloneNotSupportedException impossible) {
            throw new Error("Object.clone() threw CloneNotSupportedException", impossible);
        }
        Vector<AccessPointAdvertisement> clonehops = routeAdvertisement.getVectorHops();
        ListIterator<AccessPointAdvertisement> eachHop = clonehops.listIterator();
        while (eachHop.hasNext()) {
            AccessPointAdvertisement aHop = eachHop.next();
            eachHop.set(aHop.clone());
        }
        routeAdvertisement.setHops(clonehops);
        return routeAdvertisement;
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (!(target instanceof RouteAdvertisement)) {
            return false;
        }
        RouteAdvertisement route = (RouteAdvertisement)target;
        if (!this.dest.equals(route.getDest())) {
            return false;
        }
        if (this.hops.size() != route.size()) {
            return false;
        }
        int index = 0;
        for (AccessPointAdvertisement hop : route.hops) {
            if (hop.equals(this.hops.get(index++))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (null != this.dest.getPeerID()) {
            return this.dest.getPeerID().hashCode();
        }
        return 1;
    }

    public static String getAdvertisementType() {
        return "jxta:RA";
    }

    @Override
    public final String getBaseAdvType() {
        return RouteAdvertisement.getAdvertisementType();
    }

    @Override
    public synchronized ID getID() {
        if (null == this.dest.getPeerID()) {
            throw new IllegalStateException("Destination peerID not defined. Incomplete RouteAdvertisement");
        }
        if (this.hashID == null) {
            try {
                byte[] seed = RouteAdvertisement.getAdvertisementType().getBytes("UTF-8");
                ByteArrayInputStream in = new ByteArrayInputStream(this.dest.getPeerID().toString().getBytes("UTF-8"));
                this.hashID = IDFactory.newCodatID((PeerGroupID)this.dest.getPeerID().getPeerGroupID(), seed, in);
            }
            catch (Exception ez) {
                return ID.nullID;
            }
        }
        return this.hashID;
    }

    public PeerID getDestPeerID() {
        return this.dest.getPeerID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDestPeerID(PeerID pid) {
        if (null != pid && null != this.dest.getPeerID() && !pid.equals(this.dest.getPeerID())) {
            throw new IllegalStateException("Changing the peer id of the destination APA." + pid + " != " + this.dest.getPeerID());
        }
        this.dest.setPeerID(pid);
        RouteAdvertisement routeAdvertisement = this;
        synchronized (routeAdvertisement) {
            this.hashID = null;
        }
    }

    @Deprecated
    public AccessPointAdvertisement getDest() {
        return this.dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDest(AccessPointAdvertisement ap) {
        PeerID destPid = this.dest.getPeerID();
        this.dest = ap.clone();
        if (null != destPid && null != this.dest.getPeerID() && !destPid.equals(this.dest.getPeerID())) {
            throw new IllegalStateException("Changed the peer id of the destination APA." + destPid + " != " + this.dest.getPeerID());
        }
        if (null != destPid) {
            this.dest.setPeerID(destPid);
        }
        RouteAdvertisement routeAdvertisement = this;
        synchronized (routeAdvertisement) {
            this.hashID = null;
        }
    }

    @Deprecated
    public void addDestEndpointAddresses(Vector<String> addresses) {
        this.dest.addEndpointAddresses(addresses);
    }

    public void clearDestEndpointAddresses() {
        this.dest.clearEndpointAddresses();
    }

    public void addDestEndpointAddress(EndpointAddress addr) {
        this.dest.addEndpointAddress(addr);
    }

    public void addDestEndpointAddresses(List<EndpointAddress> addrs) {
        this.dest.addEndpointAddresses(addrs);
    }

    public void removeDestEndpointAddress(EndpointAddress addr) {
        this.dest.removeEndpointAddress(addr);
    }

    public void removeDestEndpointAddresses(Collection<EndpointAddress> addrs) {
        this.dest.removeEndpointAddresses(addrs);
    }

    @Deprecated
    public void removeDestEndpointAddresses(Vector<String> addresses) {
        this.dest.removeEndpointAddresses((List<String>)addresses);
    }

    public List<EndpointAddress> getDestEndpointAddresses() {
        ArrayList<EndpointAddress> result = new ArrayList<EndpointAddress>();
        Enumeration<String> eachEA = this.dest.getEndpointAddresses();
        while (eachEA.hasMoreElements()) {
            result.add(new EndpointAddress(eachEA.nextElement()));
        }
        return result;
    }

    @Deprecated
    public void setDestEndpointAddresses(Vector<String> ea) {
        this.dest.setEndpointAddresses(ea);
    }

    public Enumeration<AccessPointAdvertisement> getHops() {
        return this.hops.elements();
    }

    public Vector<AccessPointAdvertisement> getVectorHops() {
        return this.hops;
    }

    public void setHops(Vector<AccessPointAdvertisement> newHops) {
        if (null == newHops) {
            this.hops = new Vector();
        } else {
            for (AccessPointAdvertisement hop : newHops) {
                if (null != hop.getPeerID()) continue;
                throw new IllegalArgumentException("Bad hop");
            }
            this.hops = newHops;
        }
    }

    public boolean containsHop(PeerID pid) {
        for (AccessPointAdvertisement hop : this.hops) {
            PeerID hid = hop.getPeerID();
            if (!pid.equals(hid)) continue;
            return true;
        }
        return false;
    }

    public AccessPointAdvertisement getFirstHop() {
        return this.hops.isEmpty() ? null : this.hops.firstElement();
    }

    public void setFirstHop(AccessPointAdvertisement ap) {
        if (null == ap.getPeerID()) {
            throw new IllegalArgumentException("Bad hop");
        }
        this.hops.add(0, ap);
    }

    public AccessPointAdvertisement getLastHop() {
        return this.hops.isEmpty() ? null : this.hops.lastElement();
    }

    public void setLastHop(AccessPointAdvertisement ap) {
        if (null == ap.getPeerID()) {
            throw new IllegalArgumentException("Bad hop");
        }
        this.hops.add(ap);
    }

    public boolean hasALoop() {
        HashSet<PeerID> seenPeers = new HashSet<PeerID>(this.hops.size());
        for (AccessPointAdvertisement anAPA : this.hops) {
            PeerID pid = anAPA.getPeerID();
            if (seenPeers.contains(pid)) {
                return true;
            }
            seenPeers.add(pid);
        }
        return false;
    }

    public int size() {
        return this.hops.size();
    }

    public AccessPointAdvertisement nextHop(PeerID currentHop) {
        if (this.hops.isEmpty()) {
            return null;
        }
        int index = 0;
        boolean found = false;
        for (AccessPointAdvertisement ap : this.hops) {
            if (currentHop.equals(ap.getPeerID())) {
                found = true;
                break;
            }
            ++index;
        }
        AccessPointAdvertisement nextHop = null;
        if (!found) {
            nextHop = this.hops.get(0);
        } else if (index < this.hops.size()) {
            nextHop = this.hops.get(index);
        }
        return nextHop;
    }

    public String display() {
        StringBuilder routeBuf = new StringBuilder();
        routeBuf.append("Dest APA : ");
        AccessPointAdvertisement dest = this.getDest();
        routeBuf.append(dest.display());
        routeBuf.append("\n");
        int i = 1;
        Enumeration<AccessPointAdvertisement> e = this.getHops();
        while (e.hasMoreElements()) {
            AccessPointAdvertisement hop = e.nextElement();
            if (i == 1) {
                routeBuf.append("HOPS = ");
            }
            routeBuf.append("\n\t[").append(i++).append("] ");
            routeBuf.append(hop.display());
        }
        return routeBuf.toString();
    }

    public boolean removeHop(PeerID pid) {
        Iterator<AccessPointAdvertisement> eachHop = this.hops.iterator();
        while (eachHop.hasNext()) {
            AccessPointAdvertisement hop = eachHop.next();
            PeerID hid = hop.getPeerID();
            if (!pid.equals(hid)) continue;
            eachHop.remove();
            return true;
        }
        return false;
    }

    public AccessPointAdvertisement getHop(PeerID pid) {
        for (AccessPointAdvertisement hop : this.hops) {
            PeerID hid = hop.getPeerID();
            if (!pid.equals(hid)) continue;
            return hop.clone();
        }
        return null;
    }

    public static boolean stichRoute(RouteAdvertisement newRoute, RouteAdvertisement firstLeg) {
        return RouteAdvertisement.stichRoute(newRoute, firstLeg, null);
    }

    public static boolean stichRoute(RouteAdvertisement newRoute, RouteAdvertisement firstLeg, PeerID localPeer) {
        if (newRoute.hasALoop()) {
            return false;
        }
        Vector<AccessPointAdvertisement> hops = newRoute.getVectorHops();
        hops.ensureCapacity(firstLeg.getVectorHops().size() + 1 + hops.size());
        PeerID routerPid = firstLeg.getDest().getPeerID();
        if (newRoute.size() == 0 || !newRoute.getFirstHop().getPeerID().equals(routerPid)) {
            AccessPointAdvertisement ap = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(AccessPointAdvertisement.getAdvertisementType());
            ap.setPeerID(routerPid);
            hops.add(0, ap);
        }
        hops.addAll(0, firstLeg.getVectorHops());
        RouteAdvertisement.cleanupLoop(newRoute, localPeer);
        return true;
    }

    public static void cleanupLoop(RouteAdvertisement route, PeerID localPeer) {
        int i;
        Vector<AccessPointAdvertisement> hops = route.getVectorHops();
        Vector<AccessPointAdvertisement> newHops = new Vector<AccessPointAdvertisement>(hops.size());
        AccessPointAdvertisement lastHop = null;
        if (!hops.isEmpty()) {
            lastHop = hops.get(hops.size() - 1);
        }
        hops = route.cloneOnlyPIDs().getVectorHops();
        for (i = 0; i < hops.size(); ++i) {
            int loopAt = newHops.indexOf(hops.elementAt(i));
            if (loopAt != -1) {
                int j = newHops.size();
                while (--j > loopAt) {
                    newHops.remove(j);
                }
                continue;
            }
            newHops.add(hops.get(i));
        }
        if (localPeer != null) {
            i = newHops.size();
            while (--i >= 0) {
                if (!localPeer.equals(newHops.elementAt(i).getPeerID())) continue;
                for (int j = 0; j <= i; ++j) {
                    newHops.remove(0);
                }
            }
        }
        if (lastHop != null && newHops.size() > 0) {
            newHops.setElementAt(lastHop, newHops.size() - 1);
        }
        route.setHops(newHops);
    }
}

