/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.socket;

import java.net.SocketAddress;
import net.jxta.document.MimeMediaType;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PipeAdvertisement;

public class JxtaSocketAddress
extends SocketAddress {
    private final PeerGroupID peerGroupId;
    private final PipeAdvertisement pipeAdv;
    private final PeerID peerId;
    private final PeerAdvertisement peerAdv;
    private transient String pipeDoc;

    public JxtaSocketAddress(PeerGroup peerGroup, PipeAdvertisement pipeAdv) {
        this(peerGroup.getPeerGroupID(), pipeAdv, null);
    }

    @Deprecated
    public JxtaSocketAddress(PeerGroup peerGroup, PipeAdvertisement pipeAdv, PeerID peerId) {
        this(peerGroup.getPeerGroupID(), pipeAdv, peerId);
    }

    public JxtaSocketAddress(PeerGroup peerGroup, PipeAdvertisement pipeAdv, PeerAdvertisement peerAdv) {
        if (peerGroup == null) {
            throw new IllegalArgumentException("peerGroupId is required.");
        }
        if (pipeAdv == null) {
            throw new IllegalArgumentException("pipeAdv is required.");
        }
        if (peerAdv == null) {
            throw new IllegalArgumentException("pipeAdv is required.");
        }
        this.pipeAdv = pipeAdv.clone();
        this.peerGroupId = peerGroup.getPeerGroupID();
        this.peerId = peerAdv.getPeerID();
        this.peerAdv = peerAdv.clone();
    }

    @Deprecated
    public JxtaSocketAddress(PeerGroupID peerGroupId, PipeAdvertisement pipeAdv) {
        this(peerGroupId, pipeAdv, null);
    }

    @Deprecated
    public JxtaSocketAddress(PeerGroupID peerGroupId, PipeAdvertisement pipeAdv, PeerID peerId) {
        if (peerGroupId == null) {
            throw new IllegalArgumentException("peerGroupId is required.");
        }
        if (pipeAdv == null) {
            throw new IllegalArgumentException("pipeAdv is required.");
        }
        this.pipeAdv = pipeAdv.clone();
        this.peerGroupId = peerGroupId;
        this.peerId = peerId;
        this.peerAdv = null;
    }

    public PeerGroupID getPeerGroupId() {
        return this.peerGroupId;
    }

    public PipeAdvertisement getPipeAdv() {
        return this.pipeAdv.clone();
    }

    public PeerID getPeerId() {
        return this.peerId;
    }

    public PeerAdvertisement getPeerAdvertisement() {
        return this.peerAdv;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JxtaSocketAddress) {
            JxtaSocketAddress addr = (JxtaSocketAddress)obj;
            if (!this.peerGroupId.equals(addr.getPeerGroupId())) {
                return false;
            }
            if (!this.pipeAdv.equals(addr.getPipeAdv())) {
                return false;
            }
            return !(this.peerId != null ? !this.peerId.equals(addr.getPeerId()) : addr.getPeerId() != null);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.peerGroupId.hashCode();
        result = 37 * result + this.pipeAdv.hashCode();
        if (this.peerId != null) {
            result = 37 * result + this.peerId.hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        String lineSep = System.getProperty("line.separator");
        result.append(lineSep).append("JxtaSocketAdress:").append(lineSep);
        result.append("    PeerGroupID: ").append(this.peerGroupId.toString()).append(lineSep);
        if (this.peerId != null) {
            result.append(lineSep).append("    PeerID: ").append(this.peerId.toString()).append(lineSep);
        }
        result.append("    Pipe Adv: ").append(lineSep).append("    ").append(this.getPipeDocAsString());
        return result.toString();
    }

    private synchronized String getPipeDocAsString() {
        if (this.pipeDoc == null) {
            this.pipeDoc = this.pipeAdv.getDocument(MimeMediaType.TEXTUTF8).toString();
        }
        return this.pipeDoc;
    }
}

