/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.exception.JxtaException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.PipeID;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ModuleClassAdvertisement;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.ModuleSpecAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.util.DocumentUtilities;

@Deprecated
public final class AdvertisementUtilities {
    public static final StructuredTextDocument STANDARD_COMPATABILITY = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Comp");
    public static final String STANDARD_URI = "http://www.jxta.org/download/jxta.jar";
    public static final String STANDARD_PROVIDER = "jxta.org";

    private AdvertisementUtilities() {
    }

    public static Advertisement readAdvertisementFromFile(String fileName) throws JxtaException {
        return AdvertisementUtilities.readAdvertisementFromFile(new File(fileName));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Advertisement readAdvertisementFromFile(File file) throws JxtaException {
        Advertisement advertisement;
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(file);
                advertisement = AdvertisementFactory.newAdvertisement(MimeMediaType.XML_DEFAULTENCODING, in);
                Object var4_5 = null;
                if (in == null) return advertisement;
            }
            catch (IOException e) {
                throw new JxtaException("Advertisement Load Failed: " + file, e);
            }
            catch (Exception e) {
                throw new JxtaException("Advertisement Load Failed: " + file, e);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ignored) {
                throw throwable;
            }
        }
        try {}
        catch (IOException ignored) {
            // empty catch block
            return advertisement;
        }
        in.close();
        return advertisement;
    }

    public static void saveAdvertisementToFile(Advertisement adv, String fileName) throws JxtaException {
        AdvertisementUtilities.saveAdvertisementToFile(adv, new File(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void saveAdvertisementToFile(Advertisement adv, File file) throws JxtaException {
        FileOutputStream out = null;
        out = new FileOutputStream(file);
        Document document = adv.getDocument(MimeMediaType.XML_DEFAULTENCODING);
        document.sendToStream(out);
        Object var5_5 = null;
        if (out == null) return;
        try {
            ((OutputStream)out).close();
            return;
        }
        catch (IOException ignored) {}
        return;
        {
            catch (IOException iOException) {
                Object var5_6 = null;
                if (out == null) return;
                try {
                    ((OutputStream)out).close();
                    return;
                }
                catch (IOException ignored) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (out == null) throw throwable;
            try {
                ((OutputStream)out).close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
    }

    @Deprecated
    public static byte[] advertisementToBytes(Advertisement advertisement) throws JxtaException {
        try {
            Document document = advertisement.getDocument(MimeMediaType.XML_DEFAULTENCODING);
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            document.sendToStream(bo);
            return bo.toByteArray();
        }
        catch (IOException e) {
            throw new JxtaException("Error converting a document to bytes", e);
        }
    }

    @Deprecated
    public static Advertisement bytesToAdvertisement(byte[] buf) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(buf);
            Advertisement advertisement = AdvertisementFactory.newAdvertisement(MimeMediaType.XML_DEFAULTENCODING, in);
            return advertisement;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String advertisementToText(Advertisement advertisement, String mimeType) {
        try {
            StructuredTextDocument doc = (StructuredTextDocument)advertisement.getDocument(new MimeMediaType(mimeType));
            StringWriter stringWriter = new StringWriter();
            doc.sendToWriter(stringWriter);
            return stringWriter.toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String advertisementToPlainText(Advertisement advertisement) {
        return AdvertisementUtilities.advertisementToText(advertisement, MimeMediaType.TEXT_DEFAULTENCODING.toString());
    }

    @Deprecated
    public static String advertisementToXmlText(Advertisement advertisement) {
        return AdvertisementUtilities.advertisementToText(advertisement, MimeMediaType.XMLUTF8.toString());
    }

    @Deprecated
    public static Advertisement newAdvertisementFromXml(byte[] xmlTextAsBytes) throws JxtaException {
        try {
            return AdvertisementFactory.newAdvertisement(MimeMediaType.XML_DEFAULTENCODING, new ByteArrayInputStream(xmlTextAsBytes));
        }
        catch (Exception e) {
            throw new JxtaException("Unable to create Advertisement from the provided XML", e);
        }
    }

    @Deprecated
    public static Advertisement newAdvertisementFromXml(String xmlText) throws JxtaException {
        try {
            return AdvertisementFactory.newAdvertisement(MimeMediaType.XML_DEFAULTENCODING, new StringReader(xmlText));
        }
        catch (Exception e) {
            throw new JxtaException("Unable to create Advertisement from the provided XML", e);
        }
    }

    public static PipeAdvertisement createPipeAdvertisement() {
        return (PipeAdvertisement)AdvertisementFactory.newAdvertisement(PipeAdvertisement.getAdvertisementType());
    }

    public static PipeAdvertisement createPipeAdvertisement(PipeID pipeId, String pipeType) {
        PipeAdvertisement pipeAdvertisement = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(PipeAdvertisement.getAdvertisementType());
        pipeAdvertisement.setPipeID(pipeId);
        pipeAdvertisement.setType(pipeType);
        return pipeAdvertisement;
    }

    public static PipeAdvertisement createPipeAdvertisement(String pipeIdText, String pipeType) throws JxtaException {
        PipeID pipeId;
        try {
            pipeId = (PipeID)IDFactory.fromURI(new URI(pipeIdText));
        }
        catch (URISyntaxException failed) {
            IllegalArgumentException failure = new IllegalArgumentException("Bad pipe id");
            failure.initCause(failed);
            throw failure;
        }
        PipeAdvertisement pipeAdvertisement = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(PipeAdvertisement.getAdvertisementType());
        pipeAdvertisement.setPipeID(pipeId);
        pipeAdvertisement.setType(pipeType);
        return pipeAdvertisement;
    }

    public static PipeAdvertisement createPipeAdvertisement(Element root) {
        TextElement pipeAdvElement = (TextElement)DocumentUtilities.getChild(root, PipeAdvertisement.getAdvertisementType());
        if (pipeAdvElement == null) {
            return null;
        }
        return (PipeAdvertisement)AdvertisementFactory.newAdvertisement(pipeAdvElement);
    }

    public static PipeAdvertisement createPipeAdvertisement(PeerGroup peerGroup, String pipeType) {
        PipeID pipeID = IDFactory.newPipeID(peerGroup.getPeerGroupID());
        return AdvertisementUtilities.createPipeAdvertisement(pipeID, pipeType);
    }

    public static PipeAdvertisement createPipeAdvertisement(ID pipeID, String pipeType) {
        PipeAdvertisement pipeAdvertisement = AdvertisementUtilities.createPipeAdvertisement();
        pipeAdvertisement.setPipeID(pipeID);
        pipeAdvertisement.setType(pipeType);
        return pipeAdvertisement;
    }

    public static PipeAdvertisement createPipeAdvertisement(PeerGroup peerGroup, String sPipeID, String pipeType, String name) throws JxtaException {
        PipeID pipeId;
        PipeAdvertisement pipeAdvertisement = AdvertisementUtilities.createPipeAdvertisement(peerGroup, pipeType);
        try {
            pipeId = (PipeID)IDFactory.fromURI(new URI(sPipeID));
        }
        catch (URISyntaxException failed) {
            IllegalArgumentException failure = new IllegalArgumentException("Bad pipe id");
            failure.initCause(failed);
            throw failure;
        }
        pipeAdvertisement.setPipeID(pipeId);
        if (name != null) {
            pipeAdvertisement.setName(name);
        }
        return pipeAdvertisement;
    }

    @Deprecated
    public static PipeAdvertisement getPipeAdvertisement(Element root) {
        TextElement pipeAdvElement = (TextElement)DocumentUtilities.getChild(root, PipeAdvertisement.getAdvertisementType());
        if (pipeAdvElement == null) {
            return null;
        }
        return (PipeAdvertisement)AdvertisementFactory.newAdvertisement(pipeAdvElement);
    }

    @Deprecated
    public static PeerAdvertisement getPeerAdvertisement(Element root) {
        TextElement peerAdvElement = (TextElement)DocumentUtilities.getChild(root, PeerAdvertisement.getAdvertisementType());
        if (peerAdvElement == null) {
            return null;
        }
        return (PeerAdvertisement)AdvertisementFactory.newAdvertisement(peerAdvElement);
    }

    public static ModuleClassAdvertisement createModuleClassAdvertisement(String name, String description) {
        String moduleClassAdvertisementType = ModuleClassAdvertisement.getAdvertisementType();
        ModuleClassAdvertisement moduleClassAdvertisement = (ModuleClassAdvertisement)AdvertisementFactory.newAdvertisement(moduleClassAdvertisementType);
        moduleClassAdvertisement.setName(name);
        moduleClassAdvertisement.setDescription(description);
        ModuleClassID mcID = IDFactory.newModuleClassID();
        moduleClassAdvertisement.setModuleClassID(mcID);
        return moduleClassAdvertisement;
    }

    @Deprecated
    public static ModuleSpecAdvertisement createModuleSpecAdvertisement(String name, StructuredDocument param) {
        return AdvertisementUtilities.createModuleSpecAdvertisement(name, null, param);
    }

    @Deprecated
    public static ModuleSpecAdvertisement createModuleSpecAdvertisement(String name, ModuleClassAdvertisement moduleClassAdvertisement, StructuredDocument param) {
        String moduleSpecAdvertisementType = ModuleSpecAdvertisement.getAdvertisementType();
        ModuleSpecAdvertisement moduleSpecAdvertisement = (ModuleSpecAdvertisement)AdvertisementFactory.newAdvertisement(moduleSpecAdvertisementType);
        moduleSpecAdvertisement.setName(name);
        moduleSpecAdvertisement.setVersion("Unknown");
        moduleSpecAdvertisement.setCreator("Unknown");
        if (moduleClassAdvertisement != null) {
            ModuleClassID moduleClassID = moduleClassAdvertisement.getModuleClassID();
            moduleSpecAdvertisement.setModuleSpecID(IDFactory.newModuleSpecID(moduleClassID));
        }
        moduleSpecAdvertisement.setSpecURI("Unknown");
        if (param != null) {
            moduleSpecAdvertisement.setParam(param);
        }
        return moduleSpecAdvertisement;
    }

    public static void cachePeerAdvertisement(PeerGroup peerGroup, PeerAdvertisement peerAdvertisement) throws JxtaException {
        AdvertisementUtilities.cachePeerAdvertisement(peerGroup, peerAdvertisement, 0x6DDD00L, 0x6DDD00L);
    }

    private static void cachePeerAdvertisement(PeerGroup peerGroup, PeerAdvertisement peerAdvertisement, long lifetime, long lifetimeForOthers) throws JxtaException {
        try {
            DiscoveryService discoveryService = peerGroup.getDiscoveryService();
            if (peerAdvertisement.getPeerID().equals(peerGroup.getPeerID())) {
                return;
            }
            discoveryService.publish(peerAdvertisement, lifetime, lifetimeForOthers);
        }
        catch (IOException e) {
            throw new JxtaException("Unable to cache advertisement", e);
        }
    }

    @Deprecated
    public static ModuleImplAdvertisement createModuleImplAdvertisement(ModuleSpecID specID, String code, String description) {
        ModuleImplAdvertisement moduleImplAdvertisement = (ModuleImplAdvertisement)AdvertisementFactory.newAdvertisement(ModuleImplAdvertisement.getAdvertisementType());
        moduleImplAdvertisement.setModuleSpecID(specID);
        moduleImplAdvertisement.setCompat(STANDARD_COMPATABILITY);
        moduleImplAdvertisement.setCode(code);
        moduleImplAdvertisement.setUri(STANDARD_URI);
        moduleImplAdvertisement.setProvider(STANDARD_PROVIDER);
        moduleImplAdvertisement.setDescription(description);
        return moduleImplAdvertisement;
    }

    static {
        Object element2 = STANDARD_COMPATABILITY.createElement("Efmt", "JDK1.4.1");
        STANDARD_COMPATABILITY.appendChild(element2);
        element2 = STANDARD_COMPATABILITY.createElement("Bind", "V2.0 Ref Impl");
        STANDARD_COMPATABILITY.appendChild(element2);
    }
}

