/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.client;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.logging.Logger;
import javax.websocket.ClientEndpoint;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.glassfish.tyrus.core.AnnotatedEndpoint;
import org.glassfish.tyrus.core.ComponentProviderService;
import org.glassfish.tyrus.core.EndpointWrapper;
import org.glassfish.tyrus.core.ErrorCollector;
import org.glassfish.tyrus.core.ReflectionHelper;
import org.glassfish.tyrus.core.TyrusContainerProvider;
import org.glassfish.tyrus.spi.SPIEndpoint;
import org.glassfish.tyrus.spi.TyrusClientSocket;
import org.glassfish.tyrus.spi.TyrusContainer;

public class ClientManager
extends ContainerProvider
implements WebSocketContainer {
    private static final String ENGINE_PROVIDER_CLASSNAME = "org.glassfish.tyrus.container.grizzly.GrizzlyEngine";
    private static final Logger LOGGER = Logger.getLogger(ClientManager.class.getName());
    private final TyrusContainer engine;
    private final ComponentProviderService componentProvider;
    private final ErrorCollector collector = new ErrorCollector();
    private long defaultAsyncSendTimeout;
    private long defaultMaxSessionIdleTimeout;
    private int maxBinaryMessageBufferSize;
    private int maxTextMessageBufferSize;

    public static ClientManager createClient() {
        return ClientManager.createClient(ENGINE_PROVIDER_CLASSNAME);
    }

    public static ClientManager createClient(String engineProviderClassname) {
        return new ClientManager(engineProviderClassname);
    }

    protected WebSocketContainer getContainer() {
        return new ClientManager();
    }

    public ClientManager() {
        this(ENGINE_PROVIDER_CLASSNAME);
    }

    private ClientManager(String engineProviderClassname) {
        this.componentProvider = ComponentProviderService.create();
        Class engineProviderClazz = null;
        try {
            engineProviderClazz = ReflectionHelper.classForNameWithException((String)engineProviderClassname);
        }
        catch (ClassNotFoundException e) {
            this.collector.addException((Exception)e);
        }
        LOGGER.config(String.format("Provider class loaded: %s", engineProviderClassname));
        this.engine = (TyrusContainer)ReflectionHelper.getInstance((Class)engineProviderClazz, (ErrorCollector)this.collector);
        TyrusContainerProvider.getContainerProvider().setContainer((Object)this);
        if (!this.collector.isEmpty()) {
            throw new RuntimeException((Throwable)this.collector.composeComprehensiveException());
        }
    }

    public Session connectToServer(Class annotatedEndpointClass, URI path) throws DeploymentException {
        return this.connectToServer((Object)annotatedEndpointClass, null, path.toString());
    }

    public Session connectToServer(Class<? extends Endpoint> endpointClass, ClientEndpointConfig cec, URI path) throws DeploymentException {
        return this.connectToServer(endpointClass, cec, path.toString());
    }

    public Session connectToServer(Endpoint endpointInstance, ClientEndpointConfig cec, URI path) throws DeploymentException, IOException {
        return this.connectToServer((Object)endpointInstance, cec, path.toString());
    }

    public Session connectToServer(Object obj, URI path) throws DeploymentException {
        return this.connectToServer(obj, null, path.toString());
    }

    public Session connectToServer(Object obj, ClientEndpointConfig cec, URI path) throws DeploymentException {
        return this.connectToServer(obj, cec, path.toString());
    }

    Session connectToServer(Object o, ClientEndpointConfig configuration, String url) throws DeploymentException {
        TyrusClientSocket clientSocket = null;
        try {
            URI uri = new URI(url);
            String scheme = uri.getScheme();
            if (scheme == null || !scheme.equals("ws") && !scheme.equals("wss")) {
                throw new DeploymentException("Incorrect scheme in WebSocket endpoint URI=" + url);
            }
        }
        catch (URISyntaxException e) {
            throw new DeploymentException("Incorrect WebSocket endpoint URI=" + url, (Throwable)e);
        }
        try {
            ClientEndpointConfig config;
            Endpoint endpoint;
            if (o instanceof Endpoint) {
                endpoint = (Endpoint)o;
                config = configuration == null ? ClientEndpointConfig.Builder.create().build() : configuration;
            } else if (o instanceof Class) {
                if (Endpoint.class.isAssignableFrom((Class)o)) {
                    endpoint = (Endpoint)ReflectionHelper.getInstance((Class)((Class)o), (ErrorCollector)this.collector);
                    config = configuration == null ? ClientEndpointConfig.Builder.create().build() : configuration;
                } else if (((Class)o).getAnnotation(ClientEndpoint.class) != null) {
                    endpoint = AnnotatedEndpoint.fromClass((Class)((Class)o), (ComponentProviderService)this.componentProvider, (boolean)false, (ErrorCollector)this.collector);
                    config = (ClientEndpointConfig)((AnnotatedEndpoint)endpoint).getEndpointConfig();
                } else {
                    this.collector.addException((Exception)new DeploymentException(String.format("Class %s in not Endpoint descendant and does not have @ClientEndpoint", ((Class)o).getName())));
                    endpoint = null;
                    config = null;
                }
            } else {
                endpoint = AnnotatedEndpoint.fromInstance((Object)o, (ComponentProviderService)this.componentProvider, (boolean)false, (ErrorCollector)this.collector);
                config = (ClientEndpointConfig)((AnnotatedEndpoint)endpoint).getEndpointConfig();
            }
            if (endpoint != null) {
                EndpointWrapper clientEndpoint = new EndpointWrapper(endpoint, (EndpointConfig)config, this.componentProvider, (WebSocketContainer)this, url, this.collector, null);
                clientSocket = this.engine.openClientSocket(url, config, (SPIEndpoint)clientEndpoint);
            }
        }
        catch (Exception e) {
            this.collector.addException((Exception)new DeploymentException("Connection failed.", (Throwable)e));
        }
        if (!this.collector.isEmpty()) {
            throw this.collector.composeComprehensiveException();
        }
        return clientSocket == null ? null : clientSocket.getSession();
    }

    public int getDefaultMaxBinaryMessageBufferSize() {
        return this.maxBinaryMessageBufferSize;
    }

    public void setDefaultMaxBinaryMessageBufferSize(int i) {
        this.maxBinaryMessageBufferSize = i;
    }

    public int getDefaultMaxTextMessageBufferSize() {
        return this.maxTextMessageBufferSize;
    }

    public void setDefaultMaxTextMessageBufferSize(int i) {
        this.maxTextMessageBufferSize = i;
    }

    public Set<Extension> getInstalledExtensions() {
        return null;
    }

    public long getDefaultAsyncSendTimeout() {
        return this.defaultAsyncSendTimeout;
    }

    public void setAsyncSendTimeout(long timeoutmillis) {
        this.defaultAsyncSendTimeout = timeoutmillis;
    }

    public long getDefaultMaxSessionIdleTimeout() {
        return this.defaultMaxSessionIdleTimeout;
    }

    public void setDefaultMaxSessionIdleTimeout(long defaultMaxSessionIdleTimeout) {
        this.defaultMaxSessionIdleTimeout = defaultMaxSessionIdleTimeout;
    }
}

