/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.container.grizzly.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.DeploymentException;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.http.HttpClientFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOConnectorHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.glassfish.grizzly.strategies.WorkerThreadIOStrategy;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.tyrus.container.grizzly.client.GrizzlyClientFilter;
import org.glassfish.tyrus.spi.ClientEngine;

public class GrizzlyClientSocket {
    public static final String PROXY_URI = "org.glassfish.tyrus.client.proxy";
    public static final String WORKER_THREAD_POOL_CONFIG = "org.glassfish.tyrus.client.grizzly.workerThreadPoolConfig";
    public static final String SELECTOR_THREAD_POOL_CONFIG = "org.glassfish.tyrus.client.grizzly.selectorThreadPoolConfig";
    private static final Logger LOGGER = Logger.getLogger(GrizzlyClientSocket.class.getName());
    private final List<Proxy> proxies = new ArrayList<Proxy>();
    private final URI uri;
    private final long timeoutMs;
    private final SSLEngineConfigurator clientSSLEngineConfigurator;
    private final ThreadPoolConfig workerThreadPoolConfig;
    private final ThreadPoolConfig selectorThreadPoolConfig;
    private final ClientEngine engine;
    private SocketAddress socketAddress;
    private TCPNIOTransport transport;

    GrizzlyClientSocket(URI uri, long timeoutMs, ClientEngine engine, SSLEngineConfigurator clientSSLEngineConfigurator, String proxyString, ThreadPoolConfig workerThreadPoolConfig, ThreadPoolConfig selectorThreadPoolConfig) {
        this.uri = uri;
        this.timeoutMs = timeoutMs;
        this.clientSSLEngineConfigurator = clientSSLEngineConfigurator;
        this.workerThreadPoolConfig = workerThreadPoolConfig;
        this.selectorThreadPoolConfig = selectorThreadPoolConfig;
        this.engine = engine;
        this.setProxy(proxyString);
    }

    public void connect() throws IOException, DeploymentException {
        for (Proxy proxy : this.proxies) {
            GrizzlyFuture connectionGrizzlyFuture;
            try {
                this.transport = this.createTransport(this.workerThreadPoolConfig, this.selectorThreadPoolConfig);
                this.transport.start();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Transport failed to start.", e);
                throw e;
            }
            TCPNIOConnectorHandler connectorHandler = new TCPNIOConnectorHandler(this.transport){};
            connectorHandler.setSyncConnectTimeout(this.timeoutMs, TimeUnit.MILLISECONDS);
            ClientEngine.TimeoutHandler timeoutHandler = new ClientEngine.TimeoutHandler(){

                public void handleTimeout() {
                    GrizzlyClientSocket.this.closeTransport();
                }
            };
            switch (proxy.type()) {
                case DIRECT: {
                    connectorHandler.setProcessor(GrizzlyClientSocket.createFilterChain(this.engine, null, this.clientSSLEngineConfigurator, false, this.uri, timeoutHandler));
                    LOGGER.log(Level.CONFIG, String.format("Connecting to '%s' (no proxy).", this.uri));
                    connectionGrizzlyFuture = connectorHandler.connect(this.socketAddress);
                    break;
                }
                default: {
                    InetSocketAddress inetSocketAddress;
                    connectorHandler.setProcessor(GrizzlyClientSocket.createFilterChain(this.engine, null, this.clientSSLEngineConfigurator, true, this.uri, timeoutHandler));
                    LOGGER.log(Level.CONFIG, String.format("Connecting to '%s' via proxy '%s'.", this.uri, proxy));
                    SocketAddress address = proxy.address();
                    if (address instanceof InetSocketAddress && (inetSocketAddress = (InetSocketAddress)address).isUnresolved()) {
                        address = new InetSocketAddress(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
                    }
                    connectionGrizzlyFuture = connectorHandler.connect(address);
                }
            }
            try {
                Connection connection = (Connection)connectionGrizzlyFuture.get(this.timeoutMs, TimeUnit.MILLISECONDS);
                LOGGER.log(Level.CONFIG, String.format("Connected to '%s'.", connection.getPeerAddress()));
                return;
            }
            catch (InterruptedException interruptedException) {
                LOGGER.log(Level.CONFIG, String.format("Connection to '%s' failed.", this.uri), interruptedException);
                this.closeTransport();
            }
            catch (TimeoutException timeoutException) {
                LOGGER.log(Level.CONFIG, String.format("Connection to '%s' failed.", this.uri), timeoutException);
                this.closeTransport();
            }
            catch (ExecutionException exectionException) {
                LOGGER.log(Level.CONFIG, String.format("Connection to '%s' failed.", this.uri), exectionException);
                IOException ioException = null;
                Throwable cause = exectionException.getCause();
                if (cause != null && cause instanceof IOException) {
                    ioException = (IOException)cause;
                    ProxySelector.getDefault().connectFailed(this.uri, this.socketAddress, ioException);
                }
                this.closeTransport();
                if (ioException == null) continue;
                throw ioException;
            }
        }
        throw new DeploymentException("Connection failed.");
    }

    private TCPNIOTransport createTransport(ThreadPoolConfig workerThreadPoolConfig, ThreadPoolConfig selectorThreadPoolConfig) {
        TCPNIOTransportBuilder transportBuilder = TCPNIOTransportBuilder.newInstance();
        if (workerThreadPoolConfig == null) {
            transportBuilder.setWorkerThreadPoolConfig(ThreadPoolConfig.defaultConfig().setMaxPoolSize(2).setCorePoolSize(2));
        } else {
            transportBuilder.setWorkerThreadPoolConfig(workerThreadPoolConfig);
        }
        if (selectorThreadPoolConfig == null) {
            transportBuilder.setSelectorThreadPoolConfig(ThreadPoolConfig.defaultConfig().setMaxPoolSize(1).setCorePoolSize(1));
        } else {
            transportBuilder.setSelectorThreadPoolConfig(selectorThreadPoolConfig);
        }
        transportBuilder.setIOStrategy((IOStrategy)WorkerThreadIOStrategy.getInstance());
        return transportBuilder.build();
    }

    private void setProxy(String proxyString) {
        try {
            if (proxyString != null) {
                URI proxyUri = new URI(proxyString);
                if (proxyUri.getHost() == null) {
                    LOGGER.log(Level.WARNING, String.format("Invalid proxy '%s'.", proxyString));
                } else {
                    int proxyPort = proxyUri.getPort() == -1 ? 80 : proxyUri.getPort();
                    this.proxies.add(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyUri.getHost(), proxyPort)));
                }
            }
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.WARNING, String.format("Invalid proxy '%s'.", proxyString), e);
        }
        ProxySelector proxySelector = ProxySelector.getDefault();
        this.addProxies(proxySelector, this.uri, "socket", this.proxies);
        this.addProxies(proxySelector, this.uri, "https", this.proxies);
        this.addProxies(proxySelector, this.uri, "http", this.proxies);
        this.proxies.add(Proxy.NO_PROXY);
        int port = this.uri.getPort();
        if (port == -1) {
            String scheme = this.uri.getScheme();
            assert (scheme != null && (scheme.equals("ws") || scheme.equals("wss")));
            if (scheme.equals("ws")) {
                port = 80;
            } else if (scheme.equals("wss")) {
                port = 443;
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, String.format(String.format("Not using proxy for URI '%s'.", this.uri), new Object[0]));
        }
        this.socketAddress = new InetSocketAddress(this.uri.getHost(), port);
    }

    private void addProxies(ProxySelector proxySelector, URI uri, String scheme, List<Proxy> proxies) {
        for (Proxy p : proxySelector.select(this.getProxyUri(uri, scheme))) {
            switch (p.type()) {
                case HTTP: {
                    LOGGER.log(Level.FINE, String.format("Found proxy: '%s'", p));
                    proxies.add(p);
                    break;
                }
                case SOCKS: {
                    LOGGER.log(Level.INFO, String.format("Socks proxy is not supported, please file new issue at https://java.net/jira/browse/TYRUS. Proxy '%s' will be ignored.", p));
                    break;
                }
            }
        }
    }

    private URI getProxyUri(URI wsUri, String scheme) {
        try {
            return new URI(scheme, wsUri.getUserInfo(), wsUri.getHost(), wsUri.getPort(), wsUri.getPath(), wsUri.getQuery(), wsUri.getFragment());
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.WARNING, String.format("Exception during generating proxy URI '%s'", wsUri), e);
            return wsUri;
        }
    }

    private static Processor createFilterChain(ClientEngine engine, SSLEngineConfigurator serverSSLEngineConfigurator, SSLEngineConfigurator clientSSLEngineConfigurator, boolean proxy, URI uri, ClientEngine.TimeoutHandler timeoutHandler) {
        FilterChainBuilder clientFilterChainBuilder = FilterChainBuilder.stateless();
        Object sslFilter = null;
        clientFilterChainBuilder.add((Filter)new TransportFilter());
        if (serverSSLEngineConfigurator != null || clientSSLEngineConfigurator != null) {
            sslFilter = new SSLFilter(serverSSLEngineConfigurator, clientSSLEngineConfigurator);
            if (proxy) {
                sslFilter = new FilterWrapper((Filter)sslFilter);
            }
            clientFilterChainBuilder.add((Filter)sslFilter);
        }
        clientFilterChainBuilder.add((Filter)new HttpClientFilter());
        clientFilterChainBuilder.add((Filter)new GrizzlyClientFilter(engine, proxy, (Filter)sslFilter, uri, timeoutHandler));
        return clientFilterChainBuilder.build();
    }

    private void closeTransport() {
        if (this.transport != null) {
            try {
                this.transport.shutdownNow();
            }
            catch (IOException e) {
                Logger.getLogger(GrizzlyClientSocket.class.getName()).log(Level.INFO, "Exception thrown when closing Grizzly transport: " + e.getMessage(), e);
            }
        }
    }

    static class FilterWrapper
    implements Filter {
        private final Filter filter;
        private boolean enabled = false;

        FilterWrapper(Filter filter) {
            this.filter = filter;
        }

        public void enable() {
            this.enabled = true;
        }

        public void onAdded(FilterChain filterChain) {
            this.filter.onAdded(filterChain);
        }

        public void onRemoved(FilterChain filterChain) {
            this.filter.onRemoved(filterChain);
        }

        public void onFilterChainChanged(FilterChain filterChain) {
            this.filter.onFilterChainChanged(filterChain);
        }

        public NextAction handleRead(FilterChainContext ctx) throws IOException {
            if (this.enabled) {
                return this.filter.handleRead(ctx);
            }
            return ctx.getInvokeAction();
        }

        public NextAction handleWrite(FilterChainContext ctx) throws IOException {
            if (this.enabled) {
                return this.filter.handleWrite(ctx);
            }
            return ctx.getInvokeAction();
        }

        public NextAction handleConnect(FilterChainContext ctx) throws IOException {
            return ctx.getInvokeAction();
        }

        public NextAction handleAccept(FilterChainContext ctx) throws IOException {
            return ctx.getInvokeAction();
        }

        public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
            if (this.enabled) {
                return this.filter.handleEvent(ctx, event);
            }
            return ctx.getInvokeAction();
        }

        public NextAction handleClose(FilterChainContext ctx) throws IOException {
            if (this.enabled) {
                return this.filter.handleClose(ctx);
            }
            return ctx.getInvokeAction();
        }

        public void exceptionOccurred(FilterChainContext ctx, Throwable error) {
            if (this.enabled) {
                this.filter.exceptionOccurred(ctx, error);
            } else {
                ctx.getInvokeAction();
            }
        }
    }
}

