/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.container.jdk.client;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Queue;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import org.glassfish.tyrus.container.jdk.client.Filter;
import org.glassfish.tyrus.container.jdk.client.SslEngineConfigurator;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.spi.CompletionHandler;

class SslFilter
extends Filter {
    private static final ByteBuffer emptyBuffer = ByteBuffer.allocate(0);
    private static final String TLSV13 = "TLSv1.3";
    private final ByteBuffer applicationInputBuffer;
    private final ByteBuffer networkOutputBuffer;
    private final SSLEngine sslEngine;
    private final HostnameVerifier customHostnameVerifier;
    private final String serverHost;
    private final WriteQueue writeQueue = new WriteQueue();
    private volatile State state = State.NOT_STARTED;
    private volatile boolean tlsv13 = false;
    private Runnable pendingApplicationWrite = null;

    SslFilter(Filter downstreamFilter, org.glassfish.tyrus.client.SslEngineConfigurator sslEngineConfigurator, String serverHost) {
        super(downstreamFilter);
        this.serverHost = serverHost;
        this.sslEngine = sslEngineConfigurator.createSSLEngine(serverHost);
        this.customHostnameVerifier = sslEngineConfigurator.getHostnameVerifier();
        if (sslEngineConfigurator.isHostVerificationEnabled() && sslEngineConfigurator.getHostnameVerifier() == null) {
            SSLParameters sslParameters = this.sslEngine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            this.sslEngine.setSSLParameters(sslParameters);
        }
        this.applicationInputBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getApplicationBufferSize());
        this.networkOutputBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getPacketBufferSize());
    }

    SslFilter(Filter downstreamFilter, SSLContext sslContext, String serverHost) {
        this(downstreamFilter, new org.glassfish.tyrus.client.SslEngineConfigurator(sslContext), serverHost);
    }

    SslFilter(Filter downstreamFilter, SslEngineConfigurator sslEngineConfigurator) {
        super(downstreamFilter);
        this.sslEngine = sslEngineConfigurator.createSSLEngine();
        this.applicationInputBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getApplicationBufferSize());
        this.networkOutputBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getPacketBufferSize());
        this.customHostnameVerifier = null;
        this.serverHost = null;
    }

    @Override
    synchronized void write(ByteBuffer applicationData, CompletionHandler<ByteBuffer> completionHandler) {
        switch (this.state) {
            case NOT_STARTED: {
                this.writeQueue.write(applicationData, completionHandler);
                return;
            }
            case HANDSHAKING: {
                completionHandler.failed((Throwable)new IllegalStateException("Cannot write until SSL handshake has been completed"));
                break;
            }
            case REHANDSHAKING: {
                this.storePendingApplicationWrite(applicationData, completionHandler);
                break;
            }
            case DATA: {
                this.handleWrite(applicationData, completionHandler);
                break;
            }
            case CLOSED: {
                completionHandler.failed((Throwable)new IllegalStateException("SSL session has been closed"));
            }
        }
    }

    private void handleWrite(final ByteBuffer applicationData, final CompletionHandler<ByteBuffer> completionHandler) {
        try {
            ((Buffer)this.networkOutputBuffer).clear();
            SSLEngineResult result = this.sslEngine.wrap(applicationData, this.networkOutputBuffer);
            switch (result.getStatus()) {
                case BUFFER_OVERFLOW: {
                    throw new IllegalStateException("SSL packet does not fit into the network buffer: " + this.networkOutputBuffer + "\n" + this.getDebugState());
                }
                case BUFFER_UNDERFLOW: {
                    throw new IllegalStateException("SSL engine underflow with the following application input: " + applicationData + "\n" + this.getDebugState());
                }
                case CLOSED: {
                    this.setState(State.CLOSED);
                    break;
                }
                case OK: {
                    if (this.isHandshaking(result.getHandshakeStatus())) {
                        this.setState(State.REHANDSHAKING);
                    }
                    ((Buffer)this.networkOutputBuffer).flip();
                    if (this.networkOutputBuffer.hasRemaining()) {
                        this.writeQueue.write(this.networkOutputBuffer, new CompletionHandler<ByteBuffer>(){

                            public void completed(ByteBuffer result) {
                                SslFilter.this.handlePostWrite(applicationData, (CompletionHandler<ByteBuffer>)completionHandler);
                            }

                            public void failed(Throwable throwable) {
                                completionHandler.failed(throwable);
                            }
                        });
                        break;
                    }
                    this.handlePostWrite(applicationData, completionHandler);
                }
            }
        }
        catch (SSLException e) {
            this.handleSslError(e);
        }
    }

    private synchronized void handlePostWrite(ByteBuffer applicationData, CompletionHandler<ByteBuffer> completionHandler) {
        if (this.state == State.REHANDSHAKING) {
            if (applicationData.hasRemaining()) {
                this.storePendingApplicationWrite(applicationData, completionHandler);
                this.doHandshakeStep(emptyBuffer);
            }
        } else if (applicationData.hasRemaining()) {
            this.handleWrite(applicationData, completionHandler);
        } else {
            completionHandler.completed((Object)applicationData);
        }
    }

    private void storePendingApplicationWrite(final ByteBuffer applicationData, final CompletionHandler<ByteBuffer> completionHandler) {
        if (this.pendingApplicationWrite != null) {
            throw new IllegalStateException("Only one write operation can be in progress\n" + this.getDebugState());
        }
        this.pendingApplicationWrite = new Runnable(){

            @Override
            public void run() {
                SslFilter.this.write(applicationData, (CompletionHandler<ByteBuffer>)completionHandler);
            }
        };
    }

    @Override
    synchronized void close() {
        if (this.state == State.NOT_STARTED) {
            this.downstreamFilter.close();
            return;
        }
        this.sslEngine.closeOutbound();
        try {
            ByteBuffer buffer;
            LazyBuffer lazyBuffer = new LazyBuffer();
            while (this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                buffer = lazyBuffer.get();
                SSLEngineResult result = this.sslEngine.wrap(emptyBuffer, buffer);
                switch (result.getStatus()) {
                    case BUFFER_OVERFLOW: {
                        lazyBuffer.resize();
                        break;
                    }
                    case BUFFER_UNDERFLOW: {
                        throw new IllegalStateException("SSL engine underflow while close operation \n" + this.getDebugState());
                    }
                }
            }
            if (lazyBuffer.isAllocated()) {
                buffer = lazyBuffer.get();
                ((Buffer)buffer).flip();
                this.writeQueue.write(buffer, new CompletionHandler<ByteBuffer>(){

                    public void completed(ByteBuffer result) {
                        SslFilter.this.downstreamFilter.close();
                    }

                    public void failed(Throwable throwable) {
                        SslFilter.this.downstreamFilter.close();
                    }
                });
            } else {
                this.downstreamFilter.close();
            }
        }
        catch (Exception e) {
            this.handleSslError(e);
        }
    }

    @Override
    boolean processRead(ByteBuffer networkData) {
        boolean readMore = true;
        while (networkData.hasRemaining() && readMore) {
            switch (this.state) {
                case NOT_STARTED: {
                    return true;
                }
                case HANDSHAKING: 
                case REHANDSHAKING: {
                    readMore = this.doHandshakeStep(networkData);
                    break;
                }
                case DATA: {
                    readMore = this.handleRead(networkData);
                    break;
                }
                case CLOSED: {
                    ((Buffer)networkData).clear();
                    readMore = false;
                }
            }
        }
        return false;
    }

    private boolean handleRead(ByteBuffer networkData) {
        try {
            ((Buffer)this.applicationInputBuffer).clear();
            SSLEngineResult result = this.sslEngine.unwrap(networkData, this.applicationInputBuffer);
            switch (result.getStatus()) {
                case BUFFER_OVERFLOW: {
                    throw new IllegalStateException("Contents of a SSL packet did not fit into buffer: " + this.applicationInputBuffer + "\n" + this.getDebugState());
                }
                case BUFFER_UNDERFLOW: {
                    return false;
                }
                case CLOSED: 
                case OK: {
                    if (result.bytesProduced() > 0) {
                        ((Buffer)this.applicationInputBuffer).flip();
                        this.upstreamFilter.onRead(this.applicationInputBuffer);
                        this.applicationInputBuffer.compact();
                    }
                    if (this.sslEngine.isInboundDone()) {
                        return false;
                    }
                    if (this.tlsv13 || !this.isHandshaking(result.getHandshakeStatus()) || this.sslEngine.isOutboundDone()) break;
                    this.setState(State.REHANDSHAKING);
                    return this.doHandshakeStep(networkData);
                }
            }
        }
        catch (SSLException e) {
            this.handleSslError(e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doHandshakeStep(ByteBuffer networkData) {
        LazyBuffer inputBuffer = new LazyBuffer();
        boolean handshakeFinished = false;
        SslFilter sslFilter = this;
        synchronized (sslFilter) {
            SSLEngineResult.HandshakeStatus hs = this.sslEngine.getHandshakeStatus();
            if (!this.isHandshaking(hs)) {
                return true;
            }
            try {
                LazyBuffer outputBuffer = new LazyBuffer();
                boolean stepFinished = false;
                while (!stepFinished) {
                    hs = this.sslEngine.getHandshakeStatus();
                    block3 : switch (hs) {
                        case NOT_HANDSHAKING: {
                            throw new IllegalStateException("Trying to handshake, but SSL engine not in HANDSHAKING state.SSL filter state: \n" + this.getDebugState());
                        }
                        case FINISHED: {
                            throw new IllegalStateException("Trying to handshake, but SSL engine not in HANDSHAKING state.SSL filter state: \n" + this.getDebugState());
                        }
                        case NEED_WRAP: {
                            ByteBuffer byteBuffer = outputBuffer.get();
                            SSLEngineResult result = this.sslEngine.wrap(emptyBuffer, byteBuffer);
                            if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                                stepFinished = true;
                                handshakeFinished = true;
                            }
                            switch (result.getStatus()) {
                                case BUFFER_OVERFLOW: {
                                    outputBuffer.resize();
                                    break block3;
                                }
                                case BUFFER_UNDERFLOW: {
                                    throw new IllegalStateException("SSL engine underflow with the following SSL filter state: \n" + this.getDebugState());
                                }
                                case CLOSED: {
                                    stepFinished = true;
                                    this.setState(State.CLOSED);
                                }
                            }
                            break;
                        }
                        case NEED_UNWRAP: {
                            SSLEngineResult result = this.sslEngine.unwrap(networkData, this.applicationInputBuffer);
                            ((Buffer)this.applicationInputBuffer).flip();
                            if (this.applicationInputBuffer.hasRemaining()) {
                                inputBuffer.append(this.applicationInputBuffer);
                            }
                            this.applicationInputBuffer.compact();
                            if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                                stepFinished = true;
                                handshakeFinished = true;
                            }
                            switch (result.getStatus()) {
                                case BUFFER_OVERFLOW: {
                                    throw new IllegalStateException("SSL packet does not fit into the network buffer: " + this.getDebugState());
                                }
                                case BUFFER_UNDERFLOW: {
                                    stepFinished = true;
                                    break block3;
                                }
                                case CLOSED: {
                                    stepFinished = true;
                                    this.setState(State.CLOSED);
                                }
                            }
                            break;
                        }
                        case NEED_TASK: {
                            Runnable delegatedTask;
                            while ((delegatedTask = this.sslEngine.getDelegatedTask()) != null) {
                                delegatedTask.run();
                            }
                            break;
                        }
                    }
                }
                if (outputBuffer.isAllocated()) {
                    ByteBuffer buffer = outputBuffer.get();
                    ((Buffer)buffer).flip();
                    this.writeQueue.write(buffer, null);
                }
            }
            catch (Exception e) {
                this.handleSslError(e);
            }
        }
        if (inputBuffer.isAllocated()) {
            ByteBuffer buffer = inputBuffer.get();
            this.upstreamFilter.onRead(buffer);
        }
        if (handshakeFinished) {
            this.handleHandshakeFinished();
            this.tlsv13 = TLSV13.equals(this.sslEngine.getSession().getProtocol());
            return true;
        }
        return false;
    }

    private void handleHandshakeFinished() {
        if (this.customHostnameVerifier != null && !this.customHostnameVerifier.verify(this.serverHost, this.sslEngine.getSession())) {
            this.handleSslError(new SSLException("Server host name verification using " + this.customHostnameVerifier.getClass() + " has failed"));
            return;
        }
        if (this.state == State.HANDSHAKING) {
            this.setState(State.DATA);
            this.upstreamFilter.onSslHandshakeCompleted();
        } else if (this.state == State.REHANDSHAKING) {
            this.setState(State.DATA);
            if (this.pendingApplicationWrite != null) {
                Runnable write = this.pendingApplicationWrite;
                this.pendingApplicationWrite = null;
                write.run();
            }
        }
    }

    private void handleSslError(Throwable t) {
        this.onError(t);
    }

    @Override
    void startSsl() {
        try {
            this.setState(State.HANDSHAKING);
            this.sslEngine.beginHandshake();
            this.doHandshakeStep(emptyBuffer);
        }
        catch (SSLException e) {
            this.handleSslError(e);
        }
    }

    void rehandshake() {
        try {
            this.sslEngine.beginHandshake();
        }
        catch (SSLException e) {
            this.handleSslError(e);
        }
    }

    private String getDebugState() {
        return "SslFilter{\napplicationInputBuffer=" + this.applicationInputBuffer + ",\nnetworkOutputBuffer=" + this.networkOutputBuffer + ",\nsslEngineStatus=" + this.sslEngine.getHandshakeStatus() + ",\nsslSession=" + this.sslEngine.getSession() + ",\nstate=" + this.state + ",\npendingApplicationWrite=" + this.pendingApplicationWrite + ",\npendingWritesSize=" + this.writeQueue + "}";
    }

    private void setState(State state) {
        this.state = state;
    }

    private boolean isHandshaking(SSLEngineResult.HandshakeStatus hs) {
        return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING != hs && SSLEngineResult.HandshakeStatus.FINISHED != hs;
    }

    private class WriteQueue {
        private final Queue<Runnable> pendingWrites = new LinkedList<Runnable>();

        private WriteQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void write(final ByteBuffer data, final CompletionHandler<ByteBuffer> completionHandler) {
            SslFilter sslFilter = SslFilter.this;
            synchronized (sslFilter) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        SslFilter.this.downstreamFilter.write(data, new CompletionHandler<ByteBuffer>(){

                            public void completed(ByteBuffer result) {
                                if (completionHandler != null) {
                                    completionHandler.completed((Object)result);
                                }
                                WriteQueue.this.onWriteCompleted();
                            }

                            public void failed(Throwable throwable) {
                                if (completionHandler != null) {
                                    completionHandler.failed(throwable);
                                }
                                WriteQueue.this.onWriteCompleted();
                            }
                        });
                    }
                };
                this.pendingWrites.offer(r);
                if (this.pendingWrites.peek() == r) {
                    r.run();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onWriteCompleted() {
            SslFilter sslFilter = SslFilter.this;
            synchronized (sslFilter) {
                this.pendingWrites.poll();
                Runnable next = this.pendingWrites.peek();
                if (next != null) {
                    next.run();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            SslFilter sslFilter = SslFilter.this;
            synchronized (sslFilter) {
                return "WriteQueue{pendingWrites=" + this.pendingWrites.size() + "}";
            }
        }
    }

    private class LazyBuffer {
        private ByteBuffer buffer = null;

        private LazyBuffer() {
        }

        ByteBuffer get() {
            if (this.buffer == null) {
                this.buffer = ByteBuffer.allocate(SslFilter.this.sslEngine.getSession().getPacketBufferSize());
            }
            return this.buffer;
        }

        boolean isAllocated() {
            return this.buffer != null;
        }

        void resize() {
            int increment = SslFilter.this.sslEngine.getSession().getPacketBufferSize();
            int newSize = this.buffer.position() + increment;
            ByteBuffer newBuffer = ByteBuffer.allocate(newSize);
            ((Buffer)this.buffer).flip();
            ((Buffer)newBuffer).flip();
            this.buffer = Utils.appendBuffers((ByteBuffer)newBuffer, (ByteBuffer)this.buffer, (int)newBuffer.limit(), (int)50);
            this.buffer.compact();
        }

        void append(ByteBuffer b) {
            if (this.buffer == null) {
                this.buffer = ByteBuffer.allocate(b.remaining());
                ((Buffer)this.buffer).flip();
            }
            int newSize = this.buffer.limit() + b.remaining();
            this.buffer = Utils.appendBuffers((ByteBuffer)this.buffer, (ByteBuffer)b, (int)newSize, (int)50);
        }
    }

    private static enum State {
        NOT_STARTED,
        HANDSHAKING,
        REHANDSHAKING,
        DATA,
        CLOSED;

    }
}

