/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.servlet;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.WebConnection;
import org.glassfish.tyrus.websockets.DataFrame;
import org.glassfish.tyrus.websockets.FramingException;
import org.glassfish.tyrus.websockets.WebSocketEngine;
import org.glassfish.tyrus.websockets.draft06.ClosingFrame;

public class TyrusHttpUpgradeHandler
implements HttpUpgradeHandler,
ReadListener {
    private ServletInputStream is;
    private ServletOutputStream os;
    private WebConnection wc;
    private ByteBuffer buf;
    private boolean closed = false;
    private static final Logger LOGGER = Logger.getLogger(TyrusHttpUpgradeHandler.class.getName());
    private WebSocketEngine.WebSocketHolder webSocketHolder;

    public void init(WebConnection wc) {
        LOGGER.config("Servlet 3.1 Upgrade");
        try {
            this.is = wc.getInputStream();
            this.os = wc.getOutputStream();
            this.wc = wc;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.is.setReadListener((ReadListener)this);
        if (this.is.isReady()) {
            this.onDataAvailable();
        }
    }

    public void onDataAvailable() {
        try {
            int remaining;
            do {
                DataFrame result;
                if (this.is.isReady()) {
                    this.fillBuf();
                }
                LOGGER.finest("Remaining Data = " + this.buf.remaining());
                remaining = this.buf.remaining();
                if (this.buf == null || !this.buf.hasRemaining() || (result = this.webSocketHolder.handler.unframe(this.buf)) == null) continue;
                result.respond(this.webSocketHolder.webSocket);
            } while ((remaining != this.buf.remaining() || this.is.isReady()) && (this.buf.remaining() > 0 || this.is.isReady()));
        }
        catch (FramingException e) {
            String message = e.getMessage();
            this.webSocketHolder.webSocket.onClose(new ClosingFrame(e.getClosingCode(), message == null ? "No reason given." : message));
            try {
                if (!this.closed) {
                    this.wc.close();
                    this.closed = true;
                }
            }
            catch (Exception f) {
                LOGGER.log(Level.CONFIG, f.getMessage(), f);
            }
        }
        catch (Exception wse) {
            if (this.webSocketHolder.application.onError(this.webSocketHolder.webSocket, (Throwable)wse)) {
                String message = wse.getMessage();
                this.webSocketHolder.webSocket.onClose(new ClosingFrame(1011, message == null ? "No reason given." : message));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void fillBuf() throws IOException {
        do {
            byte[] data;
            int len;
            if ((len = this.is.read(data = new byte[200])) == 0) {
                throw new RuntimeException("No data available.");
            }
            if (this.buf == null) {
                LOGGER.finest("No Buffer. Allocating new one");
                this.buf = ByteBuffer.wrap(data);
                this.buf.limit(len);
                continue;
            }
            int limit = this.buf.limit();
            int capacity = this.buf.capacity();
            int remaining = this.buf.remaining();
            if (capacity - limit >= len) {
                LOGGER.finest("Remaining data need not be moved. New data is just appended");
                this.buf.mark();
                this.buf.position(limit);
                this.buf.limit(capacity);
                this.buf.put(data, 0, len);
                this.buf.limit(limit + len);
                this.buf.reset();
                continue;
            }
            if (remaining + len < capacity) {
                LOGGER.finest("Remaining data is moved to left. Then new data is appended");
                this.buf.compact();
                this.buf.put(data, 0, len);
                this.buf.flip();
                continue;
            }
            LOGGER.finest("Remaining data + new > capacity. So allocate new one");
            byte[] array = new byte[remaining + len];
            this.buf.get(array, 0, remaining);
            System.arraycopy(data, 0, array, remaining, len);
            this.buf = ByteBuffer.wrap(array);
            this.buf.limit(remaining + len);
        } while (this.is.isReady());
    }

    public void onAllDataRead() {
        this.webSocketHolder.webSocket.onClose(new ClosingFrame(1000, null));
    }

    public void onError(Throwable t) {
        String message = t == null ? null : t.getMessage();
        this.webSocketHolder.webSocket.onClose(new ClosingFrame(1000, message == null ? "No reason given." : message));
        try {
            if (!this.closed) {
                this.wc.close();
                this.closed = true;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.CONFIG, e.getMessage(), e);
        }
    }

    public void destroy() {
    }

    public void setWebSocketHolder(WebSocketEngine.WebSocketHolder webSocketHolder) {
        this.webSocketHolder = webSocketHolder;
    }

    ServletOutputStream getOutputStream() {
        return this.os;
    }
}

