/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.servlet;

import java.util.Set;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;
import javax.websocket.Endpoint;
import javax.websocket.server.ServerApplicationConfiguration;
import javax.websocket.server.WebSocketEndpoint;
import org.glassfish.tyrus.server.ApplicationConfig;
import org.glassfish.tyrus.servlet.TyrusServletFilter;

@HandlesTypes(value={WebSocketEndpoint.class, ApplicationConfig.class, ServerApplicationConfiguration.class, Endpoint.class})
public class TyrusServletContainerInitializer
implements ServletContainerInitializer {
    private static final Logger LOGGER = Logger.getLogger(TyrusServletContainerInitializer.class.getName());

    public void onStartup(Set<Class<?>> classes, ServletContext ctx) throws ServletException {
        if (classes == null || classes.isEmpty()) {
            return;
        }
        FilterRegistration.Dynamic reg = ctx.addFilter("WebSocket filter", (Filter)new TyrusServletFilter(classes));
        reg.setAsyncSupported(true);
        reg.addMappingForUrlPatterns(null, true, new String[]{"/*"});
        LOGGER.info("Registering WebSocket filter for url pattern /*");
    }
}

