/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.servlet;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;
import javax.websocket.server.ServerApplicationConfiguration;
import javax.websocket.server.ServerEndpointConfiguration;
import javax.websocket.server.WebSocketEndpoint;
import org.glassfish.tyrus.AnnotatedEndpoint;
import org.glassfish.tyrus.server.TyrusServerConfiguration;
import org.glassfish.tyrus.servlet.TyrusServletFilter;

@HandlesTypes(value={WebSocketEndpoint.class, ServerApplicationConfiguration.class, ServerEndpointConfiguration.class})
public class TyrusServletContainerInitializer
implements ServletContainerInitializer {
    private static final Logger LOGGER = Logger.getLogger(TyrusServletContainerInitializer.class.getName());
    private static final Set<Class<?>> FILTERED_CLASSES = new HashSet<Class<?>>(){
        {
            this.add(AnnotatedEndpoint.class);
            this.add(TyrusServerConfiguration.class);
        }
    };

    public void onStartup(Set<Class<?>> classes, ServletContext ctx) throws ServletException {
        if (classes == null || classes.isEmpty()) {
            return;
        }
        Iterator<Class<?>> it = classes.iterator();
        while (it.hasNext()) {
            Class<?> cls = it.next();
            if (!FILTERED_CLASSES.contains(cls)) continue;
            it.remove();
        }
        FilterRegistration.Dynamic reg = ctx.addFilter("WebSocket filter", (Filter)new TyrusServletFilter(classes));
        reg.setAsyncSupported(true);
        reg.addMappingForUrlPatterns(null, true, new String[]{"/*"});
        LOGGER.info("Registering WebSocket filter for url pattern /*");
    }
}

