/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.servlet;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;
import javax.websocket.Endpoint;
import javax.websocket.server.ServerApplicationConfig;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerContainerProvider;
import javax.websocket.server.ServerEndpoint;
import org.glassfish.tyrus.server.TyrusServerConfiguration;
import org.glassfish.tyrus.servlet.TyrusServerContainerProvider;
import org.glassfish.tyrus.servlet.TyrusServletFilter;

@HandlesTypes(value={ServerEndpoint.class, ServerApplicationConfig.class, Endpoint.class})
public class TyrusServletContainerInitializer
implements ServletContainerInitializer {
    static final Logger LOGGER = Logger.getLogger(TyrusServletContainerInitializer.class.getName());
    private static final Set<Class<?>> FILTERED_CLASSES = new HashSet<Class<?>>(){
        {
            this.add(TyrusServerConfiguration.class);
        }
    };

    public void onStartup(Set<Class<?>> classes, ServletContext ctx) throws ServletException {
        if (classes == null || classes.isEmpty()) {
            ServerContainer serverContainer = ServerContainerProvider.getServerContainer();
            if (serverContainer instanceof TyrusServerContainerProvider) {
                ((TyrusServerContainerProvider)serverContainer).setTyrusFilter(new TyrusServletFilter(ctx));
            } else {
                LOGGER.log(Level.WARNING, "ServerContainer.deploy is not supported.");
            }
            return;
        }
        Iterator<Class<?>> it = classes.iterator();
        while (it.hasNext()) {
            Class<?> cls = it.next();
            if (!FILTERED_CLASSES.contains(cls)) continue;
            it.remove();
        }
        TyrusServletFilter filter = new TyrusServletFilter(classes);
        FilterRegistration.Dynamic reg = ctx.addFilter("WebSocket filter", (Filter)filter);
        reg.setAsyncSupported(true);
        reg.addMappingForUrlPatterns(null, true, new String[]{"/*"});
        LOGGER.info("Registering WebSocket filter for url pattern /*");
        ServerContainer serverContainer = ServerContainerProvider.getServerContainer();
        if (serverContainer instanceof TyrusServerContainerProvider) {
            ((TyrusServerContainerProvider)serverContainer).setTyrusFilter(filter);
        } else {
            LOGGER.log(Level.WARNING, "ServerContainer.deploy is not supported.");
        }
    }
}

