/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.servlet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.WebConnection;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerContainerProvider;
import javax.websocket.server.ServerEndpointConfig;
import org.glassfish.tyrus.server.ServerContainerFactory;
import org.glassfish.tyrus.server.TyrusServerContainer;
import org.glassfish.tyrus.servlet.ConnectionImpl;
import org.glassfish.tyrus.servlet.ServletContainer;
import org.glassfish.tyrus.servlet.TyrusHttpUpgradeHandler;
import org.glassfish.tyrus.servlet.TyrusServerContainerProvider;
import org.glassfish.tyrus.servlet.TyrusServletContainerInitializer;
import org.glassfish.tyrus.websockets.Connection;
import org.glassfish.tyrus.websockets.HandshakeException;
import org.glassfish.tyrus.websockets.WebSocketEngine;
import org.glassfish.tyrus.websockets.WebSocketRequest;

class TyrusServletFilter
implements Filter {
    private static final int INFORMATIONAL_FIXED_PORT = 8080;
    private static final Logger LOGGER = Logger.getLogger(TyrusServletFilter.class.getName());
    private final WebSocketEngine engine;
    private TyrusServerContainer serverContainer = null;
    private boolean registered = false;
    private final Set<Class<?>> classes;
    private final ServletContext servletContext;
    private final Set<Class<?>> dynamicallyDeployedClasses = new HashSet();
    private final Set<ServerEndpointConfig> dynamicallyDeployedServerEndpointConfigs = new HashSet<ServerEndpointConfig>();

    public TyrusServletFilter(Set<Class<?>> classes) {
        this.classes = classes;
        this.servletContext = null;
        this.engine = WebSocketEngine.getEngine();
    }

    public TyrusServletFilter(ServletContext servletContext) {
        this.classes = null;
        this.servletContext = servletContext;
        this.engine = WebSocketEngine.getEngine();
    }

    void addClass(Class<?> clazz) {
        if (this.serverContainer != null) {
            throw new IllegalStateException("Filter already initiated.");
        }
        this.dynamicallyDeployedClasses.add(clazz);
        this.checkFilterRegistration();
    }

    void addServerEndpointConfig(ServerEndpointConfig serverEndpointConfig) {
        if (this.serverContainer != null) {
            throw new IllegalStateException("Filter already initiated.");
        }
        this.dynamicallyDeployedServerEndpointConfigs.add(serverEndpointConfig);
        this.checkFilterRegistration();
    }

    private void checkFilterRegistration() {
        if (this.servletContext != null && !this.registered) {
            this.registered = true;
            FilterRegistration.Dynamic reg = this.servletContext.addFilter("WebSocket filter", (Filter)this);
            reg.setAsyncSupported(true);
            reg.addMappingForUrlPatterns(null, true, new String[]{"/*"});
            TyrusServletContainerInitializer.LOGGER.info("Registering WebSocket filter for url pattern /*");
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String contextRoot = filterConfig.getServletContext().getContextPath();
        this.serverContainer = ServerContainerFactory.create(ServletContainer.class, (String)contextRoot, (int)8080, this.classes, this.dynamicallyDeployedClasses, this.dynamicallyDeployedServerEndpointConfigs);
        try {
            this.serverContainer.start();
        }
        catch (Exception e) {
            throw new ServletException("Web socket server initialization failed.", (Throwable)e);
        }
        finally {
            ServerContainer container = ServerContainerProvider.getServerContainer();
            if (container instanceof TyrusServerContainerProvider) {
                ((TyrusServerContainerProvider)container).cleanup();
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        final HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        String header = httpServletRequest.getHeader("Sec-WebSocket-Key");
        if (header != null) {
            LOGGER.config("Setting up WebSocket protocol handler");
            final TyrusHttpUpgradeHandlerProxy handler = new TyrusHttpUpgradeHandlerProxy();
            final ConnectionImpl webSocketConnection = new ConnectionImpl(handler, httpServletResponse);
            WebSocketRequest webSocketRequest = new WebSocketRequest(){

                public String getRequestURI() {
                    return httpServletRequest.getRequestURI();
                }

                public String getQueryString() {
                    return httpServletRequest.getQueryString();
                }

                public Connection getConnection() {
                    return webSocketConnection;
                }
            };
            Enumeration headerNames = httpServletRequest.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String key = (String)headerNames.nextElement();
                webSocketRequest.getHeaders().put(key, httpServletRequest.getHeader(key));
            }
            webSocketRequest.setRequestPath(httpServletRequest.getServletPath());
            try {
                if (!this.engine.upgrade((Connection)webSocketConnection, webSocketRequest, new WebSocketEngine.WebSocketHolderListener(){

                    public void onWebSocketHolder(WebSocketEngine.WebSocketHolder webSocketHolder) throws IOException {
                        LOGGER.config("Upgrading Servlet request");
                        handler.setHandler((TyrusHttpUpgradeHandler)httpServletRequest.upgrade(TyrusHttpUpgradeHandler.class));
                        handler.setWebSocketHolder(TyrusServletFilter.this.engine.getWebSocketHolder((Connection)webSocketConnection));
                    }
                })) {
                    filterChain.doFilter(request, response);
                    return;
                }
            }
            catch (HandshakeException e) {
                // empty catch block
            }
            response.flushBuffer();
            LOGGER.config("Handshake Complete");
        } else {
            filterChain.doFilter(request, response);
        }
    }

    public void destroy() {
        this.serverContainer.stop();
    }

    private class TyrusHttpUpgradeHandlerProxy
    extends TyrusHttpUpgradeHandler {
        private TyrusHttpUpgradeHandler handler;

        private TyrusHttpUpgradeHandlerProxy() {
        }

        @Override
        public void init(WebConnection wc) {
            this.handler.init(wc);
        }

        @Override
        public void onDataAvailable() {
            this.handler.onDataAvailable();
        }

        @Override
        public void onAllDataRead() {
            this.handler.onAllDataRead();
        }

        @Override
        public void onError(Throwable t) {
            this.handler.onError(t);
        }

        @Override
        public void destroy() {
            this.handler.destroy();
        }

        @Override
        public void setWebSocketHolder(WebSocketEngine.WebSocketHolder webSocketHolder) {
            this.handler.setWebSocketHolder(webSocketHolder);
        }

        @Override
        ServletOutputStream getOutputStream() {
            return this.handler.getOutputStream();
        }

        void setHandler(TyrusHttpUpgradeHandler handler) {
            this.handler = handler;
        }
    }
}

