/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.servlet;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.glassfish.tyrus.servlet.TyrusHttpUpgradeHandler;
import org.glassfish.tyrus.websockets.Connection;
import org.glassfish.tyrus.websockets.DataFrame;
import org.glassfish.tyrus.websockets.WebSocketEngine;
import org.glassfish.tyrus.websockets.WebSocketResponse;

class ConnectionImpl
extends Connection {
    private final TyrusHttpUpgradeHandler tyrusHttpUpgradeHandler;
    private final HttpServletResponse httpServletResponse;

    public ConnectionImpl(TyrusHttpUpgradeHandler tyrusHttpUpgradeHandler, HttpServletResponse httpServletResponse) {
        this.tyrusHttpUpgradeHandler = tyrusHttpUpgradeHandler;
        this.httpServletResponse = httpServletResponse;
    }

    public Future<DataFrame> write(final DataFrame frame, Connection.CompletionHandler<DataFrame> completionHandler) {
        block3: {
            ServletOutputStream outputStream = this.tyrusHttpUpgradeHandler.getOutputStream();
            try {
                byte[] bytes = WebSocketEngine.getEngine().getWebSocketHolder((Connection)this).handler.frame(frame);
                outputStream.write(bytes);
                outputStream.flush();
                if (completionHandler != null) {
                    completionHandler.completed((Object)frame);
                }
            }
            catch (IOException e) {
                if (completionHandler == null) break block3;
                completionHandler.failed((Throwable)e);
            }
        }
        return new Future<DataFrame>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public DataFrame get() throws InterruptedException, ExecutionException {
                return frame;
            }

            @Override
            public DataFrame get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return frame;
            }
        };
    }

    public void write(WebSocketResponse response) {
        this.httpServletResponse.setStatus(response.getStatus());
        for (Map.Entry entry : response.getHeaders().entrySet()) {
            this.httpServletResponse.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public void addCloseListener(Connection.CloseListener closeListener) {
    }

    public void closeSilently() {
    }

    public Object getUnderlyingConnection() {
        return null;
    }
}

