/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.servlet;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import org.glassfish.tyrus.servlet.TyrusHttpUpgradeHandler;
import org.glassfish.tyrus.websockets.Connection;
import org.glassfish.tyrus.websockets.DataFrame;
import org.glassfish.tyrus.websockets.WebSocketEngine;
import org.glassfish.tyrus.websockets.WebSocketResponse;
import org.glassfish.tyrus.websockets.WriteFuture;
import org.glassfish.tyrus.websockets.frametypes.ClosingFrameType;

class ConnectionImpl
extends Connection
implements WriteListener {
    private final TyrusHttpUpgradeHandler tyrusHttpUpgradeHandler;
    private final HttpServletResponse httpServletResponse;
    private final ArrayBlockingQueue<QueuedFrame> queue = new ArrayBlockingQueue(32);
    private static final Logger LOGGER = Logger.getLogger(ConnectionImpl.class.getName());
    private ServletOutputStream servletOutputStream = null;
    private volatile boolean isReady = false;

    public ConnectionImpl(TyrusHttpUpgradeHandler tyrusHttpUpgradeHandler, HttpServletResponse httpServletResponse) {
        this.tyrusHttpUpgradeHandler = tyrusHttpUpgradeHandler;
        this.httpServletResponse = httpServletResponse;
    }

    public void onWritePossible() throws IOException {
        LOGGER.log(Level.FINEST, "OnWritePossible called");
        QueuedFrame queuedFrame = this.queue.poll();
        this.isReady = this.servletOutputStream.isReady();
        while (queuedFrame != null && this.isReady) {
            this._write(queuedFrame.dataFrame, queuedFrame.completionHandler, queuedFrame.dataFrameFuture);
            this.isReady = this.servletOutputStream.isReady();
        }
    }

    public void onError(Throwable t) {
        LOGGER.log(Level.WARNING, "WriteListener.onError", t);
    }

    public Future<DataFrame> write(DataFrame frame, Connection.CompletionHandler<DataFrame> completionHandler) {
        WriteFuture dataFrameFuture = new WriteFuture();
        if (this.servletOutputStream == null) {
            try {
                this.servletOutputStream = this.tyrusHttpUpgradeHandler.getWebConnection().getOutputStream();
            }
            catch (IOException e) {
                LOGGER.log(Level.CONFIG, "ServletOutputStream cannot be obtained", e);
                completionHandler.failed((Throwable)e);
                dataFrameFuture.setFailure((Throwable)e);
                return dataFrameFuture;
            }
            this.isReady = this.servletOutputStream.isReady();
            this.servletOutputStream.setWriteListener((WriteListener)this);
        } else {
            this.isReady = this.servletOutputStream.isReady();
        }
        if (this.isReady) {
            this._write(frame, completionHandler, (WriteFuture<DataFrame>)dataFrameFuture);
            return dataFrameFuture;
        }
        QueuedFrame queuedFrame = new QueuedFrame((WriteFuture<DataFrame>)dataFrameFuture, completionHandler, frame);
        try {
            this.queue.put(queuedFrame);
            return dataFrameFuture;
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.CONFIG, "Cannot enqueue frame", e);
            completionHandler.failed((Throwable)e);
            dataFrameFuture.setFailure((Throwable)e);
            return dataFrameFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _write(DataFrame frame, Connection.CompletionHandler<DataFrame> completionHandler, WriteFuture<DataFrame> dataFrameFuture) {
        byte[] bytes = WebSocketEngine.getEngine().getWebSocketHolder((Connection)this).handler.frame(frame);
        try {
            ServletOutputStream servletOutputStream = this.servletOutputStream;
            synchronized (servletOutputStream) {
                this.servletOutputStream.write(bytes);
                this.servletOutputStream.flush();
            }
            if (completionHandler != null) {
                completionHandler.completed((Object)frame);
            }
            dataFrameFuture.setResult((Object)frame);
            if (frame.getType() instanceof ClosingFrameType) {
                this.tyrusHttpUpgradeHandler.getWebConnection().close();
            }
        }
        catch (Exception e) {
            if (completionHandler != null) {
                completionHandler.failed((Throwable)e);
            }
            dataFrameFuture.setFailure((Throwable)e);
        }
    }

    public void write(WebSocketResponse response) {
        this.httpServletResponse.setStatus(response.getStatus());
        for (Map.Entry entry : response.getHeaders().entrySet()) {
            this.httpServletResponse.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public void addCloseListener(Connection.CloseListener closeListener) {
    }

    public void closeSilently() {
        try {
            this.tyrusHttpUpgradeHandler.getWebConnection().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object getUnderlyingConnection() {
        return null;
    }

    private static class QueuedFrame {
        public final WriteFuture<DataFrame> dataFrameFuture;
        public final Connection.CompletionHandler<DataFrame> completionHandler;
        public final DataFrame dataFrame;

        QueuedFrame(WriteFuture<DataFrame> dataFrameFuture, Connection.CompletionHandler<DataFrame> completionHandler, DataFrame dataFrame) {
            this.dataFrameFuture = dataFrameFuture;
            this.completionHandler = completionHandler;
            this.dataFrame = dataFrame;
        }
    }
}

