/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import jakarta.servlet.ServletContext;
import jakarta.servlet.descriptor.JspConfigDescriptor;
import jakarta.servlet.descriptor.JspPropertyGroupDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.JspProperty;
import org.apache.jasper.compiler.JspPropertyGroup;
import org.apache.jasper.compiler.Localizer;

public class JspConfig {
    private static final String WEB_XML = "/WEB-INF/web.xml";
    private static Logger log = Logger.getLogger(JspConfig.class.getName());
    private ArrayList<JspPropertyGroup> jspProperties = null;
    private ServletContext ctxt;
    private boolean initialized = false;
    private String defaultIsXml = null;
    private String defaultIsELIgnored = null;
    private String defaultIsScriptingInvalid = "false";
    private String defaultTrimSpaces = "false";
    private String defaultPoundAllowed = "false";
    private String defaultErrorOnUndeclaredNamespace = "false";
    private JspProperty defaultJspProperty;

    public JspConfig(ServletContext ctxt) {
        this.ctxt = ctxt;
    }

    private void processWebDotXml(ServletContext ctxt) throws JasperException {
        JspConfigDescriptor jspConfig = ctxt.getJspConfigDescriptor();
        if (jspConfig == null) {
            return;
        }
        this.jspProperties = new ArrayList();
        for (JspPropertyGroupDescriptor jpg : jspConfig.getJspPropertyGroups()) {
            Collection urlPatterns = jpg.getUrlPatterns();
            String pageEncoding = jpg.getPageEncoding();
            String scriptingInvalid = jpg.getScriptingInvalid();
            String elIgnored = jpg.getElIgnored();
            String isXml = jpg.getIsXml();
            String trimSpaces = jpg.getTrimDirectiveWhitespaces();
            String poundAllowed = jpg.getDeferredSyntaxAllowedAsLiteral();
            String buffer = jpg.getBuffer();
            String defaultContentType = jpg.getDefaultContentType();
            String errorOnUndeclaredNamespace = jpg.getErrorOnUndeclaredNamespace();
            ArrayList<String> includePrelude = new ArrayList<String>();
            includePrelude.addAll(jpg.getIncludePreludes());
            ArrayList<String> includeCoda = new ArrayList<String>();
            includeCoda.addAll(jpg.getIncludeCodas());
            for (String urlPattern : urlPatterns) {
                String path = null;
                String extension = null;
                if (urlPattern.indexOf(42) < 0) {
                    path = urlPattern;
                } else {
                    String file;
                    int i = urlPattern.lastIndexOf(47);
                    if (i >= 0) {
                        path = urlPattern.substring(0, i + 1);
                        file = urlPattern.substring(i + 1);
                    } else {
                        file = urlPattern;
                    }
                    if (file.equals("*")) {
                        extension = "*";
                    } else if (file.startsWith("*.")) {
                        extension = file.substring(file.indexOf(46) + 1);
                    }
                    boolean isStar = "*".equals(extension);
                    if (path == null && (extension == null || isStar) || path != null && !isStar) {
                        if (!log.isLoggable(Level.WARNING)) continue;
                        log.warning(Localizer.getMessage("jsp.warning.bad.urlpattern.propertygroup", urlPattern));
                        continue;
                    }
                }
                JspProperty property = new JspProperty(isXml, elIgnored, scriptingInvalid, trimSpaces, poundAllowed, pageEncoding, includePrelude, includeCoda, defaultContentType, buffer, errorOnUndeclaredNamespace);
                JspPropertyGroup propertyGroup = new JspPropertyGroup(path, extension, property);
                this.jspProperties.add(propertyGroup);
            }
        }
    }

    private synchronized void init() throws JasperException {
        if (!this.initialized) {
            this.processWebDotXml(this.ctxt);
            if (this.ctxt.getEffectiveMajorVersion() < 2 || this.ctxt.getEffectiveMajorVersion() == 2 && this.ctxt.getEffectiveMinorVersion() <= 3) {
                this.defaultIsELIgnored = "true";
            }
            this.defaultJspProperty = new JspProperty(this.defaultIsXml, this.defaultIsELIgnored, this.defaultIsScriptingInvalid, this.defaultTrimSpaces, this.defaultPoundAllowed, null, null, null, null, null, this.defaultErrorOnUndeclaredNamespace);
            this.initialized = true;
        }
    }

    private JspPropertyGroup selectProperty(JspPropertyGroup prev, JspPropertyGroup curr) {
        if (prev == null) {
            return curr;
        }
        if (prev.getExtension() == null) {
            return prev;
        }
        if (curr.getExtension() == null) {
            return curr;
        }
        String prevPath = prev.getPath();
        String currPath = curr.getPath();
        if (prevPath == null && currPath == null) {
            return prev;
        }
        if (prevPath == null && currPath != null) {
            return curr;
        }
        if (prevPath != null && currPath == null) {
            return prev;
        }
        if (prevPath.length() >= currPath.length()) {
            return prev;
        }
        return curr;
    }

    public JspProperty findJspProperty(String uri) throws JasperException {
        this.init();
        if (this.jspProperties == null || uri.endsWith(".tag") || uri.endsWith(".tagx")) {
            return this.defaultJspProperty;
        }
        String uriPath = null;
        int index = uri.lastIndexOf(47);
        if (index >= 0) {
            uriPath = uri.substring(0, index + 1);
        }
        String uriExtension = null;
        index = uri.lastIndexOf(46);
        if (index >= 0) {
            uriExtension = uri.substring(index + 1);
        }
        ArrayList<String> includePreludes = new ArrayList<String>();
        ArrayList<String> includeCodas = new ArrayList<String>();
        JspPropertyGroup isXmlMatch = null;
        JspPropertyGroup elIgnoredMatch = null;
        JspPropertyGroup scriptingInvalidMatch = null;
        JspPropertyGroup trimSpacesMatch = null;
        JspPropertyGroup poundAllowedMatch = null;
        JspPropertyGroup pageEncodingMatch = null;
        JspPropertyGroup defaultContentTypeMatch = null;
        JspPropertyGroup bufferMatch = null;
        JspPropertyGroup errorOnUndeclaredNamespaceMatch = null;
        for (JspPropertyGroup jpg : this.jspProperties) {
            JspProperty jp = jpg.getJspProperty();
            String extension = jpg.getExtension();
            String path = jpg.getPath();
            if (extension != null ? path != null && uriPath != null && !uriPath.startsWith(path) || !extension.equals("*") && !extension.equals(uriExtension) : !uri.equals(path)) continue;
            if (jp.getIncludePrelude() != null) {
                includePreludes.addAll(jp.getIncludePrelude());
            }
            if (jp.getIncludeCoda() != null) {
                includeCodas.addAll(jp.getIncludeCoda());
            }
            if (jp.isXml() != null) {
                isXmlMatch = this.selectProperty(isXmlMatch, jpg);
            }
            if (jp.isELIgnored() != null) {
                elIgnoredMatch = this.selectProperty(elIgnoredMatch, jpg);
            }
            if (jp.isScriptingInvalid() != null) {
                scriptingInvalidMatch = this.selectProperty(scriptingInvalidMatch, jpg);
            }
            if (jp.getPageEncoding() != null) {
                pageEncodingMatch = this.selectProperty(pageEncodingMatch, jpg);
            }
            if (jp.getTrimSpaces() != null) {
                trimSpacesMatch = this.selectProperty(trimSpacesMatch, jpg);
            }
            if (jp.getPoundAllowed() != null) {
                poundAllowedMatch = this.selectProperty(poundAllowedMatch, jpg);
            }
            if (jp.getDefaultContentType() != null) {
                defaultContentTypeMatch = this.selectProperty(defaultContentTypeMatch, jpg);
            }
            if (jp.getBuffer() != null) {
                bufferMatch = this.selectProperty(bufferMatch, jpg);
            }
            if (jp.errorOnUndeclaredNamespace() == null) continue;
            errorOnUndeclaredNamespaceMatch = this.selectProperty(errorOnUndeclaredNamespaceMatch, jpg);
        }
        String isXml = this.defaultIsXml;
        String isELIgnored = this.defaultIsELIgnored;
        String isScriptingInvalid = this.defaultIsScriptingInvalid;
        String trimSpaces = this.defaultTrimSpaces;
        String poundAllowed = this.defaultPoundAllowed;
        String pageEncoding = null;
        String defaultContentType = null;
        String buffer = null;
        String errorOnUndeclaredNamespace = this.defaultErrorOnUndeclaredNamespace;
        if (isXmlMatch != null) {
            isXml = isXmlMatch.getJspProperty().isXml();
        }
        if (elIgnoredMatch != null) {
            isELIgnored = elIgnoredMatch.getJspProperty().isELIgnored();
        }
        if (scriptingInvalidMatch != null) {
            isScriptingInvalid = scriptingInvalidMatch.getJspProperty().isScriptingInvalid();
        }
        if (trimSpacesMatch != null) {
            trimSpaces = trimSpacesMatch.getJspProperty().getTrimSpaces();
        }
        if (poundAllowedMatch != null) {
            poundAllowed = poundAllowedMatch.getJspProperty().getPoundAllowed();
        }
        if (pageEncodingMatch != null) {
            pageEncoding = pageEncodingMatch.getJspProperty().getPageEncoding();
        }
        if (defaultContentTypeMatch != null) {
            defaultContentType = defaultContentTypeMatch.getJspProperty().getDefaultContentType();
        }
        if (bufferMatch != null) {
            buffer = bufferMatch.getJspProperty().getBuffer();
        }
        if (errorOnUndeclaredNamespaceMatch != null) {
            errorOnUndeclaredNamespace = errorOnUndeclaredNamespaceMatch.getJspProperty().errorOnUndeclaredNamespace();
        }
        return new JspProperty(isXml, isELIgnored, isScriptingInvalid, trimSpaces, poundAllowed, pageEncoding, includePreludes, includeCodas, defaultContentType, buffer, errorOnUndeclaredNamespace);
    }

    public boolean isJspPage(String uri) throws JasperException {
        this.init();
        if (this.jspProperties == null) {
            return false;
        }
        String uriPath = null;
        int index = uri.lastIndexOf(47);
        if (index >= 0) {
            uriPath = uri.substring(0, index + 1);
        }
        String uriExtension = null;
        index = uri.lastIndexOf(46);
        if (index >= 0) {
            uriExtension = uri.substring(index + 1);
        }
        for (JspPropertyGroup jpg : this.jspProperties) {
            JspProperty jp = jpg.getJspProperty();
            String extension = jpg.getExtension();
            String path = jpg.getPath();
            if (!(extension == null ? uri.equals(path) : !(path != null && !path.equals(uriPath) || !extension.equals("*") && !extension.equals(uriExtension)))) continue;
            return true;
        }
        return false;
    }
}

